/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AddClusterNodeSpecification;
import software.amazon.awssdk.services.sagemaker.model.AddClusterNodeSpecificationListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchAddClusterNodesRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, BatchAddClusterNodesRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(BatchAddClusterNodesRequest.getter(BatchAddClusterNodesRequest::clusterName)).setter(BatchAddClusterNodesRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(BatchAddClusterNodesRequest.getter(BatchAddClusterNodesRequest::clientToken)).setter(BatchAddClusterNodesRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<AddClusterNodeSpecification>> NODES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NodesToAdd").getter(BatchAddClusterNodesRequest.getter(BatchAddClusterNodesRequest::nodesToAdd)).setter(BatchAddClusterNodesRequest.setter(Builder::nodesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddClusterNodeSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, CLIENT_TOKEN_FIELD, NODES_TO_ADD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchAddClusterNodesRequest.memberNameToFieldInitializer();
    private final String clusterName;
    private final String clientToken;
    private final List<AddClusterNodeSpecification> nodesToAdd;

    private BatchAddClusterNodesRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.clientToken = builder.clientToken;
        this.nodesToAdd = builder.nodesToAdd;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasNodesToAdd() {
        return this.nodesToAdd != null && !(this.nodesToAdd instanceof SdkAutoConstructList);
    }

    public final List<AddClusterNodeSpecification> nodesToAdd() {
        return this.nodesToAdd;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodesToAdd() ? this.nodesToAdd() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAddClusterNodesRequest)) {
            return false;
        }
        BatchAddClusterNodesRequest other = (BatchAddClusterNodesRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasNodesToAdd() == other.hasNodesToAdd() && Objects.equals(this.nodesToAdd(), other.nodesToAdd());
    }

    public final String toString() {
        return ToString.builder((String)"BatchAddClusterNodesRequest").add("ClusterName", (Object)this.clusterName()).add("ClientToken", (Object)this.clientToken()).add("NodesToAdd", this.hasNodesToAdd() ? this.nodesToAdd() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "NodesToAdd": {
                return Optional.ofNullable(clazz.cast(this.nodesToAdd()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterName", CLUSTER_NAME_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("NodesToAdd", NODES_TO_ADD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAddClusterNodesRequest, T> g) {
        return obj -> g.apply((BatchAddClusterNodesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private String clientToken;
        private List<AddClusterNodeSpecification> nodesToAdd = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAddClusterNodesRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.clientToken(model.clientToken);
            this.nodesToAdd(model.nodesToAdd);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<AddClusterNodeSpecification.Builder> getNodesToAdd() {
            List<AddClusterNodeSpecification.Builder> result = AddClusterNodeSpecificationListCopier.copyToBuilder(this.nodesToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodesToAdd(Collection<AddClusterNodeSpecification.BuilderImpl> nodesToAdd) {
            this.nodesToAdd = AddClusterNodeSpecificationListCopier.copyFromBuilder(nodesToAdd);
        }

        @Override
        public final Builder nodesToAdd(Collection<AddClusterNodeSpecification> nodesToAdd) {
            this.nodesToAdd = AddClusterNodeSpecificationListCopier.copy(nodesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodesToAdd(AddClusterNodeSpecification ... nodesToAdd) {
            this.nodesToAdd(Arrays.asList(nodesToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodesToAdd(Consumer<AddClusterNodeSpecification.Builder> ... nodesToAdd) {
            this.nodesToAdd(Stream.of(nodesToAdd).map(c -> (AddClusterNodeSpecification)((AddClusterNodeSpecification.Builder)AddClusterNodeSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchAddClusterNodesRequest build() {
            return new BatchAddClusterNodesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchAddClusterNodesRequest> {
        public Builder clusterName(String var1);

        public Builder clientToken(String var1);

        public Builder nodesToAdd(Collection<AddClusterNodeSpecification> var1);

        public Builder nodesToAdd(AddClusterNodeSpecification ... var1);

        public Builder nodesToAdd(Consumer<AddClusterNodeSpecification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

