/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceStorageConfig;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceStorageConfigsCopier;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceType;
import software.amazon.awssdk.services.sagemaker.model.DeepHealthCheckType;
import software.amazon.awssdk.services.sagemaker.model.EnvironmentConfigDetails;
import software.amazon.awssdk.services.sagemaker.model.InstanceGroupStatus;
import software.amazon.awssdk.services.sagemaker.model.OnStartDeepHealthChecksCopier;
import software.amazon.awssdk.services.sagemaker.model.ScheduledUpdateConfig;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterRestrictedInstanceGroupDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterRestrictedInstanceGroupDetails> {
    private static final SdkField<Integer> CURRENT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CurrentCount").getter(ClusterRestrictedInstanceGroupDetails.getter(ClusterRestrictedInstanceGroupDetails::currentCount)).setter(ClusterRestrictedInstanceGroupDetails.setter(Builder::currentCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentCount").build()}).build();
    private static final SdkField<Integer> TARGET_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetCount").getter(ClusterRestrictedInstanceGroupDetails.getter(ClusterRestrictedInstanceGroupDetails::targetCount)).setter(ClusterRestrictedInstanceGroupDetails.setter(Builder::targetCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCount").build()}).build();
    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceGroupName").getter(ClusterRestrictedInstanceGroupDetails.getter(ClusterRestrictedInstanceGroupDetails::instanceGroupName)).setter(ClusterRestrictedInstanceGroupDetails.setter(Builder::instanceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ClusterRestrictedInstanceGroupDetails.getter(ClusterRestrictedInstanceGroupDetails::instanceTypeAsString)).setter(ClusterRestrictedInstanceGroupDetails.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRole").getter(ClusterRestrictedInstanceGroupDetails.getter(ClusterRestrictedInstanceGroupDetails::executionRole)).setter(ClusterRestrictedInstanceGroupDetails.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRole").build()}).build();
    private static final SdkField<Integer> THREADS_PER_CORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThreadsPerCore").getter(ClusterRestrictedInstanceGroupDetails.getter(ClusterRestrictedInstanceGroupDetails::threadsPerCore)).setter(ClusterRestrictedInstanceGroupDetails.setter(Builder::threadsPerCore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadsPerCore").build()}).build();
    private static final SdkField<List<ClusterInstanceStorageConfig>> INSTANCE_STORAGE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceStorageConfigs").getter(ClusterRestrictedInstanceGroupDetails.getter(ClusterRestrictedInstanceGroupDetails::instanceStorageConfigs)).setter(ClusterRestrictedInstanceGroupDetails.setter(Builder::instanceStorageConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStorageConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterInstanceStorageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ON_START_DEEP_HEALTH_CHECKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OnStartDeepHealthChecks").getter(ClusterRestrictedInstanceGroupDetails.getter(ClusterRestrictedInstanceGroupDetails::onStartDeepHealthChecksAsStrings)).setter(ClusterRestrictedInstanceGroupDetails.setter(Builder::onStartDeepHealthChecksWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnStartDeepHealthChecks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ClusterRestrictedInstanceGroupDetails.getter(ClusterRestrictedInstanceGroupDetails::statusAsString)).setter(ClusterRestrictedInstanceGroupDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> TRAINING_PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingPlanArn").getter(ClusterRestrictedInstanceGroupDetails.getter(ClusterRestrictedInstanceGroupDetails::trainingPlanArn)).setter(ClusterRestrictedInstanceGroupDetails.setter(Builder::trainingPlanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingPlanArn").build()}).build();
    private static final SdkField<String> TRAINING_PLAN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingPlanStatus").getter(ClusterRestrictedInstanceGroupDetails.getter(ClusterRestrictedInstanceGroupDetails::trainingPlanStatus)).setter(ClusterRestrictedInstanceGroupDetails.setter(Builder::trainingPlanStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingPlanStatus").build()}).build();
    private static final SdkField<VpcConfig> OVERRIDE_VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OverrideVpcConfig").getter(ClusterRestrictedInstanceGroupDetails.getter(ClusterRestrictedInstanceGroupDetails::overrideVpcConfig)).setter(ClusterRestrictedInstanceGroupDetails.setter(Builder::overrideVpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideVpcConfig").build()}).build();
    private static final SdkField<ScheduledUpdateConfig> SCHEDULED_UPDATE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScheduledUpdateConfig").getter(ClusterRestrictedInstanceGroupDetails.getter(ClusterRestrictedInstanceGroupDetails::scheduledUpdateConfig)).setter(ClusterRestrictedInstanceGroupDetails.setter(Builder::scheduledUpdateConfig)).constructor(ScheduledUpdateConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledUpdateConfig").build()}).build();
    private static final SdkField<EnvironmentConfigDetails> ENVIRONMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnvironmentConfig").getter(ClusterRestrictedInstanceGroupDetails.getter(ClusterRestrictedInstanceGroupDetails::environmentConfig)).setter(ClusterRestrictedInstanceGroupDetails.setter(Builder::environmentConfig)).constructor(EnvironmentConfigDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_COUNT_FIELD, TARGET_COUNT_FIELD, INSTANCE_GROUP_NAME_FIELD, INSTANCE_TYPE_FIELD, EXECUTION_ROLE_FIELD, THREADS_PER_CORE_FIELD, INSTANCE_STORAGE_CONFIGS_FIELD, ON_START_DEEP_HEALTH_CHECKS_FIELD, STATUS_FIELD, TRAINING_PLAN_ARN_FIELD, TRAINING_PLAN_STATUS_FIELD, OVERRIDE_VPC_CONFIG_FIELD, SCHEDULED_UPDATE_CONFIG_FIELD, ENVIRONMENT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterRestrictedInstanceGroupDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer currentCount;
    private final Integer targetCount;
    private final String instanceGroupName;
    private final String instanceType;
    private final String executionRole;
    private final Integer threadsPerCore;
    private final List<ClusterInstanceStorageConfig> instanceStorageConfigs;
    private final List<String> onStartDeepHealthChecks;
    private final String status;
    private final String trainingPlanArn;
    private final String trainingPlanStatus;
    private final VpcConfig overrideVpcConfig;
    private final ScheduledUpdateConfig scheduledUpdateConfig;
    private final EnvironmentConfigDetails environmentConfig;

    private ClusterRestrictedInstanceGroupDetails(BuilderImpl builder) {
        this.currentCount = builder.currentCount;
        this.targetCount = builder.targetCount;
        this.instanceGroupName = builder.instanceGroupName;
        this.instanceType = builder.instanceType;
        this.executionRole = builder.executionRole;
        this.threadsPerCore = builder.threadsPerCore;
        this.instanceStorageConfigs = builder.instanceStorageConfigs;
        this.onStartDeepHealthChecks = builder.onStartDeepHealthChecks;
        this.status = builder.status;
        this.trainingPlanArn = builder.trainingPlanArn;
        this.trainingPlanStatus = builder.trainingPlanStatus;
        this.overrideVpcConfig = builder.overrideVpcConfig;
        this.scheduledUpdateConfig = builder.scheduledUpdateConfig;
        this.environmentConfig = builder.environmentConfig;
    }

    public final Integer currentCount() {
        return this.currentCount;
    }

    public final Integer targetCount() {
        return this.targetCount;
    }

    public final String instanceGroupName() {
        return this.instanceGroupName;
    }

    public final ClusterInstanceType instanceType() {
        return ClusterInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final Integer threadsPerCore() {
        return this.threadsPerCore;
    }

    public final boolean hasInstanceStorageConfigs() {
        return this.instanceStorageConfigs != null && !(this.instanceStorageConfigs instanceof SdkAutoConstructList);
    }

    public final List<ClusterInstanceStorageConfig> instanceStorageConfigs() {
        return this.instanceStorageConfigs;
    }

    public final List<DeepHealthCheckType> onStartDeepHealthChecks() {
        return OnStartDeepHealthChecksCopier.copyStringToEnum(this.onStartDeepHealthChecks);
    }

    public final boolean hasOnStartDeepHealthChecks() {
        return this.onStartDeepHealthChecks != null && !(this.onStartDeepHealthChecks instanceof SdkAutoConstructList);
    }

    public final List<String> onStartDeepHealthChecksAsStrings() {
        return this.onStartDeepHealthChecks;
    }

    public final InstanceGroupStatus status() {
        return InstanceGroupStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String trainingPlanArn() {
        return this.trainingPlanArn;
    }

    public final String trainingPlanStatus() {
        return this.trainingPlanStatus;
    }

    public final VpcConfig overrideVpcConfig() {
        return this.overrideVpcConfig;
    }

    public final ScheduledUpdateConfig scheduledUpdateConfig() {
        return this.scheduledUpdateConfig;
    }

    public final EnvironmentConfigDetails environmentConfig() {
        return this.environmentConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currentCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.threadsPerCore());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceStorageConfigs() ? this.instanceStorageConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOnStartDeepHealthChecks() ? this.onStartDeepHealthChecksAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingPlanStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideVpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledUpdateConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterRestrictedInstanceGroupDetails)) {
            return false;
        }
        ClusterRestrictedInstanceGroupDetails other = (ClusterRestrictedInstanceGroupDetails)obj;
        return Objects.equals(this.currentCount(), other.currentCount()) && Objects.equals(this.targetCount(), other.targetCount()) && Objects.equals(this.instanceGroupName(), other.instanceGroupName()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.threadsPerCore(), other.threadsPerCore()) && this.hasInstanceStorageConfigs() == other.hasInstanceStorageConfigs() && Objects.equals(this.instanceStorageConfigs(), other.instanceStorageConfigs()) && this.hasOnStartDeepHealthChecks() == other.hasOnStartDeepHealthChecks() && Objects.equals(this.onStartDeepHealthChecksAsStrings(), other.onStartDeepHealthChecksAsStrings()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.trainingPlanArn(), other.trainingPlanArn()) && Objects.equals(this.trainingPlanStatus(), other.trainingPlanStatus()) && Objects.equals(this.overrideVpcConfig(), other.overrideVpcConfig()) && Objects.equals(this.scheduledUpdateConfig(), other.scheduledUpdateConfig()) && Objects.equals(this.environmentConfig(), other.environmentConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterRestrictedInstanceGroupDetails").add("CurrentCount", (Object)this.currentCount()).add("TargetCount", (Object)this.targetCount()).add("InstanceGroupName", (Object)this.instanceGroupName()).add("InstanceType", (Object)this.instanceTypeAsString()).add("ExecutionRole", (Object)this.executionRole()).add("ThreadsPerCore", (Object)this.threadsPerCore()).add("InstanceStorageConfigs", this.hasInstanceStorageConfigs() ? this.instanceStorageConfigs() : null).add("OnStartDeepHealthChecks", this.hasOnStartDeepHealthChecks() ? this.onStartDeepHealthChecksAsStrings() : null).add("Status", (Object)this.statusAsString()).add("TrainingPlanArn", (Object)this.trainingPlanArn()).add("TrainingPlanStatus", (Object)this.trainingPlanStatus()).add("OverrideVpcConfig", (Object)this.overrideVpcConfig()).add("ScheduledUpdateConfig", (Object)this.scheduledUpdateConfig()).add("EnvironmentConfig", (Object)this.environmentConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrentCount": {
                return Optional.ofNullable(clazz.cast(this.currentCount()));
            }
            case "TargetCount": {
                return Optional.ofNullable(clazz.cast(this.targetCount()));
            }
            case "InstanceGroupName": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupName()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "ExecutionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "ThreadsPerCore": {
                return Optional.ofNullable(clazz.cast(this.threadsPerCore()));
            }
            case "InstanceStorageConfigs": {
                return Optional.ofNullable(clazz.cast(this.instanceStorageConfigs()));
            }
            case "OnStartDeepHealthChecks": {
                return Optional.ofNullable(clazz.cast(this.onStartDeepHealthChecksAsStrings()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "TrainingPlanArn": {
                return Optional.ofNullable(clazz.cast(this.trainingPlanArn()));
            }
            case "TrainingPlanStatus": {
                return Optional.ofNullable(clazz.cast(this.trainingPlanStatus()));
            }
            case "OverrideVpcConfig": {
                return Optional.ofNullable(clazz.cast(this.overrideVpcConfig()));
            }
            case "ScheduledUpdateConfig": {
                return Optional.ofNullable(clazz.cast(this.scheduledUpdateConfig()));
            }
            case "EnvironmentConfig": {
                return Optional.ofNullable(clazz.cast(this.environmentConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CurrentCount", CURRENT_COUNT_FIELD);
        map.put("TargetCount", TARGET_COUNT_FIELD);
        map.put("InstanceGroupName", INSTANCE_GROUP_NAME_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("ExecutionRole", EXECUTION_ROLE_FIELD);
        map.put("ThreadsPerCore", THREADS_PER_CORE_FIELD);
        map.put("InstanceStorageConfigs", INSTANCE_STORAGE_CONFIGS_FIELD);
        map.put("OnStartDeepHealthChecks", ON_START_DEEP_HEALTH_CHECKS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("TrainingPlanArn", TRAINING_PLAN_ARN_FIELD);
        map.put("TrainingPlanStatus", TRAINING_PLAN_STATUS_FIELD);
        map.put("OverrideVpcConfig", OVERRIDE_VPC_CONFIG_FIELD);
        map.put("ScheduledUpdateConfig", SCHEDULED_UPDATE_CONFIG_FIELD);
        map.put("EnvironmentConfig", ENVIRONMENT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterRestrictedInstanceGroupDetails, T> g) {
        return obj -> g.apply((ClusterRestrictedInstanceGroupDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer currentCount;
        private Integer targetCount;
        private String instanceGroupName;
        private String instanceType;
        private String executionRole;
        private Integer threadsPerCore;
        private List<ClusterInstanceStorageConfig> instanceStorageConfigs = DefaultSdkAutoConstructList.getInstance();
        private List<String> onStartDeepHealthChecks = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String trainingPlanArn;
        private String trainingPlanStatus;
        private VpcConfig overrideVpcConfig;
        private ScheduledUpdateConfig scheduledUpdateConfig;
        private EnvironmentConfigDetails environmentConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterRestrictedInstanceGroupDetails model) {
            this.currentCount(model.currentCount);
            this.targetCount(model.targetCount);
            this.instanceGroupName(model.instanceGroupName);
            this.instanceType(model.instanceType);
            this.executionRole(model.executionRole);
            this.threadsPerCore(model.threadsPerCore);
            this.instanceStorageConfigs(model.instanceStorageConfigs);
            this.onStartDeepHealthChecksWithStrings(model.onStartDeepHealthChecks);
            this.status(model.status);
            this.trainingPlanArn(model.trainingPlanArn);
            this.trainingPlanStatus(model.trainingPlanStatus);
            this.overrideVpcConfig(model.overrideVpcConfig);
            this.scheduledUpdateConfig(model.scheduledUpdateConfig);
            this.environmentConfig(model.environmentConfig);
        }

        public final Integer getCurrentCount() {
            return this.currentCount;
        }

        public final void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        @Override
        public final Builder currentCount(Integer currentCount) {
            this.currentCount = currentCount;
            return this;
        }

        public final Integer getTargetCount() {
            return this.targetCount;
        }

        public final void setTargetCount(Integer targetCount) {
            this.targetCount = targetCount;
        }

        @Override
        public final Builder targetCount(Integer targetCount) {
            this.targetCount = targetCount;
            return this;
        }

        public final String getInstanceGroupName() {
            return this.instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ClusterInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final Integer getThreadsPerCore() {
            return this.threadsPerCore;
        }

        public final void setThreadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
        }

        @Override
        public final Builder threadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
            return this;
        }

        public final List<ClusterInstanceStorageConfig.Builder> getInstanceStorageConfigs() {
            List<ClusterInstanceStorageConfig.Builder> result = ClusterInstanceStorageConfigsCopier.copyToBuilder(this.instanceStorageConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceStorageConfigs(Collection<ClusterInstanceStorageConfig.BuilderImpl> instanceStorageConfigs) {
            this.instanceStorageConfigs = ClusterInstanceStorageConfigsCopier.copyFromBuilder(instanceStorageConfigs);
        }

        @Override
        public final Builder instanceStorageConfigs(Collection<ClusterInstanceStorageConfig> instanceStorageConfigs) {
            this.instanceStorageConfigs = ClusterInstanceStorageConfigsCopier.copy(instanceStorageConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStorageConfigs(ClusterInstanceStorageConfig ... instanceStorageConfigs) {
            this.instanceStorageConfigs(Arrays.asList(instanceStorageConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStorageConfigs(Consumer<ClusterInstanceStorageConfig.Builder> ... instanceStorageConfigs) {
            this.instanceStorageConfigs(Stream.of(instanceStorageConfigs).map(c -> (ClusterInstanceStorageConfig)((ClusterInstanceStorageConfig.Builder)ClusterInstanceStorageConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getOnStartDeepHealthChecks() {
            if (this.onStartDeepHealthChecks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.onStartDeepHealthChecks;
        }

        public final void setOnStartDeepHealthChecks(Collection<String> onStartDeepHealthChecks) {
            this.onStartDeepHealthChecks = OnStartDeepHealthChecksCopier.copy(onStartDeepHealthChecks);
        }

        @Override
        public final Builder onStartDeepHealthChecksWithStrings(Collection<String> onStartDeepHealthChecks) {
            this.onStartDeepHealthChecks = OnStartDeepHealthChecksCopier.copy(onStartDeepHealthChecks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onStartDeepHealthChecksWithStrings(String ... onStartDeepHealthChecks) {
            this.onStartDeepHealthChecksWithStrings(Arrays.asList(onStartDeepHealthChecks));
            return this;
        }

        @Override
        public final Builder onStartDeepHealthChecks(Collection<DeepHealthCheckType> onStartDeepHealthChecks) {
            this.onStartDeepHealthChecks = OnStartDeepHealthChecksCopier.copyEnumToString(onStartDeepHealthChecks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onStartDeepHealthChecks(DeepHealthCheckType ... onStartDeepHealthChecks) {
            this.onStartDeepHealthChecks(Arrays.asList(onStartDeepHealthChecks));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InstanceGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTrainingPlanArn() {
            return this.trainingPlanArn;
        }

        public final void setTrainingPlanArn(String trainingPlanArn) {
            this.trainingPlanArn = trainingPlanArn;
        }

        @Override
        public final Builder trainingPlanArn(String trainingPlanArn) {
            this.trainingPlanArn = trainingPlanArn;
            return this;
        }

        public final String getTrainingPlanStatus() {
            return this.trainingPlanStatus;
        }

        public final void setTrainingPlanStatus(String trainingPlanStatus) {
            this.trainingPlanStatus = trainingPlanStatus;
        }

        @Override
        public final Builder trainingPlanStatus(String trainingPlanStatus) {
            this.trainingPlanStatus = trainingPlanStatus;
            return this;
        }

        public final VpcConfig.Builder getOverrideVpcConfig() {
            return this.overrideVpcConfig != null ? this.overrideVpcConfig.toBuilder() : null;
        }

        public final void setOverrideVpcConfig(VpcConfig.BuilderImpl overrideVpcConfig) {
            this.overrideVpcConfig = overrideVpcConfig != null ? overrideVpcConfig.build() : null;
        }

        @Override
        public final Builder overrideVpcConfig(VpcConfig overrideVpcConfig) {
            this.overrideVpcConfig = overrideVpcConfig;
            return this;
        }

        public final ScheduledUpdateConfig.Builder getScheduledUpdateConfig() {
            return this.scheduledUpdateConfig != null ? this.scheduledUpdateConfig.toBuilder() : null;
        }

        public final void setScheduledUpdateConfig(ScheduledUpdateConfig.BuilderImpl scheduledUpdateConfig) {
            this.scheduledUpdateConfig = scheduledUpdateConfig != null ? scheduledUpdateConfig.build() : null;
        }

        @Override
        public final Builder scheduledUpdateConfig(ScheduledUpdateConfig scheduledUpdateConfig) {
            this.scheduledUpdateConfig = scheduledUpdateConfig;
            return this;
        }

        public final EnvironmentConfigDetails.Builder getEnvironmentConfig() {
            return this.environmentConfig != null ? this.environmentConfig.toBuilder() : null;
        }

        public final void setEnvironmentConfig(EnvironmentConfigDetails.BuilderImpl environmentConfig) {
            this.environmentConfig = environmentConfig != null ? environmentConfig.build() : null;
        }

        @Override
        public final Builder environmentConfig(EnvironmentConfigDetails environmentConfig) {
            this.environmentConfig = environmentConfig;
            return this;
        }

        public ClusterRestrictedInstanceGroupDetails build() {
            return new ClusterRestrictedInstanceGroupDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterRestrictedInstanceGroupDetails> {
        public Builder currentCount(Integer var1);

        public Builder targetCount(Integer var1);

        public Builder instanceGroupName(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(ClusterInstanceType var1);

        public Builder executionRole(String var1);

        public Builder threadsPerCore(Integer var1);

        public Builder instanceStorageConfigs(Collection<ClusterInstanceStorageConfig> var1);

        public Builder instanceStorageConfigs(ClusterInstanceStorageConfig ... var1);

        public Builder instanceStorageConfigs(Consumer<ClusterInstanceStorageConfig.Builder> ... var1);

        public Builder onStartDeepHealthChecksWithStrings(Collection<String> var1);

        public Builder onStartDeepHealthChecksWithStrings(String ... var1);

        public Builder onStartDeepHealthChecks(Collection<DeepHealthCheckType> var1);

        public Builder onStartDeepHealthChecks(DeepHealthCheckType ... var1);

        public Builder status(String var1);

        public Builder status(InstanceGroupStatus var1);

        public Builder trainingPlanArn(String var1);

        public Builder trainingPlanStatus(String var1);

        public Builder overrideVpcConfig(VpcConfig var1);

        default public Builder overrideVpcConfig(Consumer<VpcConfig.Builder> overrideVpcConfig) {
            return this.overrideVpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(overrideVpcConfig)).build());
        }

        public Builder scheduledUpdateConfig(ScheduledUpdateConfig var1);

        default public Builder scheduledUpdateConfig(Consumer<ScheduledUpdateConfig.Builder> scheduledUpdateConfig) {
            return this.scheduledUpdateConfig((ScheduledUpdateConfig)((ScheduledUpdateConfig.Builder)ScheduledUpdateConfig.builder().applyMutation(scheduledUpdateConfig)).build());
        }

        public Builder environmentConfig(EnvironmentConfigDetails var1);

        default public Builder environmentConfig(Consumer<EnvironmentConfigDetails.Builder> environmentConfig) {
            return this.environmentConfig((EnvironmentConfigDetails)((EnvironmentConfigDetails.Builder)EnvironmentConfigDetails.builder().applyMutation(environmentConfig)).build());
        }
    }
}

