/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.VolumeAttachmentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetachClusterNodeVolumeResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DetachClusterNodeVolumeResponse> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(DetachClusterNodeVolumeResponse.getter(DetachClusterNodeVolumeResponse::clusterArn)).setter(DetachClusterNodeVolumeResponse.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()}).build();
    private static final SdkField<String> NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeId").getter(DetachClusterNodeVolumeResponse.getter(DetachClusterNodeVolumeResponse::nodeId)).setter(DetachClusterNodeVolumeResponse.setter(Builder::nodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(DetachClusterNodeVolumeResponse.getter(DetachClusterNodeVolumeResponse::volumeId)).setter(DetachClusterNodeVolumeResponse.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()}).build();
    private static final SdkField<Instant> ATTACH_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AttachTime").getter(DetachClusterNodeVolumeResponse.getter(DetachClusterNodeVolumeResponse::attachTime)).setter(DetachClusterNodeVolumeResponse.setter(Builder::attachTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DetachClusterNodeVolumeResponse.getter(DetachClusterNodeVolumeResponse::statusAsString)).setter(DetachClusterNodeVolumeResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceName").getter(DetachClusterNodeVolumeResponse.getter(DetachClusterNodeVolumeResponse::deviceName)).setter(DetachClusterNodeVolumeResponse.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, NODE_ID_FIELD, VOLUME_ID_FIELD, ATTACH_TIME_FIELD, STATUS_FIELD, DEVICE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DetachClusterNodeVolumeResponse.memberNameToFieldInitializer();
    private final String clusterArn;
    private final String nodeId;
    private final String volumeId;
    private final Instant attachTime;
    private final String status;
    private final String deviceName;

    private DetachClusterNodeVolumeResponse(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.nodeId = builder.nodeId;
        this.volumeId = builder.volumeId;
        this.attachTime = builder.attachTime;
        this.status = builder.status;
        this.deviceName = builder.deviceName;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public final Instant attachTime() {
        return this.attachTime;
    }

    public final VolumeAttachmentStatus status() {
        return VolumeAttachmentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String deviceName() {
        return this.deviceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachClusterNodeVolumeResponse)) {
            return false;
        }
        DetachClusterNodeVolumeResponse other = (DetachClusterNodeVolumeResponse)((Object)obj);
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.nodeId(), other.nodeId()) && Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.attachTime(), other.attachTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.deviceName(), other.deviceName());
    }

    public final String toString() {
        return ToString.builder((String)"DetachClusterNodeVolumeResponse").add("ClusterArn", (Object)this.clusterArn()).add("NodeId", (Object)this.nodeId()).add("VolumeId", (Object)this.volumeId()).add("AttachTime", (Object)this.attachTime()).add("Status", (Object)this.statusAsString()).add("DeviceName", (Object)this.deviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "NodeId": {
                return Optional.ofNullable(clazz.cast(this.nodeId()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "AttachTime": {
                return Optional.ofNullable(clazz.cast(this.attachTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterArn", CLUSTER_ARN_FIELD);
        map.put("NodeId", NODE_ID_FIELD);
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("AttachTime", ATTACH_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("DeviceName", DEVICE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetachClusterNodeVolumeResponse, T> g) {
        return obj -> g.apply((DetachClusterNodeVolumeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String clusterArn;
        private String nodeId;
        private String volumeId;
        private Instant attachTime;
        private String status;
        private String deviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachClusterNodeVolumeResponse model) {
            super(model);
            this.clusterArn(model.clusterArn);
            this.nodeId(model.nodeId);
            this.volumeId(model.volumeId);
            this.attachTime(model.attachTime);
            this.status(model.status);
            this.deviceName(model.deviceName);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getNodeId() {
            return this.nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final Instant getAttachTime() {
            return this.attachTime;
        }

        public final void setAttachTime(Instant attachTime) {
            this.attachTime = attachTime;
        }

        @Override
        public final Builder attachTime(Instant attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VolumeAttachmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        @Override
        public DetachClusterNodeVolumeResponse build() {
            return new DetachClusterNodeVolumeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetachClusterNodeVolumeResponse> {
        public Builder clusterArn(String var1);

        public Builder nodeId(String var1);

        public Builder volumeId(String var1);

        public Builder attachTime(Instant var1);

        public Builder status(String var1);

        public Builder status(VolumeAttachmentStatus var1);

        public Builder deviceName(String var1);
    }
}

