/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.FeatureStatus;
import software.amazon.awssdk.services.sagemaker.model.VpcOnlyTrustedAccountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DockerSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DockerSettings> {
    private static final SdkField<String> ENABLE_DOCKER_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnableDockerAccess").getter(DockerSettings.getter(DockerSettings::enableDockerAccessAsString)).setter(DockerSettings.setter(Builder::enableDockerAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDockerAccess").build()}).build();
    private static final SdkField<List<String>> VPC_ONLY_TRUSTED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcOnlyTrustedAccounts").getter(DockerSettings.getter(DockerSettings::vpcOnlyTrustedAccounts)).setter(DockerSettings.setter(Builder::vpcOnlyTrustedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOnlyTrustedAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROOTLESS_DOCKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RootlessDocker").getter(DockerSettings.getter(DockerSettings::rootlessDockerAsString)).setter(DockerSettings.setter(Builder::rootlessDocker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootlessDocker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_DOCKER_ACCESS_FIELD, VPC_ONLY_TRUSTED_ACCOUNTS_FIELD, ROOTLESS_DOCKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DockerSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String enableDockerAccess;
    private final List<String> vpcOnlyTrustedAccounts;
    private final String rootlessDocker;

    private DockerSettings(BuilderImpl builder) {
        this.enableDockerAccess = builder.enableDockerAccess;
        this.vpcOnlyTrustedAccounts = builder.vpcOnlyTrustedAccounts;
        this.rootlessDocker = builder.rootlessDocker;
    }

    public final FeatureStatus enableDockerAccess() {
        return FeatureStatus.fromValue(this.enableDockerAccess);
    }

    public final String enableDockerAccessAsString() {
        return this.enableDockerAccess;
    }

    public final boolean hasVpcOnlyTrustedAccounts() {
        return this.vpcOnlyTrustedAccounts != null && !(this.vpcOnlyTrustedAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> vpcOnlyTrustedAccounts() {
        return this.vpcOnlyTrustedAccounts;
    }

    public final FeatureStatus rootlessDocker() {
        return FeatureStatus.fromValue(this.rootlessDocker);
    }

    public final String rootlessDockerAsString() {
        return this.rootlessDocker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDockerAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcOnlyTrustedAccounts() ? this.vpcOnlyTrustedAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rootlessDockerAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DockerSettings)) {
            return false;
        }
        DockerSettings other = (DockerSettings)obj;
        return Objects.equals(this.enableDockerAccessAsString(), other.enableDockerAccessAsString()) && this.hasVpcOnlyTrustedAccounts() == other.hasVpcOnlyTrustedAccounts() && Objects.equals(this.vpcOnlyTrustedAccounts(), other.vpcOnlyTrustedAccounts()) && Objects.equals(this.rootlessDockerAsString(), other.rootlessDockerAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DockerSettings").add("EnableDockerAccess", (Object)this.enableDockerAccessAsString()).add("VpcOnlyTrustedAccounts", this.hasVpcOnlyTrustedAccounts() ? this.vpcOnlyTrustedAccounts() : null).add("RootlessDocker", (Object)this.rootlessDockerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnableDockerAccess": {
                return Optional.ofNullable(clazz.cast(this.enableDockerAccessAsString()));
            }
            case "VpcOnlyTrustedAccounts": {
                return Optional.ofNullable(clazz.cast(this.vpcOnlyTrustedAccounts()));
            }
            case "RootlessDocker": {
                return Optional.ofNullable(clazz.cast(this.rootlessDockerAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EnableDockerAccess", ENABLE_DOCKER_ACCESS_FIELD);
        map.put("VpcOnlyTrustedAccounts", VPC_ONLY_TRUSTED_ACCOUNTS_FIELD);
        map.put("RootlessDocker", ROOTLESS_DOCKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DockerSettings, T> g) {
        return obj -> g.apply((DockerSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String enableDockerAccess;
        private List<String> vpcOnlyTrustedAccounts = DefaultSdkAutoConstructList.getInstance();
        private String rootlessDocker;

        private BuilderImpl() {
        }

        private BuilderImpl(DockerSettings model) {
            this.enableDockerAccess(model.enableDockerAccess);
            this.vpcOnlyTrustedAccounts(model.vpcOnlyTrustedAccounts);
            this.rootlessDocker(model.rootlessDocker);
        }

        public final String getEnableDockerAccess() {
            return this.enableDockerAccess;
        }

        public final void setEnableDockerAccess(String enableDockerAccess) {
            this.enableDockerAccess = enableDockerAccess;
        }

        @Override
        public final Builder enableDockerAccess(String enableDockerAccess) {
            this.enableDockerAccess = enableDockerAccess;
            return this;
        }

        @Override
        public final Builder enableDockerAccess(FeatureStatus enableDockerAccess) {
            this.enableDockerAccess(enableDockerAccess == null ? null : enableDockerAccess.toString());
            return this;
        }

        public final Collection<String> getVpcOnlyTrustedAccounts() {
            if (this.vpcOnlyTrustedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcOnlyTrustedAccounts;
        }

        public final void setVpcOnlyTrustedAccounts(Collection<String> vpcOnlyTrustedAccounts) {
            this.vpcOnlyTrustedAccounts = VpcOnlyTrustedAccountsCopier.copy(vpcOnlyTrustedAccounts);
        }

        @Override
        public final Builder vpcOnlyTrustedAccounts(Collection<String> vpcOnlyTrustedAccounts) {
            this.vpcOnlyTrustedAccounts = VpcOnlyTrustedAccountsCopier.copy(vpcOnlyTrustedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcOnlyTrustedAccounts(String ... vpcOnlyTrustedAccounts) {
            this.vpcOnlyTrustedAccounts(Arrays.asList(vpcOnlyTrustedAccounts));
            return this;
        }

        public final String getRootlessDocker() {
            return this.rootlessDocker;
        }

        public final void setRootlessDocker(String rootlessDocker) {
            this.rootlessDocker = rootlessDocker;
        }

        @Override
        public final Builder rootlessDocker(String rootlessDocker) {
            this.rootlessDocker = rootlessDocker;
            return this;
        }

        @Override
        public final Builder rootlessDocker(FeatureStatus rootlessDocker) {
            this.rootlessDocker(rootlessDocker == null ? null : rootlessDocker.toString());
            return this;
        }

        public DockerSettings build() {
            return new DockerSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DockerSettings> {
        public Builder enableDockerAccess(String var1);

        public Builder enableDockerAccess(FeatureStatus var1);

        public Builder vpcOnlyTrustedAccounts(Collection<String> var1);

        public Builder vpcOnlyTrustedAccounts(String ... var1);

        public Builder rootlessDocker(String var1);

        public Builder rootlessDocker(FeatureStatus var1);
    }
}

