/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ReservedCapacityInstanceType;
import software.amazon.awssdk.services.sagemaker.model.ReservedCapacityStatus;
import software.amazon.awssdk.services.sagemaker.model.ReservedCapacityType;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.UltraServerSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedCapacityResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeReservedCapacityResponse> {
    private static final SdkField<String> RESERVED_CAPACITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedCapacityArn").getter(DescribeReservedCapacityResponse.getter(DescribeReservedCapacityResponse::reservedCapacityArn)).setter(DescribeReservedCapacityResponse.setter(Builder::reservedCapacityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCapacityArn").build()}).build();
    private static final SdkField<String> RESERVED_CAPACITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedCapacityType").getter(DescribeReservedCapacityResponse.getter(DescribeReservedCapacityResponse::reservedCapacityTypeAsString)).setter(DescribeReservedCapacityResponse.setter(Builder::reservedCapacityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCapacityType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeReservedCapacityResponse.getter(DescribeReservedCapacityResponse::statusAsString)).setter(DescribeReservedCapacityResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(DescribeReservedCapacityResponse.getter(DescribeReservedCapacityResponse::availabilityZone)).setter(DescribeReservedCapacityResponse.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<Long> DURATION_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DurationHours").getter(DescribeReservedCapacityResponse.getter(DescribeReservedCapacityResponse::durationHours)).setter(DescribeReservedCapacityResponse.setter(Builder::durationHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationHours").build()}).build();
    private static final SdkField<Long> DURATION_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DurationMinutes").getter(DescribeReservedCapacityResponse.getter(DescribeReservedCapacityResponse::durationMinutes)).setter(DescribeReservedCapacityResponse.setter(Builder::durationMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMinutes").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(DescribeReservedCapacityResponse.getter(DescribeReservedCapacityResponse::startTime)).setter(DescribeReservedCapacityResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(DescribeReservedCapacityResponse.getter(DescribeReservedCapacityResponse::endTime)).setter(DescribeReservedCapacityResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(DescribeReservedCapacityResponse.getter(DescribeReservedCapacityResponse::instanceTypeAsString)).setter(DescribeReservedCapacityResponse.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Integer> TOTAL_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalInstanceCount").getter(DescribeReservedCapacityResponse.getter(DescribeReservedCapacityResponse::totalInstanceCount)).setter(DescribeReservedCapacityResponse.setter(Builder::totalInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInstanceCount").build()}).build();
    private static final SdkField<Integer> AVAILABLE_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AvailableInstanceCount").getter(DescribeReservedCapacityResponse.getter(DescribeReservedCapacityResponse::availableInstanceCount)).setter(DescribeReservedCapacityResponse.setter(Builder::availableInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableInstanceCount").build()}).build();
    private static final SdkField<Integer> IN_USE_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InUseInstanceCount").getter(DescribeReservedCapacityResponse.getter(DescribeReservedCapacityResponse::inUseInstanceCount)).setter(DescribeReservedCapacityResponse.setter(Builder::inUseInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InUseInstanceCount").build()}).build();
    private static final SdkField<UltraServerSummary> ULTRA_SERVER_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UltraServerSummary").getter(DescribeReservedCapacityResponse.getter(DescribeReservedCapacityResponse::ultraServerSummary)).setter(DescribeReservedCapacityResponse.setter(Builder::ultraServerSummary)).constructor(UltraServerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UltraServerSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_CAPACITY_ARN_FIELD, RESERVED_CAPACITY_TYPE_FIELD, STATUS_FIELD, AVAILABILITY_ZONE_FIELD, DURATION_HOURS_FIELD, DURATION_MINUTES_FIELD, START_TIME_FIELD, END_TIME_FIELD, INSTANCE_TYPE_FIELD, TOTAL_INSTANCE_COUNT_FIELD, AVAILABLE_INSTANCE_COUNT_FIELD, IN_USE_INSTANCE_COUNT_FIELD, ULTRA_SERVER_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeReservedCapacityResponse.memberNameToFieldInitializer();
    private final String reservedCapacityArn;
    private final String reservedCapacityType;
    private final String status;
    private final String availabilityZone;
    private final Long durationHours;
    private final Long durationMinutes;
    private final Instant startTime;
    private final Instant endTime;
    private final String instanceType;
    private final Integer totalInstanceCount;
    private final Integer availableInstanceCount;
    private final Integer inUseInstanceCount;
    private final UltraServerSummary ultraServerSummary;

    private DescribeReservedCapacityResponse(BuilderImpl builder) {
        super(builder);
        this.reservedCapacityArn = builder.reservedCapacityArn;
        this.reservedCapacityType = builder.reservedCapacityType;
        this.status = builder.status;
        this.availabilityZone = builder.availabilityZone;
        this.durationHours = builder.durationHours;
        this.durationMinutes = builder.durationMinutes;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.instanceType = builder.instanceType;
        this.totalInstanceCount = builder.totalInstanceCount;
        this.availableInstanceCount = builder.availableInstanceCount;
        this.inUseInstanceCount = builder.inUseInstanceCount;
        this.ultraServerSummary = builder.ultraServerSummary;
    }

    public final String reservedCapacityArn() {
        return this.reservedCapacityArn;
    }

    public final ReservedCapacityType reservedCapacityType() {
        return ReservedCapacityType.fromValue(this.reservedCapacityType);
    }

    public final String reservedCapacityTypeAsString() {
        return this.reservedCapacityType;
    }

    public final ReservedCapacityStatus status() {
        return ReservedCapacityStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Long durationHours() {
        return this.durationHours;
    }

    public final Long durationMinutes() {
        return this.durationMinutes;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final ReservedCapacityInstanceType instanceType() {
        return ReservedCapacityInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Integer totalInstanceCount() {
        return this.totalInstanceCount;
    }

    public final Integer availableInstanceCount() {
        return this.availableInstanceCount;
    }

    public final Integer inUseInstanceCount() {
        return this.inUseInstanceCount;
    }

    public final UltraServerSummary ultraServerSummary() {
        return this.ultraServerSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedCapacityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedCapacityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.inUseInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.ultraServerSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedCapacityResponse)) {
            return false;
        }
        DescribeReservedCapacityResponse other = (DescribeReservedCapacityResponse)((Object)obj);
        return Objects.equals(this.reservedCapacityArn(), other.reservedCapacityArn()) && Objects.equals(this.reservedCapacityTypeAsString(), other.reservedCapacityTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.durationHours(), other.durationHours()) && Objects.equals(this.durationMinutes(), other.durationMinutes()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.totalInstanceCount(), other.totalInstanceCount()) && Objects.equals(this.availableInstanceCount(), other.availableInstanceCount()) && Objects.equals(this.inUseInstanceCount(), other.inUseInstanceCount()) && Objects.equals(this.ultraServerSummary(), other.ultraServerSummary());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReservedCapacityResponse").add("ReservedCapacityArn", (Object)this.reservedCapacityArn()).add("ReservedCapacityType", (Object)this.reservedCapacityTypeAsString()).add("Status", (Object)this.statusAsString()).add("AvailabilityZone", (Object)this.availabilityZone()).add("DurationHours", (Object)this.durationHours()).add("DurationMinutes", (Object)this.durationMinutes()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("InstanceType", (Object)this.instanceTypeAsString()).add("TotalInstanceCount", (Object)this.totalInstanceCount()).add("AvailableInstanceCount", (Object)this.availableInstanceCount()).add("InUseInstanceCount", (Object)this.inUseInstanceCount()).add("UltraServerSummary", (Object)this.ultraServerSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedCapacityArn": {
                return Optional.ofNullable(clazz.cast(this.reservedCapacityArn()));
            }
            case "ReservedCapacityType": {
                return Optional.ofNullable(clazz.cast(this.reservedCapacityTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "DurationHours": {
                return Optional.ofNullable(clazz.cast(this.durationHours()));
            }
            case "DurationMinutes": {
                return Optional.ofNullable(clazz.cast(this.durationMinutes()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "TotalInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.totalInstanceCount()));
            }
            case "AvailableInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.availableInstanceCount()));
            }
            case "InUseInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.inUseInstanceCount()));
            }
            case "UltraServerSummary": {
                return Optional.ofNullable(clazz.cast(this.ultraServerSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReservedCapacityArn", RESERVED_CAPACITY_ARN_FIELD);
        map.put("ReservedCapacityType", RESERVED_CAPACITY_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("DurationHours", DURATION_HOURS_FIELD);
        map.put("DurationMinutes", DURATION_MINUTES_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("TotalInstanceCount", TOTAL_INSTANCE_COUNT_FIELD);
        map.put("AvailableInstanceCount", AVAILABLE_INSTANCE_COUNT_FIELD);
        map.put("InUseInstanceCount", IN_USE_INSTANCE_COUNT_FIELD);
        map.put("UltraServerSummary", ULTRA_SERVER_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedCapacityResponse, T> g) {
        return obj -> g.apply((DescribeReservedCapacityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String reservedCapacityArn;
        private String reservedCapacityType;
        private String status;
        private String availabilityZone;
        private Long durationHours;
        private Long durationMinutes;
        private Instant startTime;
        private Instant endTime;
        private String instanceType;
        private Integer totalInstanceCount;
        private Integer availableInstanceCount;
        private Integer inUseInstanceCount;
        private UltraServerSummary ultraServerSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedCapacityResponse model) {
            super(model);
            this.reservedCapacityArn(model.reservedCapacityArn);
            this.reservedCapacityType(model.reservedCapacityType);
            this.status(model.status);
            this.availabilityZone(model.availabilityZone);
            this.durationHours(model.durationHours);
            this.durationMinutes(model.durationMinutes);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.instanceType(model.instanceType);
            this.totalInstanceCount(model.totalInstanceCount);
            this.availableInstanceCount(model.availableInstanceCount);
            this.inUseInstanceCount(model.inUseInstanceCount);
            this.ultraServerSummary(model.ultraServerSummary);
        }

        public final String getReservedCapacityArn() {
            return this.reservedCapacityArn;
        }

        public final void setReservedCapacityArn(String reservedCapacityArn) {
            this.reservedCapacityArn = reservedCapacityArn;
        }

        @Override
        public final Builder reservedCapacityArn(String reservedCapacityArn) {
            this.reservedCapacityArn = reservedCapacityArn;
            return this;
        }

        public final String getReservedCapacityType() {
            return this.reservedCapacityType;
        }

        public final void setReservedCapacityType(String reservedCapacityType) {
            this.reservedCapacityType = reservedCapacityType;
        }

        @Override
        public final Builder reservedCapacityType(String reservedCapacityType) {
            this.reservedCapacityType = reservedCapacityType;
            return this;
        }

        @Override
        public final Builder reservedCapacityType(ReservedCapacityType reservedCapacityType) {
            this.reservedCapacityType(reservedCapacityType == null ? null : reservedCapacityType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReservedCapacityStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Long getDurationHours() {
            return this.durationHours;
        }

        public final void setDurationHours(Long durationHours) {
            this.durationHours = durationHours;
        }

        @Override
        public final Builder durationHours(Long durationHours) {
            this.durationHours = durationHours;
            return this;
        }

        public final Long getDurationMinutes() {
            return this.durationMinutes;
        }

        public final void setDurationMinutes(Long durationMinutes) {
            this.durationMinutes = durationMinutes;
        }

        @Override
        public final Builder durationMinutes(Long durationMinutes) {
            this.durationMinutes = durationMinutes;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ReservedCapacityInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getTotalInstanceCount() {
            return this.totalInstanceCount;
        }

        public final void setTotalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
        }

        @Override
        public final Builder totalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
            return this;
        }

        public final Integer getAvailableInstanceCount() {
            return this.availableInstanceCount;
        }

        public final void setAvailableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
        }

        @Override
        public final Builder availableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
            return this;
        }

        public final Integer getInUseInstanceCount() {
            return this.inUseInstanceCount;
        }

        public final void setInUseInstanceCount(Integer inUseInstanceCount) {
            this.inUseInstanceCount = inUseInstanceCount;
        }

        @Override
        public final Builder inUseInstanceCount(Integer inUseInstanceCount) {
            this.inUseInstanceCount = inUseInstanceCount;
            return this;
        }

        public final UltraServerSummary.Builder getUltraServerSummary() {
            return this.ultraServerSummary != null ? this.ultraServerSummary.toBuilder() : null;
        }

        public final void setUltraServerSummary(UltraServerSummary.BuilderImpl ultraServerSummary) {
            this.ultraServerSummary = ultraServerSummary != null ? ultraServerSummary.build() : null;
        }

        @Override
        public final Builder ultraServerSummary(UltraServerSummary ultraServerSummary) {
            this.ultraServerSummary = ultraServerSummary;
            return this;
        }

        @Override
        public DescribeReservedCapacityResponse build() {
            return new DescribeReservedCapacityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedCapacityResponse> {
        public Builder reservedCapacityArn(String var1);

        public Builder reservedCapacityType(String var1);

        public Builder reservedCapacityType(ReservedCapacityType var1);

        public Builder status(String var1);

        public Builder status(ReservedCapacityStatus var1);

        public Builder availabilityZone(String var1);

        public Builder durationHours(Long var1);

        public Builder durationMinutes(Long var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder instanceType(String var1);

        public Builder instanceType(ReservedCapacityInstanceType var1);

        public Builder totalInstanceCount(Integer var1);

        public Builder availableInstanceCount(Integer var1);

        public Builder inUseInstanceCount(Integer var1);

        public Builder ultraServerSummary(UltraServerSummary var1);

        default public Builder ultraServerSummary(Consumer<UltraServerSummary.Builder> ultraServerSummary) {
            return this.ultraServerSummary((UltraServerSummary)((UltraServerSummary.Builder)UltraServerSummary.builder().applyMutation(ultraServerSummary)).build());
        }
    }
}

