/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.FSxLustreConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentConfigDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentConfigDetails> {
    private static final SdkField<FSxLustreConfig> F_SX_LUSTRE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FSxLustreConfig").getter(EnvironmentConfigDetails.getter(EnvironmentConfigDetails::fSxLustreConfig)).setter(EnvironmentConfigDetails.setter(Builder::fSxLustreConfig)).constructor(FSxLustreConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FSxLustreConfig").build()}).build();
    private static final SdkField<String> S3_OUTPUT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3OutputPath").getter(EnvironmentConfigDetails.getter(EnvironmentConfigDetails::s3OutputPath)).setter(EnvironmentConfigDetails.setter(Builder::s3OutputPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(F_SX_LUSTRE_CONFIG_FIELD, S3_OUTPUT_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnvironmentConfigDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final FSxLustreConfig fSxLustreConfig;
    private final String s3OutputPath;

    private EnvironmentConfigDetails(BuilderImpl builder) {
        this.fSxLustreConfig = builder.fSxLustreConfig;
        this.s3OutputPath = builder.s3OutputPath;
    }

    public final FSxLustreConfig fSxLustreConfig() {
        return this.fSxLustreConfig;
    }

    public final String s3OutputPath() {
        return this.s3OutputPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fSxLustreConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentConfigDetails)) {
            return false;
        }
        EnvironmentConfigDetails other = (EnvironmentConfigDetails)obj;
        return Objects.equals(this.fSxLustreConfig(), other.fSxLustreConfig()) && Objects.equals(this.s3OutputPath(), other.s3OutputPath());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentConfigDetails").add("FSxLustreConfig", (Object)this.fSxLustreConfig()).add("S3OutputPath", (Object)this.s3OutputPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FSxLustreConfig": {
                return Optional.ofNullable(clazz.cast(this.fSxLustreConfig()));
            }
            case "S3OutputPath": {
                return Optional.ofNullable(clazz.cast(this.s3OutputPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FSxLustreConfig", F_SX_LUSTRE_CONFIG_FIELD);
        map.put("S3OutputPath", S3_OUTPUT_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentConfigDetails, T> g) {
        return obj -> g.apply((EnvironmentConfigDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FSxLustreConfig fSxLustreConfig;
        private String s3OutputPath;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentConfigDetails model) {
            this.fSxLustreConfig(model.fSxLustreConfig);
            this.s3OutputPath(model.s3OutputPath);
        }

        public final FSxLustreConfig.Builder getFSxLustreConfig() {
            return this.fSxLustreConfig != null ? this.fSxLustreConfig.toBuilder() : null;
        }

        public final void setFSxLustreConfig(FSxLustreConfig.BuilderImpl fSxLustreConfig) {
            this.fSxLustreConfig = fSxLustreConfig != null ? fSxLustreConfig.build() : null;
        }

        @Override
        public final Builder fSxLustreConfig(FSxLustreConfig fSxLustreConfig) {
            this.fSxLustreConfig = fSxLustreConfig;
            return this;
        }

        public final String getS3OutputPath() {
            return this.s3OutputPath;
        }

        public final void setS3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
        }

        @Override
        public final Builder s3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        public EnvironmentConfigDetails build() {
            return new EnvironmentConfigDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentConfigDetails> {
        public Builder fSxLustreConfig(FSxLustreConfig var1);

        default public Builder fSxLustreConfig(Consumer<FSxLustreConfig.Builder> fSxLustreConfig) {
            return this.fSxLustreConfig((FSxLustreConfig)((FSxLustreConfig.Builder)FSxLustreConfig.builder().applyMutation(fSxLustreConfig)).build());
        }

        public Builder s3OutputPath(String var1);
    }
}

