/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.CompilationJobSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.CompilationJobSummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCompilationJobsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListCompilationJobsResponse> {
    private static final SdkField<List<CompilationJobSummary>> COMPILATION_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CompilationJobSummaries").getter(ListCompilationJobsResponse.getter(ListCompilationJobsResponse::compilationJobSummaries)).setter(ListCompilationJobsResponse.setter(Builder::compilationJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CompilationJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCompilationJobsResponse.getter(ListCompilationJobsResponse::nextToken)).setter(ListCompilationJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPILATION_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCompilationJobsResponse.memberNameToFieldInitializer();
    private final List<CompilationJobSummary> compilationJobSummaries;
    private final String nextToken;

    private ListCompilationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.compilationJobSummaries = builder.compilationJobSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCompilationJobSummaries() {
        return this.compilationJobSummaries != null && !(this.compilationJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<CompilationJobSummary> compilationJobSummaries() {
        return this.compilationJobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompilationJobSummaries() ? this.compilationJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCompilationJobsResponse)) {
            return false;
        }
        ListCompilationJobsResponse other = (ListCompilationJobsResponse)((Object)obj);
        return this.hasCompilationJobSummaries() == other.hasCompilationJobSummaries() && Objects.equals(this.compilationJobSummaries(), other.compilationJobSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCompilationJobsResponse").add("CompilationJobSummaries", this.hasCompilationJobSummaries() ? this.compilationJobSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompilationJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.compilationJobSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CompilationJobSummaries", COMPILATION_JOB_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCompilationJobsResponse, T> g) {
        return obj -> g.apply((ListCompilationJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<CompilationJobSummary> compilationJobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCompilationJobsResponse model) {
            super(model);
            this.compilationJobSummaries(model.compilationJobSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<CompilationJobSummary.Builder> getCompilationJobSummaries() {
            List<CompilationJobSummary.Builder> result = CompilationJobSummariesCopier.copyToBuilder(this.compilationJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCompilationJobSummaries(Collection<CompilationJobSummary.BuilderImpl> compilationJobSummaries) {
            this.compilationJobSummaries = CompilationJobSummariesCopier.copyFromBuilder(compilationJobSummaries);
        }

        @Override
        public final Builder compilationJobSummaries(Collection<CompilationJobSummary> compilationJobSummaries) {
            this.compilationJobSummaries = CompilationJobSummariesCopier.copy(compilationJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compilationJobSummaries(CompilationJobSummary ... compilationJobSummaries) {
            this.compilationJobSummaries(Arrays.asList(compilationJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compilationJobSummaries(Consumer<CompilationJobSummary.Builder> ... compilationJobSummaries) {
            this.compilationJobSummaries(Stream.of(compilationJobSummaries).map(c -> (CompilationJobSummary)((CompilationJobSummary.Builder)CompilationJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCompilationJobsResponse build() {
            return new ListCompilationJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCompilationJobsResponse> {
        public Builder compilationJobSummaries(Collection<CompilationJobSummary> var1);

        public Builder compilationJobSummaries(CompilationJobSummary ... var1);

        public Builder compilationJobSummaries(Consumer<CompilationJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

