/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.DeviceFleetSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.DeviceFleetSummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeviceFleetsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListDeviceFleetsResponse> {
    private static final SdkField<List<DeviceFleetSummary>> DEVICE_FLEET_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeviceFleetSummaries").getter(ListDeviceFleetsResponse.getter(ListDeviceFleetsResponse::deviceFleetSummaries)).setter(ListDeviceFleetsResponse.setter(Builder::deviceFleetSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeviceFleetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDeviceFleetsResponse.getter(ListDeviceFleetsResponse::nextToken)).setter(ListDeviceFleetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_FLEET_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDeviceFleetsResponse.memberNameToFieldInitializer();
    private final List<DeviceFleetSummary> deviceFleetSummaries;
    private final String nextToken;

    private ListDeviceFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.deviceFleetSummaries = builder.deviceFleetSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDeviceFleetSummaries() {
        return this.deviceFleetSummaries != null && !(this.deviceFleetSummaries instanceof SdkAutoConstructList);
    }

    public final List<DeviceFleetSummary> deviceFleetSummaries() {
        return this.deviceFleetSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceFleetSummaries() ? this.deviceFleetSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceFleetsResponse)) {
            return false;
        }
        ListDeviceFleetsResponse other = (ListDeviceFleetsResponse)((Object)obj);
        return this.hasDeviceFleetSummaries() == other.hasDeviceFleetSummaries() && Objects.equals(this.deviceFleetSummaries(), other.deviceFleetSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDeviceFleetsResponse").add("DeviceFleetSummaries", this.hasDeviceFleetSummaries() ? this.deviceFleetSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceFleetSummaries": {
                return Optional.ofNullable(clazz.cast(this.deviceFleetSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeviceFleetSummaries", DEVICE_FLEET_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDeviceFleetsResponse, T> g) {
        return obj -> g.apply((ListDeviceFleetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<DeviceFleetSummary> deviceFleetSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceFleetsResponse model) {
            super(model);
            this.deviceFleetSummaries(model.deviceFleetSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<DeviceFleetSummary.Builder> getDeviceFleetSummaries() {
            List<DeviceFleetSummary.Builder> result = DeviceFleetSummariesCopier.copyToBuilder(this.deviceFleetSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeviceFleetSummaries(Collection<DeviceFleetSummary.BuilderImpl> deviceFleetSummaries) {
            this.deviceFleetSummaries = DeviceFleetSummariesCopier.copyFromBuilder(deviceFleetSummaries);
        }

        @Override
        public final Builder deviceFleetSummaries(Collection<DeviceFleetSummary> deviceFleetSummaries) {
            this.deviceFleetSummaries = DeviceFleetSummariesCopier.copy(deviceFleetSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceFleetSummaries(DeviceFleetSummary ... deviceFleetSummaries) {
            this.deviceFleetSummaries(Arrays.asList(deviceFleetSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceFleetSummaries(Consumer<DeviceFleetSummary.Builder> ... deviceFleetSummaries) {
            this.deviceFleetSummaries(Stream.of(deviceFleetSummaries).map(c -> (DeviceFleetSummary)((DeviceFleetSummary.Builder)DeviceFleetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDeviceFleetsResponse build() {
            return new ListDeviceFleetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeviceFleetsResponse> {
        public Builder deviceFleetSummaries(Collection<DeviceFleetSummary> var1);

        public Builder deviceFleetSummaries(DeviceFleetSummary ... var1);

        public Builder deviceFleetSummaries(Consumer<DeviceFleetSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

