/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.sagemaker.model.AddAssociationRequest;
import software.amazon.awssdk.services.sagemaker.model.AddAssociationResponse;
import software.amazon.awssdk.services.sagemaker.model.AddTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.AddTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.AttachClusterNodeVolumeRequest;
import software.amazon.awssdk.services.sagemaker.model.AttachClusterNodeVolumeResponse;
import software.amazon.awssdk.services.sagemaker.model.BatchAddClusterNodesRequest;
import software.amazon.awssdk.services.sagemaker.model.BatchAddClusterNodesResponse;
import software.amazon.awssdk.services.sagemaker.model.BatchDeleteClusterNodesRequest;
import software.amazon.awssdk.services.sagemaker.model.BatchDeleteClusterNodesResponse;
import software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateActionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateActionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAppRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAppResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateArtifactRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateArtifactResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobV2Request;
import software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobV2Response;
import software.amazon.awssdk.services.sagemaker.model.CreateClusterRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateClusterResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateClusterSchedulerConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateClusterSchedulerConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateComputeQuotaRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateComputeQuotaResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateContextRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateContextResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateDeviceFleetRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateDeviceFleetResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateDomainRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateDomainResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentStageRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentStageResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgePackagingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEdgePackagingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateHubContentPresignedUrlsRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateHubContentPresignedUrlsResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateHubContentReferenceRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateHubContentReferenceResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateHubRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateHubResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateHumanTaskUiRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateHumanTaskUiResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateImageRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateImageResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateImageVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateImageVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateMlflowTrackingServerRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateMlflowTrackingServerResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelCardExportJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelCardExportJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelCardRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelCardResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateModelRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateModelResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateOptimizationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateOptimizationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePartnerAppPresignedUrlRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePartnerAppPresignedUrlResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePartnerAppRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePartnerAppResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePipelineRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePipelineResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedMlflowTrackingServerUrlRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedMlflowTrackingServerUrlResponse;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest;
import software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateProjectRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateProjectResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateSpaceRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateSpaceResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTrainingPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTransformJobRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTransformJobResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateTrialRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateTrialResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateUserProfileRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateUserProfileResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkforceRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkforceResponse;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.CreateWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteActionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteActionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAlgorithmRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAlgorithmResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAppImageConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAppImageConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAppRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAppResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteArtifactRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteArtifactResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteAssociationRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteAssociationResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteClusterRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteClusterResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteClusterSchedulerConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteClusterSchedulerConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteComputeQuotaRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteComputeQuotaResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteContextRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteContextResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteDataQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteDataQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteDeviceFleetRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteDeviceFleetResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteDomainRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteDomainResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentStageRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentStageResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteFlowDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteFlowDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteHubContentReferenceRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteHubContentReferenceResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteHubContentRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteHubContentResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteHubRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteHubResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteHumanTaskUiRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteHumanTaskUiResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteImageRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteImageResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteImageVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteImageVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteInferenceComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteInferenceComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteInferenceExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteInferenceExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteMlflowTrackingServerRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteMlflowTrackingServerResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelBiasJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelBiasJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelCardRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelCardResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelExplainabilityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelExplainabilityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupPolicyRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupPolicyResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteModelResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteOptimizationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteOptimizationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DeletePartnerAppRequest;
import software.amazon.awssdk.services.sagemaker.model.DeletePartnerAppResponse;
import software.amazon.awssdk.services.sagemaker.model.DeletePipelineRequest;
import software.amazon.awssdk.services.sagemaker.model.DeletePipelineResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteProcessingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteProcessingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteProjectRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteProjectResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteSpaceRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteSpaceResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteStudioLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteStudioLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrialRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteTrialResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteUserProfileRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteUserProfileResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkforceRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkforceResponse;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.DeleteWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DeregisterDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.DeregisterDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeActionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeActionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAppRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAppResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeArtifactRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeArtifactResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobV2Request;
import software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobV2Response;
import software.amazon.awssdk.services.sagemaker.model.DescribeClusterEventRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeClusterEventResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeClusterNodeRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeClusterNodeResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeClusterRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeClusterResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeClusterSchedulerConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeClusterSchedulerConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeComputeQuotaRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeComputeQuotaResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeContextRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeContextResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeDeviceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeDeviceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeDomainRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeDomainResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeHubContentRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeHubContentResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeHubRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeHubResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeMlflowTrackingServerRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeMlflowTrackingServerResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelBiasJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelBiasJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelCardExportJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelCardExportJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelCardRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelCardResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeModelResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeOptimizationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeOptimizationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribePartnerAppRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribePartnerAppResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribePipelineResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeProjectRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeProjectResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeReservedCapacityRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeReservedCapacityResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeSpaceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeSpaceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingPlanRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrainingPlanResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrialRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeTrialResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceResponse;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.DescribeWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.DetachClusterNodeVolumeRequest;
import software.amazon.awssdk.services.sagemaker.model.DetachClusterNodeVolumeResponse;
import software.amazon.awssdk.services.sagemaker.model.DisableSagemakerServicecatalogPortfolioRequest;
import software.amazon.awssdk.services.sagemaker.model.DisableSagemakerServicecatalogPortfolioResponse;
import software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.DisassociateTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.EnableSagemakerServicecatalogPortfolioRequest;
import software.amazon.awssdk.services.sagemaker.model.EnableSagemakerServicecatalogPortfolioResponse;
import software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportRequest;
import software.amazon.awssdk.services.sagemaker.model.GetDeviceFleetReportResponse;
import software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyRequest;
import software.amazon.awssdk.services.sagemaker.model.GetLineageGroupPolicyResponse;
import software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyRequest;
import software.amazon.awssdk.services.sagemaker.model.GetModelPackageGroupPolicyResponse;
import software.amazon.awssdk.services.sagemaker.model.GetSagemakerServicecatalogPortfolioStatusRequest;
import software.amazon.awssdk.services.sagemaker.model.GetSagemakerServicecatalogPortfolioStatusResponse;
import software.amazon.awssdk.services.sagemaker.model.GetScalingConfigurationRecommendationRequest;
import software.amazon.awssdk.services.sagemaker.model.GetScalingConfigurationRecommendationResponse;
import software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsRequest;
import software.amazon.awssdk.services.sagemaker.model.GetSearchSuggestionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ImportHubContentRequest;
import software.amazon.awssdk.services.sagemaker.model.ImportHubContentResponse;
import software.amazon.awssdk.services.sagemaker.model.ListActionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListActionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAlgorithmsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAliasesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAliasesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAppImageConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAppsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAppsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListArtifactsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListArtifactsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAssociationsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAssociationsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAutoMlJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobResponse;
import software.amazon.awssdk.services.sagemaker.model.ListClusterEventsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListClusterEventsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListClusterNodesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListClusterNodesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListClusterSchedulerConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListClusterSchedulerConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListClustersRequest;
import software.amazon.awssdk.services.sagemaker.model.ListClustersResponse;
import software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCodeRepositoriesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListComputeQuotasRequest;
import software.amazon.awssdk.services.sagemaker.model.ListComputeQuotasResponse;
import software.amazon.awssdk.services.sagemaker.model.ListContextsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListContextsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListDomainsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDomainsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEdgePackagingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListExperimentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListExperimentsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListFlowDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListHubContentVersionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHubContentVersionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListHubContentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHubContentsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListHubsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHubsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHumanTaskUisResponse;
import software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListHyperParameterTuningJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListImageVersionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListImageVersionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListImagesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListImagesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceComponentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceComponentsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceExperimentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceExperimentsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobStepsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobStepsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsForWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLabelingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListLineageGroupsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListMlflowTrackingServersRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMlflowTrackingServersResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardExportJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardExportJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardVersionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardVersionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelExplainabilityJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelMetadataRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelMetadataResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackagesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackagesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListModelsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertHistoryRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertHistoryResponse;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringExecutionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstanceLifecycleConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListOptimizationJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListOptimizationJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPartnerAppsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPartnerAppsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineParametersForExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineVersionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineVersionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListPipelinesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelinesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListProjectsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListProjectsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListResourceCatalogsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListResourceCatalogsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListSpacesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListSpacesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListStageDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListStageDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListSubscribedWorkteamsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTagsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTagsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsForHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingPlansRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrainingPlansResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTransformJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTransformJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrialComponentsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListTrialsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTrialsResponse;
import software.amazon.awssdk.services.sagemaker.model.ListUltraServersByReservedCapacityRequest;
import software.amazon.awssdk.services.sagemaker.model.ListUltraServersByReservedCapacityResponse;
import software.amazon.awssdk.services.sagemaker.model.ListUserProfilesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListUserProfilesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListWorkforcesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListWorkforcesResponse;
import software.amazon.awssdk.services.sagemaker.model.ListWorkteamsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListWorkteamsResponse;
import software.amazon.awssdk.services.sagemaker.model.PutModelPackageGroupPolicyRequest;
import software.amazon.awssdk.services.sagemaker.model.PutModelPackageGroupPolicyResponse;
import software.amazon.awssdk.services.sagemaker.model.QueryLineageRequest;
import software.amazon.awssdk.services.sagemaker.model.QueryLineageResponse;
import software.amazon.awssdk.services.sagemaker.model.RegisterDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.RegisterDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateRequest;
import software.amazon.awssdk.services.sagemaker.model.RenderUiTemplateResponse;
import software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.RetryPipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.SearchRequest;
import software.amazon.awssdk.services.sagemaker.model.SearchResponse;
import software.amazon.awssdk.services.sagemaker.model.SearchTrainingPlanOfferingsRequest;
import software.amazon.awssdk.services.sagemaker.model.SearchTrainingPlanOfferingsResponse;
import software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureRequest;
import software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepFailureResponse;
import software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessRequest;
import software.amazon.awssdk.services.sagemaker.model.SendPipelineExecutionStepSuccessResponse;
import software.amazon.awssdk.services.sagemaker.model.StartEdgeDeploymentStageRequest;
import software.amazon.awssdk.services.sagemaker.model.StartEdgeDeploymentStageResponse;
import software.amazon.awssdk.services.sagemaker.model.StartInferenceExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.StartInferenceExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.StartMlflowTrackingServerRequest;
import software.amazon.awssdk.services.sagemaker.model.StartMlflowTrackingServerResponse;
import software.amazon.awssdk.services.sagemaker.model.StartMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.StartMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.StartNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.StartNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.StartPipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.StartSessionRequest;
import software.amazon.awssdk.services.sagemaker.model.StartSessionResponse;
import software.amazon.awssdk.services.sagemaker.model.StopAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopAutoMlJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopCompilationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopCompilationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopEdgeDeploymentStageRequest;
import software.amazon.awssdk.services.sagemaker.model.StopEdgeDeploymentStageResponse;
import software.amazon.awssdk.services.sagemaker.model.StopEdgePackagingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopEdgePackagingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopHyperParameterTuningJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopHyperParameterTuningJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopInferenceExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.StopInferenceExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.StopInferenceRecommendationsJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopInferenceRecommendationsJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopLabelingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopLabelingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopMlflowTrackingServerRequest;
import software.amazon.awssdk.services.sagemaker.model.StopMlflowTrackingServerResponse;
import software.amazon.awssdk.services.sagemaker.model.StopMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.StopMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.StopNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.StopNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.StopOptimizationJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopOptimizationJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopPipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.StopPipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.StopProcessingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopProcessingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.StopTransformJobRequest;
import software.amazon.awssdk.services.sagemaker.model.StopTransformJobResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateActionRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateActionResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateAppImageConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateArtifactRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateArtifactResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateClusterRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateClusterResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateClusterSchedulerConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateClusterSchedulerConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateClusterSoftwareRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateClusterSoftwareResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateCodeRepositoryResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateComputeQuotaRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateComputeQuotaResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateContextRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateContextResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateDeviceFleetRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateDeviceFleetResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateDevicesResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateDomainRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateDomainResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateEndpointWeightsAndCapacitiesResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateFeatureGroupRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateFeatureMetadataRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateFeatureMetadataResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateHubContentReferenceRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateHubContentReferenceResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateHubContentRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateHubContentResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateHubRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateHubResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateImageRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateImageResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateImageVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateImageVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateInferenceComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateInferenceComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateInferenceComponentRuntimeConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateInferenceComponentRuntimeConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateInferenceExperimentRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateInferenceExperimentResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateMlflowTrackingServerRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateMlflowTrackingServerResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateModelCardRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateModelCardResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateModelPackageRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateModelPackageResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringAlertRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringAlertResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringScheduleRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateMonitoringScheduleResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceLifecycleConfigRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceLifecycleConfigResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateNotebookInstanceResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdatePartnerAppRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdatePartnerAppResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineExecutionResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineVersionRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdatePipelineVersionResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateProjectRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateProjectResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateSpaceRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateSpaceResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrainingJobResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrialComponentResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrialRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateTrialResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateUserProfileResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkforceResponse;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamRequest;
import software.amazon.awssdk.services.sagemaker.model.UpdateWorkteamResponse;
import software.amazon.awssdk.services.sagemaker.paginators.CreateHubContentPresignedUrlsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListActionsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListAlgorithmsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListAliasesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListAppImageConfigsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListAppsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListArtifactsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListAssociationsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListAutoMLJobsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListCandidatesForAutoMLJobPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListClusterEventsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListClusterNodesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListClusterSchedulerConfigsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListClustersPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListCodeRepositoriesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListCompilationJobsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListComputeQuotasPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListContextsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListDataQualityJobDefinitionsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListDeviceFleetsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListDevicesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListDomainsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListEdgeDeploymentPlansPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListEdgePackagingJobsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListEndpointConfigsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListEndpointsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListExperimentsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListFeatureGroupsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListFlowDefinitionsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListHumanTaskUisPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListHyperParameterTuningJobsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListImageVersionsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListImagesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListInferenceComponentsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListInferenceExperimentsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListInferenceRecommendationsJobStepsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListInferenceRecommendationsJobsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsForWorkteamPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListLabelingJobsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListLineageGroupsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListMlflowTrackingServersPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelBiasJobDefinitionsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelCardExportJobsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelCardVersionsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelCardsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelExplainabilityJobDefinitionsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelMetadataPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelPackageGroupsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelPackagesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelQualityJobDefinitionsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListModelsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringAlertHistoryPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringAlertsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringExecutionsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListMonitoringSchedulesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstanceLifecycleConfigsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListNotebookInstancesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListOptimizationJobsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListPartnerAppsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListPipelineExecutionStepsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListPipelineExecutionsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListPipelineParametersForExecutionPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListPipelineVersionsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListPipelinesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListProcessingJobsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListProjectsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListResourceCatalogsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListSpacesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListStageDevicesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListStudioLifecycleConfigsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListSubscribedWorkteamsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListTagsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsForHyperParameterTuningJobPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrainingJobsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrainingPlansPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListTransformJobsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrialComponentsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListTrialsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListUltraServersByReservedCapacityPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListUserProfilesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListWorkforcesPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.ListWorkteamsPublisher;
import software.amazon.awssdk.services.sagemaker.paginators.QueryLineagePublisher;
import software.amazon.awssdk.services.sagemaker.paginators.SearchPublisher;
import software.amazon.awssdk.services.sagemaker.waiters.SageMakerAsyncWaiter;

/**
 * Service client for accessing SageMaker asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * Provides APIs for creating and managing SageMaker resources.
 * </p>
 * <p>
 * Other Resources:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/whatis.html#first-time-user">SageMaker Developer Guide</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/augmented-ai/2019-11-07/APIReference/Welcome.html">Amazon Augmented AI Runtime
 * API Reference</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SageMakerAsyncClient extends AwsClient {
    String SERVICE_NAME = "sagemaker";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "api.sagemaker";

    /**
     * <p>
     * Creates an <i>association</i> between the source and the destination. A source can be associated with multiple
     * destinations, and a destination can be associated with multiple sources. An association is a lineage tracking
     * entity. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     *
     * @param addAssociationRequest
     * @return A Java Future containing the result of the AddAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.AddAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddAssociationResponse> addAssociation(AddAssociationRequest addAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <i>association</i> between the source and the destination. A source can be associated with multiple
     * destinations, and a destination can be associated with multiple sources. An association is a lineage tracking
     * entity. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddAssociationRequest.Builder} avoiding the need to
     * create one manually via {@link AddAssociationRequest#builder()}
     * </p>
     *
     * @param addAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.AddAssociationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AddAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.AddAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddAssociationResponse> addAssociation(Consumer<AddAssociationRequest.Builder> addAssociationRequest) {
        return addAssociation(AddAssociationRequest.builder().applyMutation(addAssociationRequest).build());
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified SageMaker resource. You can add tags to notebook instances,
     * training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint
     * configurations, and endpoints.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information
     * about tags, see For more information, see <a
     * href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">Amazon Web Services Tagging
     * Strategies</a>.
     * </p>
     * <note>
     * <p>
     * Tags that you add to a hyperparameter tuning job by calling this API are also added to any training jobs that the
     * hyperparameter tuning job launches after you call this API, but not to training jobs that the hyperparameter
     * tuning job launched before you called this API. To make sure that the tags associated with a hyperparameter
     * tuning job are also added to all training jobs that the hyperparameter tuning job launches, add the tags when you
     * first create the tuning job by specifying them in the <code>Tags</code> parameter of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateHyperParameterTuningJob.html"
     * >CreateHyperParameterTuningJob</a>
     * </p>
     * </note> <note>
     * <p>
     * Tags that you add to a SageMaker Domain or User Profile by calling this API are also added to any Apps that the
     * Domain or User Profile launches after you call this API, but not to Apps that the Domain or User Profile launched
     * before you called this API. To make sure that the tags associated with a Domain or User Profile are also added to
     * all Apps that the Domain or User Profile launches, add the tags when you first create the Domain or User Profile
     * by specifying them in the <code>Tags</code> parameter of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateDomain.html">CreateDomain</a> or <a
     * href
     * ="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateUserProfile.html">CreateUserProfile</a>.
     * </p>
     * </note>
     *
     * @param addTagsRequest
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsResponse> addTags(AddTagsRequest addTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified SageMaker resource. You can add tags to notebook instances,
     * training jobs, hyperparameter tuning jobs, batch transform jobs, models, labeling jobs, work teams, endpoint
     * configurations, and endpoints.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. Tag keys must be unique per resource. For more information
     * about tags, see For more information, see <a
     * href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">Amazon Web Services Tagging
     * Strategies</a>.
     * </p>
     * <note>
     * <p>
     * Tags that you add to a hyperparameter tuning job by calling this API are also added to any training jobs that the
     * hyperparameter tuning job launches after you call this API, but not to training jobs that the hyperparameter
     * tuning job launched before you called this API. To make sure that the tags associated with a hyperparameter
     * tuning job are also added to all training jobs that the hyperparameter tuning job launches, add the tags when you
     * first create the tuning job by specifying them in the <code>Tags</code> parameter of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateHyperParameterTuningJob.html"
     * >CreateHyperParameterTuningJob</a>
     * </p>
     * </note> <note>
     * <p>
     * Tags that you add to a SageMaker Domain or User Profile by calling this API are also added to any Apps that the
     * Domain or User Profile launches after you call this API, but not to Apps that the Domain or User Profile launched
     * before you called this API. To make sure that the tags associated with a Domain or User Profile are also added to
     * all Apps that the Domain or User Profile launches, add the tags when you first create the Domain or User Profile
     * by specifying them in the <code>Tags</code> parameter of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateDomain.html">CreateDomain</a> or <a
     * href
     * ="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateUserProfile.html">CreateUserProfile</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsRequest.Builder} avoiding the need to create
     * one manually via {@link AddTagsRequest#builder()}
     * </p>
     *
     * @param addTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.AddTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AddTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AddTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsResponse> addTags(Consumer<AddTagsRequest.Builder> addTagsRequest) {
        return addTags(AddTagsRequest.builder().applyMutation(addTagsRequest).build());
    }

    /**
     * <p>
     * Associates a trial component with a trial. A trial component can be associated with multiple trials. To
     * disassociate a trial component from a trial, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DisassociateTrialComponent.html"
     * >DisassociateTrialComponent</a> API.
     * </p>
     *
     * @param associateTrialComponentRequest
     * @return A Java Future containing the result of the AssociateTrialComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.AssociateTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AssociateTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateTrialComponentResponse> associateTrialComponent(
            AssociateTrialComponentRequest associateTrialComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a trial component with a trial. A trial component can be associated with multiple trials. To
     * disassociate a trial component from a trial, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DisassociateTrialComponent.html"
     * >DisassociateTrialComponent</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateTrialComponentRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateTrialComponentRequest#builder()}
     * </p>
     *
     * @param associateTrialComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.AssociateTrialComponentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateTrialComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.AssociateTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AssociateTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateTrialComponentResponse> associateTrialComponent(
            Consumer<AssociateTrialComponentRequest.Builder> associateTrialComponentRequest) {
        return associateTrialComponent(AssociateTrialComponentRequest.builder().applyMutation(associateTrialComponentRequest)
                .build());
    }

    /**
     * <p>
     * Attaches your Amazon Elastic Block Store (Amazon EBS) volume to a node in your EKS orchestrated HyperPod cluster.
     * </p>
     * <p>
     * This API works with the Amazon Elastic Block Store (Amazon EBS) Container Storage Interface (CSI) driver to
     * manage the lifecycle of persistent storage in your HyperPod EKS clusters.
     * </p>
     *
     * @param attachClusterNodeVolumeRequest
     * @return A Java Future containing the result of the AttachClusterNodeVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.AttachClusterNodeVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AttachClusterNodeVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AttachClusterNodeVolumeResponse> attachClusterNodeVolume(
            AttachClusterNodeVolumeRequest attachClusterNodeVolumeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches your Amazon Elastic Block Store (Amazon EBS) volume to a node in your EKS orchestrated HyperPod cluster.
     * </p>
     * <p>
     * This API works with the Amazon Elastic Block Store (Amazon EBS) Container Storage Interface (CSI) driver to
     * manage the lifecycle of persistent storage in your HyperPod EKS clusters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachClusterNodeVolumeRequest.Builder} avoiding
     * the need to create one manually via {@link AttachClusterNodeVolumeRequest#builder()}
     * </p>
     *
     * @param attachClusterNodeVolumeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.AttachClusterNodeVolumeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AttachClusterNodeVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.AttachClusterNodeVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/AttachClusterNodeVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AttachClusterNodeVolumeResponse> attachClusterNodeVolume(
            Consumer<AttachClusterNodeVolumeRequest.Builder> attachClusterNodeVolumeRequest) {
        return attachClusterNodeVolume(AttachClusterNodeVolumeRequest.builder().applyMutation(attachClusterNodeVolumeRequest)
                .build());
    }

    /**
     * <p>
     * Adds nodes to a HyperPod cluster by incrementing the target count for one or more instance groups. This operation
     * returns a unique <code>NodeLogicalId</code> for each node being added, which can be used to track the
     * provisioning status of the node. This API provides a safer alternative to <code>UpdateCluster</code> for scaling
     * operations by avoiding unintended configuration changes.
     * </p>
     * <note>
     * <p>
     * This API is only supported for clusters using <code>Continuous</code> as the <code>NodeProvisioningMode</code>.
     * </p>
     * </note>
     *
     * @param batchAddClusterNodesRequest
     * @return A Java Future containing the result of the BatchAddClusterNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.BatchAddClusterNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/BatchAddClusterNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAddClusterNodesResponse> batchAddClusterNodes(
            BatchAddClusterNodesRequest batchAddClusterNodesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds nodes to a HyperPod cluster by incrementing the target count for one or more instance groups. This operation
     * returns a unique <code>NodeLogicalId</code> for each node being added, which can be used to track the
     * provisioning status of the node. This API provides a safer alternative to <code>UpdateCluster</code> for scaling
     * operations by avoiding unintended configuration changes.
     * </p>
     * <note>
     * <p>
     * This API is only supported for clusters using <code>Continuous</code> as the <code>NodeProvisioningMode</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchAddClusterNodesRequest.Builder} avoiding the
     * need to create one manually via {@link BatchAddClusterNodesRequest#builder()}
     * </p>
     *
     * @param batchAddClusterNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.BatchAddClusterNodesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchAddClusterNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.BatchAddClusterNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/BatchAddClusterNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchAddClusterNodesResponse> batchAddClusterNodes(
            Consumer<BatchAddClusterNodesRequest.Builder> batchAddClusterNodesRequest) {
        return batchAddClusterNodes(BatchAddClusterNodesRequest.builder().applyMutation(batchAddClusterNodesRequest).build());
    }

    /**
     * <p>
     * Deletes specific nodes within a SageMaker HyperPod cluster. <code>BatchDeleteClusterNodes</code> accepts a
     * cluster name and a list of node IDs.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * To safeguard your work, back up your data to Amazon S3 or an FSx for Lustre file system before invoking the API
     * on a worker node group. This will help prevent any potential data loss from the instance root volume. For more
     * information about backup, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-operate-cli-command.html#sagemaker-hyperpod-operate-cli-command-update-cluster-software-backup"
     * >Use the backup script provided by SageMaker HyperPod</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you want to invoke this API on an existing cluster, you'll first need to patch the cluster by running the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateClusterSoftware.html">
     * UpdateClusterSoftware API</a>. For more information about patching a cluster, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-operate-cli-command.html#sagemaker-hyperpod-operate-cli-command-update-cluster-software"
     * >Update the SageMaker HyperPod platform software of a cluster</a>.
     * </p>
     * </li>
     * </ul>
     * </important>
     *
     * @param batchDeleteClusterNodesRequest
     * @return A Java Future containing the result of the BatchDeleteClusterNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.BatchDeleteClusterNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/BatchDeleteClusterNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteClusterNodesResponse> batchDeleteClusterNodes(
            BatchDeleteClusterNodesRequest batchDeleteClusterNodesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes specific nodes within a SageMaker HyperPod cluster. <code>BatchDeleteClusterNodes</code> accepts a
     * cluster name and a list of node IDs.
     * </p>
     * <important>
     * <ul>
     * <li>
     * <p>
     * To safeguard your work, back up your data to Amazon S3 or an FSx for Lustre file system before invoking the API
     * on a worker node group. This will help prevent any potential data loss from the instance root volume. For more
     * information about backup, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-operate-cli-command.html#sagemaker-hyperpod-operate-cli-command-update-cluster-software-backup"
     * >Use the backup script provided by SageMaker HyperPod</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you want to invoke this API on an existing cluster, you'll first need to patch the cluster by running the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateClusterSoftware.html">
     * UpdateClusterSoftware API</a>. For more information about patching a cluster, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-operate-cli-command.html#sagemaker-hyperpod-operate-cli-command-update-cluster-software"
     * >Update the SageMaker HyperPod platform software of a cluster</a>.
     * </p>
     * </li>
     * </ul>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteClusterNodesRequest.Builder} avoiding
     * the need to create one manually via {@link BatchDeleteClusterNodesRequest#builder()}
     * </p>
     *
     * @param batchDeleteClusterNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.BatchDeleteClusterNodesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDeleteClusterNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.BatchDeleteClusterNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/BatchDeleteClusterNodes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDeleteClusterNodesResponse> batchDeleteClusterNodes(
            Consumer<BatchDeleteClusterNodesRequest.Builder> batchDeleteClusterNodesRequest) {
        return batchDeleteClusterNodes(BatchDeleteClusterNodesRequest.builder().applyMutation(batchDeleteClusterNodesRequest)
                .build());
    }

    /**
     * <p>
     * This action batch describes a list of versioned model packages
     * </p>
     *
     * @param batchDescribeModelPackageRequest
     * @return A Java Future containing the result of the BatchDescribeModelPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.BatchDescribeModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/BatchDescribeModelPackage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDescribeModelPackageResponse> batchDescribeModelPackage(
            BatchDescribeModelPackageRequest batchDescribeModelPackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action batch describes a list of versioned model packages
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDescribeModelPackageRequest.Builder} avoiding
     * the need to create one manually via {@link BatchDescribeModelPackageRequest#builder()}
     * </p>
     *
     * @param batchDescribeModelPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.BatchDescribeModelPackageRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the BatchDescribeModelPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.BatchDescribeModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/BatchDescribeModelPackage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchDescribeModelPackageResponse> batchDescribeModelPackage(
            Consumer<BatchDescribeModelPackageRequest.Builder> batchDescribeModelPackageRequest) {
        return batchDescribeModelPackage(BatchDescribeModelPackageRequest.builder()
                .applyMutation(batchDescribeModelPackageRequest).build());
    }

    /**
     * <p>
     * Creates an <i>action</i>. An action is a lineage tracking entity that represents an action or activity. For
     * example, a model deployment or an HPO job. Generally, an action involves at least one input or output artifact.
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon
     * SageMaker ML Lineage Tracking</a>.
     * </p>
     *
     * @param createActionRequest
     * @return A Java Future containing the result of the CreateAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateActionResponse> createAction(CreateActionRequest createActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <i>action</i>. An action is a lineage tracking entity that represents an action or activity. For
     * example, a model deployment or an HPO job. Generally, an action involves at least one input or output artifact.
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon
     * SageMaker ML Lineage Tracking</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateActionRequest.Builder} avoiding the need to
     * create one manually via {@link CreateActionRequest#builder()}
     * </p>
     *
     * @param createActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateActionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateActionResponse> createAction(Consumer<CreateActionRequest.Builder> createActionRequest) {
        return createAction(CreateActionRequest.builder().applyMutation(createActionRequest).build());
    }

    /**
     * <p>
     * Create a machine learning algorithm that you can use in SageMaker and list in the Amazon Web Services
     * Marketplace.
     * </p>
     *
     * @param createAlgorithmRequest
     * @return A Java Future containing the result of the CreateAlgorithm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAlgorithm" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAlgorithmResponse> createAlgorithm(CreateAlgorithmRequest createAlgorithmRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a machine learning algorithm that you can use in SageMaker and list in the Amazon Web Services
     * Marketplace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAlgorithmRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAlgorithmRequest#builder()}
     * </p>
     *
     * @param createAlgorithmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateAlgorithmRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAlgorithm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAlgorithm" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAlgorithmResponse> createAlgorithm(
            Consumer<CreateAlgorithmRequest.Builder> createAlgorithmRequest) {
        return createAlgorithm(CreateAlgorithmRequest.builder().applyMutation(createAlgorithmRequest).build());
    }

    /**
     * <p>
     * Creates a running app for the specified UserProfile. This operation is automatically invoked by Amazon SageMaker
     * AI upon access to the associated Domain, and when new kernel configurations are selected by the user. A user may
     * have multiple Apps active simultaneously.
     * </p>
     *
     * @param createAppRequest
     * @return A Java Future containing the result of the CreateApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAppResponse> createApp(CreateAppRequest createAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a running app for the specified UserProfile. This operation is automatically invoked by Amazon SageMaker
     * AI upon access to the associated Domain, and when new kernel configurations are selected by the user. A user may
     * have multiple Apps active simultaneously.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAppRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAppRequest#builder()}
     * </p>
     *
     * @param createAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateAppRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAppResponse> createApp(Consumer<CreateAppRequest.Builder> createAppRequest) {
        return createApp(CreateAppRequest.builder().applyMutation(createAppRequest).build());
    }

    /**
     * <p>
     * Creates a configuration for running a SageMaker AI image as a KernelGateway app. The configuration specifies the
     * Amazon Elastic File System storage volume on the image, and a list of the kernels in the image.
     * </p>
     *
     * @param createAppImageConfigRequest
     * @return A Java Future containing the result of the CreateAppImageConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAppImageConfigResponse> createAppImageConfig(
            CreateAppImageConfigRequest createAppImageConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a configuration for running a SageMaker AI image as a KernelGateway app. The configuration specifies the
     * Amazon Elastic File System storage volume on the image, and a list of the kernels in the image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAppImageConfigRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAppImageConfigRequest#builder()}
     * </p>
     *
     * @param createAppImageConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateAppImageConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAppImageConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAppImageConfigResponse> createAppImageConfig(
            Consumer<CreateAppImageConfigRequest.Builder> createAppImageConfigRequest) {
        return createAppImageConfig(CreateAppImageConfigRequest.builder().applyMutation(createAppImageConfigRequest).build());
    }

    /**
     * <p>
     * Creates an <i>artifact</i>. An artifact is a lineage tracking entity that represents a URI addressable object or
     * data. Some examples are the S3 URI of a dataset and the ECR registry path of an image. For more information, see
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     *
     * @param createArtifactRequest
     * @return A Java Future containing the result of the CreateArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateArtifact" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateArtifactResponse> createArtifact(CreateArtifactRequest createArtifactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <i>artifact</i>. An artifact is a lineage tracking entity that represents a URI addressable object or
     * data. Some examples are the S3 URI of a dataset and the ECR registry path of an image. For more information, see
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateArtifactRequest.Builder} avoiding the need to
     * create one manually via {@link CreateArtifactRequest#builder()}
     * </p>
     *
     * @param createArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateArtifactRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateArtifact" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateArtifactResponse> createArtifact(Consumer<CreateArtifactRequest.Builder> createArtifactRequest) {
        return createArtifact(CreateArtifactRequest.builder().applyMutation(createArtifactRequest).build());
    }

    /**
     * <p>
     * Creates an Autopilot job also referred to as Autopilot experiment or AutoML job.
     * </p>
     * <p>
     * An AutoML job in SageMaker AI is a fully automated process that allows you to build machine learning models with
     * minimal effort and machine learning expertise. When initiating an AutoML job, you provide your data and
     * optionally specify parameters tailored to your use case. SageMaker AI then automates the entire model development
     * lifecycle, including data preprocessing, model training, tuning, and evaluation. AutoML jobs are designed to
     * simplify and accelerate the model building process by automating various tasks and exploring different
     * combinations of machine learning algorithms, data preprocessing techniques, and hyperparameter values. The output
     * of an AutoML job comprises one or more trained models ready for deployment and inference. Additionally, SageMaker
     * AI AutoML jobs generate a candidate model leaderboard, allowing you to select the best-performing model for
     * deployment.
     * </p>
     * <p>
     * For more information about AutoML jobs, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html"
     * >https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html</a> in the SageMaker
     * AI developer guide.
     * </p>
     * <note>
     * <p>
     * We recommend using the new versions <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>
     * and <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html">
     * DescribeAutoMLJobV2</a>, which offer backward compatibility.
     * </p>
     * <p>
     * <code>CreateAutoMLJobV2</code> can manage tabular problem types identical to those of its previous version
     * <code>CreateAutoMLJob</code>, as well as time-series forecasting, non-tabular problem types such as image or text
     * classification, and text generation (LLMs fine-tuning).
     * </p>
     * <p>
     * Find guidelines about how to migrate a <code>CreateAutoMLJob</code> to <code>CreateAutoMLJobV2</code> in <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-create-experiment.html#autopilot-create-experiment-api-migrate-v1-v2"
     * >Migrate a CreateAutoMLJob to CreateAutoMLJobV2</a>.
     * </p>
     * </note>
     * <p>
     * You can find the best-performing model after you run an AutoML job by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html"
     * >DescribeAutoMLJobV2</a> (recommended) or <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJob.html"
     * >DescribeAutoMLJob</a>.
     * </p>
     *
     * @param createAutoMlJobRequest
     * @return A Java Future containing the result of the CreateAutoMLJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAutoMLJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAutoMlJobResponse> createAutoMLJob(CreateAutoMlJobRequest createAutoMlJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Autopilot job also referred to as Autopilot experiment or AutoML job.
     * </p>
     * <p>
     * An AutoML job in SageMaker AI is a fully automated process that allows you to build machine learning models with
     * minimal effort and machine learning expertise. When initiating an AutoML job, you provide your data and
     * optionally specify parameters tailored to your use case. SageMaker AI then automates the entire model development
     * lifecycle, including data preprocessing, model training, tuning, and evaluation. AutoML jobs are designed to
     * simplify and accelerate the model building process by automating various tasks and exploring different
     * combinations of machine learning algorithms, data preprocessing techniques, and hyperparameter values. The output
     * of an AutoML job comprises one or more trained models ready for deployment and inference. Additionally, SageMaker
     * AI AutoML jobs generate a candidate model leaderboard, allowing you to select the best-performing model for
     * deployment.
     * </p>
     * <p>
     * For more information about AutoML jobs, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html"
     * >https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html</a> in the SageMaker
     * AI developer guide.
     * </p>
     * <note>
     * <p>
     * We recommend using the new versions <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>
     * and <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html">
     * DescribeAutoMLJobV2</a>, which offer backward compatibility.
     * </p>
     * <p>
     * <code>CreateAutoMLJobV2</code> can manage tabular problem types identical to those of its previous version
     * <code>CreateAutoMLJob</code>, as well as time-series forecasting, non-tabular problem types such as image or text
     * classification, and text generation (LLMs fine-tuning).
     * </p>
     * <p>
     * Find guidelines about how to migrate a <code>CreateAutoMLJob</code> to <code>CreateAutoMLJobV2</code> in <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-create-experiment.html#autopilot-create-experiment-api-migrate-v1-v2"
     * >Migrate a CreateAutoMLJob to CreateAutoMLJobV2</a>.
     * </p>
     * </note>
     * <p>
     * You can find the best-performing model after you run an AutoML job by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html"
     * >DescribeAutoMLJobV2</a> (recommended) or <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJob.html"
     * >DescribeAutoMLJob</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAutoMlJobRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAutoMlJobRequest#builder()}
     * </p>
     *
     * @param createAutoMlJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAutoMLJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAutoMLJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAutoMlJobResponse> createAutoMLJob(
            Consumer<CreateAutoMlJobRequest.Builder> createAutoMlJobRequest) {
        return createAutoMLJob(CreateAutoMlJobRequest.builder().applyMutation(createAutoMlJobRequest).build());
    }

    /**
     * <p>
     * Creates an Autopilot job also referred to as Autopilot experiment or AutoML job V2.
     * </p>
     * <p>
     * An AutoML job in SageMaker AI is a fully automated process that allows you to build machine learning models with
     * minimal effort and machine learning expertise. When initiating an AutoML job, you provide your data and
     * optionally specify parameters tailored to your use case. SageMaker AI then automates the entire model development
     * lifecycle, including data preprocessing, model training, tuning, and evaluation. AutoML jobs are designed to
     * simplify and accelerate the model building process by automating various tasks and exploring different
     * combinations of machine learning algorithms, data preprocessing techniques, and hyperparameter values. The output
     * of an AutoML job comprises one or more trained models ready for deployment and inference. Additionally, SageMaker
     * AI AutoML jobs generate a candidate model leaderboard, allowing you to select the best-performing model for
     * deployment.
     * </p>
     * <p>
     * For more information about AutoML jobs, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html"
     * >https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html</a> in the SageMaker
     * AI developer guide.
     * </p>
     * <p>
     * AutoML jobs V2 support various problem types such as regression, binary, and multiclass classification with
     * tabular data, text and image classification, time-series forecasting, and fine-tuning of large language models
     * (LLMs) for text generation.
     * </p>
     * <note>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>
     * and <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html">
     * DescribeAutoMLJobV2</a> are new versions of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html">CreateAutoMLJob</a> and
     * <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJob.html">DescribeAutoMLJob</a>
     * which offer backward compatibility.
     * </p>
     * <p>
     * <code>CreateAutoMLJobV2</code> can manage tabular problem types identical to those of its previous version
     * <code>CreateAutoMLJob</code>, as well as time-series forecasting, non-tabular problem types such as image or text
     * classification, and text generation (LLMs fine-tuning).
     * </p>
     * <p>
     * Find guidelines about how to migrate a <code>CreateAutoMLJob</code> to <code>CreateAutoMLJobV2</code> in <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-create-experiment.html#autopilot-create-experiment-api-migrate-v1-v2"
     * >Migrate a CreateAutoMLJob to CreateAutoMLJobV2</a>.
     * </p>
     * </note>
     * <p>
     * For the list of available problem types supported by <code>CreateAutoMLJobV2</code>, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLProblemTypeConfig.html"
     * >AutoMLProblemTypeConfig</a>.
     * </p>
     * <p>
     * You can find the best-performing model after you run an AutoML job V2 by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html"
     * >DescribeAutoMLJobV2</a>.
     * </p>
     *
     * @param createAutoMlJobV2Request
     * @return A Java Future containing the result of the CreateAutoMLJobV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateAutoMLJobV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAutoMLJobV2" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAutoMlJobV2Response> createAutoMLJobV2(CreateAutoMlJobV2Request createAutoMlJobV2Request) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Autopilot job also referred to as Autopilot experiment or AutoML job V2.
     * </p>
     * <p>
     * An AutoML job in SageMaker AI is a fully automated process that allows you to build machine learning models with
     * minimal effort and machine learning expertise. When initiating an AutoML job, you provide your data and
     * optionally specify parameters tailored to your use case. SageMaker AI then automates the entire model development
     * lifecycle, including data preprocessing, model training, tuning, and evaluation. AutoML jobs are designed to
     * simplify and accelerate the model building process by automating various tasks and exploring different
     * combinations of machine learning algorithms, data preprocessing techniques, and hyperparameter values. The output
     * of an AutoML job comprises one or more trained models ready for deployment and inference. Additionally, SageMaker
     * AI AutoML jobs generate a candidate model leaderboard, allowing you to select the best-performing model for
     * deployment.
     * </p>
     * <p>
     * For more information about AutoML jobs, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html"
     * >https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development.html</a> in the SageMaker
     * AI developer guide.
     * </p>
     * <p>
     * AutoML jobs V2 support various problem types such as regression, binary, and multiclass classification with
     * tabular data, text and image classification, time-series forecasting, and fine-tuning of large language models
     * (LLMs) for text generation.
     * </p>
     * <note>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>
     * and <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html">
     * DescribeAutoMLJobV2</a> are new versions of <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html">CreateAutoMLJob</a> and
     * <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJob.html">DescribeAutoMLJob</a>
     * which offer backward compatibility.
     * </p>
     * <p>
     * <code>CreateAutoMLJobV2</code> can manage tabular problem types identical to those of its previous version
     * <code>CreateAutoMLJob</code>, as well as time-series forecasting, non-tabular problem types such as image or text
     * classification, and text generation (LLMs fine-tuning).
     * </p>
     * <p>
     * Find guidelines about how to migrate a <code>CreateAutoMLJob</code> to <code>CreateAutoMLJobV2</code> in <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/autopilot-automate-model-development-create-experiment.html#autopilot-create-experiment-api-migrate-v1-v2"
     * >Migrate a CreateAutoMLJob to CreateAutoMLJobV2</a>.
     * </p>
     * </note>
     * <p>
     * For the list of available problem types supported by <code>CreateAutoMLJobV2</code>, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_AutoMLProblemTypeConfig.html"
     * >AutoMLProblemTypeConfig</a>.
     * </p>
     * <p>
     * You can find the best-performing model after you run an AutoML job V2 by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeAutoMLJobV2.html"
     * >DescribeAutoMLJobV2</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAutoMlJobV2Request.Builder} avoiding the need
     * to create one manually via {@link CreateAutoMlJobV2Request#builder()}
     * </p>
     *
     * @param createAutoMlJobV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateAutoMlJobV2Request.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAutoMLJobV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateAutoMLJobV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateAutoMLJobV2" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAutoMlJobV2Response> createAutoMLJobV2(
            Consumer<CreateAutoMlJobV2Request.Builder> createAutoMlJobV2Request) {
        return createAutoMLJobV2(CreateAutoMlJobV2Request.builder().applyMutation(createAutoMlJobV2Request).build());
    }

    /**
     * <p>
     * Creates a SageMaker HyperPod cluster. SageMaker HyperPod is a capability of SageMaker for creating and managing
     * persistent clusters for developing large machine learning models, such as large language models (LLMs) and
     * diffusion models. To learn more, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod.html">Amazon SageMaker HyperPod</a> in
     * the <i>Amazon SageMaker Developer Guide</i>.
     * </p>
     *
     * @param createClusterRequest
     * @return A Java Future containing the result of the CreateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClusterResponse> createCluster(CreateClusterRequest createClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a SageMaker HyperPod cluster. SageMaker HyperPod is a capability of SageMaker for creating and managing
     * persistent clusters for developing large machine learning models, such as large language models (LLMs) and
     * diffusion models. To learn more, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod.html">Amazon SageMaker HyperPod</a> in
     * the <i>Amazon SageMaker Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterRequest.Builder} avoiding the need to
     * create one manually via {@link CreateClusterRequest#builder()}
     * </p>
     *
     * @param createClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateClusterResponse> createCluster(Consumer<CreateClusterRequest.Builder> createClusterRequest) {
        return createCluster(CreateClusterRequest.builder().applyMutation(createClusterRequest).build());
    }

    /**
     * <p>
     * Create cluster policy configuration. This policy is used for task prioritization and fair-share allocation of
     * idle compute. This helps prioritize critical workloads and distributes idle compute across entities.
     * </p>
     *
     * @param createClusterSchedulerConfigRequest
     * @return A Java Future containing the result of the CreateClusterSchedulerConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateClusterSchedulerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateClusterSchedulerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateClusterSchedulerConfigResponse> createClusterSchedulerConfig(
            CreateClusterSchedulerConfigRequest createClusterSchedulerConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create cluster policy configuration. This policy is used for task prioritization and fair-share allocation of
     * idle compute. This helps prioritize critical workloads and distributes idle compute across entities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateClusterSchedulerConfigRequest.Builder}
     * avoiding the need to create one manually via {@link CreateClusterSchedulerConfigRequest#builder()}
     * </p>
     *
     * @param createClusterSchedulerConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateClusterSchedulerConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateClusterSchedulerConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateClusterSchedulerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateClusterSchedulerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateClusterSchedulerConfigResponse> createClusterSchedulerConfig(
            Consumer<CreateClusterSchedulerConfigRequest.Builder> createClusterSchedulerConfigRequest) {
        return createClusterSchedulerConfig(CreateClusterSchedulerConfigRequest.builder()
                .applyMutation(createClusterSchedulerConfigRequest).build());
    }

    /**
     * <p>
     * Creates a Git repository as a resource in your SageMaker AI account. You can associate the repository with
     * notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a
     * resource in your SageMaker AI account, so it can be associated with more than one notebook instance, and it
     * persists independently from the lifecycle of any notebook instances it is associated with.
     * </p>
     * <p>
     * The repository can be hosted either in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or
     * in any other Git repository.
     * </p>
     *
     * @param createCodeRepositoryRequest
     * @return A Java Future containing the result of the CreateCodeRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCodeRepositoryResponse> createCodeRepository(
            CreateCodeRepositoryRequest createCodeRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Git repository as a resource in your SageMaker AI account. You can associate the repository with
     * notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a
     * resource in your SageMaker AI account, so it can be associated with more than one notebook instance, and it
     * persists independently from the lifecycle of any notebook instances it is associated with.
     * </p>
     * <p>
     * The repository can be hosted either in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or
     * in any other Git repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCodeRepositoryRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCodeRepositoryRequest#builder()}
     * </p>
     *
     * @param createCodeRepositoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateCodeRepositoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateCodeRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCodeRepositoryResponse> createCodeRepository(
            Consumer<CreateCodeRepositoryRequest.Builder> createCodeRepositoryRequest) {
        return createCodeRepository(CreateCodeRepositoryRequest.builder().applyMutation(createCodeRepositoryRequest).build());
    }

    /**
     * <p>
     * Starts a model compilation job. After the model has been compiled, Amazon SageMaker AI saves the resulting model
     * artifacts to an Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * </p>
     * <p>
     * If you choose to host your model using Amazon SageMaker AI hosting services, you can use the resulting model
     * artifacts as part of the model. You can also use the artifacts with Amazon Web Services IoT Greengrass. In that
     * case, deploy them as an ML resource.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A name for the compilation job
     * </p>
     * </li>
     * <li>
     * <p>
     * Information about the input model artifacts
     * </p>
     * </li>
     * <li>
     * <p>
     * The output location for the compiled model and the device (target) that the model runs on
     * </p>
     * </li>
     * <li>
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker AI assumes to perform the model compilation
     * job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also provide a <code>Tag</code> to track the model compilation job's resource use and costs. The response
     * body contains the <code>CompilationJobArn</code> for the compiled job.
     * </p>
     * <p>
     * To stop a model compilation job, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopCompilationJob.html"
     * >StopCompilationJob</a>. To get information about a particular model compilation job, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeCompilationJob.html"
     * >DescribeCompilationJob</a>. To get information about multiple model compilation jobs, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListCompilationJobs.html"
     * >ListCompilationJobs</a>.
     * </p>
     *
     * @param createCompilationJobRequest
     * @return A Java Future containing the result of the CreateCompilationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateCompilationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCompilationJobResponse> createCompilationJob(
            CreateCompilationJobRequest createCompilationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a model compilation job. After the model has been compiled, Amazon SageMaker AI saves the resulting model
     * artifacts to an Amazon Simple Storage Service (Amazon S3) bucket that you specify.
     * </p>
     * <p>
     * If you choose to host your model using Amazon SageMaker AI hosting services, you can use the resulting model
     * artifacts as part of the model. You can also use the artifacts with Amazon Web Services IoT Greengrass. In that
     * case, deploy them as an ML resource.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A name for the compilation job
     * </p>
     * </li>
     * <li>
     * <p>
     * Information about the input model artifacts
     * </p>
     * </li>
     * <li>
     * <p>
     * The output location for the compiled model and the device (target) that the model runs on
     * </p>
     * </li>
     * <li>
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker AI assumes to perform the model compilation
     * job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also provide a <code>Tag</code> to track the model compilation job's resource use and costs. The response
     * body contains the <code>CompilationJobArn</code> for the compiled job.
     * </p>
     * <p>
     * To stop a model compilation job, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StopCompilationJob.html"
     * >StopCompilationJob</a>. To get information about a particular model compilation job, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeCompilationJob.html"
     * >DescribeCompilationJob</a>. To get information about multiple model compilation jobs, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListCompilationJobs.html"
     * >ListCompilationJobs</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCompilationJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCompilationJobRequest#builder()}
     * </p>
     *
     * @param createCompilationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateCompilationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateCompilationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateCompilationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCompilationJobResponse> createCompilationJob(
            Consumer<CreateCompilationJobRequest.Builder> createCompilationJobRequest) {
        return createCompilationJob(CreateCompilationJobRequest.builder().applyMutation(createCompilationJobRequest).build());
    }

    /**
     * <p>
     * Create compute allocation definition. This defines how compute is allocated, shared, and borrowed for specified
     * entities. Specifically, how to lend and borrow idle compute and assign a fair-share weight to the specified
     * entities.
     * </p>
     *
     * @param createComputeQuotaRequest
     * @return A Java Future containing the result of the CreateComputeQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateComputeQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateComputeQuota" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateComputeQuotaResponse> createComputeQuota(CreateComputeQuotaRequest createComputeQuotaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create compute allocation definition. This defines how compute is allocated, shared, and borrowed for specified
     * entities. Specifically, how to lend and borrow idle compute and assign a fair-share weight to the specified
     * entities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateComputeQuotaRequest.Builder} avoiding the
     * need to create one manually via {@link CreateComputeQuotaRequest#builder()}
     * </p>
     *
     * @param createComputeQuotaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateComputeQuotaRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateComputeQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateComputeQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateComputeQuota" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateComputeQuotaResponse> createComputeQuota(
            Consumer<CreateComputeQuotaRequest.Builder> createComputeQuotaRequest) {
        return createComputeQuota(CreateComputeQuotaRequest.builder().applyMutation(createComputeQuotaRequest).build());
    }

    /**
     * <p>
     * Creates a <i>context</i>. A context is a lineage tracking entity that represents a logical grouping of other
     * tracking or experiment entities. Some examples are an endpoint and a model package. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     *
     * @param createContextRequest
     * @return A Java Future containing the result of the CreateContext operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateContext" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateContextResponse> createContext(CreateContextRequest createContextRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <i>context</i>. A context is a lineage tracking entity that represents a logical grouping of other
     * tracking or experiment entities. Some examples are an endpoint and a model package. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html">Amazon SageMaker ML Lineage
     * Tracking</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContextRequest.Builder} avoiding the need to
     * create one manually via {@link CreateContextRequest#builder()}
     * </p>
     *
     * @param createContextRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateContextRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateContext operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateContext" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateContextResponse> createContext(Consumer<CreateContextRequest.Builder> createContextRequest) {
        return createContext(CreateContextRequest.builder().applyMutation(createContextRequest).build());
    }

    /**
     * <p>
     * Creates a definition for a job that monitors data quality and drift. For information about model monitor, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker AI Model Monitor</a>.
     * </p>
     *
     * @param createDataQualityJobDefinitionRequest
     * @return A Java Future containing the result of the CreateDataQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDataQualityJobDefinitionResponse> createDataQualityJobDefinition(
            CreateDataQualityJobDefinitionRequest createDataQualityJobDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a definition for a job that monitors data quality and drift. For information about model monitor, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker AI Model Monitor</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataQualityJobDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDataQualityJobDefinitionRequest#builder()}
     * </p>
     *
     * @param createDataQualityJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateDataQualityJobDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateDataQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDataQualityJobDefinitionResponse> createDataQualityJobDefinition(
            Consumer<CreateDataQualityJobDefinitionRequest.Builder> createDataQualityJobDefinitionRequest) {
        return createDataQualityJobDefinition(CreateDataQualityJobDefinitionRequest.builder()
                .applyMutation(createDataQualityJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Creates a device fleet.
     * </p>
     *
     * @param createDeviceFleetRequest
     * @return A Java Future containing the result of the CreateDeviceFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDeviceFleetResponse> createDeviceFleet(CreateDeviceFleetRequest createDeviceFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a device fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeviceFleetRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDeviceFleetRequest#builder()}
     * </p>
     *
     * @param createDeviceFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateDeviceFleetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDeviceFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDeviceFleetResponse> createDeviceFleet(
            Consumer<CreateDeviceFleetRequest.Builder> createDeviceFleetRequest) {
        return createDeviceFleet(CreateDeviceFleetRequest.builder().applyMutation(createDeviceFleetRequest).build());
    }

    /**
     * <p>
     * Creates a <code>Domain</code>. A domain consists of an associated Amazon Elastic File System volume, a list of
     * authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC)
     * configurations. Users within a domain can share notebook files and other artifacts with each other.
     * </p>
     * <p>
     * <b>EFS storage</b>
     * </p>
     * <p>
     * When a domain is created, an EFS volume is created for use by all of the users within the domain. Each user
     * receives a private home directory within the EFS volume for notebooks, Git repositories, and data files.
     * </p>
     * <p>
     * SageMaker AI uses the Amazon Web Services Key Management Service (Amazon Web Services KMS) to encrypt the EFS
     * volume attached to the domain with an Amazon Web Services managed key by default. For more control, you can
     * specify a customer managed key. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/encryption-at-rest.html">Protect Data at Rest Using
     * Encryption</a>.
     * </p>
     * <p>
     * <b>VPC configuration</b>
     * </p>
     * <p>
     * All traffic between the domain and the Amazon EFS volume is through the specified VPC and subnets. For other
     * traffic, you can specify the <code>AppNetworkAccessType</code> parameter. <code>AppNetworkAccessType</code>
     * corresponds to the network access type that you choose when you onboard to the domain. The following options are
     * available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PublicInternetOnly</code> - Non-EFS traffic goes through a VPC managed by Amazon SageMaker AI, which allows
     * internet access. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VpcOnly</code> - All traffic is through the specified VPC and subnets. Internet access is disabled by
     * default. To allow internet access, you must specify a NAT gateway.
     * </p>
     * <p>
     * When internet access is disabled, you won't be able to run a Amazon SageMaker AI Studio notebook or to train or
     * host models unless your VPC has an interface endpoint to the SageMaker AI API and runtime or a NAT gateway and
     * your security groups allow outbound connections.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * NFS traffic over TCP on port 2049 needs to be allowed in both inbound and outbound rules in order to launch a
     * Amazon SageMaker AI Studio app successfully.
     * </p>
     * </important>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-notebooks-and-internet-access.html">Connect Amazon
     * SageMaker AI Studio Notebooks to Resources in a VPC</a>.
     * </p>
     *
     * @param createDomainRequest
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDomainResponse> createDomain(CreateDomainRequest createDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>Domain</code>. A domain consists of an associated Amazon Elastic File System volume, a list of
     * authorized users, and a variety of security, application, policy, and Amazon Virtual Private Cloud (VPC)
     * configurations. Users within a domain can share notebook files and other artifacts with each other.
     * </p>
     * <p>
     * <b>EFS storage</b>
     * </p>
     * <p>
     * When a domain is created, an EFS volume is created for use by all of the users within the domain. Each user
     * receives a private home directory within the EFS volume for notebooks, Git repositories, and data files.
     * </p>
     * <p>
     * SageMaker AI uses the Amazon Web Services Key Management Service (Amazon Web Services KMS) to encrypt the EFS
     * volume attached to the domain with an Amazon Web Services managed key by default. For more control, you can
     * specify a customer managed key. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/encryption-at-rest.html">Protect Data at Rest Using
     * Encryption</a>.
     * </p>
     * <p>
     * <b>VPC configuration</b>
     * </p>
     * <p>
     * All traffic between the domain and the Amazon EFS volume is through the specified VPC and subnets. For other
     * traffic, you can specify the <code>AppNetworkAccessType</code> parameter. <code>AppNetworkAccessType</code>
     * corresponds to the network access type that you choose when you onboard to the domain. The following options are
     * available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PublicInternetOnly</code> - Non-EFS traffic goes through a VPC managed by Amazon SageMaker AI, which allows
     * internet access. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VpcOnly</code> - All traffic is through the specified VPC and subnets. Internet access is disabled by
     * default. To allow internet access, you must specify a NAT gateway.
     * </p>
     * <p>
     * When internet access is disabled, you won't be able to run a Amazon SageMaker AI Studio notebook or to train or
     * host models unless your VPC has an interface endpoint to the SageMaker AI API and runtime or a NAT gateway and
     * your security groups allow outbound connections.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * NFS traffic over TCP on port 2049 needs to be allowed in both inbound and outbound rules in order to launch a
     * Amazon SageMaker AI Studio app successfully.
     * </p>
     * </important>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-notebooks-and-internet-access.html">Connect Amazon
     * SageMaker AI Studio Notebooks to Resources in a VPC</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDomainRequest#builder()}
     * </p>
     *
     * @param createDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDomainResponse> createDomain(Consumer<CreateDomainRequest.Builder> createDomainRequest) {
        return createDomain(CreateDomainRequest.builder().applyMutation(createDomainRequest).build());
    }

    /**
     * <p>
     * Creates an edge deployment plan, consisting of multiple stages. Each stage may have a different deployment
     * configuration and devices.
     * </p>
     *
     * @param createEdgeDeploymentPlanRequest
     * @return A Java Future containing the result of the CreateEdgeDeploymentPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEdgeDeploymentPlanResponse> createEdgeDeploymentPlan(
            CreateEdgeDeploymentPlanRequest createEdgeDeploymentPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an edge deployment plan, consisting of multiple stages. Each stage may have a different deployment
     * configuration and devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEdgeDeploymentPlanRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEdgeDeploymentPlanRequest#builder()}
     * </p>
     *
     * @param createEdgeDeploymentPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentPlanRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateEdgeDeploymentPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEdgeDeploymentPlanResponse> createEdgeDeploymentPlan(
            Consumer<CreateEdgeDeploymentPlanRequest.Builder> createEdgeDeploymentPlanRequest) {
        return createEdgeDeploymentPlan(CreateEdgeDeploymentPlanRequest.builder().applyMutation(createEdgeDeploymentPlanRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new stage in an existing edge deployment plan.
     * </p>
     *
     * @param createEdgeDeploymentStageRequest
     * @return A Java Future containing the result of the CreateEdgeDeploymentStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateEdgeDeploymentStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgeDeploymentStage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEdgeDeploymentStageResponse> createEdgeDeploymentStage(
            CreateEdgeDeploymentStageRequest createEdgeDeploymentStageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new stage in an existing edge deployment plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEdgeDeploymentStageRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEdgeDeploymentStageRequest#builder()}
     * </p>
     *
     * @param createEdgeDeploymentStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateEdgeDeploymentStageRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateEdgeDeploymentStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateEdgeDeploymentStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgeDeploymentStage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEdgeDeploymentStageResponse> createEdgeDeploymentStage(
            Consumer<CreateEdgeDeploymentStageRequest.Builder> createEdgeDeploymentStageRequest) {
        return createEdgeDeploymentStage(CreateEdgeDeploymentStageRequest.builder()
                .applyMutation(createEdgeDeploymentStageRequest).build());
    }

    /**
     * <p>
     * Starts a SageMaker Edge Manager model packaging job. Edge Manager will use the model artifacts from the Amazon
     * Simple Storage Service bucket that you specify. After the model has been packaged, Amazon SageMaker saves the
     * resulting artifacts to an S3 bucket that you specify.
     * </p>
     *
     * @param createEdgePackagingJobRequest
     * @return A Java Future containing the result of the CreateEdgePackagingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateEdgePackagingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgePackagingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEdgePackagingJobResponse> createEdgePackagingJob(
            CreateEdgePackagingJobRequest createEdgePackagingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a SageMaker Edge Manager model packaging job. Edge Manager will use the model artifacts from the Amazon
     * Simple Storage Service bucket that you specify. After the model has been packaged, Amazon SageMaker saves the
     * resulting artifacts to an S3 bucket that you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEdgePackagingJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEdgePackagingJobRequest#builder()}
     * </p>
     *
     * @param createEdgePackagingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateEdgePackagingJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEdgePackagingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateEdgePackagingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEdgePackagingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEdgePackagingJobResponse> createEdgePackagingJob(
            Consumer<CreateEdgePackagingJobRequest.Builder> createEdgePackagingJobRequest) {
        return createEdgePackagingJob(CreateEdgePackagingJobRequest.builder().applyMutation(createEdgePackagingJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates an endpoint using the endpoint configuration specified in the request. SageMaker uses the endpoint to
     * provision resources and deploy models. You create the endpoint configuration with the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
     * >CreateEndpointConfig</a> API.
     * </p>
     * <p>
     * Use this API to deploy models using SageMaker hosting services.
     * </p>
     * <note>
     * <p>
     * You must not delete an <code>EndpointConfig</code> that is in use by an endpoint that is live or while the
     * <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. To
     * update an endpoint, you must create a new <code>EndpointConfig</code>.
     * </p>
     * </note>
     * <p>
     * The endpoint name must be unique within an Amazon Web Services Region in your Amazon Web Services account.
     * </p>
     * <p>
     * When it receives the request, SageMaker creates the endpoint, launches the resources (ML compute instances), and
     * deploys the model(s) on them.
     * </p>
     * <note>
     * <p>
     * When you call <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a>, a
     * load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a
     * DynamoDB table supporting <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html">
     * <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed
     * write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB,
     * this causes a validation error. If you repeat your read request after a short time, the response should return
     * the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers
     * call <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpointConfig.html">
     * DescribeEndpointConfig</a> before calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> to
     * minimize the potential impact of a DynamoDB eventually consistent read.
     * </p>
     * </note>
     * <p>
     * When SageMaker receives the request, it sets the endpoint status to <code>Creating</code>. After it creates the
     * endpoint, it sets the status to <code>InService</code>. SageMaker can then process incoming requests for
     * inferences. To check the status of an endpoint, use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpoint.html">DescribeEndpoint</a>
     * API.
     * </p>
     * <p>
     * If any of the models hosted at this endpoint get model data from an Amazon S3 location, SageMaker uses Amazon Web
     * Services Security Token Service to download model artifacts from the S3 path you provided. Amazon Web Services
     * STS is activated in your Amazon Web Services account by default. If you previously deactivated Amazon Web
     * Services STS for a region, you need to reactivate Amazon Web Services STS for that region. For more information,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating
     * and Deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Amazon Web Services
     * Identity and Access Management User Guide</i>.
     * </p>
     * <note>
     * <p>
     * To add the IAM role policies for using this API operation, go to the <a
     * href="https://console.aws.amazon.com/iam/">IAM console</a>, and choose Roles in the left navigation pane. Search
     * the IAM role that you want to grant access to use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> and
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html">
     * CreateEndpointConfig</a> API operations, add the following policies to the role.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Option 1: For a full SageMaker access, search and attach the <code>AmazonSageMakerFullAccess</code> policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * Option 2: For granting a limited access to an IAM role, paste the following Action elements manually into the
     * JSON file of the IAM role:
     * </p>
     * <p>
     * <code>"Action": ["sagemaker:CreateEndpoint", "sagemaker:CreateEndpointConfig"]</code>
     * </p>
     * <p>
     * <code>"Resource": [</code>
     * </p>
     * <p>
     * <code>"arn:aws:sagemaker:region:account-id:endpoint/endpointName"</code>
     * </p>
     * <p>
     * <code>"arn:aws:sagemaker:region:account-id:endpoint-config/endpointConfigName"</code>
     * </p>
     * <p>
     * <code>]</code>
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/api-permissions-reference.html">SageMaker API Permissions:
     * Actions, Permissions, and Resources Reference</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createEndpointRequest
     * @return A Java Future containing the result of the CreateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateEndpointResponse> createEndpoint(CreateEndpointRequest createEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an endpoint using the endpoint configuration specified in the request. SageMaker uses the endpoint to
     * provision resources and deploy models. You create the endpoint configuration with the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
     * >CreateEndpointConfig</a> API.
     * </p>
     * <p>
     * Use this API to deploy models using SageMaker hosting services.
     * </p>
     * <note>
     * <p>
     * You must not delete an <code>EndpointConfig</code> that is in use by an endpoint that is live or while the
     * <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. To
     * update an endpoint, you must create a new <code>EndpointConfig</code>.
     * </p>
     * </note>
     * <p>
     * The endpoint name must be unique within an Amazon Web Services Region in your Amazon Web Services account.
     * </p>
     * <p>
     * When it receives the request, SageMaker creates the endpoint, launches the resources (ML compute instances), and
     * deploys the model(s) on them.
     * </p>
     * <note>
     * <p>
     * When you call <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a>, a
     * load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a
     * DynamoDB table supporting <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html">
     * <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed
     * write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB,
     * this causes a validation error. If you repeat your read request after a short time, the response should return
     * the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers
     * call <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpointConfig.html">
     * DescribeEndpointConfig</a> before calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> to
     * minimize the potential impact of a DynamoDB eventually consistent read.
     * </p>
     * </note>
     * <p>
     * When SageMaker receives the request, it sets the endpoint status to <code>Creating</code>. After it creates the
     * endpoint, it sets the status to <code>InService</code>. SageMaker can then process incoming requests for
     * inferences. To check the status of an endpoint, use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpoint.html">DescribeEndpoint</a>
     * API.
     * </p>
     * <p>
     * If any of the models hosted at this endpoint get model data from an Amazon S3 location, SageMaker uses Amazon Web
     * Services Security Token Service to download model artifacts from the S3 path you provided. Amazon Web Services
     * STS is activated in your Amazon Web Services account by default. If you previously deactivated Amazon Web
     * Services STS for a region, you need to reactivate Amazon Web Services STS for that region. For more information,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating
     * and Deactivating Amazon Web Services STS in an Amazon Web Services Region</a> in the <i>Amazon Web Services
     * Identity and Access Management User Guide</i>.
     * </p>
     * <note>
     * <p>
     * To add the IAM role policies for using this API operation, go to the <a
     * href="https://console.aws.amazon.com/iam/">IAM console</a>, and choose Roles in the left navigation pane. Search
     * the IAM role that you want to grant access to use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> and
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html">
     * CreateEndpointConfig</a> API operations, add the following policies to the role.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Option 1: For a full SageMaker access, search and attach the <code>AmazonSageMakerFullAccess</code> policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * Option 2: For granting a limited access to an IAM role, paste the following Action elements manually into the
     * JSON file of the IAM role:
     * </p>
     * <p>
     * <code>"Action": ["sagemaker:CreateEndpoint", "sagemaker:CreateEndpointConfig"]</code>
     * </p>
     * <p>
     * <code>"Resource": [</code>
     * </p>
     * <p>
     * <code>"arn:aws:sagemaker:region:account-id:endpoint/endpointName"</code>
     * </p>
     * <p>
     * <code>"arn:aws:sagemaker:region:account-id:endpoint-config/endpointConfigName"</code>
     * </p>
     * <p>
     * <code>]</code>
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/api-permissions-reference.html">SageMaker API Permissions:
     * Actions, Permissions, and Resources Reference</a>.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link CreateEndpointRequest#builder()}
     * </p>
     *
     * @param createEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateEndpointRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateEndpointResponse> createEndpoint(Consumer<CreateEndpointRequest.Builder> createEndpointRequest) {
        return createEndpoint(CreateEndpointRequest.builder().applyMutation(createEndpointRequest).build());
    }

    /**
     * <p>
     * Creates an endpoint configuration that SageMaker hosting services uses to deploy models. In the configuration,
     * you identify one or more models, created using the <code>CreateModel</code> API, to deploy and the resources that
     * you want SageMaker to provision. Then you call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> API.
     * </p>
     * <note>
     * <p>
     * Use this API if you want to use SageMaker hosting services to deploy models into production.
     * </p>
     * </note>
     * <p>
     * In the request, you define a <code>ProductionVariant</code>, for each model that you want to deploy. Each
     * <code>ProductionVariant</code> parameter also describes the resources that you want SageMaker to provision. This
     * includes the number and type of ML compute instances to deploy.
     * </p>
     * <p>
     * If you are hosting multiple models, you also assign a <code>VariantWeight</code> to specify how much traffic you
     * want to allocate to each model. For example, suppose that you want to host two models, A and B, and you assign
     * traffic weight 2 for model A and 1 for model B. SageMaker distributes two-thirds of the traffic to Model A, and
     * one-third to model B.
     * </p>
     * <note>
     * <p>
     * When you call <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a>, a
     * load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a
     * DynamoDB table supporting <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html">
     * <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed
     * write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB,
     * this causes a validation error. If you repeat your read request after a short time, the response should return
     * the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers
     * call <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpointConfig.html">
     * DescribeEndpointConfig</a> before calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> to
     * minimize the potential impact of a DynamoDB eventually consistent read.
     * </p>
     * </note>
     *
     * @param createEndpointConfigRequest
     * @return A Java Future containing the result of the CreateEndpointConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEndpointConfigResponse> createEndpointConfig(
            CreateEndpointConfigRequest createEndpointConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an endpoint configuration that SageMaker hosting services uses to deploy models. In the configuration,
     * you identify one or more models, created using the <code>CreateModel</code> API, to deploy and the resources that
     * you want SageMaker to provision. Then you call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> API.
     * </p>
     * <note>
     * <p>
     * Use this API if you want to use SageMaker hosting services to deploy models into production.
     * </p>
     * </note>
     * <p>
     * In the request, you define a <code>ProductionVariant</code>, for each model that you want to deploy. Each
     * <code>ProductionVariant</code> parameter also describes the resources that you want SageMaker to provision. This
     * includes the number and type of ML compute instances to deploy.
     * </p>
     * <p>
     * If you are hosting multiple models, you also assign a <code>VariantWeight</code> to specify how much traffic you
     * want to allocate to each model. For example, suppose that you want to host two models, A and B, and you assign
     * traffic weight 2 for model A and 1 for model B. SageMaker distributes two-thirds of the traffic to Model A, and
     * one-third to model B.
     * </p>
     * <note>
     * <p>
     * When you call <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a>, a
     * load call is made to DynamoDB to verify that your endpoint configuration exists. When you read data from a
     * DynamoDB table supporting <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html">
     * <code>Eventually Consistent Reads</code> </a>, the response might not reflect the results of a recently completed
     * write operation. The response might include some stale data. If the dependent entities are not yet in DynamoDB,
     * this causes a validation error. If you repeat your read request after a short time, the response should return
     * the latest data. So retry logic is recommended to handle these possible issues. We also recommend that customers
     * call <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeEndpointConfig.html">
     * DescribeEndpointConfig</a> before calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpoint.html">CreateEndpoint</a> to
     * minimize the potential impact of a DynamoDB eventually consistent read.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEndpointConfigRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEndpointConfigRequest#builder()}
     * </p>
     *
     * @param createEndpointConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEndpointConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEndpointConfigResponse> createEndpointConfig(
            Consumer<CreateEndpointConfigRequest.Builder> createEndpointConfigRequest) {
        return createEndpointConfig(CreateEndpointConfigRequest.builder().applyMutation(createEndpointConfigRequest).build());
    }

    /**
     * <p>
     * Creates a SageMaker <i>experiment</i>. An experiment is a collection of <i>trials</i> that are observed, compared
     * and evaluated as a group. A trial is a set of steps, called <i>trial components</i>, that produce a machine
     * learning model.
     * </p>
     * <note>
     * <p>
     * In the Studio UI, trials are referred to as <i>run groups</i> and trial components are referred to as
     * <i>runs</i>.
     * </p>
     * </note>
     * <p>
     * The goal of an experiment is to determine the components that produce the best model. Multiple trials are
     * performed, each one isolating and measuring the impact of a change to one or more inputs, while keeping the
     * remaining inputs constant.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to experiments, trials, trial components and then use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search for the
     * tags.
     * </p>
     * <p>
     * To add a description to an experiment, specify the optional <code>Description</code> parameter. To add a
     * description later, or to change the description, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateExperiment.html">UpdateExperiment</a>
     * API.
     * </p>
     * <p>
     * To get a list of all your experiments, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListExperiments.html">ListExperiments</a>
     * API. To view an experiment's properties, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeExperiment.html"
     * >DescribeExperiment</a> API. To get a list of all the trials associated with an experiment, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrials.html">ListTrials</a> API. To
     * create a trial call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrial.html">CreateTrial</a> API.
     * </p>
     *
     * @param createExperimentRequest
     * @return A Java Future containing the result of the CreateExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateExperimentResponse> createExperiment(CreateExperimentRequest createExperimentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a SageMaker <i>experiment</i>. An experiment is a collection of <i>trials</i> that are observed, compared
     * and evaluated as a group. A trial is a set of steps, called <i>trial components</i>, that produce a machine
     * learning model.
     * </p>
     * <note>
     * <p>
     * In the Studio UI, trials are referred to as <i>run groups</i> and trial components are referred to as
     * <i>runs</i>.
     * </p>
     * </note>
     * <p>
     * The goal of an experiment is to determine the components that produce the best model. Multiple trials are
     * performed, each one isolating and measuring the impact of a change to one or more inputs, while keeping the
     * remaining inputs constant.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to experiments, trials, trial components and then use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search for the
     * tags.
     * </p>
     * <p>
     * To add a description to an experiment, specify the optional <code>Description</code> parameter. To add a
     * description later, or to change the description, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_UpdateExperiment.html">UpdateExperiment</a>
     * API.
     * </p>
     * <p>
     * To get a list of all your experiments, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListExperiments.html">ListExperiments</a>
     * API. To view an experiment's properties, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeExperiment.html"
     * >DescribeExperiment</a> API. To get a list of all the trials associated with an experiment, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrials.html">ListTrials</a> API. To
     * create a trial call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrial.html">CreateTrial</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateExperimentRequest.Builder} avoiding the need
     * to create one manually via {@link CreateExperimentRequest#builder()}
     * </p>
     *
     * @param createExperimentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateExperimentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateExperimentResponse> createExperiment(
            Consumer<CreateExperimentRequest.Builder> createExperimentRequest) {
        return createExperiment(CreateExperimentRequest.builder().applyMutation(createExperimentRequest).build());
    }

    /**
     * <p>
     * Create a new <code>FeatureGroup</code>. A <code>FeatureGroup</code> is a group of <code>Features</code> defined
     * in the <code>FeatureStore</code> to describe a <code>Record</code>.
     * </p>
     * <p>
     * The <code>FeatureGroup</code> defines the schema and features contained in the <code>FeatureGroup</code>. A
     * <code>FeatureGroup</code> definition is composed of a list of <code>Features</code>, a
     * <code>RecordIdentifierFeatureName</code>, an <code>EventTimeFeatureName</code> and configurations for its
     * <code>OnlineStore</code> and <code>OfflineStore</code>. Check <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">Amazon Web Services service
     * quotas</a> to see the <code>FeatureGroup</code>s quota for your Amazon Web Services account.
     * </p>
     * <p>
     * Note that it can take approximately 10-15 minutes to provision an <code>OnlineStore</code>
     * <code>FeatureGroup</code> with the <code>InMemory</code> <code>StorageType</code>.
     * </p>
     * <important>
     * <p>
     * You must include at least one of <code>OnlineStoreConfig</code> and <code>OfflineStoreConfig</code> to create a
     * <code>FeatureGroup</code>.
     * </p>
     * </important>
     *
     * @param createFeatureGroupRequest
     * @return A Java Future containing the result of the CreateFeatureGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFeatureGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateFeatureGroupResponse> createFeatureGroup(CreateFeatureGroupRequest createFeatureGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new <code>FeatureGroup</code>. A <code>FeatureGroup</code> is a group of <code>Features</code> defined
     * in the <code>FeatureStore</code> to describe a <code>Record</code>.
     * </p>
     * <p>
     * The <code>FeatureGroup</code> defines the schema and features contained in the <code>FeatureGroup</code>. A
     * <code>FeatureGroup</code> definition is composed of a list of <code>Features</code>, a
     * <code>RecordIdentifierFeatureName</code>, an <code>EventTimeFeatureName</code> and configurations for its
     * <code>OnlineStore</code> and <code>OfflineStore</code>. Check <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">Amazon Web Services service
     * quotas</a> to see the <code>FeatureGroup</code>s quota for your Amazon Web Services account.
     * </p>
     * <p>
     * Note that it can take approximately 10-15 minutes to provision an <code>OnlineStore</code>
     * <code>FeatureGroup</code> with the <code>InMemory</code> <code>StorageType</code>.
     * </p>
     * <important>
     * <p>
     * You must include at least one of <code>OnlineStoreConfig</code> and <code>OfflineStoreConfig</code> to create a
     * <code>FeatureGroup</code>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFeatureGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFeatureGroupRequest#builder()}
     * </p>
     *
     * @param createFeatureGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateFeatureGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateFeatureGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFeatureGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateFeatureGroupResponse> createFeatureGroup(
            Consumer<CreateFeatureGroupRequest.Builder> createFeatureGroupRequest) {
        return createFeatureGroup(CreateFeatureGroupRequest.builder().applyMutation(createFeatureGroupRequest).build());
    }

    /**
     * <p>
     * Creates a flow definition.
     * </p>
     *
     * @param createFlowDefinitionRequest
     * @return A Java Future containing the result of the CreateFlowDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFlowDefinitionResponse> createFlowDefinition(
            CreateFlowDefinitionRequest createFlowDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a flow definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFlowDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFlowDefinitionRequest#builder()}
     * </p>
     *
     * @param createFlowDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateFlowDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateFlowDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFlowDefinitionResponse> createFlowDefinition(
            Consumer<CreateFlowDefinitionRequest.Builder> createFlowDefinitionRequest) {
        return createFlowDefinition(CreateFlowDefinitionRequest.builder().applyMutation(createFlowDefinitionRequest).build());
    }

    /**
     * <p>
     * Create a hub.
     * </p>
     *
     * @param createHubRequest
     * @return A Java Future containing the result of the CreateHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHub" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateHubResponse> createHub(CreateHubRequest createHubRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHubRequest.Builder} avoiding the need to
     * create one manually via {@link CreateHubRequest#builder()}
     * </p>
     *
     * @param createHubRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateHubRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHub" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateHubResponse> createHub(Consumer<CreateHubRequest.Builder> createHubRequest) {
        return createHub(CreateHubRequest.builder().applyMutation(createHubRequest).build());
    }

    /**
     * <p>
     * Creates presigned URLs for accessing hub content artifacts. This operation generates time-limited, secure URLs
     * that allow direct download of model artifacts and associated files from Amazon SageMaker hub content, including
     * gated models that require end-user license agreement acceptance.
     * </p>
     *
     * @param createHubContentPresignedUrlsRequest
     * @return A Java Future containing the result of the CreateHubContentPresignedUrls operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateHubContentPresignedUrls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHubContentPresignedUrls"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHubContentPresignedUrlsResponse> createHubContentPresignedUrls(
            CreateHubContentPresignedUrlsRequest createHubContentPresignedUrlsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates presigned URLs for accessing hub content artifacts. This operation generates time-limited, secure URLs
     * that allow direct download of model artifacts and associated files from Amazon SageMaker hub content, including
     * gated models that require end-user license agreement acceptance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHubContentPresignedUrlsRequest.Builder}
     * avoiding the need to create one manually via {@link CreateHubContentPresignedUrlsRequest#builder()}
     * </p>
     *
     * @param createHubContentPresignedUrlsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateHubContentPresignedUrlsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateHubContentPresignedUrls operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateHubContentPresignedUrls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHubContentPresignedUrls"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHubContentPresignedUrlsResponse> createHubContentPresignedUrls(
            Consumer<CreateHubContentPresignedUrlsRequest.Builder> createHubContentPresignedUrlsRequest) {
        return createHubContentPresignedUrls(CreateHubContentPresignedUrlsRequest.builder()
                .applyMutation(createHubContentPresignedUrlsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #createHubContentPresignedUrls(software.amazon.awssdk.services.sagemaker.model.CreateHubContentPresignedUrlsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.CreateHubContentPresignedUrlsPublisher publisher = client.createHubContentPresignedUrlsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.CreateHubContentPresignedUrlsPublisher publisher = client.createHubContentPresignedUrlsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.CreateHubContentPresignedUrlsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.CreateHubContentPresignedUrlsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #createHubContentPresignedUrls(software.amazon.awssdk.services.sagemaker.model.CreateHubContentPresignedUrlsRequest)}
     * operation.</b>
     * </p>
     *
     * @param createHubContentPresignedUrlsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateHubContentPresignedUrls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHubContentPresignedUrls"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateHubContentPresignedUrlsPublisher createHubContentPresignedUrlsPaginator(
            CreateHubContentPresignedUrlsRequest createHubContentPresignedUrlsRequest) {
        return new CreateHubContentPresignedUrlsPublisher(this, createHubContentPresignedUrlsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #createHubContentPresignedUrls(software.amazon.awssdk.services.sagemaker.model.CreateHubContentPresignedUrlsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.CreateHubContentPresignedUrlsPublisher publisher = client.createHubContentPresignedUrlsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sagemaker.paginators.CreateHubContentPresignedUrlsPublisher publisher = client.createHubContentPresignedUrlsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sagemaker.model.CreateHubContentPresignedUrlsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sagemaker.model.CreateHubContentPresignedUrlsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #createHubContentPresignedUrls(software.amazon.awssdk.services.sagemaker.model.CreateHubContentPresignedUrlsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHubContentPresignedUrlsRequest.Builder}
     * avoiding the need to create one manually via {@link CreateHubContentPresignedUrlsRequest#builder()}
     * </p>
     *
     * @param createHubContentPresignedUrlsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateHubContentPresignedUrlsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateHubContentPresignedUrls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHubContentPresignedUrls"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateHubContentPresignedUrlsPublisher createHubContentPresignedUrlsPaginator(
            Consumer<CreateHubContentPresignedUrlsRequest.Builder> createHubContentPresignedUrlsRequest) {
        return createHubContentPresignedUrlsPaginator(CreateHubContentPresignedUrlsRequest.builder()
                .applyMutation(createHubContentPresignedUrlsRequest).build());
    }

    /**
     * <p>
     * Create a hub content reference in order to add a model in the JumpStart public hub to a private hub.
     * </p>
     *
     * @param createHubContentReferenceRequest
     * @return A Java Future containing the result of the CreateHubContentReference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateHubContentReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHubContentReference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHubContentReferenceResponse> createHubContentReference(
            CreateHubContentReferenceRequest createHubContentReferenceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a hub content reference in order to add a model in the JumpStart public hub to a private hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHubContentReferenceRequest.Builder} avoiding
     * the need to create one manually via {@link CreateHubContentReferenceRequest#builder()}
     * </p>
     *
     * @param createHubContentReferenceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateHubContentReferenceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateHubContentReference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateHubContentReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHubContentReference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHubContentReferenceResponse> createHubContentReference(
            Consumer<CreateHubContentReferenceRequest.Builder> createHubContentReferenceRequest) {
        return createHubContentReference(CreateHubContentReferenceRequest.builder()
                .applyMutation(createHubContentReferenceRequest).build());
    }

    /**
     * <p>
     * Defines the settings you will use for the human review workflow user interface. Reviewers will see a three-panel
     * interface with an instruction area, the item to review, and an input area.
     * </p>
     *
     * @param createHumanTaskUiRequest
     * @return A Java Future containing the result of the CreateHumanTaskUi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateHumanTaskUiResponse> createHumanTaskUi(CreateHumanTaskUiRequest createHumanTaskUiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines the settings you will use for the human review workflow user interface. Reviewers will see a three-panel
     * interface with an instruction area, the item to review, and an input area.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHumanTaskUiRequest.Builder} avoiding the need
     * to create one manually via {@link CreateHumanTaskUiRequest#builder()}
     * </p>
     *
     * @param createHumanTaskUiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateHumanTaskUiRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateHumanTaskUi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateHumanTaskUiResponse> createHumanTaskUi(
            Consumer<CreateHumanTaskUiRequest.Builder> createHumanTaskUiRequest) {
        return createHumanTaskUi(CreateHumanTaskUiRequest.builder().applyMutation(createHumanTaskUiRequest).build());
    }

    /**
     * <p>
     * Starts a hyperparameter tuning job. A hyperparameter tuning job finds the best version of a model by running many
     * training jobs on your dataset using the algorithm you choose and values for hyperparameters within ranges that
     * you specify. It then chooses the hyperparameter values that result in a model that performs the best, as measured
     * by an objective metric that you choose.
     * </p>
     * <p>
     * A hyperparameter tuning job automatically creates Amazon SageMaker experiments, trials, and trial components for
     * each training job that it runs. You can view these entities in Amazon SageMaker Studio. For more information, see
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/experiments-view-compare.html#experiments-view">View
     * Experiments, Trials, and Trial Components</a>.
     * </p>
     * <important>
     * <p>
     * Do not include any security-sensitive information including account access IDs, secrets, or tokens in any
     * hyperparameter fields. As part of the shared responsibility model, you are responsible for any potential
     * exposure, unauthorized access, or compromise of your sensitive data if caused by any security-sensitive
     * information included in the request hyperparameter variable or plain text fields..
     * </p>
     * </important>
     *
     * @param createHyperParameterTuningJobRequest
     * @return A Java Future containing the result of the CreateHyperParameterTuningJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateHyperParameterTuningJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHyperParameterTuningJobResponse> createHyperParameterTuningJob(
            CreateHyperParameterTuningJobRequest createHyperParameterTuningJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a hyperparameter tuning job. A hyperparameter tuning job finds the best version of a model by running many
     * training jobs on your dataset using the algorithm you choose and values for hyperparameters within ranges that
     * you specify. It then chooses the hyperparameter values that result in a model that performs the best, as measured
     * by an objective metric that you choose.
     * </p>
     * <p>
     * A hyperparameter tuning job automatically creates Amazon SageMaker experiments, trials, and trial components for
     * each training job that it runs. You can view these entities in Amazon SageMaker Studio. For more information, see
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/experiments-view-compare.html#experiments-view">View
     * Experiments, Trials, and Trial Components</a>.
     * </p>
     * <important>
     * <p>
     * Do not include any security-sensitive information including account access IDs, secrets, or tokens in any
     * hyperparameter fields. As part of the shared responsibility model, you are responsible for any potential
     * exposure, unauthorized access, or compromise of your sensitive data if caused by any security-sensitive
     * information included in the request hyperparameter variable or plain text fields..
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateHyperParameterTuningJobRequest.Builder}
     * avoiding the need to create one manually via {@link CreateHyperParameterTuningJobRequest#builder()}
     * </p>
     *
     * @param createHyperParameterTuningJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateHyperParameterTuningJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateHyperParameterTuningJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateHyperParameterTuningJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateHyperParameterTuningJobResponse> createHyperParameterTuningJob(
            Consumer<CreateHyperParameterTuningJobRequest.Builder> createHyperParameterTuningJobRequest) {
        return createHyperParameterTuningJob(CreateHyperParameterTuningJobRequest.builder()
                .applyMutation(createHyperParameterTuningJobRequest).build());
    }

    /**
     * <p>
     * Creates a custom SageMaker AI image. A SageMaker AI image is a set of image versions. Each image version
     * represents a container image stored in Amazon ECR. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html">Bring your own SageMaker AI image</a>.
     * </p>
     *
     * @param createImageRequest
     * @return A Java Future containing the result of the CreateImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateImageResponse> createImage(CreateImageRequest createImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom SageMaker AI image. A SageMaker AI image is a set of image versions. Each image version
     * represents a container image stored in Amazon ECR. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-byoi.html">Bring your own SageMaker AI image</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImageRequest.Builder} avoiding the need to
     * create one manually via {@link CreateImageRequest#builder()}
     * </p>
     *
     * @param createImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateImageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateImageResponse> createImage(Consumer<CreateImageRequest.Builder> createImageRequest) {
        return createImage(CreateImageRequest.builder().applyMutation(createImageRequest).build());
    }

    /**
     * <p>
     * Creates a version of the SageMaker AI image specified by <code>ImageName</code>. The version represents the
     * Amazon ECR container image specified by <code>BaseImage</code>.
     * </p>
     *
     * @param createImageVersionRequest
     * @return A Java Future containing the result of the CreateImageVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateImageVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateImageVersionResponse> createImageVersion(CreateImageVersionRequest createImageVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a version of the SageMaker AI image specified by <code>ImageName</code>. The version represents the
     * Amazon ECR container image specified by <code>BaseImage</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImageVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateImageVersionRequest#builder()}
     * </p>
     *
     * @param createImageVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateImageVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateImageVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateImageVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateImageVersionResponse> createImageVersion(
            Consumer<CreateImageVersionRequest.Builder> createImageVersionRequest) {
        return createImageVersion(CreateImageVersionRequest.builder().applyMutation(createImageVersionRequest).build());
    }

    /**
     * <p>
     * Creates an inference component, which is a SageMaker AI hosting object that you can use to deploy a model to an
     * endpoint. In the inference component settings, you specify the model, the endpoint, and how the model utilizes
     * the resources that the endpoint hosts. You can optimize resource utilization by tailoring how the required CPU
     * cores, accelerators, and memory are allocated. You can deploy multiple inference components to an endpoint, where
     * each inference component contains one model and the resource utilization needs for that individual model. After
     * you deploy an inference component, you can directly invoke the associated model when you use the InvokeEndpoint
     * API action.
     * </p>
     *
     * @param createInferenceComponentRequest
     * @return A Java Future containing the result of the CreateInferenceComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateInferenceComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateInferenceComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInferenceComponentResponse> createInferenceComponent(
            CreateInferenceComponentRequest createInferenceComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an inference component, which is a SageMaker AI hosting object that you can use to deploy a model to an
     * endpoint. In the inference component settings, you specify the model, the endpoint, and how the model utilizes
     * the resources that the endpoint hosts. You can optimize resource utilization by tailoring how the required CPU
     * cores, accelerators, and memory are allocated. You can deploy multiple inference components to an endpoint, where
     * each inference component contains one model and the resource utilization needs for that individual model. After
     * you deploy an inference component, you can directly invoke the associated model when you use the InvokeEndpoint
     * API action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInferenceComponentRequest.Builder} avoiding
     * the need to create one manually via {@link CreateInferenceComponentRequest#builder()}
     * </p>
     *
     * @param createInferenceComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateInferenceComponentRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateInferenceComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateInferenceComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateInferenceComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInferenceComponentResponse> createInferenceComponent(
            Consumer<CreateInferenceComponentRequest.Builder> createInferenceComponentRequest) {
        return createInferenceComponent(CreateInferenceComponentRequest.builder().applyMutation(createInferenceComponentRequest)
                .build());
    }

    /**
     * <p>
     * Creates an inference experiment using the configurations specified in the request.
     * </p>
     * <p>
     * Use this API to setup and schedule an experiment to compare model variants on a Amazon SageMaker inference
     * endpoint. For more information about inference experiments, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/shadow-tests.html">Shadow tests</a>.
     * </p>
     * <p>
     * Amazon SageMaker begins your experiment at the scheduled time and routes traffic to your endpoint's model
     * variants based on your specified configuration.
     * </p>
     * <p>
     * While the experiment is in progress or after it has concluded, you can view metrics that compare your model
     * variants. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/shadow-tests-view-monitor-edit.html">View, monitor, and
     * edit shadow tests</a>.
     * </p>
     *
     * @param createInferenceExperimentRequest
     * @return A Java Future containing the result of the CreateInferenceExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateInferenceExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateInferenceExperiment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInferenceExperimentResponse> createInferenceExperiment(
            CreateInferenceExperimentRequest createInferenceExperimentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an inference experiment using the configurations specified in the request.
     * </p>
     * <p>
     * Use this API to setup and schedule an experiment to compare model variants on a Amazon SageMaker inference
     * endpoint. For more information about inference experiments, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/shadow-tests.html">Shadow tests</a>.
     * </p>
     * <p>
     * Amazon SageMaker begins your experiment at the scheduled time and routes traffic to your endpoint's model
     * variants based on your specified configuration.
     * </p>
     * <p>
     * While the experiment is in progress or after it has concluded, you can view metrics that compare your model
     * variants. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/shadow-tests-view-monitor-edit.html">View, monitor, and
     * edit shadow tests</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInferenceExperimentRequest.Builder} avoiding
     * the need to create one manually via {@link CreateInferenceExperimentRequest#builder()}
     * </p>
     *
     * @param createInferenceExperimentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateInferenceExperimentRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateInferenceExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateInferenceExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateInferenceExperiment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInferenceExperimentResponse> createInferenceExperiment(
            Consumer<CreateInferenceExperimentRequest.Builder> createInferenceExperimentRequest) {
        return createInferenceExperiment(CreateInferenceExperimentRequest.builder()
                .applyMutation(createInferenceExperimentRequest).build());
    }

    /**
     * <p>
     * Starts a recommendation job. You can create either an instance recommendation or load test job.
     * </p>
     *
     * @param createInferenceRecommendationsJobRequest
     * @return A Java Future containing the result of the CreateInferenceRecommendationsJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateInferenceRecommendationsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateInferenceRecommendationsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInferenceRecommendationsJobResponse> createInferenceRecommendationsJob(
            CreateInferenceRecommendationsJobRequest createInferenceRecommendationsJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a recommendation job. You can create either an instance recommendation or load test job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInferenceRecommendationsJobRequest.Builder}
     * avoiding the need to create one manually via {@link CreateInferenceRecommendationsJobRequest#builder()}
     * </p>
     *
     * @param createInferenceRecommendationsJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateInferenceRecommendationsJobRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateInferenceRecommendationsJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateInferenceRecommendationsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateInferenceRecommendationsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateInferenceRecommendationsJobResponse> createInferenceRecommendationsJob(
            Consumer<CreateInferenceRecommendationsJobRequest.Builder> createInferenceRecommendationsJobRequest) {
        return createInferenceRecommendationsJob(CreateInferenceRecommendationsJobRequest.builder()
                .applyMutation(createInferenceRecommendationsJobRequest).build());
    }

    /**
     * <p>
     * Creates a job that uses workers to label the data objects in your input dataset. You can use the labeled data to
     * train machine learning models.
     * </p>
     * <p>
     * You can select your workforce from one of three providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A private workforce that you create. It can include employees, contractors, and outside experts. Use a private
     * workforce when want the data to stay within your organization or when a specific set of skills is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * One or more vendors that you select from the Amazon Web Services Marketplace. Vendors provide expertise in
     * specific areas.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Amazon Mechanical Turk workforce. This is the largest workforce, but it should only be used for public data
     * or data that has been stripped of any personally identifiable information.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also use <i>automated data labeling</i> to reduce the number of data objects that need to be labeled by a
     * human. Automated data labeling uses <i>active learning</i> to determine if a data object can be labeled by
     * machine or if it needs to be sent to a human worker. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html">Using Automated Data
     * Labeling</a>.
     * </p>
     * <p>
     * The data objects to be labeled are contained in an Amazon S3 bucket. You create a <i>manifest file</i> that
     * describes the location of each object. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html">Using Input and Output Data</a>.
     * </p>
     * <p>
     * The output can be used as the manifest file for another labeling job or as training data for your machine
     * learning models.
     * </p>
     * <p>
     * You can use this operation to create a static labeling job or a streaming labeling job. A static labeling job
     * stops if all data objects in the input manifest file identified in <code>ManifestS3Uri</code> have been labeled.
     * A streaming labeling job runs perpetually until it is manually stopped, or remains idle for 10 days. You can send
     * new data objects to an active (<code>InProgress</code>) streaming labeling job in real time. To learn how to
     * create a static labeling job, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-create-labeling-job-api.html">Create a Labeling Job
     * (API) </a> in the Amazon SageMaker Developer Guide. To learn how to create a streaming labeling job, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-create-job.html">Create a Streaming Labeling
     * Job</a>.
     * </p>
     *
     * @param createLabelingJobRequest
     * @return A Java Future containing the result of the CreateLabelingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateLabelingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateLabelingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLabelingJobResponse> createLabelingJob(CreateLabelingJobRequest createLabelingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a job that uses workers to label the data objects in your input dataset. You can use the labeled data to
     * train machine learning models.
     * </p>
     * <p>
     * You can select your workforce from one of three providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A private workforce that you create. It can include employees, contractors, and outside experts. Use a private
     * workforce when want the data to stay within your organization or when a specific set of skills is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * One or more vendors that you select from the Amazon Web Services Marketplace. Vendors provide expertise in
     * specific areas.
     * </p>
     * </li>
     * <li>
     * <p>
     * The Amazon Mechanical Turk workforce. This is the largest workforce, but it should only be used for public data
     * or data that has been stripped of any personally identifiable information.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also use <i>automated data labeling</i> to reduce the number of data objects that need to be labeled by a
     * human. Automated data labeling uses <i>active learning</i> to determine if a data object can be labeled by
     * machine or if it needs to be sent to a human worker. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html">Using Automated Data
     * Labeling</a>.
     * </p>
     * <p>
     * The data objects to be labeled are contained in an Amazon S3 bucket. You create a <i>manifest file</i> that
     * describes the location of each object. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html">Using Input and Output Data</a>.
     * </p>
     * <p>
     * The output can be used as the manifest file for another labeling job or as training data for your machine
     * learning models.
     * </p>
     * <p>
     * You can use this operation to create a static labeling job or a streaming labeling job. A static labeling job
     * stops if all data objects in the input manifest file identified in <code>ManifestS3Uri</code> have been labeled.
     * A streaming labeling job runs perpetually until it is manually stopped, or remains idle for 10 days. You can send
     * new data objects to an active (<code>InProgress</code>) streaming labeling job in real time. To learn how to
     * create a static labeling job, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-create-labeling-job-api.html">Create a Labeling Job
     * (API) </a> in the Amazon SageMaker Developer Guide. To learn how to create a streaming labeling job, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-streaming-create-job.html">Create a Streaming Labeling
     * Job</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLabelingJobRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLabelingJobRequest#builder()}
     * </p>
     *
     * @param createLabelingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateLabelingJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateLabelingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateLabelingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateLabelingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateLabelingJobResponse> createLabelingJob(
            Consumer<CreateLabelingJobRequest.Builder> createLabelingJobRequest) {
        return createLabelingJob(CreateLabelingJobRequest.builder().applyMutation(createLabelingJobRequest).build());
    }

    /**
     * <p>
     * Creates an MLflow Tracking Server using a general purpose Amazon S3 bucket as the artifact store. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server.html">Create an MLflow
     * Tracking Server</a>.
     * </p>
     *
     * @param createMlflowTrackingServerRequest
     * @return A Java Future containing the result of the CreateMlflowTrackingServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateMlflowTrackingServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateMlflowTrackingServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMlflowTrackingServerResponse> createMlflowTrackingServer(
            CreateMlflowTrackingServerRequest createMlflowTrackingServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an MLflow Tracking Server using a general purpose Amazon S3 bucket as the artifact store. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server.html">Create an MLflow
     * Tracking Server</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMlflowTrackingServerRequest.Builder} avoiding
     * the need to create one manually via {@link CreateMlflowTrackingServerRequest#builder()}
     * </p>
     *
     * @param createMlflowTrackingServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateMlflowTrackingServerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateMlflowTrackingServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateMlflowTrackingServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateMlflowTrackingServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMlflowTrackingServerResponse> createMlflowTrackingServer(
            Consumer<CreateMlflowTrackingServerRequest.Builder> createMlflowTrackingServerRequest) {
        return createMlflowTrackingServer(CreateMlflowTrackingServerRequest.builder()
                .applyMutation(createMlflowTrackingServerRequest).build());
    }

    /**
     * <p>
     * Creates a model in SageMaker. In the request, you name the model and describe a primary container. For the
     * primary container, you specify the Docker image that contains inference code, artifacts (from prior training),
     * and a custom environment map that the inference code uses when you deploy the model for predictions.
     * </p>
     * <p>
     * Use this API to create a model if you want to use SageMaker hosting services or run a batch transform job.
     * </p>
     * <p>
     * To host your model, you create an endpoint configuration with the <code>CreateEndpointConfig</code> API, and then
     * create an endpoint with the <code>CreateEndpoint</code> API. SageMaker then deploys all of the containers that
     * you defined for the model in the hosting environment.
     * </p>
     * <p>
     * To run a batch transform using your model, you start a job with the <code>CreateTransformJob</code> API.
     * SageMaker uses your model and your dataset to get inferences which are then saved to a specified S3 location.
     * </p>
     * <p>
     * In the request, you also provide an IAM role that SageMaker can assume to access model artifacts and docker image
     * for deployment on ML compute hosting instances or for batch transform jobs. In addition, you also use the IAM
     * role to manage permissions the inference code needs. For example, if the inference code access any other Amazon
     * Web Services resources, you grant necessary permissions via this role.
     * </p>
     *
     * @param createModelRequest
     * @return A Java Future containing the result of the CreateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateModelResponse> createModel(CreateModelRequest createModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a model in SageMaker. In the request, you name the model and describe a primary container. For the
     * primary container, you specify the Docker image that contains inference code, artifacts (from prior training),
     * and a custom environment map that the inference code uses when you deploy the model for predictions.
     * </p>
     * <p>
     * Use this API to create a model if you want to use SageMaker hosting services or run a batch transform job.
     * </p>
     * <p>
     * To host your model, you create an endpoint configuration with the <code>CreateEndpointConfig</code> API, and then
     * create an endpoint with the <code>CreateEndpoint</code> API. SageMaker then deploys all of the containers that
     * you defined for the model in the hosting environment.
     * </p>
     * <p>
     * To run a batch transform using your model, you start a job with the <code>CreateTransformJob</code> API.
     * SageMaker uses your model and your dataset to get inferences which are then saved to a specified S3 location.
     * </p>
     * <p>
     * In the request, you also provide an IAM role that SageMaker can assume to access model artifacts and docker image
     * for deployment on ML compute hosting instances or for batch transform jobs. In addition, you also use the IAM
     * role to manage permissions the inference code needs. For example, if the inference code access any other Amazon
     * Web Services resources, you grant necessary permissions via this role.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateModelRequest#builder()}
     * </p>
     *
     * @param createModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateModelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateModelResponse> createModel(Consumer<CreateModelRequest.Builder> createModelRequest) {
        return createModel(CreateModelRequest.builder().applyMutation(createModelRequest).build());
    }

    /**
     * <p>
     * Creates the definition for a model bias job.
     * </p>
     *
     * @param createModelBiasJobDefinitionRequest
     * @return A Java Future containing the result of the CreateModelBiasJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateModelBiasJobDefinitionResponse> createModelBiasJobDefinition(
            CreateModelBiasJobDefinitionRequest createModelBiasJobDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the definition for a model bias job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelBiasJobDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateModelBiasJobDefinitionRequest#builder()}
     * </p>
     *
     * @param createModelBiasJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateModelBiasJobDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateModelBiasJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateModelBiasJobDefinitionResponse> createModelBiasJobDefinition(
            Consumer<CreateModelBiasJobDefinitionRequest.Builder> createModelBiasJobDefinitionRequest) {
        return createModelBiasJobDefinition(CreateModelBiasJobDefinitionRequest.builder()
                .applyMutation(createModelBiasJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon SageMaker Model Card.
     * </p>
     * <p>
     * For information about how to use model cards, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html">Amazon SageMaker Model Card</a>.
     * </p>
     *
     * @param createModelCardRequest
     * @return A Java Future containing the result of the CreateModelCard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelCard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelCard" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateModelCardResponse> createModelCard(CreateModelCardRequest createModelCardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon SageMaker Model Card.
     * </p>
     * <p>
     * For information about how to use model cards, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-cards.html">Amazon SageMaker Model Card</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelCardRequest.Builder} avoiding the need
     * to create one manually via {@link CreateModelCardRequest#builder()}
     * </p>
     *
     * @param createModelCardRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateModelCardRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateModelCard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelCard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelCard" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateModelCardResponse> createModelCard(
            Consumer<CreateModelCardRequest.Builder> createModelCardRequest) {
        return createModelCard(CreateModelCardRequest.builder().applyMutation(createModelCardRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon SageMaker Model Card export job.
     * </p>
     *
     * @param createModelCardExportJobRequest
     * @return A Java Future containing the result of the CreateModelCardExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelCardExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelCardExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateModelCardExportJobResponse> createModelCardExportJob(
            CreateModelCardExportJobRequest createModelCardExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon SageMaker Model Card export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelCardExportJobRequest.Builder} avoiding
     * the need to create one manually via {@link CreateModelCardExportJobRequest#builder()}
     * </p>
     *
     * @param createModelCardExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateModelCardExportJobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateModelCardExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelCardExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelCardExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateModelCardExportJobResponse> createModelCardExportJob(
            Consumer<CreateModelCardExportJobRequest.Builder> createModelCardExportJobRequest) {
        return createModelCardExportJob(CreateModelCardExportJobRequest.builder().applyMutation(createModelCardExportJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates the definition for a model explainability job.
     * </p>
     *
     * @param createModelExplainabilityJobDefinitionRequest
     * @return A Java Future containing the result of the CreateModelExplainabilityJobDefinition operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateModelExplainabilityJobDefinitionResponse> createModelExplainabilityJobDefinition(
            CreateModelExplainabilityJobDefinitionRequest createModelExplainabilityJobDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the definition for a model explainability job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateModelExplainabilityJobDefinitionRequest.Builder} avoiding the need to create one manually via
     * {@link CreateModelExplainabilityJobDefinitionRequest#builder()}
     * </p>
     *
     * @param createModelExplainabilityJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateModelExplainabilityJobDefinitionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateModelExplainabilityJobDefinition operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateModelExplainabilityJobDefinitionResponse> createModelExplainabilityJobDefinition(
            Consumer<CreateModelExplainabilityJobDefinitionRequest.Builder> createModelExplainabilityJobDefinitionRequest) {
        return createModelExplainabilityJobDefinition(CreateModelExplainabilityJobDefinitionRequest.builder()
                .applyMutation(createModelExplainabilityJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Creates a model package that you can use to create SageMaker models or list on Amazon Web Services Marketplace,
     * or a versioned model that is part of a model group. Buyers can subscribe to model packages listed on Amazon Web
     * Services Marketplace to create models in SageMaker.
     * </p>
     * <p>
     * To create a model package by specifying a Docker container that contains your inference code and the Amazon S3
     * location of your model artifacts, provide values for <code>InferenceSpecification</code>. To create a model from
     * an algorithm resource that you created or subscribed to in Amazon Web Services Marketplace, provide a value for
     * <code>SourceAlgorithmSpecification</code>.
     * </p>
     * <note>
     * <p>
     * There are two types of model packages:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Versioned - a model that is part of a model group in the model registry.
     * </p>
     * </li>
     * <li>
     * <p>
     * Unversioned - a model package that is not part of a model group.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createModelPackageRequest
     * @return A Java Future containing the result of the CreateModelPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateModelPackageResponse> createModelPackage(CreateModelPackageRequest createModelPackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a model package that you can use to create SageMaker models or list on Amazon Web Services Marketplace,
     * or a versioned model that is part of a model group. Buyers can subscribe to model packages listed on Amazon Web
     * Services Marketplace to create models in SageMaker.
     * </p>
     * <p>
     * To create a model package by specifying a Docker container that contains your inference code and the Amazon S3
     * location of your model artifacts, provide values for <code>InferenceSpecification</code>. To create a model from
     * an algorithm resource that you created or subscribed to in Amazon Web Services Marketplace, provide a value for
     * <code>SourceAlgorithmSpecification</code>.
     * </p>
     * <note>
     * <p>
     * There are two types of model packages:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Versioned - a model that is part of a model group in the model registry.
     * </p>
     * </li>
     * <li>
     * <p>
     * Unversioned - a model package that is not part of a model group.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelPackageRequest.Builder} avoiding the
     * need to create one manually via {@link CreateModelPackageRequest#builder()}
     * </p>
     *
     * @param createModelPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateModelPackageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateModelPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateModelPackageResponse> createModelPackage(
            Consumer<CreateModelPackageRequest.Builder> createModelPackageRequest) {
        return createModelPackage(CreateModelPackageRequest.builder().applyMutation(createModelPackageRequest).build());
    }

    /**
     * <p>
     * Creates a model group. A model group contains a group of model versions.
     * </p>
     *
     * @param createModelPackageGroupRequest
     * @return A Java Future containing the result of the CreateModelPackageGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateModelPackageGroupResponse> createModelPackageGroup(
            CreateModelPackageGroupRequest createModelPackageGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a model group. A model group contains a group of model versions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelPackageGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateModelPackageGroupRequest#builder()}
     * </p>
     *
     * @param createModelPackageGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateModelPackageGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateModelPackageGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateModelPackageGroupResponse> createModelPackageGroup(
            Consumer<CreateModelPackageGroupRequest.Builder> createModelPackageGroupRequest) {
        return createModelPackageGroup(CreateModelPackageGroupRequest.builder().applyMutation(createModelPackageGroupRequest)
                .build());
    }

    /**
     * <p>
     * Creates a definition for a job that monitors model quality and drift. For information about model monitor, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker AI Model Monitor</a>.
     * </p>
     *
     * @param createModelQualityJobDefinitionRequest
     * @return A Java Future containing the result of the CreateModelQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateModelQualityJobDefinitionResponse> createModelQualityJobDefinition(
            CreateModelQualityJobDefinitionRequest createModelQualityJobDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a definition for a job that monitors model quality and drift. For information about model monitor, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html">Amazon SageMaker AI Model Monitor</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelQualityJobDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateModelQualityJobDefinitionRequest#builder()}
     * </p>
     *
     * @param createModelQualityJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateModelQualityJobDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateModelQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateModelQualityJobDefinitionResponse> createModelQualityJobDefinition(
            Consumer<CreateModelQualityJobDefinitionRequest.Builder> createModelQualityJobDefinitionRequest) {
        return createModelQualityJobDefinition(CreateModelQualityJobDefinitionRequest.builder()
                .applyMutation(createModelQualityJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Creates a schedule that regularly starts Amazon SageMaker AI Processing Jobs to monitor the data captured for an
     * Amazon SageMaker AI Endpoint.
     * </p>
     *
     * @param createMonitoringScheduleRequest
     * @return A Java Future containing the result of the CreateMonitoringSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMonitoringScheduleResponse> createMonitoringSchedule(
            CreateMonitoringScheduleRequest createMonitoringScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a schedule that regularly starts Amazon SageMaker AI Processing Jobs to monitor the data captured for an
     * Amazon SageMaker AI Endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMonitoringScheduleRequest.Builder} avoiding
     * the need to create one manually via {@link CreateMonitoringScheduleRequest#builder()}
     * </p>
     *
     * @param createMonitoringScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateMonitoringScheduleRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateMonitoringSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMonitoringScheduleResponse> createMonitoringSchedule(
            Consumer<CreateMonitoringScheduleRequest.Builder> createMonitoringScheduleRequest) {
        return createMonitoringSchedule(CreateMonitoringScheduleRequest.builder().applyMutation(createMonitoringScheduleRequest)
                .build());
    }

    /**
     * <p>
     * Creates an SageMaker AI notebook instance. A notebook instance is a machine learning (ML) compute instance
     * running on a Jupyter notebook.
     * </p>
     * <p>
     * In a <code>CreateNotebookInstance</code> request, specify the type of ML compute instance that you want to run.
     * SageMaker AI launches the instance, installs common libraries that you can use to explore datasets for model
     * training, and attaches an ML storage volume to the notebook instance.
     * </p>
     * <p>
     * SageMaker AI also provides a set of example notebooks. Each notebook demonstrates how to use SageMaker AI with a
     * specific algorithm or with a machine learning framework.
     * </p>
     * <p>
     * After receiving the request, SageMaker AI does the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Creates a network interface in the SageMaker AI VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Option) If you specified <code>SubnetId</code>, SageMaker AI creates a network interface in your own VPC, which
     * is inferred from the subnet ID that you provide in the input. When creating this network interface, SageMaker AI
     * attaches the security group that you specified in the request to the network interface that it creates in your
     * VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * Launches an EC2 instance of the type specified in the request in the SageMaker AI VPC. If you specified
     * <code>SubnetId</code> of your VPC, SageMaker AI specifies both network interfaces when launching this instance.
     * This enables inbound traffic from your own VPC to the notebook instance, assuming that the security groups allow
     * it.
     * </p>
     * </li>
     * </ol>
     * <p>
     * After creating the notebook instance, SageMaker AI returns its Amazon Resource Name (ARN). You can't change the
     * name of a notebook instance after you create it.
     * </p>
     * <p>
     * After SageMaker AI creates the notebook instance, you can connect to the Jupyter server and work in Jupyter
     * notebooks. For example, you can write code to explore a dataset that you can use for model training, train a
     * model, host models by creating SageMaker AI endpoints, and validate hosted models.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It
     * Works</a>.
     * </p>
     *
     * @param createNotebookInstanceRequest
     * @return A Java Future containing the result of the CreateNotebookInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNotebookInstanceResponse> createNotebookInstance(
            CreateNotebookInstanceRequest createNotebookInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an SageMaker AI notebook instance. A notebook instance is a machine learning (ML) compute instance
     * running on a Jupyter notebook.
     * </p>
     * <p>
     * In a <code>CreateNotebookInstance</code> request, specify the type of ML compute instance that you want to run.
     * SageMaker AI launches the instance, installs common libraries that you can use to explore datasets for model
     * training, and attaches an ML storage volume to the notebook instance.
     * </p>
     * <p>
     * SageMaker AI also provides a set of example notebooks. Each notebook demonstrates how to use SageMaker AI with a
     * specific algorithm or with a machine learning framework.
     * </p>
     * <p>
     * After receiving the request, SageMaker AI does the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Creates a network interface in the SageMaker AI VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Option) If you specified <code>SubnetId</code>, SageMaker AI creates a network interface in your own VPC, which
     * is inferred from the subnet ID that you provide in the input. When creating this network interface, SageMaker AI
     * attaches the security group that you specified in the request to the network interface that it creates in your
     * VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * Launches an EC2 instance of the type specified in the request in the SageMaker AI VPC. If you specified
     * <code>SubnetId</code> of your VPC, SageMaker AI specifies both network interfaces when launching this instance.
     * This enables inbound traffic from your own VPC to the notebook instance, assuming that the security groups allow
     * it.
     * </p>
     * </li>
     * </ol>
     * <p>
     * After creating the notebook instance, SageMaker AI returns its Amazon Resource Name (ARN). You can't change the
     * name of a notebook instance after you create it.
     * </p>
     * <p>
     * After SageMaker AI creates the notebook instance, you can connect to the Jupyter server and work in Jupyter
     * notebooks. For example, you can write code to explore a dataset that you can use for model training, train a
     * model, host models by creating SageMaker AI endpoints, and validate hosted models.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It
     * Works</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNotebookInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateNotebookInstanceRequest#builder()}
     * </p>
     *
     * @param createNotebookInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateNotebookInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNotebookInstanceResponse> createNotebookInstance(
            Consumer<CreateNotebookInstanceRequest.Builder> createNotebookInstanceRequest) {
        return createNotebookInstance(CreateNotebookInstanceRequest.builder().applyMutation(createNotebookInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Creates a lifecycle configuration that you can associate with a notebook instance. A <i>lifecycle
     * configuration</i> is a collection of shell scripts that run when you create or start a notebook instance.
     * </p>
     * <p>
     * Each lifecycle configuration script has a limit of 16384 characters.
     * </p>
     * <p>
     * The value of the <code>&#36PATH</code> environment variable that is available to both scripts is
     * <code>/sbin:bin:/usr/sbin:/usr/bin</code>.
     * </p>
     * <p>
     * View Amazon CloudWatch Logs for notebook instance lifecycle configurations in log group
     * <code>/aws/sagemaker/NotebookInstances</code> in log stream
     * <code>[notebook-instance-name]/[LifecycleConfigHook]</code>.
     * </p>
     * <p>
     * Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes,
     * it fails and the notebook instance is not created or started.
     * </p>
     * <p>
     * For information about notebook instance lifestyle configurations, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance</a>.
     * </p>
     *
     * @param createNotebookInstanceLifecycleConfigRequest
     * @return A Java Future containing the result of the CreateNotebookInstanceLifecycleConfig operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateNotebookInstanceLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNotebookInstanceLifecycleConfigResponse> createNotebookInstanceLifecycleConfig(
            CreateNotebookInstanceLifecycleConfigRequest createNotebookInstanceLifecycleConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a lifecycle configuration that you can associate with a notebook instance. A <i>lifecycle
     * configuration</i> is a collection of shell scripts that run when you create or start a notebook instance.
     * </p>
     * <p>
     * Each lifecycle configuration script has a limit of 16384 characters.
     * </p>
     * <p>
     * The value of the <code>&#36PATH</code> environment variable that is available to both scripts is
     * <code>/sbin:bin:/usr/sbin:/usr/bin</code>.
     * </p>
     * <p>
     * View Amazon CloudWatch Logs for notebook instance lifecycle configurations in log group
     * <code>/aws/sagemaker/NotebookInstances</code> in log stream
     * <code>[notebook-instance-name]/[LifecycleConfigHook]</code>.
     * </p>
     * <p>
     * Lifecycle configuration scripts cannot run for longer than 5 minutes. If a script runs for longer than 5 minutes,
     * it fails and the notebook instance is not created or started.
     * </p>
     * <p>
     * For information about notebook instance lifestyle configurations, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateNotebookInstanceLifecycleConfigRequest.Builder} avoiding the need to create one manually via
     * {@link CreateNotebookInstanceLifecycleConfigRequest#builder()}
     * </p>
     *
     * @param createNotebookInstanceLifecycleConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateNotebookInstanceLifecycleConfigRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateNotebookInstanceLifecycleConfig operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateNotebookInstanceLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNotebookInstanceLifecycleConfigResponse> createNotebookInstanceLifecycleConfig(
            Consumer<CreateNotebookInstanceLifecycleConfigRequest.Builder> createNotebookInstanceLifecycleConfigRequest) {
        return createNotebookInstanceLifecycleConfig(CreateNotebookInstanceLifecycleConfigRequest.builder()
                .applyMutation(createNotebookInstanceLifecycleConfigRequest).build());
    }

    /**
     * <p>
     * Creates a job that optimizes a model for inference performance. To create the job, you provide the location of a
     * source model, and you provide the settings for the optimization techniques that you want the job to apply. When
     * the job completes successfully, SageMaker uploads the new optimized model to the output destination that you
     * specify.
     * </p>
     * <p>
     * For more information about how to use this action, and about the supported optimization techniques, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-optimize.html">Optimize model inference with Amazon
     * SageMaker</a>.
     * </p>
     *
     * @param createOptimizationJobRequest
     * @return A Java Future containing the result of the CreateOptimizationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateOptimizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateOptimizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOptimizationJobResponse> createOptimizationJob(
            CreateOptimizationJobRequest createOptimizationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a job that optimizes a model for inference performance. To create the job, you provide the location of a
     * source model, and you provide the settings for the optimization techniques that you want the job to apply. When
     * the job completes successfully, SageMaker uploads the new optimized model to the output destination that you
     * specify.
     * </p>
     * <p>
     * For more information about how to use this action, and about the supported optimization techniques, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-optimize.html">Optimize model inference with Amazon
     * SageMaker</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOptimizationJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateOptimizationJobRequest#builder()}
     * </p>
     *
     * @param createOptimizationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateOptimizationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateOptimizationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateOptimizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateOptimizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateOptimizationJobResponse> createOptimizationJob(
            Consumer<CreateOptimizationJobRequest.Builder> createOptimizationJobRequest) {
        return createOptimizationJob(CreateOptimizationJobRequest.builder().applyMutation(createOptimizationJobRequest).build());
    }

    /**
     * <p>
     * Creates an Amazon SageMaker Partner AI App.
     * </p>
     *
     * @param createPartnerAppRequest
     * @return A Java Future containing the result of the CreatePartnerApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePartnerApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePartnerApp" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePartnerAppResponse> createPartnerApp(CreatePartnerAppRequest createPartnerAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon SageMaker Partner AI App.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePartnerAppRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePartnerAppRequest#builder()}
     * </p>
     *
     * @param createPartnerAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreatePartnerAppRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePartnerApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePartnerApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePartnerApp" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePartnerAppResponse> createPartnerApp(
            Consumer<CreatePartnerAppRequest.Builder> createPartnerAppRequest) {
        return createPartnerApp(CreatePartnerAppRequest.builder().applyMutation(createPartnerAppRequest).build());
    }

    /**
     * <p>
     * Creates a presigned URL to access an Amazon SageMaker Partner AI App.
     * </p>
     *
     * @param createPartnerAppPresignedUrlRequest
     * @return A Java Future containing the result of the CreatePartnerAppPresignedUrl operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePartnerAppPresignedUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePartnerAppPresignedUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePartnerAppPresignedUrlResponse> createPartnerAppPresignedUrl(
            CreatePartnerAppPresignedUrlRequest createPartnerAppPresignedUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a presigned URL to access an Amazon SageMaker Partner AI App.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePartnerAppPresignedUrlRequest.Builder}
     * avoiding the need to create one manually via {@link CreatePartnerAppPresignedUrlRequest#builder()}
     * </p>
     *
     * @param createPartnerAppPresignedUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreatePartnerAppPresignedUrlRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreatePartnerAppPresignedUrl operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePartnerAppPresignedUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePartnerAppPresignedUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePartnerAppPresignedUrlResponse> createPartnerAppPresignedUrl(
            Consumer<CreatePartnerAppPresignedUrlRequest.Builder> createPartnerAppPresignedUrlRequest) {
        return createPartnerAppPresignedUrl(CreatePartnerAppPresignedUrlRequest.builder()
                .applyMutation(createPartnerAppPresignedUrlRequest).build());
    }

    /**
     * <p>
     * Creates a pipeline using a JSON pipeline definition.
     * </p>
     *
     * @param createPipelineRequest
     * @return A Java Future containing the result of the CreatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePipelineResponse> createPipeline(CreatePipelineRequest createPipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a pipeline using a JSON pipeline definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePipelineRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePipelineRequest#builder()}
     * </p>
     *
     * @param createPipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreatePipelineRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreatePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePipelineResponse> createPipeline(Consumer<CreatePipelineRequest.Builder> createPipelineRequest) {
        return createPipeline(CreatePipelineRequest.builder().applyMutation(createPipelineRequest).build());
    }

    /**
     * <p>
     * Creates a URL for a specified UserProfile in a Domain. When accessed in a web browser, the user will be
     * automatically signed in to the domain, and granted access to all of the Apps and files associated with the
     * Domain's Amazon Elastic File System volume. This operation can only be called when the authentication mode equals
     * IAM.
     * </p>
     * <p>
     * The IAM role or user passed to this API defines the permissions to access the app. Once the presigned URL is
     * created, no additional permission is required to access this URL. IAM authorization policies for this API are
     * also enforced for every HTTP request and WebSocket frame that attempts to connect to the app.
     * </p>
     * <p>
     * You can restrict access to this API and to the URL that it returns to a list of IP addresses, Amazon VPCs or
     * Amazon VPC Endpoints that you specify. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-interface-endpoint.html">Connect to Amazon SageMaker
     * AI Studio Through an Interface VPC Endpoint</a> .
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The URL that you get from a call to <code>CreatePresignedDomainUrl</code> has a default timeout of 5 minutes. You
     * can configure this value using <code>ExpiresInSeconds</code>. If you try to use the URL after the timeout limit
     * expires, you are directed to the Amazon Web Services console sign-in page.
     * </p>
     * </li>
     * <li>
     * <p>
     * The JupyterLab session default expiration time is 12 hours. You can configure this value using
     * SessionExpirationDurationInSeconds.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createPresignedDomainUrlRequest
     * @return A Java Future containing the result of the CreatePresignedDomainUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePresignedDomainUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedDomainUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePresignedDomainUrlResponse> createPresignedDomainUrl(
            CreatePresignedDomainUrlRequest createPresignedDomainUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a URL for a specified UserProfile in a Domain. When accessed in a web browser, the user will be
     * automatically signed in to the domain, and granted access to all of the Apps and files associated with the
     * Domain's Amazon Elastic File System volume. This operation can only be called when the authentication mode equals
     * IAM.
     * </p>
     * <p>
     * The IAM role or user passed to this API defines the permissions to access the app. Once the presigned URL is
     * created, no additional permission is required to access this URL. IAM authorization policies for this API are
     * also enforced for every HTTP request and WebSocket frame that attempts to connect to the app.
     * </p>
     * <p>
     * You can restrict access to this API and to the URL that it returns to a list of IP addresses, Amazon VPCs or
     * Amazon VPC Endpoints that you specify. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio-interface-endpoint.html">Connect to Amazon SageMaker
     * AI Studio Through an Interface VPC Endpoint</a> .
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The URL that you get from a call to <code>CreatePresignedDomainUrl</code> has a default timeout of 5 minutes. You
     * can configure this value using <code>ExpiresInSeconds</code>. If you try to use the URL after the timeout limit
     * expires, you are directed to the Amazon Web Services console sign-in page.
     * </p>
     * </li>
     * <li>
     * <p>
     * The JupyterLab session default expiration time is 12 hours. You can configure this value using
     * SessionExpirationDurationInSeconds.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePresignedDomainUrlRequest.Builder} avoiding
     * the need to create one manually via {@link CreatePresignedDomainUrlRequest#builder()}
     * </p>
     *
     * @param createPresignedDomainUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreatePresignedDomainUrlRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreatePresignedDomainUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePresignedDomainUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedDomainUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePresignedDomainUrlResponse> createPresignedDomainUrl(
            Consumer<CreatePresignedDomainUrlRequest.Builder> createPresignedDomainUrlRequest) {
        return createPresignedDomainUrl(CreatePresignedDomainUrlRequest.builder().applyMutation(createPresignedDomainUrlRequest)
                .build());
    }

    /**
     * <p>
     * Returns a presigned URL that you can use to connect to the MLflow UI attached to your tracking server. For more
     * information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-launch-ui.html">Launch the
     * MLflow UI using a presigned URL</a>.
     * </p>
     *
     * @param createPresignedMlflowTrackingServerUrlRequest
     * @return A Java Future containing the result of the CreatePresignedMlflowTrackingServerUrl operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePresignedMlflowTrackingServerUrl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedMlflowTrackingServerUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePresignedMlflowTrackingServerUrlResponse> createPresignedMlflowTrackingServerUrl(
            CreatePresignedMlflowTrackingServerUrlRequest createPresignedMlflowTrackingServerUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a presigned URL that you can use to connect to the MLflow UI attached to your tracking server. For more
     * information, see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-launch-ui.html">Launch the
     * MLflow UI using a presigned URL</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreatePresignedMlflowTrackingServerUrlRequest.Builder} avoiding the need to create one manually via
     * {@link CreatePresignedMlflowTrackingServerUrlRequest#builder()}
     * </p>
     *
     * @param createPresignedMlflowTrackingServerUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreatePresignedMlflowTrackingServerUrlRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreatePresignedMlflowTrackingServerUrl operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePresignedMlflowTrackingServerUrl
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedMlflowTrackingServerUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePresignedMlflowTrackingServerUrlResponse> createPresignedMlflowTrackingServerUrl(
            Consumer<CreatePresignedMlflowTrackingServerUrlRequest.Builder> createPresignedMlflowTrackingServerUrlRequest) {
        return createPresignedMlflowTrackingServerUrl(CreatePresignedMlflowTrackingServerUrlRequest.builder()
                .applyMutation(createPresignedMlflowTrackingServerUrlRequest).build());
    }

    /**
     * <p>
     * Returns a URL that you can use to connect to the Jupyter server from a notebook instance. In the SageMaker AI
     * console, when you choose <code>Open</code> next to a notebook instance, SageMaker AI opens a new tab showing the
     * Jupyter server home page from the notebook instance. The console uses this API to get the URL and show the page.
     * </p>
     * <p>
     * The IAM role or user used to call this API defines the permissions to access the notebook instance. Once the
     * presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for
     * this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the notebook
     * instance.
     * </p>
     * <p>
     * You can restrict access to this API and to the URL that it returns to a list of IP addresses that you specify.
     * Use the <code>NotIpAddress</code> condition operator and the <code>aws:SourceIP</code> condition context key to
     * specify the list of IP addresses that you want to have access to the notebook instance. For more information, see
     * <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/security_iam_id-based-policy-examples.html#nbi-ip-filter"
     * >Limit Access to a Notebook Instance by IP Address</a>.
     * </p>
     * <note>
     * <p>
     * The URL that you get from a call to <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreatePresignedNotebookInstanceUrl.html"
     * >CreatePresignedNotebookInstanceUrl</a> is valid only for 5 minutes. If you try to use the URL after the 5-minute
     * limit expires, you are directed to the Amazon Web Services console sign-in page.
     * </p>
     * </note>
     *
     * @param createPresignedNotebookInstanceUrlRequest
     * @return A Java Future containing the result of the CreatePresignedNotebookInstanceUrl operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePresignedNotebookInstanceUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedNotebookInstanceUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePresignedNotebookInstanceUrlResponse> createPresignedNotebookInstanceUrl(
            CreatePresignedNotebookInstanceUrlRequest createPresignedNotebookInstanceUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a URL that you can use to connect to the Jupyter server from a notebook instance. In the SageMaker AI
     * console, when you choose <code>Open</code> next to a notebook instance, SageMaker AI opens a new tab showing the
     * Jupyter server home page from the notebook instance. The console uses this API to get the URL and show the page.
     * </p>
     * <p>
     * The IAM role or user used to call this API defines the permissions to access the notebook instance. Once the
     * presigned URL is created, no additional permission is required to access this URL. IAM authorization policies for
     * this API are also enforced for every HTTP request and WebSocket frame that attempts to connect to the notebook
     * instance.
     * </p>
     * <p>
     * You can restrict access to this API and to the URL that it returns to a list of IP addresses that you specify.
     * Use the <code>NotIpAddress</code> condition operator and the <code>aws:SourceIP</code> condition context key to
     * specify the list of IP addresses that you want to have access to the notebook instance. For more information, see
     * <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/security_iam_id-based-policy-examples.html#nbi-ip-filter"
     * >Limit Access to a Notebook Instance by IP Address</a>.
     * </p>
     * <note>
     * <p>
     * The URL that you get from a call to <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreatePresignedNotebookInstanceUrl.html"
     * >CreatePresignedNotebookInstanceUrl</a> is valid only for 5 minutes. If you try to use the URL after the 5-minute
     * limit expires, you are directed to the Amazon Web Services console sign-in page.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePresignedNotebookInstanceUrlRequest.Builder}
     * avoiding the need to create one manually via {@link CreatePresignedNotebookInstanceUrlRequest#builder()}
     * </p>
     *
     * @param createPresignedNotebookInstanceUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreatePresignedNotebookInstanceUrlRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreatePresignedNotebookInstanceUrl operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreatePresignedNotebookInstanceUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreatePresignedNotebookInstanceUrl"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePresignedNotebookInstanceUrlResponse> createPresignedNotebookInstanceUrl(
            Consumer<CreatePresignedNotebookInstanceUrlRequest.Builder> createPresignedNotebookInstanceUrlRequest) {
        return createPresignedNotebookInstanceUrl(CreatePresignedNotebookInstanceUrlRequest.builder()
                .applyMutation(createPresignedNotebookInstanceUrlRequest).build());
    }

    /**
     * <p>
     * Creates a processing job.
     * </p>
     *
     * @param createProcessingJobRequest
     * @return A Java Future containing the result of the CreateProcessingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateProcessingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateProcessingJobResponse> createProcessingJob(
            CreateProcessingJobRequest createProcessingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a processing job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProcessingJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateProcessingJobRequest#builder()}
     * </p>
     *
     * @param createProcessingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateProcessingJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateProcessingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateProcessingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateProcessingJobResponse> createProcessingJob(
            Consumer<CreateProcessingJobRequest.Builder> createProcessingJobRequest) {
        return createProcessingJob(CreateProcessingJobRequest.builder().applyMutation(createProcessingJobRequest).build());
    }

    /**
     * <p>
     * Creates a machine learning (ML) project that can contain one or more templates that set up an ML pipeline from
     * training to deploying an approved model.
     * </p>
     *
     * @param createProjectRequest
     * @return A Java Future containing the result of the CreateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProjectResponse> createProject(CreateProjectRequest createProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a machine learning (ML) project that can contain one or more templates that set up an ML pipeline from
     * training to deploying an approved model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProjectRequest#builder()}
     * </p>
     *
     * @param createProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateProjectRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateProjectResponse> createProject(Consumer<CreateProjectRequest.Builder> createProjectRequest) {
        return createProject(CreateProjectRequest.builder().applyMutation(createProjectRequest).build());
    }

    /**
     * <p>
     * Creates a private space or a space used for real time collaboration in a domain.
     * </p>
     *
     * @param createSpaceRequest
     * @return A Java Future containing the result of the CreateSpace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateSpace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSpaceResponse> createSpace(CreateSpaceRequest createSpaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a private space or a space used for real time collaboration in a domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSpaceRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSpaceRequest#builder()}
     * </p>
     *
     * @param createSpaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateSpaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateSpace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateSpace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSpaceResponse> createSpace(Consumer<CreateSpaceRequest.Builder> createSpaceRequest) {
        return createSpace(CreateSpaceRequest.builder().applyMutation(createSpaceRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon SageMaker AI Studio Lifecycle Configuration.
     * </p>
     *
     * @param createStudioLifecycleConfigRequest
     * @return A Java Future containing the result of the CreateStudioLifecycleConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStudioLifecycleConfigResponse> createStudioLifecycleConfig(
            CreateStudioLifecycleConfigRequest createStudioLifecycleConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon SageMaker AI Studio Lifecycle Configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStudioLifecycleConfigRequest.Builder}
     * avoiding the need to create one manually via {@link CreateStudioLifecycleConfigRequest#builder()}
     * </p>
     *
     * @param createStudioLifecycleConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateStudioLifecycleConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateStudioLifecycleConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateStudioLifecycleConfigResponse> createStudioLifecycleConfig(
            Consumer<CreateStudioLifecycleConfigRequest.Builder> createStudioLifecycleConfigRequest) {
        return createStudioLifecycleConfig(CreateStudioLifecycleConfigRequest.builder()
                .applyMutation(createStudioLifecycleConfigRequest).build());
    }

    /**
     * <p>
     * Starts a model training job. After training completes, SageMaker saves the resulting model artifacts to an Amazon
     * S3 location that you specify.
     * </p>
     * <p>
     * If you choose to host your model using SageMaker hosting services, you can use the resulting model artifacts as
     * part of the model. You can also use the artifacts in a machine learning service other than SageMaker, provided
     * that you know how to use them for inference.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AlgorithmSpecification</code> - Identifies the training algorithm to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HyperParameters</code> - Specify these algorithm-specific parameters to enable the estimation of model
     * parameters during training. Hyperparameters can be tuned to optimize this learning process. For a list of
     * hyperparameters for each training algorithm provided by SageMaker, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>.
     * </p>
     * <important>
     * <p>
     * Do not include any security-sensitive information including account access IDs, secrets, or tokens in any
     * hyperparameter fields. As part of the shared responsibility model, you are responsible for any potential
     * exposure, unauthorized access, or compromise of your sensitive data if caused by security-sensitive information
     * included in the request hyperparameter variable or plain text fields.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>InputDataConfig</code> - Describes the input required by the training job and the Amazon S3, EFS, or FSx
     * location where it is stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutputDataConfig</code> - Identifies the Amazon S3 bucket where you want SageMaker to save the results of
     * model training.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceConfig</code> - Identifies the resources, ML compute instances, and ML storage volumes to deploy
     * for model training. In distributed training, you specify more than one instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EnableManagedSpotTraining</code> - Optimize the cost of training machine learning models by up to 80% by
     * using Amazon EC2 Spot instances. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html">Managed Spot
     * Training</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RoleArn</code> - The Amazon Resource Name (ARN) that SageMaker assumes to perform tasks on your behalf
     * during model training. You must grant this role the necessary permissions so that SageMaker can successfully
     * complete model training.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StoppingCondition</code> - To help cap training costs, use <code>MaxRuntimeInSeconds</code> to set a time
     * limit for training. Use <code>MaxWaitTimeInSeconds</code> to specify how long a managed spot training job has to
     * complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Environment</code> - The environment variables to set in the Docker container.
     * </p>
     * <important>
     * <p>
     * Do not include any security-sensitive information including account access IDs, secrets, or tokens in any
     * environment fields. As part of the shared responsibility model, you are responsible for any potential exposure,
     * unauthorized access, or compromise of your sensitive data if caused by security-sensitive information included in
     * the request environment variable or plain text fields.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>RetryStrategy</code> - The number of times to retry the job when the job fails due to an
     * <code>InternalServerError</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about SageMaker, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It Works</a>.
     * </p>
     *
     * @param createTrainingJobRequest
     * @return A Java Future containing the result of the CreateTrainingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTrainingJobResponse> createTrainingJob(CreateTrainingJobRequest createTrainingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a model training job. After training completes, SageMaker saves the resulting model artifacts to an Amazon
     * S3 location that you specify.
     * </p>
     * <p>
     * If you choose to host your model using SageMaker hosting services, you can use the resulting model artifacts as
     * part of the model. You can also use the artifacts in a machine learning service other than SageMaker, provided
     * that you know how to use them for inference.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AlgorithmSpecification</code> - Identifies the training algorithm to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HyperParameters</code> - Specify these algorithm-specific parameters to enable the estimation of model
     * parameters during training. Hyperparameters can be tuned to optimize this learning process. For a list of
     * hyperparameters for each training algorithm provided by SageMaker, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html">Algorithms</a>.
     * </p>
     * <important>
     * <p>
     * Do not include any security-sensitive information including account access IDs, secrets, or tokens in any
     * hyperparameter fields. As part of the shared responsibility model, you are responsible for any potential
     * exposure, unauthorized access, or compromise of your sensitive data if caused by security-sensitive information
     * included in the request hyperparameter variable or plain text fields.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>InputDataConfig</code> - Describes the input required by the training job and the Amazon S3, EFS, or FSx
     * location where it is stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutputDataConfig</code> - Identifies the Amazon S3 bucket where you want SageMaker to save the results of
     * model training.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ResourceConfig</code> - Identifies the resources, ML compute instances, and ML storage volumes to deploy
     * for model training. In distributed training, you specify more than one instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EnableManagedSpotTraining</code> - Optimize the cost of training machine learning models by up to 80% by
     * using Amazon EC2 Spot instances. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-managed-spot-training.html">Managed Spot
     * Training</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RoleArn</code> - The Amazon Resource Name (ARN) that SageMaker assumes to perform tasks on your behalf
     * during model training. You must grant this role the necessary permissions so that SageMaker can successfully
     * complete model training.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>StoppingCondition</code> - To help cap training costs, use <code>MaxRuntimeInSeconds</code> to set a time
     * limit for training. Use <code>MaxWaitTimeInSeconds</code> to specify how long a managed spot training job has to
     * complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Environment</code> - The environment variables to set in the Docker container.
     * </p>
     * <important>
     * <p>
     * Do not include any security-sensitive information including account access IDs, secrets, or tokens in any
     * environment fields. As part of the shared responsibility model, you are responsible for any potential exposure,
     * unauthorized access, or compromise of your sensitive data if caused by security-sensitive information included in
     * the request environment variable or plain text fields.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <code>RetryStrategy</code> - The number of times to retry the job when the job fails due to an
     * <code>InternalServerError</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about SageMaker, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html">How It Works</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrainingJobRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTrainingJobRequest#builder()}
     * </p>
     *
     * @param createTrainingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateTrainingJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTrainingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTrainingJobResponse> createTrainingJob(
            Consumer<CreateTrainingJobRequest.Builder> createTrainingJobRequest) {
        return createTrainingJob(CreateTrainingJobRequest.builder().applyMutation(createTrainingJobRequest).build());
    }

    /**
     * <p>
     * Creates a new training plan in SageMaker to reserve compute capacity.
     * </p>
     * <p>
     * Amazon SageMaker Training Plan is a capability within SageMaker that allows customers to reserve and manage GPU
     * capacity for large-scale AI model training. It provides a way to secure predictable access to computational
     * resources within specific timelines and budgets, without the need to manage underlying infrastructure.
     * </p>
     * <p>
     * <b>How it works</b>
     * </p>
     * <p>
     * Plans can be created for specific resources such as SageMaker Training Jobs or SageMaker HyperPod clusters,
     * automatically provisioning resources, setting up infrastructure, executing workloads, and handling infrastructure
     * failures.
     * </p>
     * <p>
     * <b>Plan creation workflow</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Users search for available plan offerings based on their requirements (e.g., instance type, count, start time,
     * duration) using the
     * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_SearchTrainingPlanOfferings.html">SearchTrainingPlanOfferings</a> </code>
     * API operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * They create a plan that best matches their needs using the ID of the plan offering they want to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * After successful upfront payment, the plan's status becomes <code>Scheduled</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The plan can be used to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Queue training jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Allocate to an instance group of a SageMaker HyperPod cluster.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * When the plan start date arrives, it becomes <code>Active</code>. Based on available reserved capacity:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Training jobs are launched.
     * </p>
     * </li>
     * <li>
     * <p>
     * Instance groups are provisioned.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * <b>Plan composition</b>
     * </p>
     * <p>
     * A plan can consist of one or more Reserved Capacities, each defined by a specific instance type, quantity,
     * Availability Zone, duration, and start and end times. For more information about Reserved Capacity, see
     * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ReservedCapacitySummary.html">ReservedCapacitySummary</a> </code>
     * .
     * </p>
     *
     * @param createTrainingPlanRequest
     * @return A Java Future containing the result of the CreateTrainingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateTrainingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingPlan" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTrainingPlanResponse> createTrainingPlan(CreateTrainingPlanRequest createTrainingPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new training plan in SageMaker to reserve compute capacity.
     * </p>
     * <p>
     * Amazon SageMaker Training Plan is a capability within SageMaker that allows customers to reserve and manage GPU
     * capacity for large-scale AI model training. It provides a way to secure predictable access to computational
     * resources within specific timelines and budgets, without the need to manage underlying infrastructure.
     * </p>
     * <p>
     * <b>How it works</b>
     * </p>
     * <p>
     * Plans can be created for specific resources such as SageMaker Training Jobs or SageMaker HyperPod clusters,
     * automatically provisioning resources, setting up infrastructure, executing workloads, and handling infrastructure
     * failures.
     * </p>
     * <p>
     * <b>Plan creation workflow</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * Users search for available plan offerings based on their requirements (e.g., instance type, count, start time,
     * duration) using the
     * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_SearchTrainingPlanOfferings.html">SearchTrainingPlanOfferings</a> </code>
     * API operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * They create a plan that best matches their needs using the ID of the plan offering they want to use.
     * </p>
     * </li>
     * <li>
     * <p>
     * After successful upfront payment, the plan's status becomes <code>Scheduled</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The plan can be used to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Queue training jobs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Allocate to an instance group of a SageMaker HyperPod cluster.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * When the plan start date arrives, it becomes <code>Active</code>. Based on available reserved capacity:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Training jobs are launched.
     * </p>
     * </li>
     * <li>
     * <p>
     * Instance groups are provisioned.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * <b>Plan composition</b>
     * </p>
     * <p>
     * A plan can consist of one or more Reserved Capacities, each defined by a specific instance type, quantity,
     * Availability Zone, duration, and start and end times. For more information about Reserved Capacity, see
     * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ReservedCapacitySummary.html">ReservedCapacitySummary</a> </code>
     * .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrainingPlanRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTrainingPlanRequest#builder()}
     * </p>
     *
     * @param createTrainingPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateTrainingPlanRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTrainingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateTrainingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrainingPlan" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTrainingPlanResponse> createTrainingPlan(
            Consumer<CreateTrainingPlanRequest.Builder> createTrainingPlanRequest) {
        return createTrainingPlan(CreateTrainingPlanRequest.builder().applyMutation(createTrainingPlanRequest).build());
    }

    /**
     * <p>
     * Starts a transform job. A transform job uses a trained model to get inferences on a dataset and saves these
     * results to an Amazon S3 location that you specify.
     * </p>
     * <p>
     * To perform batch transformations, you create a transform job and use the data that you have readily available.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TransformJobName</code> - Identifies the transform job. The name must be unique within an Amazon Web
     * Services Region in an Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ModelName</code> - Identifies the model to use. <code>ModelName</code> must be the name of an existing
     * Amazon SageMaker model in the same Amazon Web Services Region and Amazon Web Services account. For information on
     * creating a model, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html">CreateModel</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformInput</code> - Describes the dataset to be transformed and the Amazon S3 location where it is
     * stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformOutput</code> - Identifies the Amazon S3 location where you want Amazon SageMaker to save the
     * results from the transform job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformResources</code> - Identifies the ML compute instances and AMI image versions for the transform
     * job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about how batch transformation works, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html">Batch Transform</a>.
     * </p>
     *
     * @param createTransformJobRequest
     * @return A Java Future containing the result of the CreateTransformJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTransformJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTransformJobResponse> createTransformJob(CreateTransformJobRequest createTransformJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a transform job. A transform job uses a trained model to get inferences on a dataset and saves these
     * results to an Amazon S3 location that you specify.
     * </p>
     * <p>
     * To perform batch transformations, you create a transform job and use the data that you have readily available.
     * </p>
     * <p>
     * In the request body, you provide the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TransformJobName</code> - Identifies the transform job. The name must be unique within an Amazon Web
     * Services Region in an Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ModelName</code> - Identifies the model to use. <code>ModelName</code> must be the name of an existing
     * Amazon SageMaker model in the same Amazon Web Services Region and Amazon Web Services account. For information on
     * creating a model, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html">CreateModel</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformInput</code> - Describes the dataset to be transformed and the Amazon S3 location where it is
     * stored.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformOutput</code> - Identifies the Amazon S3 location where you want Amazon SageMaker to save the
     * results from the transform job.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TransformResources</code> - Identifies the ML compute instances and AMI image versions for the transform
     * job.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about how batch transformation works, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html">Batch Transform</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTransformJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTransformJobRequest#builder()}
     * </p>
     *
     * @param createTransformJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateTransformJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTransformJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTransformJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTransformJobResponse> createTransformJob(
            Consumer<CreateTransformJobRequest.Builder> createTransformJobRequest) {
        return createTransformJob(CreateTransformJobRequest.builder().applyMutation(createTransformJobRequest).build());
    }

    /**
     * <p>
     * Creates an SageMaker <i>trial</i>. A trial is a set of steps called <i>trial components</i> that produce a
     * machine learning model. A trial is part of a single SageMaker <i>experiment</i>.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to a trial and then use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search for the
     * tags.
     * </p>
     * <p>
     * To get a list of all your trials, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrials.html">ListTrials</a> API. To view
     * a trial's properties, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrial.html">DescribeTrial</a> API. To
     * create a trial component, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrialComponent.html"
     * >CreateTrialComponent</a> API.
     * </p>
     *
     * @param createTrialRequest
     * @return A Java Future containing the result of the CreateTrial operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrial" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTrialResponse> createTrial(CreateTrialRequest createTrialRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an SageMaker <i>trial</i>. A trial is a set of steps called <i>trial components</i> that produce a
     * machine learning model. A trial is part of a single SageMaker <i>experiment</i>.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to a trial and then use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search for the
     * tags.
     * </p>
     * <p>
     * To get a list of all your trials, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrials.html">ListTrials</a> API. To view
     * a trial's properties, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrial.html">DescribeTrial</a> API. To
     * create a trial component, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrialComponent.html"
     * >CreateTrialComponent</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrialRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTrialRequest#builder()}
     * </p>
     *
     * @param createTrialRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateTrialRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateTrial operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrial" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTrialResponse> createTrial(Consumer<CreateTrialRequest.Builder> createTrialRequest) {
        return createTrial(CreateTrialRequest.builder().applyMutation(createTrialRequest).build());
    }

    /**
     * <p>
     * Creates a <i>trial component</i>, which is a stage of a machine learning <i>trial</i>. A trial is composed of one
     * or more trial components. A trial component can be used in multiple trials.
     * </p>
     * <p>
     * Trial components include pre-processing jobs, training jobs, and batch transform jobs.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to a trial component and then use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search for the
     * tags.
     * </p>
     *
     * @param createTrialComponentRequest
     * @return A Java Future containing the result of the CreateTrialComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrialComponentResponse> createTrialComponent(
            CreateTrialComponentRequest createTrialComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <i>trial component</i>, which is a stage of a machine learning <i>trial</i>. A trial is composed of one
     * or more trial components. A trial component can be used in multiple trials.
     * </p>
     * <p>
     * Trial components include pre-processing jobs, training jobs, and batch transform jobs.
     * </p>
     * <p>
     * When you use SageMaker Studio or the SageMaker Python SDK, all experiments, trials, and trial components are
     * automatically tracked, logged, and indexed. When you use the Amazon Web Services SDK for Python (Boto), you must
     * use the logging APIs provided by the SDK.
     * </p>
     * <p>
     * You can add tags to a trial component and then use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search for the
     * tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrialComponentRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTrialComponentRequest#builder()}
     * </p>
     *
     * @param createTrialComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateTrialComponentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTrialComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrialComponentResponse> createTrialComponent(
            Consumer<CreateTrialComponentRequest.Builder> createTrialComponentRequest) {
        return createTrialComponent(CreateTrialComponentRequest.builder().applyMutation(createTrialComponentRequest).build());
    }

    /**
     * <p>
     * Creates a user profile. A user profile represents a single user within a domain, and is the main way to reference
     * a "person" for the purposes of sharing, reporting, and other user-oriented features. This entity is created when
     * a user onboards to a domain. If an administrator invites a person by email or imports them from IAM Identity
     * Center, a user profile is automatically created. A user profile is the primary holder of settings for an
     * individual user and has a reference to the user's private Amazon Elastic File System home directory.
     * </p>
     *
     * @param createUserProfileRequest
     * @return A Java Future containing the result of the CreateUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateUserProfileResponse> createUserProfile(CreateUserProfileRequest createUserProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user profile. A user profile represents a single user within a domain, and is the main way to reference
     * a "person" for the purposes of sharing, reporting, and other user-oriented features. This entity is created when
     * a user onboards to a domain. If an administrator invites a person by email or imports them from IAM Identity
     * Center, a user profile is automatically created. A user profile is the primary holder of settings for an
     * individual user and has a reference to the user's private Amazon Elastic File System home directory.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserProfileRequest.Builder} avoiding the need
     * to create one manually via {@link CreateUserProfileRequest#builder()}
     * </p>
     *
     * @param createUserProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateUserProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateUserProfileResponse> createUserProfile(
            Consumer<CreateUserProfileRequest.Builder> createUserProfileRequest) {
        return createUserProfile(CreateUserProfileRequest.builder().applyMutation(createUserProfileRequest).build());
    }

    /**
     * <p>
     * Use this operation to create a workforce. This operation will return an error if a workforce already exists in
     * the Amazon Web Services Region that you specify. You can only create one workforce in each Amazon Web Services
     * Region per Amazon Web Services account.
     * </p>
     * <p>
     * If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use the
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteWorkforce.html">DeleteWorkforce</a>
     * API operation to delete the existing workforce and then use <code>CreateWorkforce</code> to create a new
     * workforce.
     * </p>
     * <p>
     * To create a private workforce using Amazon Cognito, you must specify a Cognito user pool in
     * <code>CognitoConfig</code>. You can also create an Amazon Cognito workforce using the Amazon SageMaker console.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html"> Create a Private
     * Workforce (Amazon Cognito)</a>.
     * </p>
     * <p>
     * To create a private workforce using your own OIDC Identity Provider (IdP), specify your IdP configuration in
     * <code>OidcConfig</code>. Your OIDC IdP must support <i>groups</i> because groups are used by Ground Truth and
     * Amazon A2I to create work teams. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private-oidc.html"> Create a Private
     * Workforce (OIDC IdP)</a>.
     * </p>
     *
     * @param createWorkforceRequest
     * @return A Java Future containing the result of the CreateWorkforce operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkforce" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkforceResponse> createWorkforce(CreateWorkforceRequest createWorkforceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to create a workforce. This operation will return an error if a workforce already exists in
     * the Amazon Web Services Region that you specify. You can only create one workforce in each Amazon Web Services
     * Region per Amazon Web Services account.
     * </p>
     * <p>
     * If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use the
     * <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteWorkforce.html">DeleteWorkforce</a>
     * API operation to delete the existing workforce and then use <code>CreateWorkforce</code> to create a new
     * workforce.
     * </p>
     * <p>
     * To create a private workforce using Amazon Cognito, you must specify a Cognito user pool in
     * <code>CognitoConfig</code>. You can also create an Amazon Cognito workforce using the Amazon SageMaker console.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private.html"> Create a Private
     * Workforce (Amazon Cognito)</a>.
     * </p>
     * <p>
     * To create a private workforce using your own OIDC Identity Provider (IdP), specify your IdP configuration in
     * <code>OidcConfig</code>. Your OIDC IdP must support <i>groups</i> because groups are used by Ground Truth and
     * Amazon A2I to create work teams. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-create-private-oidc.html"> Create a Private
     * Workforce (OIDC IdP)</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkforceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateWorkforceRequest#builder()}
     * </p>
     *
     * @param createWorkforceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateWorkforceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWorkforce operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkforce" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkforceResponse> createWorkforce(
            Consumer<CreateWorkforceRequest.Builder> createWorkforceRequest) {
        return createWorkforce(CreateWorkforceRequest.builder().applyMutation(createWorkforceRequest).build());
    }

    /**
     * <p>
     * Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools.
     * You must first create the user pools before you can create a work team.
     * </p>
     * <p>
     * You cannot create more than 25 work teams in an account and region.
     * </p>
     *
     * @param createWorkteamRequest
     * @return A Java Future containing the result of the CreateWorkteam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkteamResponse> createWorkteam(CreateWorkteamRequest createWorkteamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new work team for labeling your data. A work team is defined by one or more Amazon Cognito user pools.
     * You must first create the user pools before you can create a work team.
     * </p>
     * <p>
     * You cannot create more than 25 work teams in an account and region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkteamRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWorkteamRequest#builder()}
     * </p>
     *
     * @param createWorkteamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.CreateWorkteamRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateWorkteam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.CreateWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkteamResponse> createWorkteam(Consumer<CreateWorkteamRequest.Builder> createWorkteamRequest) {
        return createWorkteam(CreateWorkteamRequest.builder().applyMutation(createWorkteamRequest).build());
    }

    /**
     * <p>
     * Deletes an action.
     * </p>
     *
     * @param deleteActionRequest
     * @return A Java Future containing the result of the DeleteAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteActionResponse> deleteAction(DeleteActionRequest deleteActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteActionRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteActionRequest#builder()}
     * </p>
     *
     * @param deleteActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteActionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteActionResponse> deleteAction(Consumer<DeleteActionRequest.Builder> deleteActionRequest) {
        return deleteAction(DeleteActionRequest.builder().applyMutation(deleteActionRequest).build());
    }

    /**
     * <p>
     * Removes the specified algorithm from your account.
     * </p>
     *
     * @param deleteAlgorithmRequest
     * @return A Java Future containing the result of the DeleteAlgorithm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAlgorithm" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAlgorithmResponse> deleteAlgorithm(DeleteAlgorithmRequest deleteAlgorithmRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified algorithm from your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAlgorithmRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAlgorithmRequest#builder()}
     * </p>
     *
     * @param deleteAlgorithmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteAlgorithmRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAlgorithm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAlgorithm" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAlgorithmResponse> deleteAlgorithm(
            Consumer<DeleteAlgorithmRequest.Builder> deleteAlgorithmRequest) {
        return deleteAlgorithm(DeleteAlgorithmRequest.builder().applyMutation(deleteAlgorithmRequest).build());
    }

    /**
     * <p>
     * Used to stop and delete an app.
     * </p>
     *
     * @param deleteAppRequest
     * @return A Java Future containing the result of the DeleteApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAppResponse> deleteApp(DeleteAppRequest deleteAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to stop and delete an app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAppRequest#builder()}
     * </p>
     *
     * @param deleteAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteAppRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAppResponse> deleteApp(Consumer<DeleteAppRequest.Builder> deleteAppRequest) {
        return deleteApp(DeleteAppRequest.builder().applyMutation(deleteAppRequest).build());
    }

    /**
     * <p>
     * Deletes an AppImageConfig.
     * </p>
     *
     * @param deleteAppImageConfigRequest
     * @return A Java Future containing the result of the DeleteAppImageConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAppImageConfigResponse> deleteAppImageConfig(
            DeleteAppImageConfigRequest deleteAppImageConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an AppImageConfig.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppImageConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAppImageConfigRequest#builder()}
     * </p>
     *
     * @param deleteAppImageConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteAppImageConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAppImageConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAppImageConfigResponse> deleteAppImageConfig(
            Consumer<DeleteAppImageConfigRequest.Builder> deleteAppImageConfigRequest) {
        return deleteAppImageConfig(DeleteAppImageConfigRequest.builder().applyMutation(deleteAppImageConfigRequest).build());
    }

    /**
     * <p>
     * Deletes an artifact. Either <code>ArtifactArn</code> or <code>Source</code> must be specified.
     * </p>
     *
     * @param deleteArtifactRequest
     * @return A Java Future containing the result of the DeleteArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteArtifact" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteArtifactResponse> deleteArtifact(DeleteArtifactRequest deleteArtifactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an artifact. Either <code>ArtifactArn</code> or <code>Source</code> must be specified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteArtifactRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteArtifactRequest#builder()}
     * </p>
     *
     * @param deleteArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteArtifactRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteArtifact" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteArtifactResponse> deleteArtifact(Consumer<DeleteArtifactRequest.Builder> deleteArtifactRequest) {
        return deleteArtifact(DeleteArtifactRequest.builder().applyMutation(deleteArtifactRequest).build());
    }

    /**
     * <p>
     * Deletes an association.
     * </p>
     *
     * @param deleteAssociationRequest
     * @return A Java Future containing the result of the DeleteAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAssociation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAssociationResponse> deleteAssociation(DeleteAssociationRequest deleteAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssociationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAssociationRequest#builder()}
     * </p>
     *
     * @param deleteAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteAssociationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteAssociation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAssociationResponse> deleteAssociation(
            Consumer<DeleteAssociationRequest.Builder> deleteAssociationRequest) {
        return deleteAssociation(DeleteAssociationRequest.builder().applyMutation(deleteAssociationRequest).build());
    }

    /**
     * <p>
     * Delete a SageMaker HyperPod cluster.
     * </p>
     *
     * @param deleteClusterRequest
     * @return A Java Future containing the result of the DeleteCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteClusterResponse> deleteCluster(DeleteClusterRequest deleteClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a SageMaker HyperPod cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteClusterRequest#builder()}
     * </p>
     *
     * @param deleteClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteClusterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteClusterResponse> deleteCluster(Consumer<DeleteClusterRequest.Builder> deleteClusterRequest) {
        return deleteCluster(DeleteClusterRequest.builder().applyMutation(deleteClusterRequest).build());
    }

    /**
     * <p>
     * Deletes the cluster policy of the cluster.
     * </p>
     *
     * @param deleteClusterSchedulerConfigRequest
     * @return A Java Future containing the result of the DeleteClusterSchedulerConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteClusterSchedulerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteClusterSchedulerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteClusterSchedulerConfigResponse> deleteClusterSchedulerConfig(
            DeleteClusterSchedulerConfigRequest deleteClusterSchedulerConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the cluster policy of the cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteClusterSchedulerConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteClusterSchedulerConfigRequest#builder()}
     * </p>
     *
     * @param deleteClusterSchedulerConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteClusterSchedulerConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteClusterSchedulerConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteClusterSchedulerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteClusterSchedulerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteClusterSchedulerConfigResponse> deleteClusterSchedulerConfig(
            Consumer<DeleteClusterSchedulerConfigRequest.Builder> deleteClusterSchedulerConfigRequest) {
        return deleteClusterSchedulerConfig(DeleteClusterSchedulerConfigRequest.builder()
                .applyMutation(deleteClusterSchedulerConfigRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Git repository from your account.
     * </p>
     *
     * @param deleteCodeRepositoryRequest
     * @return A Java Future containing the result of the DeleteCodeRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCodeRepositoryResponse> deleteCodeRepository(
            DeleteCodeRepositoryRequest deleteCodeRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Git repository from your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCodeRepositoryRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCodeRepositoryRequest#builder()}
     * </p>
     *
     * @param deleteCodeRepositoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteCodeRepositoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCodeRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCodeRepositoryResponse> deleteCodeRepository(
            Consumer<DeleteCodeRepositoryRequest.Builder> deleteCodeRepositoryRequest) {
        return deleteCodeRepository(DeleteCodeRepositoryRequest.builder().applyMutation(deleteCodeRepositoryRequest).build());
    }

    /**
     * <p>
     * Deletes the specified compilation job. This action deletes only the compilation job resource in Amazon SageMaker
     * AI. It doesn't delete other resources that are related to that job, such as the model artifacts that the job
     * creates, the compilation logs in CloudWatch, the compiled model, or the IAM role.
     * </p>
     * <p>
     * You can delete a compilation job only if its current status is <code>COMPLETED</code>, <code>FAILED</code>, or
     * <code>STOPPED</code>. If the job status is <code>STARTING</code> or <code>INPROGRESS</code>, stop the job, and
     * then delete it after its status becomes <code>STOPPED</code>.
     * </p>
     *
     * @param deleteCompilationJobRequest
     * @return A Java Future containing the result of the DeleteCompilationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteCompilationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCompilationJobResponse> deleteCompilationJob(
            DeleteCompilationJobRequest deleteCompilationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified compilation job. This action deletes only the compilation job resource in Amazon SageMaker
     * AI. It doesn't delete other resources that are related to that job, such as the model artifacts that the job
     * creates, the compilation logs in CloudWatch, the compiled model, or the IAM role.
     * </p>
     * <p>
     * You can delete a compilation job only if its current status is <code>COMPLETED</code>, <code>FAILED</code>, or
     * <code>STOPPED</code>. If the job status is <code>STARTING</code> or <code>INPROGRESS</code>, stop the job, and
     * then delete it after its status becomes <code>STOPPED</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCompilationJobRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCompilationJobRequest#builder()}
     * </p>
     *
     * @param deleteCompilationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteCompilationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteCompilationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteCompilationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCompilationJobResponse> deleteCompilationJob(
            Consumer<DeleteCompilationJobRequest.Builder> deleteCompilationJobRequest) {
        return deleteCompilationJob(DeleteCompilationJobRequest.builder().applyMutation(deleteCompilationJobRequest).build());
    }

    /**
     * <p>
     * Deletes the compute allocation from the cluster.
     * </p>
     *
     * @param deleteComputeQuotaRequest
     * @return A Java Future containing the result of the DeleteComputeQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteComputeQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteComputeQuota" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteComputeQuotaResponse> deleteComputeQuota(DeleteComputeQuotaRequest deleteComputeQuotaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the compute allocation from the cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteComputeQuotaRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteComputeQuotaRequest#builder()}
     * </p>
     *
     * @param deleteComputeQuotaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteComputeQuotaRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteComputeQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteComputeQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteComputeQuota" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteComputeQuotaResponse> deleteComputeQuota(
            Consumer<DeleteComputeQuotaRequest.Builder> deleteComputeQuotaRequest) {
        return deleteComputeQuota(DeleteComputeQuotaRequest.builder().applyMutation(deleteComputeQuotaRequest).build());
    }

    /**
     * <p>
     * Deletes an context.
     * </p>
     *
     * @param deleteContextRequest
     * @return A Java Future containing the result of the DeleteContext operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteContext" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteContextResponse> deleteContext(DeleteContextRequest deleteContextRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an context.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContextRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteContextRequest#builder()}
     * </p>
     *
     * @param deleteContextRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteContextRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteContext operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteContext" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteContextResponse> deleteContext(Consumer<DeleteContextRequest.Builder> deleteContextRequest) {
        return deleteContext(DeleteContextRequest.builder().applyMutation(deleteContextRequest).build());
    }

    /**
     * <p>
     * Deletes a data quality monitoring job definition.
     * </p>
     *
     * @param deleteDataQualityJobDefinitionRequest
     * @return A Java Future containing the result of the DeleteDataQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDataQualityJobDefinitionResponse> deleteDataQualityJobDefinition(
            DeleteDataQualityJobDefinitionRequest deleteDataQualityJobDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a data quality monitoring job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataQualityJobDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDataQualityJobDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteDataQualityJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteDataQualityJobDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteDataQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDataQualityJobDefinitionResponse> deleteDataQualityJobDefinition(
            Consumer<DeleteDataQualityJobDefinitionRequest.Builder> deleteDataQualityJobDefinitionRequest) {
        return deleteDataQualityJobDefinition(DeleteDataQualityJobDefinitionRequest.builder()
                .applyMutation(deleteDataQualityJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     *
     * @param deleteDeviceFleetRequest
     * @return A Java Future containing the result of the DeleteDeviceFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDeviceFleetResponse> deleteDeviceFleet(DeleteDeviceFleetRequest deleteDeviceFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDeviceFleetRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDeviceFleetRequest#builder()}
     * </p>
     *
     * @param deleteDeviceFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteDeviceFleetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDeviceFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDeviceFleetResponse> deleteDeviceFleet(
            Consumer<DeleteDeviceFleetRequest.Builder> deleteDeviceFleetRequest) {
        return deleteDeviceFleet(DeleteDeviceFleetRequest.builder().applyMutation(deleteDeviceFleetRequest).build());
    }

    /**
     * <p>
     * Used to delete a domain. If you onboarded with IAM mode, you will need to delete your domain to onboard again
     * using IAM Identity Center. Use with caution. All of the members of the domain will lose access to their EFS
     * volume, including data, notebooks, and other artifacts.
     * </p>
     *
     * @param deleteDomainRequest
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDomainResponse> deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to delete a domain. If you onboarded with IAM mode, you will need to delete your domain to onboard again
     * using IAM Identity Center. Use with caution. All of the members of the domain will lose access to their EFS
     * volume, including data, notebooks, and other artifacts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDomainRequest#builder()}
     * </p>
     *
     * @param deleteDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDomainResponse> deleteDomain(Consumer<DeleteDomainRequest.Builder> deleteDomainRequest) {
        return deleteDomain(DeleteDomainRequest.builder().applyMutation(deleteDomainRequest).build());
    }

    /**
     * <p>
     * Deletes an edge deployment plan if (and only if) all the stages in the plan are inactive or there are no stages
     * in the plan.
     * </p>
     *
     * @param deleteEdgeDeploymentPlanRequest
     * @return A Java Future containing the result of the DeleteEdgeDeploymentPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEdgeDeploymentPlanResponse> deleteEdgeDeploymentPlan(
            DeleteEdgeDeploymentPlanRequest deleteEdgeDeploymentPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an edge deployment plan if (and only if) all the stages in the plan are inactive or there are no stages
     * in the plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEdgeDeploymentPlanRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEdgeDeploymentPlanRequest#builder()}
     * </p>
     *
     * @param deleteEdgeDeploymentPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentPlanRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteEdgeDeploymentPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEdgeDeploymentPlanResponse> deleteEdgeDeploymentPlan(
            Consumer<DeleteEdgeDeploymentPlanRequest.Builder> deleteEdgeDeploymentPlanRequest) {
        return deleteEdgeDeploymentPlan(DeleteEdgeDeploymentPlanRequest.builder().applyMutation(deleteEdgeDeploymentPlanRequest)
                .build());
    }

    /**
     * <p>
     * Delete a stage in an edge deployment plan if (and only if) the stage is inactive.
     * </p>
     *
     * @param deleteEdgeDeploymentStageRequest
     * @return A Java Future containing the result of the DeleteEdgeDeploymentStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteEdgeDeploymentStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEdgeDeploymentStage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEdgeDeploymentStageResponse> deleteEdgeDeploymentStage(
            DeleteEdgeDeploymentStageRequest deleteEdgeDeploymentStageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a stage in an edge deployment plan if (and only if) the stage is inactive.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEdgeDeploymentStageRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEdgeDeploymentStageRequest#builder()}
     * </p>
     *
     * @param deleteEdgeDeploymentStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteEdgeDeploymentStageRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteEdgeDeploymentStage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteEdgeDeploymentStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEdgeDeploymentStage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEdgeDeploymentStageResponse> deleteEdgeDeploymentStage(
            Consumer<DeleteEdgeDeploymentStageRequest.Builder> deleteEdgeDeploymentStageRequest) {
        return deleteEdgeDeploymentStage(DeleteEdgeDeploymentStageRequest.builder()
                .applyMutation(deleteEdgeDeploymentStageRequest).build());
    }

    /**
     * <p>
     * Deletes an endpoint. SageMaker frees up all of the resources that were deployed when the endpoint was created.
     * </p>
     * <p>
     * SageMaker retires any custom KMS key grants associated with the endpoint, meaning you don't need to use the <a
     * href="http://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> API call.
     * </p>
     * <p>
     * When you delete your endpoint, SageMaker asynchronously deletes associated endpoint resources such as KMS key
     * grants. You might still see these resources in your account for a few minutes after deleting your endpoint. Do
     * not delete or revoke the permissions for your
     * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html#sagemaker-CreateModel-request-ExecutionRoleArn">ExecutionRoleArn</a> </code>
     * , otherwise SageMaker cannot delete these resources.
     * </p>
     *
     * @param deleteEndpointRequest
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an endpoint. SageMaker frees up all of the resources that were deployed when the endpoint was created.
     * </p>
     * <p>
     * SageMaker retires any custom KMS key grants associated with the endpoint, meaning you don't need to use the <a
     * href="http://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html">RevokeGrant</a> API call.
     * </p>
     * <p>
     * When you delete your endpoint, SageMaker asynchronously deletes associated endpoint resources such as KMS key
     * grants. You might still see these resources in your account for a few minutes after deleting your endpoint. Do
     * not delete or revoke the permissions for your
     * <code> <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateModel.html#sagemaker-CreateModel-request-ExecutionRoleArn">ExecutionRoleArn</a> </code>
     * , otherwise SageMaker cannot delete these resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEndpointRequest#builder()}
     * </p>
     *
     * @param deleteEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteEndpointRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEndpointResponse> deleteEndpoint(Consumer<DeleteEndpointRequest.Builder> deleteEndpointRequest) {
        return deleteEndpoint(DeleteEndpointRequest.builder().applyMutation(deleteEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes an endpoint configuration. The <code>DeleteEndpointConfig</code> API deletes only the specified
     * configuration. It does not delete endpoints created using the configuration.
     * </p>
     * <p>
     * You must not delete an <code>EndpointConfig</code> in use by an endpoint that is live or while the
     * <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. If you
     * delete the <code>EndpointConfig</code> of an endpoint that is active or being created or updated you may lose
     * visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring
     * charges.
     * </p>
     *
     * @param deleteEndpointConfigRequest
     * @return A Java Future containing the result of the DeleteEndpointConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEndpointConfigResponse> deleteEndpointConfig(
            DeleteEndpointConfigRequest deleteEndpointConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an endpoint configuration. The <code>DeleteEndpointConfig</code> API deletes only the specified
     * configuration. It does not delete endpoints created using the configuration.
     * </p>
     * <p>
     * You must not delete an <code>EndpointConfig</code> in use by an endpoint that is live or while the
     * <code>UpdateEndpoint</code> or <code>CreateEndpoint</code> operations are being performed on the endpoint. If you
     * delete the <code>EndpointConfig</code> of an endpoint that is active or being created or updated you may lose
     * visibility into the instance type the endpoint is using. The endpoint must be deleted in order to stop incurring
     * charges.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEndpointConfigRequest#builder()}
     * </p>
     *
     * @param deleteEndpointConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEndpointConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEndpointConfigResponse> deleteEndpointConfig(
            Consumer<DeleteEndpointConfigRequest.Builder> deleteEndpointConfigRequest) {
        return deleteEndpointConfig(DeleteEndpointConfigRequest.builder().applyMutation(deleteEndpointConfigRequest).build());
    }

    /**
     * <p>
     * Deletes an SageMaker experiment. All trials associated with the experiment must be deleted first. Use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrials.html">ListTrials</a> API to get a
     * list of the trials associated with the experiment.
     * </p>
     *
     * @param deleteExperimentRequest
     * @return A Java Future containing the result of the DeleteExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteExperimentResponse> deleteExperiment(DeleteExperimentRequest deleteExperimentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an SageMaker experiment. All trials associated with the experiment must be deleted first. Use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListTrials.html">ListTrials</a> API to get a
     * list of the trials associated with the experiment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteExperimentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteExperimentRequest#builder()}
     * </p>
     *
     * @param deleteExperimentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteExperimentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteExperimentResponse> deleteExperiment(
            Consumer<DeleteExperimentRequest.Builder> deleteExperimentRequest) {
        return deleteExperiment(DeleteExperimentRequest.builder().applyMutation(deleteExperimentRequest).build());
    }

    /**
     * <p>
     * Delete the <code>FeatureGroup</code> and any data that was written to the <code>OnlineStore</code> of the
     * <code>FeatureGroup</code>. Data cannot be accessed from the <code>OnlineStore</code> immediately after
     * <code>DeleteFeatureGroup</code> is called.
     * </p>
     * <p>
     * Data written into the <code>OfflineStore</code> will not be deleted. The Amazon Web Services Glue database and
     * tables that are automatically created for your <code>OfflineStore</code> are not deleted.
     * </p>
     * <p>
     * Note that it can take approximately 10-15 minutes to delete an <code>OnlineStore</code> <code>FeatureGroup</code>
     * with the <code>InMemory</code> <code>StorageType</code>.
     * </p>
     *
     * @param deleteFeatureGroupRequest
     * @return A Java Future containing the result of the DeleteFeatureGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteFeatureGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteFeatureGroupResponse> deleteFeatureGroup(DeleteFeatureGroupRequest deleteFeatureGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the <code>FeatureGroup</code> and any data that was written to the <code>OnlineStore</code> of the
     * <code>FeatureGroup</code>. Data cannot be accessed from the <code>OnlineStore</code> immediately after
     * <code>DeleteFeatureGroup</code> is called.
     * </p>
     * <p>
     * Data written into the <code>OfflineStore</code> will not be deleted. The Amazon Web Services Glue database and
     * tables that are automatically created for your <code>OfflineStore</code> are not deleted.
     * </p>
     * <p>
     * Note that it can take approximately 10-15 minutes to delete an <code>OnlineStore</code> <code>FeatureGroup</code>
     * with the <code>InMemory</code> <code>StorageType</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFeatureGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFeatureGroupRequest#builder()}
     * </p>
     *
     * @param deleteFeatureGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteFeatureGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteFeatureGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteFeatureGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteFeatureGroupResponse> deleteFeatureGroup(
            Consumer<DeleteFeatureGroupRequest.Builder> deleteFeatureGroupRequest) {
        return deleteFeatureGroup(DeleteFeatureGroupRequest.builder().applyMutation(deleteFeatureGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified flow definition.
     * </p>
     *
     * @param deleteFlowDefinitionRequest
     * @return A Java Future containing the result of the DeleteFlowDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFlowDefinitionResponse> deleteFlowDefinition(
            DeleteFlowDefinitionRequest deleteFlowDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified flow definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFlowDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFlowDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteFlowDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteFlowDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteFlowDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFlowDefinitionResponse> deleteFlowDefinition(
            Consumer<DeleteFlowDefinitionRequest.Builder> deleteFlowDefinitionRequest) {
        return deleteFlowDefinition(DeleteFlowDefinitionRequest.builder().applyMutation(deleteFlowDefinitionRequest).build());
    }

    /**
     * <p>
     * Delete a hub.
     * </p>
     *
     * @param deleteHubRequest
     * @return A Java Future containing the result of the DeleteHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHub" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteHubResponse> deleteHub(DeleteHubRequest deleteHubRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHubRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteHubRequest#builder()}
     * </p>
     *
     * @param deleteHubRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteHubRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHub" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteHubResponse> deleteHub(Consumer<DeleteHubRequest.Builder> deleteHubRequest) {
        return deleteHub(DeleteHubRequest.builder().applyMutation(deleteHubRequest).build());
    }

    /**
     * <p>
     * Delete the contents of a hub.
     * </p>
     *
     * @param deleteHubContentRequest
     * @return A Java Future containing the result of the DeleteHubContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteHubContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHubContent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteHubContentResponse> deleteHubContent(DeleteHubContentRequest deleteHubContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the contents of a hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHubContentRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteHubContentRequest#builder()}
     * </p>
     *
     * @param deleteHubContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteHubContentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteHubContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteHubContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHubContent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteHubContentResponse> deleteHubContent(
            Consumer<DeleteHubContentRequest.Builder> deleteHubContentRequest) {
        return deleteHubContent(DeleteHubContentRequest.builder().applyMutation(deleteHubContentRequest).build());
    }

    /**
     * <p>
     * Delete a hub content reference in order to remove a model from a private hub.
     * </p>
     *
     * @param deleteHubContentReferenceRequest
     * @return A Java Future containing the result of the DeleteHubContentReference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteHubContentReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHubContentReference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHubContentReferenceResponse> deleteHubContentReference(
            DeleteHubContentReferenceRequest deleteHubContentReferenceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a hub content reference in order to remove a model from a private hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHubContentReferenceRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteHubContentReferenceRequest#builder()}
     * </p>
     *
     * @param deleteHubContentReferenceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteHubContentReferenceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteHubContentReference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteHubContentReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHubContentReference"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHubContentReferenceResponse> deleteHubContentReference(
            Consumer<DeleteHubContentReferenceRequest.Builder> deleteHubContentReferenceRequest) {
        return deleteHubContentReference(DeleteHubContentReferenceRequest.builder()
                .applyMutation(deleteHubContentReferenceRequest).build());
    }

    /**
     * <p>
     * Use this operation to delete a human task user interface (worker task template).
     * </p>
     * <p>
     * To see a list of human task user interfaces (work task templates) in your account, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListHumanTaskUis.html">ListHumanTaskUis</a>.
     * When you delete a worker task template, it no longer appears when you call <code>ListHumanTaskUis</code>.
     * </p>
     *
     * @param deleteHumanTaskUiRequest
     * @return A Java Future containing the result of the DeleteHumanTaskUi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteHumanTaskUiResponse> deleteHumanTaskUi(DeleteHumanTaskUiRequest deleteHumanTaskUiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to delete a human task user interface (worker task template).
     * </p>
     * <p>
     * To see a list of human task user interfaces (work task templates) in your account, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListHumanTaskUis.html">ListHumanTaskUis</a>.
     * When you delete a worker task template, it no longer appears when you call <code>ListHumanTaskUis</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHumanTaskUiRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteHumanTaskUiRequest#builder()}
     * </p>
     *
     * @param deleteHumanTaskUiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteHumanTaskUiRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteHumanTaskUi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteHumanTaskUiResponse> deleteHumanTaskUi(
            Consumer<DeleteHumanTaskUiRequest.Builder> deleteHumanTaskUiRequest) {
        return deleteHumanTaskUi(DeleteHumanTaskUiRequest.builder().applyMutation(deleteHumanTaskUiRequest).build());
    }

    /**
     * <p>
     * Deletes a hyperparameter tuning job. The <code>DeleteHyperParameterTuningJob</code> API deletes only the tuning
     * job entry that was created in SageMaker when you called the <code>CreateHyperParameterTuningJob</code> API. It
     * does not delete training jobs, artifacts, or the IAM role that you specified when creating the model.
     * </p>
     *
     * @param deleteHyperParameterTuningJobRequest
     * @return A Java Future containing the result of the DeleteHyperParameterTuningJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteHyperParameterTuningJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHyperParameterTuningJobResponse> deleteHyperParameterTuningJob(
            DeleteHyperParameterTuningJobRequest deleteHyperParameterTuningJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a hyperparameter tuning job. The <code>DeleteHyperParameterTuningJob</code> API deletes only the tuning
     * job entry that was created in SageMaker when you called the <code>CreateHyperParameterTuningJob</code> API. It
     * does not delete training jobs, artifacts, or the IAM role that you specified when creating the model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteHyperParameterTuningJobRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteHyperParameterTuningJobRequest#builder()}
     * </p>
     *
     * @param deleteHyperParameterTuningJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteHyperParameterTuningJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteHyperParameterTuningJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteHyperParameterTuningJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteHyperParameterTuningJobResponse> deleteHyperParameterTuningJob(
            Consumer<DeleteHyperParameterTuningJobRequest.Builder> deleteHyperParameterTuningJobRequest) {
        return deleteHyperParameterTuningJob(DeleteHyperParameterTuningJobRequest.builder()
                .applyMutation(deleteHyperParameterTuningJobRequest).build());
    }

    /**
     * <p>
     * Deletes a SageMaker AI image and all versions of the image. The container images aren't deleted.
     * </p>
     *
     * @param deleteImageRequest
     * @return A Java Future containing the result of the DeleteImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteImageResponse> deleteImage(DeleteImageRequest deleteImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a SageMaker AI image and all versions of the image. The container images aren't deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImageRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteImageRequest#builder()}
     * </p>
     *
     * @param deleteImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteImageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteImageResponse> deleteImage(Consumer<DeleteImageRequest.Builder> deleteImageRequest) {
        return deleteImage(DeleteImageRequest.builder().applyMutation(deleteImageRequest).build());
    }

    /**
     * <p>
     * Deletes a version of a SageMaker AI image. The container image the version represents isn't deleted.
     * </p>
     *
     * @param deleteImageVersionRequest
     * @return A Java Future containing the result of the DeleteImageVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteImageVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteImageVersionResponse> deleteImageVersion(DeleteImageVersionRequest deleteImageVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a version of a SageMaker AI image. The container image the version represents isn't deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImageVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteImageVersionRequest#builder()}
     * </p>
     *
     * @param deleteImageVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteImageVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteImageVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteImageVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteImageVersionResponse> deleteImageVersion(
            Consumer<DeleteImageVersionRequest.Builder> deleteImageVersionRequest) {
        return deleteImageVersion(DeleteImageVersionRequest.builder().applyMutation(deleteImageVersionRequest).build());
    }

    /**
     * <p>
     * Deletes an inference component.
     * </p>
     *
     * @param deleteInferenceComponentRequest
     * @return A Java Future containing the result of the DeleteInferenceComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteInferenceComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteInferenceComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInferenceComponentResponse> deleteInferenceComponent(
            DeleteInferenceComponentRequest deleteInferenceComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an inference component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInferenceComponentRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteInferenceComponentRequest#builder()}
     * </p>
     *
     * @param deleteInferenceComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteInferenceComponentRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteInferenceComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteInferenceComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteInferenceComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInferenceComponentResponse> deleteInferenceComponent(
            Consumer<DeleteInferenceComponentRequest.Builder> deleteInferenceComponentRequest) {
        return deleteInferenceComponent(DeleteInferenceComponentRequest.builder().applyMutation(deleteInferenceComponentRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an inference experiment.
     * </p>
     * <note>
     * <p>
     * This operation does not delete your endpoint, variants, or any underlying resources. This operation only deletes
     * the metadata of your experiment.
     * </p>
     * </note>
     *
     * @param deleteInferenceExperimentRequest
     * @return A Java Future containing the result of the DeleteInferenceExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteInferenceExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteInferenceExperiment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInferenceExperimentResponse> deleteInferenceExperiment(
            DeleteInferenceExperimentRequest deleteInferenceExperimentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an inference experiment.
     * </p>
     * <note>
     * <p>
     * This operation does not delete your endpoint, variants, or any underlying resources. This operation only deletes
     * the metadata of your experiment.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInferenceExperimentRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteInferenceExperimentRequest#builder()}
     * </p>
     *
     * @param deleteInferenceExperimentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteInferenceExperimentRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteInferenceExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteInferenceExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteInferenceExperiment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteInferenceExperimentResponse> deleteInferenceExperiment(
            Consumer<DeleteInferenceExperimentRequest.Builder> deleteInferenceExperimentRequest) {
        return deleteInferenceExperiment(DeleteInferenceExperimentRequest.builder()
                .applyMutation(deleteInferenceExperimentRequest).build());
    }

    /**
     * <p>
     * Deletes an MLflow Tracking Server. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-cleanup.html.html">Clean up MLflow resources</a>.
     * </p>
     *
     * @param deleteMlflowTrackingServerRequest
     * @return A Java Future containing the result of the DeleteMlflowTrackingServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteMlflowTrackingServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteMlflowTrackingServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMlflowTrackingServerResponse> deleteMlflowTrackingServer(
            DeleteMlflowTrackingServerRequest deleteMlflowTrackingServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an MLflow Tracking Server. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-cleanup.html.html">Clean up MLflow resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMlflowTrackingServerRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteMlflowTrackingServerRequest#builder()}
     * </p>
     *
     * @param deleteMlflowTrackingServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteMlflowTrackingServerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteMlflowTrackingServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteMlflowTrackingServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteMlflowTrackingServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMlflowTrackingServerResponse> deleteMlflowTrackingServer(
            Consumer<DeleteMlflowTrackingServerRequest.Builder> deleteMlflowTrackingServerRequest) {
        return deleteMlflowTrackingServer(DeleteMlflowTrackingServerRequest.builder()
                .applyMutation(deleteMlflowTrackingServerRequest).build());
    }

    /**
     * <p>
     * Deletes a model. The <code>DeleteModel</code> API deletes only the model entry that was created in SageMaker when
     * you called the <code>CreateModel</code> API. It does not delete model artifacts, inference code, or the IAM role
     * that you specified when creating the model.
     * </p>
     *
     * @param deleteModelRequest
     * @return A Java Future containing the result of the DeleteModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteModelResponse> deleteModel(DeleteModelRequest deleteModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a model. The <code>DeleteModel</code> API deletes only the model entry that was created in SageMaker when
     * you called the <code>CreateModel</code> API. It does not delete model artifacts, inference code, or the IAM role
     * that you specified when creating the model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteModelRequest#builder()}
     * </p>
     *
     * @param deleteModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteModelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteModelResponse> deleteModel(Consumer<DeleteModelRequest.Builder> deleteModelRequest) {
        return deleteModel(DeleteModelRequest.builder().applyMutation(deleteModelRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker AI model bias job definition.
     * </p>
     *
     * @param deleteModelBiasJobDefinitionRequest
     * @return A Java Future containing the result of the DeleteModelBiasJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteModelBiasJobDefinitionResponse> deleteModelBiasJobDefinition(
            DeleteModelBiasJobDefinitionRequest deleteModelBiasJobDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker AI model bias job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelBiasJobDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteModelBiasJobDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteModelBiasJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteModelBiasJobDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteModelBiasJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteModelBiasJobDefinitionResponse> deleteModelBiasJobDefinition(
            Consumer<DeleteModelBiasJobDefinitionRequest.Builder> deleteModelBiasJobDefinitionRequest) {
        return deleteModelBiasJobDefinition(DeleteModelBiasJobDefinitionRequest.builder()
                .applyMutation(deleteModelBiasJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker Model Card.
     * </p>
     *
     * @param deleteModelCardRequest
     * @return A Java Future containing the result of the DeleteModelCard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelCard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelCard" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteModelCardResponse> deleteModelCard(DeleteModelCardRequest deleteModelCardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker Model Card.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelCardRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteModelCardRequest#builder()}
     * </p>
     *
     * @param deleteModelCardRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteModelCardRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteModelCard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelCard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelCard" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteModelCardResponse> deleteModelCard(
            Consumer<DeleteModelCardRequest.Builder> deleteModelCardRequest) {
        return deleteModelCard(DeleteModelCardRequest.builder().applyMutation(deleteModelCardRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker AI model explainability job definition.
     * </p>
     *
     * @param deleteModelExplainabilityJobDefinitionRequest
     * @return A Java Future containing the result of the DeleteModelExplainabilityJobDefinition operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteModelExplainabilityJobDefinitionResponse> deleteModelExplainabilityJobDefinition(
            DeleteModelExplainabilityJobDefinitionRequest deleteModelExplainabilityJobDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon SageMaker AI model explainability job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteModelExplainabilityJobDefinitionRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteModelExplainabilityJobDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteModelExplainabilityJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteModelExplainabilityJobDefinitionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteModelExplainabilityJobDefinition operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteModelExplainabilityJobDefinitionResponse> deleteModelExplainabilityJobDefinition(
            Consumer<DeleteModelExplainabilityJobDefinitionRequest.Builder> deleteModelExplainabilityJobDefinitionRequest) {
        return deleteModelExplainabilityJobDefinition(DeleteModelExplainabilityJobDefinitionRequest.builder()
                .applyMutation(deleteModelExplainabilityJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Deletes a model package.
     * </p>
     * <p>
     * A model package is used to create SageMaker models or list on Amazon Web Services Marketplace. Buyers can
     * subscribe to model packages listed on Amazon Web Services Marketplace to create models in SageMaker.
     * </p>
     *
     * @param deleteModelPackageRequest
     * @return A Java Future containing the result of the DeleteModelPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteModelPackageResponse> deleteModelPackage(DeleteModelPackageRequest deleteModelPackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a model package.
     * </p>
     * <p>
     * A model package is used to create SageMaker models or list on Amazon Web Services Marketplace. Buyers can
     * subscribe to model packages listed on Amazon Web Services Marketplace to create models in SageMaker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelPackageRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteModelPackageRequest#builder()}
     * </p>
     *
     * @param deleteModelPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteModelPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteModelPackageResponse> deleteModelPackage(
            Consumer<DeleteModelPackageRequest.Builder> deleteModelPackageRequest) {
        return deleteModelPackage(DeleteModelPackageRequest.builder().applyMutation(deleteModelPackageRequest).build());
    }

    /**
     * <p>
     * Deletes the specified model group.
     * </p>
     *
     * @param deleteModelPackageGroupRequest
     * @return A Java Future containing the result of the DeleteModelPackageGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteModelPackageGroupResponse> deleteModelPackageGroup(
            DeleteModelPackageGroupRequest deleteModelPackageGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified model group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelPackageGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteModelPackageGroupRequest#builder()}
     * </p>
     *
     * @param deleteModelPackageGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteModelPackageGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteModelPackageGroupResponse> deleteModelPackageGroup(
            Consumer<DeleteModelPackageGroupRequest.Builder> deleteModelPackageGroupRequest) {
        return deleteModelPackageGroup(DeleteModelPackageGroupRequest.builder().applyMutation(deleteModelPackageGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a model group resource policy.
     * </p>
     *
     * @param deleteModelPackageGroupPolicyRequest
     * @return A Java Future containing the result of the DeleteModelPackageGroupPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelPackageGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackageGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteModelPackageGroupPolicyResponse> deleteModelPackageGroupPolicy(
            DeleteModelPackageGroupPolicyRequest deleteModelPackageGroupPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a model group resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelPackageGroupPolicyRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteModelPackageGroupPolicyRequest#builder()}
     * </p>
     *
     * @param deleteModelPackageGroupPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteModelPackageGroupPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteModelPackageGroupPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelPackageGroupPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelPackageGroupPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteModelPackageGroupPolicyResponse> deleteModelPackageGroupPolicy(
            Consumer<DeleteModelPackageGroupPolicyRequest.Builder> deleteModelPackageGroupPolicyRequest) {
        return deleteModelPackageGroupPolicy(DeleteModelPackageGroupPolicyRequest.builder()
                .applyMutation(deleteModelPackageGroupPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the secified model quality monitoring job definition.
     * </p>
     *
     * @param deleteModelQualityJobDefinitionRequest
     * @return A Java Future containing the result of the DeleteModelQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteModelQualityJobDefinitionResponse> deleteModelQualityJobDefinition(
            DeleteModelQualityJobDefinitionRequest deleteModelQualityJobDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the secified model quality monitoring job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelQualityJobDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteModelQualityJobDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteModelQualityJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteModelQualityJobDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteModelQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteModelQualityJobDefinitionResponse> deleteModelQualityJobDefinition(
            Consumer<DeleteModelQualityJobDefinitionRequest.Builder> deleteModelQualityJobDefinitionRequest) {
        return deleteModelQualityJobDefinition(DeleteModelQualityJobDefinitionRequest.builder()
                .applyMutation(deleteModelQualityJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Deletes a monitoring schedule. Also stops the schedule had not already been stopped. This does not delete the job
     * execution history of the monitoring schedule.
     * </p>
     *
     * @param deleteMonitoringScheduleRequest
     * @return A Java Future containing the result of the DeleteMonitoringSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMonitoringScheduleResponse> deleteMonitoringSchedule(
            DeleteMonitoringScheduleRequest deleteMonitoringScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a monitoring schedule. Also stops the schedule had not already been stopped. This does not delete the job
     * execution history of the monitoring schedule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMonitoringScheduleRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteMonitoringScheduleRequest#builder()}
     * </p>
     *
     * @param deleteMonitoringScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteMonitoringScheduleRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteMonitoringSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMonitoringScheduleResponse> deleteMonitoringSchedule(
            Consumer<DeleteMonitoringScheduleRequest.Builder> deleteMonitoringScheduleRequest) {
        return deleteMonitoringSchedule(DeleteMonitoringScheduleRequest.builder().applyMutation(deleteMonitoringScheduleRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an SageMaker AI notebook instance. Before you can delete a notebook instance, you must call the
     * <code>StopNotebookInstance</code> API.
     * </p>
     * <important>
     * <p>
     * When you delete a notebook instance, you lose all of your data. SageMaker AI removes the ML compute instance, and
     * deletes the ML storage volume and the network interface associated with the notebook instance.
     * </p>
     * </important>
     *
     * @param deleteNotebookInstanceRequest
     * @return A Java Future containing the result of the DeleteNotebookInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNotebookInstanceResponse> deleteNotebookInstance(
            DeleteNotebookInstanceRequest deleteNotebookInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an SageMaker AI notebook instance. Before you can delete a notebook instance, you must call the
     * <code>StopNotebookInstance</code> API.
     * </p>
     * <important>
     * <p>
     * When you delete a notebook instance, you lose all of your data. SageMaker AI removes the ML compute instance, and
     * deletes the ML storage volume and the network interface associated with the notebook instance.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNotebookInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteNotebookInstanceRequest#builder()}
     * </p>
     *
     * @param deleteNotebookInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteNotebookInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNotebookInstanceResponse> deleteNotebookInstance(
            Consumer<DeleteNotebookInstanceRequest.Builder> deleteNotebookInstanceRequest) {
        return deleteNotebookInstance(DeleteNotebookInstanceRequest.builder().applyMutation(deleteNotebookInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a notebook instance lifecycle configuration.
     * </p>
     *
     * @param deleteNotebookInstanceLifecycleConfigRequest
     * @return A Java Future containing the result of the DeleteNotebookInstanceLifecycleConfig operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteNotebookInstanceLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNotebookInstanceLifecycleConfigResponse> deleteNotebookInstanceLifecycleConfig(
            DeleteNotebookInstanceLifecycleConfigRequest deleteNotebookInstanceLifecycleConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a notebook instance lifecycle configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteNotebookInstanceLifecycleConfigRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteNotebookInstanceLifecycleConfigRequest#builder()}
     * </p>
     *
     * @param deleteNotebookInstanceLifecycleConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteNotebookInstanceLifecycleConfigRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteNotebookInstanceLifecycleConfig operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteNotebookInstanceLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNotebookInstanceLifecycleConfigResponse> deleteNotebookInstanceLifecycleConfig(
            Consumer<DeleteNotebookInstanceLifecycleConfigRequest.Builder> deleteNotebookInstanceLifecycleConfigRequest) {
        return deleteNotebookInstanceLifecycleConfig(DeleteNotebookInstanceLifecycleConfigRequest.builder()
                .applyMutation(deleteNotebookInstanceLifecycleConfigRequest).build());
    }

    /**
     * <p>
     * Deletes an optimization job.
     * </p>
     *
     * @param deleteOptimizationJobRequest
     * @return A Java Future containing the result of the DeleteOptimizationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteOptimizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteOptimizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOptimizationJobResponse> deleteOptimizationJob(
            DeleteOptimizationJobRequest deleteOptimizationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an optimization job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOptimizationJobRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteOptimizationJobRequest#builder()}
     * </p>
     *
     * @param deleteOptimizationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteOptimizationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteOptimizationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteOptimizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteOptimizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteOptimizationJobResponse> deleteOptimizationJob(
            Consumer<DeleteOptimizationJobRequest.Builder> deleteOptimizationJobRequest) {
        return deleteOptimizationJob(DeleteOptimizationJobRequest.builder().applyMutation(deleteOptimizationJobRequest).build());
    }

    /**
     * <p>
     * Deletes a SageMaker Partner AI App.
     * </p>
     *
     * @param deletePartnerAppRequest
     * @return A Java Future containing the result of the DeletePartnerApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeletePartnerApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeletePartnerApp" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePartnerAppResponse> deletePartnerApp(DeletePartnerAppRequest deletePartnerAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a SageMaker Partner AI App.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePartnerAppRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePartnerAppRequest#builder()}
     * </p>
     *
     * @param deletePartnerAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeletePartnerAppRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePartnerApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeletePartnerApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeletePartnerApp" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePartnerAppResponse> deletePartnerApp(
            Consumer<DeletePartnerAppRequest.Builder> deletePartnerAppRequest) {
        return deletePartnerApp(DeletePartnerAppRequest.builder().applyMutation(deletePartnerAppRequest).build());
    }

    /**
     * <p>
     * Deletes a pipeline if there are no running instances of the pipeline. To delete a pipeline, you must stop all
     * running instances of the pipeline using the <code>StopPipelineExecution</code> API. When you delete a pipeline,
     * all instances of the pipeline are deleted.
     * </p>
     *
     * @param deletePipelineRequest
     * @return A Java Future containing the result of the DeletePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeletePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeletePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePipelineResponse> deletePipeline(DeletePipelineRequest deletePipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a pipeline if there are no running instances of the pipeline. To delete a pipeline, you must stop all
     * running instances of the pipeline using the <code>StopPipelineExecution</code> API. When you delete a pipeline,
     * all instances of the pipeline are deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePipelineRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePipelineRequest#builder()}
     * </p>
     *
     * @param deletePipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeletePipelineRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeletePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeletePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeletePipeline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePipelineResponse> deletePipeline(Consumer<DeletePipelineRequest.Builder> deletePipelineRequest) {
        return deletePipeline(DeletePipelineRequest.builder().applyMutation(deletePipelineRequest).build());
    }

    /**
     * <p>
     * Deletes a processing job. After Amazon SageMaker deletes a processing job, all of the metadata for the processing
     * job is lost. You can delete only processing jobs that are in a terminal state (<code>Stopped</code>,
     * <code>Failed</code>, or <code>Completed</code>). You cannot delete a job that is in the <code>InProgress</code>
     * or <code>Stopping</code> state. After deleting the job, you can reuse its name to create another processing job.
     * </p>
     *
     * @param deleteProcessingJobRequest
     * @return A Java Future containing the result of the DeleteProcessingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteProcessingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteProcessingJobResponse> deleteProcessingJob(
            DeleteProcessingJobRequest deleteProcessingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a processing job. After Amazon SageMaker deletes a processing job, all of the metadata for the processing
     * job is lost. You can delete only processing jobs that are in a terminal state (<code>Stopped</code>,
     * <code>Failed</code>, or <code>Completed</code>). You cannot delete a job that is in the <code>InProgress</code>
     * or <code>Stopping</code> state. After deleting the job, you can reuse its name to create another processing job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProcessingJobRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteProcessingJobRequest#builder()}
     * </p>
     *
     * @param deleteProcessingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteProcessingJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteProcessingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteProcessingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteProcessingJobResponse> deleteProcessingJob(
            Consumer<DeleteProcessingJobRequest.Builder> deleteProcessingJobRequest) {
        return deleteProcessingJob(DeleteProcessingJobRequest.builder().applyMutation(deleteProcessingJobRequest).build());
    }

    /**
     * <p>
     * Delete the specified project.
     * </p>
     *
     * @param deleteProjectRequest
     * @return A Java Future containing the result of the DeleteProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProjectResponse> deleteProject(DeleteProjectRequest deleteProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete the specified project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProjectRequest#builder()}
     * </p>
     *
     * @param deleteProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteProjectRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException There was a conflict when you attempted to modify a SageMaker entity such as an
     *         <code>Experiment</code> or <code>Artifact</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteProjectResponse> deleteProject(Consumer<DeleteProjectRequest.Builder> deleteProjectRequest) {
        return deleteProject(DeleteProjectRequest.builder().applyMutation(deleteProjectRequest).build());
    }

    /**
     * <p>
     * Used to delete a space.
     * </p>
     *
     * @param deleteSpaceRequest
     * @return A Java Future containing the result of the DeleteSpace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteSpace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSpaceResponse> deleteSpace(DeleteSpaceRequest deleteSpaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to delete a space.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSpaceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteSpaceRequest#builder()}
     * </p>
     *
     * @param deleteSpaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteSpaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteSpace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteSpace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSpaceResponse> deleteSpace(Consumer<DeleteSpaceRequest.Builder> deleteSpaceRequest) {
        return deleteSpace(DeleteSpaceRequest.builder().applyMutation(deleteSpaceRequest).build());
    }

    /**
     * <p>
     * Deletes the Amazon SageMaker AI Studio Lifecycle Configuration. In order to delete the Lifecycle Configuration,
     * there must be no running apps using the Lifecycle Configuration. You must also remove the Lifecycle Configuration
     * from UserSettings in all Domains and UserProfiles.
     * </p>
     *
     * @param deleteStudioLifecycleConfigRequest
     * @return A Java Future containing the result of the DeleteStudioLifecycleConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStudioLifecycleConfigResponse> deleteStudioLifecycleConfig(
            DeleteStudioLifecycleConfigRequest deleteStudioLifecycleConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the Amazon SageMaker AI Studio Lifecycle Configuration. In order to delete the Lifecycle Configuration,
     * there must be no running apps using the Lifecycle Configuration. You must also remove the Lifecycle Configuration
     * from UserSettings in all Domains and UserProfiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStudioLifecycleConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteStudioLifecycleConfigRequest#builder()}
     * </p>
     *
     * @param deleteStudioLifecycleConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteStudioLifecycleConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteStudioLifecycleConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteStudioLifecycleConfigResponse> deleteStudioLifecycleConfig(
            Consumer<DeleteStudioLifecycleConfigRequest.Builder> deleteStudioLifecycleConfigRequest) {
        return deleteStudioLifecycleConfig(DeleteStudioLifecycleConfigRequest.builder()
                .applyMutation(deleteStudioLifecycleConfigRequest).build());
    }

    /**
     * <p>
     * Deletes the specified tags from an SageMaker resource.
     * </p>
     * <p>
     * To list a resource's tags, use the <code>ListTags</code> API.
     * </p>
     * <note>
     * <p>
     * When you call this API to delete tags from a hyperparameter tuning job, the deleted tags are not removed from
     * training jobs that the hyperparameter tuning job launched before you called this API.
     * </p>
     * </note> <note>
     * <p>
     * When you call this API to delete tags from a SageMaker Domain or User Profile, the deleted tags are not removed
     * from Apps that the SageMaker Domain or User Profile launched before you called this API.
     * </p>
     * </note>
     *
     * @param deleteTagsRequest
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTagsResponse> deleteTags(DeleteTagsRequest deleteTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified tags from an SageMaker resource.
     * </p>
     * <p>
     * To list a resource's tags, use the <code>ListTags</code> API.
     * </p>
     * <note>
     * <p>
     * When you call this API to delete tags from a hyperparameter tuning job, the deleted tags are not removed from
     * training jobs that the hyperparameter tuning job launched before you called this API.
     * </p>
     * </note> <note>
     * <p>
     * When you call this API to delete tags from a SageMaker Domain or User Profile, the deleted tags are not removed
     * from Apps that the SageMaker Domain or User Profile launched before you called this API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTagsRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTagsRequest#builder()}
     * </p>
     *
     * @param deleteTagsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteTagsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTagsResponse> deleteTags(Consumer<DeleteTagsRequest.Builder> deleteTagsRequest) {
        return deleteTags(DeleteTagsRequest.builder().applyMutation(deleteTagsRequest).build());
    }

    /**
     * <p>
     * Deletes a training job. After SageMaker deletes a training job, all of the metadata for the training job is lost.
     * You can delete only training jobs that are in a terminal state (<code>Stopped</code>, <code>Failed</code>, or
     * <code>Completed</code>) and don't retain an <code>Available</code> <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-warm-pools.html">managed warm pool</a>. You cannot
     * delete a job that is in the <code>InProgress</code> or <code>Stopping</code> state. After deleting the job, you
     * can reuse its name to create another training job.
     * </p>
     *
     * @param deleteTrainingJobRequest
     * @return A Java Future containing the result of the DeleteTrainingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrainingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTrainingJobResponse> deleteTrainingJob(DeleteTrainingJobRequest deleteTrainingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a training job. After SageMaker deletes a training job, all of the metadata for the training job is lost.
     * You can delete only training jobs that are in a terminal state (<code>Stopped</code>, <code>Failed</code>, or
     * <code>Completed</code>) and don't retain an <code>Available</code> <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/train-warm-pools.html">managed warm pool</a>. You cannot
     * delete a job that is in the <code>InProgress</code> or <code>Stopping</code> state. After deleting the job, you
     * can reuse its name to create another training job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrainingJobRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTrainingJobRequest#builder()}
     * </p>
     *
     * @param deleteTrainingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteTrainingJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTrainingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrainingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTrainingJobResponse> deleteTrainingJob(
            Consumer<DeleteTrainingJobRequest.Builder> deleteTrainingJobRequest) {
        return deleteTrainingJob(DeleteTrainingJobRequest.builder().applyMutation(deleteTrainingJobRequest).build());
    }

    /**
     * <p>
     * Deletes the specified trial. All trial components that make up the trial must be deleted first. Use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrialComponent.html"
     * >DescribeTrialComponent</a> API to get the list of trial components.
     * </p>
     *
     * @param deleteTrialRequest
     * @return A Java Future containing the result of the DeleteTrial operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrial" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTrialResponse> deleteTrial(DeleteTrialRequest deleteTrialRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified trial. All trial components that make up the trial must be deleted first. Use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DescribeTrialComponent.html"
     * >DescribeTrialComponent</a> API to get the list of trial components.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrialRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTrialRequest#builder()}
     * </p>
     *
     * @param deleteTrialRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteTrialRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTrial operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrial" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTrialResponse> deleteTrial(Consumer<DeleteTrialRequest.Builder> deleteTrialRequest) {
        return deleteTrial(DeleteTrialRequest.builder().applyMutation(deleteTrialRequest).build());
    }

    /**
     * <p>
     * Deletes the specified trial component. A trial component must be disassociated from all trials before the trial
     * component can be deleted. To disassociate a trial component from a trial, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DisassociateTrialComponent.html"
     * >DisassociateTrialComponent</a> API.
     * </p>
     *
     * @param deleteTrialComponentRequest
     * @return A Java Future containing the result of the DeleteTrialComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrialComponentResponse> deleteTrialComponent(
            DeleteTrialComponentRequest deleteTrialComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified trial component. A trial component must be disassociated from all trials before the trial
     * component can be deleted. To disassociate a trial component from a trial, call the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DisassociateTrialComponent.html"
     * >DisassociateTrialComponent</a> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrialComponentRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTrialComponentRequest#builder()}
     * </p>
     *
     * @param deleteTrialComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteTrialComponentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTrialComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrialComponentResponse> deleteTrialComponent(
            Consumer<DeleteTrialComponentRequest.Builder> deleteTrialComponentRequest) {
        return deleteTrialComponent(DeleteTrialComponentRequest.builder().applyMutation(deleteTrialComponentRequest).build());
    }

    /**
     * <p>
     * Deletes a user profile. When a user profile is deleted, the user loses access to their EFS volume, including
     * data, notebooks, and other artifacts.
     * </p>
     *
     * @param deleteUserProfileRequest
     * @return A Java Future containing the result of the DeleteUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteUserProfileResponse> deleteUserProfile(DeleteUserProfileRequest deleteUserProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user profile. When a user profile is deleted, the user loses access to their EFS volume, including
     * data, notebooks, and other artifacts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserProfileRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteUserProfileRequest#builder()}
     * </p>
     *
     * @param deleteUserProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteUserProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceInUseException Resource being accessed is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteUserProfileResponse> deleteUserProfile(
            Consumer<DeleteUserProfileRequest.Builder> deleteUserProfileRequest) {
        return deleteUserProfile(DeleteUserProfileRequest.builder().applyMutation(deleteUserProfileRequest).build());
    }

    /**
     * <p>
     * Use this operation to delete a workforce.
     * </p>
     * <p>
     * If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use this
     * operation to delete the existing workforce and then use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateWorkforce.html">CreateWorkforce</a> to
     * create a new workforce.
     * </p>
     * <important>
     * <p>
     * If a private workforce contains one or more work teams, you must use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteWorkteam.html">DeleteWorkteam</a>
     * operation to delete all work teams before you delete the workforce. If you try to delete a workforce that
     * contains one or more work teams, you will receive a <code>ResourceInUse</code> error.
     * </p>
     * </important>
     *
     * @param deleteWorkforceRequest
     * @return A Java Future containing the result of the DeleteWorkforce operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkforce" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkforceResponse> deleteWorkforce(DeleteWorkforceRequest deleteWorkforceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to delete a workforce.
     * </p>
     * <p>
     * If you want to create a new workforce in an Amazon Web Services Region where a workforce already exists, use this
     * operation to delete the existing workforce and then use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateWorkforce.html">CreateWorkforce</a> to
     * create a new workforce.
     * </p>
     * <important>
     * <p>
     * If a private workforce contains one or more work teams, you must use the <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_DeleteWorkteam.html">DeleteWorkteam</a>
     * operation to delete all work teams before you delete the workforce. If you try to delete a workforce that
     * contains one or more work teams, you will receive a <code>ResourceInUse</code> error.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkforceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteWorkforceRequest#builder()}
     * </p>
     *
     * @param deleteWorkforceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteWorkforceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWorkforce operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkforce" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkforceResponse> deleteWorkforce(
            Consumer<DeleteWorkforceRequest.Builder> deleteWorkforceRequest) {
        return deleteWorkforce(DeleteWorkforceRequest.builder().applyMutation(deleteWorkforceRequest).build());
    }

    /**
     * <p>
     * Deletes an existing work team. This operation can't be undone.
     * </p>
     *
     * @param deleteWorkteamRequest
     * @return A Java Future containing the result of the DeleteWorkteam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkteamResponse> deleteWorkteam(DeleteWorkteamRequest deleteWorkteamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing work team. This operation can't be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkteamRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWorkteamRequest#builder()}
     * </p>
     *
     * @param deleteWorkteamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeleteWorkteamRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteWorkteam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeleteWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeleteWorkteam" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkteamResponse> deleteWorkteam(Consumer<DeleteWorkteamRequest.Builder> deleteWorkteamRequest) {
        return deleteWorkteam(DeleteWorkteamRequest.builder().applyMutation(deleteWorkteamRequest).build());
    }

    /**
     * <p>
     * Deregisters the specified devices. After you deregister a device, you will need to re-register the devices.
     * </p>
     *
     * @param deregisterDevicesRequest
     * @return A Java Future containing the result of the DeregisterDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeregisterDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeregisterDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterDevicesResponse> deregisterDevices(DeregisterDevicesRequest deregisterDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters the specified devices. After you deregister a device, you will need to re-register the devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterDevicesRequest.Builder} avoiding the need
     * to create one manually via {@link DeregisterDevicesRequest#builder()}
     * </p>
     *
     * @param deregisterDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DeregisterDevicesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeregisterDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DeregisterDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DeregisterDevices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterDevicesResponse> deregisterDevices(
            Consumer<DeregisterDevicesRequest.Builder> deregisterDevicesRequest) {
        return deregisterDevices(DeregisterDevicesRequest.builder().applyMutation(deregisterDevicesRequest).build());
    }

    /**
     * <p>
     * Describes an action.
     * </p>
     *
     * @param describeActionRequest
     * @return A Java Future containing the result of the DescribeAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeActionResponse> describeAction(DescribeActionRequest describeActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActionRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeActionRequest#builder()}
     * </p>
     *
     * @param describeActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeActionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeActionResponse> describeAction(Consumer<DescribeActionRequest.Builder> describeActionRequest) {
        return describeAction(DescribeActionRequest.builder().applyMutation(describeActionRequest).build());
    }

    /**
     * <p>
     * Returns a description of the specified algorithm that is in your account.
     * </p>
     *
     * @param describeAlgorithmRequest
     * @return A Java Future containing the result of the DescribeAlgorithm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAlgorithm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAlgorithmResponse> describeAlgorithm(DescribeAlgorithmRequest describeAlgorithmRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of the specified algorithm that is in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAlgorithmRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAlgorithmRequest#builder()}
     * </p>
     *
     * @param describeAlgorithmRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeAlgorithmRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAlgorithm operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeAlgorithm
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAlgorithm" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAlgorithmResponse> describeAlgorithm(
            Consumer<DescribeAlgorithmRequest.Builder> describeAlgorithmRequest) {
        return describeAlgorithm(DescribeAlgorithmRequest.builder().applyMutation(describeAlgorithmRequest).build());
    }

    /**
     * <p>
     * Describes the app.
     * </p>
     *
     * @param describeAppRequest
     * @return A Java Future containing the result of the DescribeApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAppResponse> describeApp(DescribeAppRequest describeAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAppRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAppRequest#builder()}
     * </p>
     *
     * @param describeAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeAppRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAppResponse> describeApp(Consumer<DescribeAppRequest.Builder> describeAppRequest) {
        return describeApp(DescribeAppRequest.builder().applyMutation(describeAppRequest).build());
    }

    /**
     * <p>
     * Describes an AppImageConfig.
     * </p>
     *
     * @param describeAppImageConfigRequest
     * @return A Java Future containing the result of the DescribeAppImageConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAppImageConfigResponse> describeAppImageConfig(
            DescribeAppImageConfigRequest describeAppImageConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an AppImageConfig.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAppImageConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAppImageConfigRequest#builder()}
     * </p>
     *
     * @param describeAppImageConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeAppImageConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAppImageConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeAppImageConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAppImageConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAppImageConfigResponse> describeAppImageConfig(
            Consumer<DescribeAppImageConfigRequest.Builder> describeAppImageConfigRequest) {
        return describeAppImageConfig(DescribeAppImageConfigRequest.builder().applyMutation(describeAppImageConfigRequest)
                .build());
    }

    /**
     * <p>
     * Describes an artifact.
     * </p>
     *
     * @param describeArtifactRequest
     * @return A Java Future containing the result of the DescribeArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeArtifact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeArtifactResponse> describeArtifact(DescribeArtifactRequest describeArtifactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an artifact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeArtifactRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeArtifactRequest#builder()}
     * </p>
     *
     * @param describeArtifactRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeArtifactRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeArtifact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeArtifact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeArtifact" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeArtifactResponse> describeArtifact(
            Consumer<DescribeArtifactRequest.Builder> describeArtifactRequest) {
        return describeArtifact(DescribeArtifactRequest.builder().applyMutation(describeArtifactRequest).build());
    }

    /**
     * <p>
     * Returns information about an AutoML job created by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html">CreateAutoMLJob</a>.
     * </p>
     * <note>
     * <p>
     * AutoML jobs created by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>
     * cannot be described by <code>DescribeAutoMLJob</code>.
     * </p>
     * </note>
     *
     * @param describeAutoMlJobRequest
     * @return A Java Future containing the result of the DescribeAutoMLJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAutoMLJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAutoMlJobResponse> describeAutoMLJob(DescribeAutoMlJobRequest describeAutoMlJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an AutoML job created by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html">CreateAutoMLJob</a>.
     * </p>
     * <note>
     * <p>
     * AutoML jobs created by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>
     * cannot be described by <code>DescribeAutoMLJob</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutoMlJobRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAutoMlJobRequest#builder()}
     * </p>
     *
     * @param describeAutoMlJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAutoMLJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeAutoMLJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAutoMLJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAutoMlJobResponse> describeAutoMLJob(
            Consumer<DescribeAutoMlJobRequest.Builder> describeAutoMlJobRequest) {
        return describeAutoMLJob(DescribeAutoMlJobRequest.builder().applyMutation(describeAutoMlJobRequest).build());
    }

    /**
     * <p>
     * Returns information about an AutoML job created by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>
     * or <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html">CreateAutoMLJob</a>.
     * </p>
     *
     * @param describeAutoMlJobV2Request
     * @return A Java Future containing the result of the DescribeAutoMLJobV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeAutoMLJobV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAutoMLJobV2" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAutoMlJobV2Response> describeAutoMLJobV2(
            DescribeAutoMlJobV2Request describeAutoMlJobV2Request) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an AutoML job created by calling <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJobV2.html">CreateAutoMLJobV2</a>
     * or <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateAutoMLJob.html">CreateAutoMLJob</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutoMlJobV2Request.Builder} avoiding the
     * need to create one manually via {@link DescribeAutoMlJobV2Request#builder()}
     * </p>
     *
     * @param describeAutoMlJobV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeAutoMlJobV2Request.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAutoMLJobV2 operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeAutoMLJobV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeAutoMLJobV2" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAutoMlJobV2Response> describeAutoMLJobV2(
            Consumer<DescribeAutoMlJobV2Request.Builder> describeAutoMlJobV2Request) {
        return describeAutoMLJobV2(DescribeAutoMlJobV2Request.builder().applyMutation(describeAutoMlJobV2Request).build());
    }

    /**
     * <p>
     * Retrieves information of a SageMaker HyperPod cluster.
     * </p>
     *
     * @param describeClusterRequest
     * @return A Java Future containing the result of the DescribeCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeClusterResponse> describeCluster(DescribeClusterRequest describeClusterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information of a SageMaker HyperPod cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeClusterRequest#builder()}
     * </p>
     *
     * @param describeClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeClusterRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeClusterResponse> describeCluster(
            Consumer<DescribeClusterRequest.Builder> describeClusterRequest) {
        return describeCluster(DescribeClusterRequest.builder().applyMutation(describeClusterRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specific event for a given HyperPod cluster. This functionality is only
     * supported when the <code>NodeProvisioningMode</code> is set to <code>Continuous</code>.
     * </p>
     *
     * @param describeClusterEventRequest
     * @return A Java Future containing the result of the DescribeClusterEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeClusterEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeClusterEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterEventResponse> describeClusterEvent(
            DescribeClusterEventRequest describeClusterEventRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specific event for a given HyperPod cluster. This functionality is only
     * supported when the <code>NodeProvisioningMode</code> is set to <code>Continuous</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterEventRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeClusterEventRequest#builder()}
     * </p>
     *
     * @param describeClusterEventRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeClusterEventRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeClusterEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeClusterEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeClusterEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterEventResponse> describeClusterEvent(
            Consumer<DescribeClusterEventRequest.Builder> describeClusterEventRequest) {
        return describeClusterEvent(DescribeClusterEventRequest.builder().applyMutation(describeClusterEventRequest).build());
    }

    /**
     * <p>
     * Retrieves information of a node (also called a <i>instance</i> interchangeably) of a SageMaker HyperPod cluster.
     * </p>
     *
     * @param describeClusterNodeRequest
     * @return A Java Future containing the result of the DescribeClusterNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeClusterNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeClusterNode" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeClusterNodeResponse> describeClusterNode(
            DescribeClusterNodeRequest describeClusterNodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information of a node (also called a <i>instance</i> interchangeably) of a SageMaker HyperPod cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterNodeRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeClusterNodeRequest#builder()}
     * </p>
     *
     * @param describeClusterNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeClusterNodeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeClusterNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeClusterNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeClusterNode" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeClusterNodeResponse> describeClusterNode(
            Consumer<DescribeClusterNodeRequest.Builder> describeClusterNodeRequest) {
        return describeClusterNode(DescribeClusterNodeRequest.builder().applyMutation(describeClusterNodeRequest).build());
    }

    /**
     * <p>
     * Description of the cluster policy. This policy is used for task prioritization and fair-share allocation. This
     * helps prioritize critical workloads and distributes idle compute across entities.
     * </p>
     *
     * @param describeClusterSchedulerConfigRequest
     * @return A Java Future containing the result of the DescribeClusterSchedulerConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeClusterSchedulerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeClusterSchedulerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterSchedulerConfigResponse> describeClusterSchedulerConfig(
            DescribeClusterSchedulerConfigRequest describeClusterSchedulerConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Description of the cluster policy. This policy is used for task prioritization and fair-share allocation. This
     * helps prioritize critical workloads and distributes idle compute across entities.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeClusterSchedulerConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeClusterSchedulerConfigRequest#builder()}
     * </p>
     *
     * @param describeClusterSchedulerConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeClusterSchedulerConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeClusterSchedulerConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeClusterSchedulerConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeClusterSchedulerConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeClusterSchedulerConfigResponse> describeClusterSchedulerConfig(
            Consumer<DescribeClusterSchedulerConfigRequest.Builder> describeClusterSchedulerConfigRequest) {
        return describeClusterSchedulerConfig(DescribeClusterSchedulerConfigRequest.builder()
                .applyMutation(describeClusterSchedulerConfigRequest).build());
    }

    /**
     * <p>
     * Gets details about the specified Git repository.
     * </p>
     *
     * @param describeCodeRepositoryRequest
     * @return A Java Future containing the result of the DescribeCodeRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCodeRepositoryResponse> describeCodeRepository(
            DescribeCodeRepositoryRequest describeCodeRepositoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about the specified Git repository.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCodeRepositoryRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCodeRepositoryRequest#builder()}
     * </p>
     *
     * @param describeCodeRepositoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeCodeRepositoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeCodeRepository operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeCodeRepository
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCodeRepository"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCodeRepositoryResponse> describeCodeRepository(
            Consumer<DescribeCodeRepositoryRequest.Builder> describeCodeRepositoryRequest) {
        return describeCodeRepository(DescribeCodeRepositoryRequest.builder().applyMutation(describeCodeRepositoryRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about a model compilation job.
     * </p>
     * <p>
     * To create a model compilation job, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateCompilationJob.html"
     * >CreateCompilationJob</a>. To get information about multiple model compilation jobs, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListCompilationJobs.html"
     * >ListCompilationJobs</a>.
     * </p>
     *
     * @param describeCompilationJobRequest
     * @return A Java Future containing the result of the DescribeCompilationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeCompilationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCompilationJobResponse> describeCompilationJob(
            DescribeCompilationJobRequest describeCompilationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a model compilation job.
     * </p>
     * <p>
     * To create a model compilation job, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateCompilationJob.html"
     * >CreateCompilationJob</a>. To get information about multiple model compilation jobs, use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_ListCompilationJobs.html"
     * >ListCompilationJobs</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCompilationJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCompilationJobRequest#builder()}
     * </p>
     *
     * @param describeCompilationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeCompilationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeCompilationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeCompilationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeCompilationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeCompilationJobResponse> describeCompilationJob(
            Consumer<DescribeCompilationJobRequest.Builder> describeCompilationJobRequest) {
        return describeCompilationJob(DescribeCompilationJobRequest.builder().applyMutation(describeCompilationJobRequest)
                .build());
    }

    /**
     * <p>
     * Description of the compute allocation definition.
     * </p>
     *
     * @param describeComputeQuotaRequest
     * @return A Java Future containing the result of the DescribeComputeQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeComputeQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeComputeQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeComputeQuotaResponse> describeComputeQuota(
            DescribeComputeQuotaRequest describeComputeQuotaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Description of the compute allocation definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeComputeQuotaRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeComputeQuotaRequest#builder()}
     * </p>
     *
     * @param describeComputeQuotaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeComputeQuotaRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeComputeQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeComputeQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeComputeQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeComputeQuotaResponse> describeComputeQuota(
            Consumer<DescribeComputeQuotaRequest.Builder> describeComputeQuotaRequest) {
        return describeComputeQuota(DescribeComputeQuotaRequest.builder().applyMutation(describeComputeQuotaRequest).build());
    }

    /**
     * <p>
     * Describes a context.
     * </p>
     *
     * @param describeContextRequest
     * @return A Java Future containing the result of the DescribeContext operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeContext" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeContextResponse> describeContext(DescribeContextRequest describeContextRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a context.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContextRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeContextRequest#builder()}
     * </p>
     *
     * @param describeContextRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeContextRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeContext operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeContext
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeContext" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeContextResponse> describeContext(
            Consumer<DescribeContextRequest.Builder> describeContextRequest) {
        return describeContext(DescribeContextRequest.builder().applyMutation(describeContextRequest).build());
    }

    /**
     * <p>
     * Gets the details of a data quality monitoring job definition.
     * </p>
     *
     * @param describeDataQualityJobDefinitionRequest
     * @return A Java Future containing the result of the DescribeDataQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDataQualityJobDefinitionResponse> describeDataQualityJobDefinition(
            DescribeDataQualityJobDefinitionRequest describeDataQualityJobDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of a data quality monitoring job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataQualityJobDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDataQualityJobDefinitionRequest#builder()}
     * </p>
     *
     * @param describeDataQualityJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeDataQualityJobDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeDataQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeDataQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDataQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDataQualityJobDefinitionResponse> describeDataQualityJobDefinition(
            Consumer<DescribeDataQualityJobDefinitionRequest.Builder> describeDataQualityJobDefinitionRequest) {
        return describeDataQualityJobDefinition(DescribeDataQualityJobDefinitionRequest.builder()
                .applyMutation(describeDataQualityJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Describes the device.
     * </p>
     *
     * @param describeDeviceRequest
     * @return A Java Future containing the result of the DescribeDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDeviceResponse> describeDevice(DescribeDeviceRequest describeDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeDeviceRequest#builder()}
     * </p>
     *
     * @param describeDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeDeviceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDevice" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDeviceResponse> describeDevice(Consumer<DescribeDeviceRequest.Builder> describeDeviceRequest) {
        return describeDevice(DescribeDeviceRequest.builder().applyMutation(describeDeviceRequest).build());
    }

    /**
     * <p>
     * A description of the fleet the device belongs to.
     * </p>
     *
     * @param describeDeviceFleetRequest
     * @return A Java Future containing the result of the DescribeDeviceFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDeviceFleetResponse> describeDeviceFleet(
            DescribeDeviceFleetRequest describeDeviceFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A description of the fleet the device belongs to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeviceFleetRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDeviceFleetRequest#builder()}
     * </p>
     *
     * @param describeDeviceFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeDeviceFleetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDeviceFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeDeviceFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDeviceFleet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDeviceFleetResponse> describeDeviceFleet(
            Consumer<DescribeDeviceFleetRequest.Builder> describeDeviceFleetRequest) {
        return describeDeviceFleet(DescribeDeviceFleetRequest.builder().applyMutation(describeDeviceFleetRequest).build());
    }

    /**
     * <p>
     * The description of the domain.
     * </p>
     *
     * @param describeDomainRequest
     * @return A Java Future containing the result of the DescribeDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDomainResponse> describeDomain(DescribeDomainRequest describeDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The description of the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeDomainRequest#builder()}
     * </p>
     *
     * @param describeDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDomainResponse> describeDomain(Consumer<DescribeDomainRequest.Builder> describeDomainRequest) {
        return describeDomain(DescribeDomainRequest.builder().applyMutation(describeDomainRequest).build());
    }

    /**
     * <p>
     * Describes an edge deployment plan with deployment status per stage.
     * </p>
     *
     * @param describeEdgeDeploymentPlanRequest
     * @return A Java Future containing the result of the DescribeEdgeDeploymentPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEdgeDeploymentPlanResponse> describeEdgeDeploymentPlan(
            DescribeEdgeDeploymentPlanRequest describeEdgeDeploymentPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an edge deployment plan with deployment status per stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEdgeDeploymentPlanRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEdgeDeploymentPlanRequest#builder()}
     * </p>
     *
     * @param describeEdgeDeploymentPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeEdgeDeploymentPlanRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeEdgeDeploymentPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeEdgeDeploymentPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEdgeDeploymentPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEdgeDeploymentPlanResponse> describeEdgeDeploymentPlan(
            Consumer<DescribeEdgeDeploymentPlanRequest.Builder> describeEdgeDeploymentPlanRequest) {
        return describeEdgeDeploymentPlan(DescribeEdgeDeploymentPlanRequest.builder()
                .applyMutation(describeEdgeDeploymentPlanRequest).build());
    }

    /**
     * <p>
     * A description of edge packaging jobs.
     * </p>
     *
     * @param describeEdgePackagingJobRequest
     * @return A Java Future containing the result of the DescribeEdgePackagingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeEdgePackagingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEdgePackagingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEdgePackagingJobResponse> describeEdgePackagingJob(
            DescribeEdgePackagingJobRequest describeEdgePackagingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A description of edge packaging jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEdgePackagingJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEdgePackagingJobRequest#builder()}
     * </p>
     *
     * @param describeEdgePackagingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeEdgePackagingJobRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeEdgePackagingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeEdgePackagingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEdgePackagingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEdgePackagingJobResponse> describeEdgePackagingJob(
            Consumer<DescribeEdgePackagingJobRequest.Builder> describeEdgePackagingJobRequest) {
        return describeEdgePackagingJob(DescribeEdgePackagingJobRequest.builder().applyMutation(describeEdgePackagingJobRequest)
                .build());
    }

    /**
     * <p>
     * Returns the description of an endpoint.
     * </p>
     *
     * @param describeEndpointRequest
     * @return A Java Future containing the result of the DescribeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointResponse> describeEndpoint(DescribeEndpointRequest describeEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointRequest#builder()}
     * </p>
     *
     * @param describeEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointResponse> describeEndpoint(
            Consumer<DescribeEndpointRequest.Builder> describeEndpointRequest) {
        return describeEndpoint(DescribeEndpointRequest.builder().applyMutation(describeEndpointRequest).build());
    }

    /**
     * <p>
     * Returns the description of an endpoint configuration created using the <code>CreateEndpointConfig</code> API.
     * </p>
     *
     * @param describeEndpointConfigRequest
     * @return A Java Future containing the result of the DescribeEndpointConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointConfigResponse> describeEndpointConfig(
            DescribeEndpointConfigRequest describeEndpointConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description of an endpoint configuration created using the <code>CreateEndpointConfig</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEndpointConfigRequest#builder()}
     * </p>
     *
     * @param describeEndpointConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEndpointConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeEndpointConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeEndpointConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointConfigResponse> describeEndpointConfig(
            Consumer<DescribeEndpointConfigRequest.Builder> describeEndpointConfigRequest) {
        return describeEndpointConfig(DescribeEndpointConfigRequest.builder().applyMutation(describeEndpointConfigRequest)
                .build());
    }

    /**
     * <p>
     * Provides a list of an experiment's properties.
     * </p>
     *
     * @param describeExperimentRequest
     * @return A Java Future containing the result of the DescribeExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeExperimentResponse> describeExperiment(DescribeExperimentRequest describeExperimentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of an experiment's properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExperimentRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeExperimentRequest#builder()}
     * </p>
     *
     * @param describeExperimentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeExperimentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeExperiment" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeExperimentResponse> describeExperiment(
            Consumer<DescribeExperimentRequest.Builder> describeExperimentRequest) {
        return describeExperiment(DescribeExperimentRequest.builder().applyMutation(describeExperimentRequest).build());
    }

    /**
     * <p>
     * Use this operation to describe a <code>FeatureGroup</code>. The response includes information on the creation
     * time, <code>FeatureGroup</code> name, the unique identifier for each <code>FeatureGroup</code>, and more.
     * </p>
     *
     * @param describeFeatureGroupRequest
     * @return A Java Future containing the result of the DescribeFeatureGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFeatureGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFeatureGroupResponse> describeFeatureGroup(
            DescribeFeatureGroupRequest describeFeatureGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this operation to describe a <code>FeatureGroup</code>. The response includes information on the creation
     * time, <code>FeatureGroup</code> name, the unique identifier for each <code>FeatureGroup</code>, and more.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFeatureGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFeatureGroupRequest#builder()}
     * </p>
     *
     * @param describeFeatureGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeFeatureGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeFeatureGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFeatureGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFeatureGroupResponse> describeFeatureGroup(
            Consumer<DescribeFeatureGroupRequest.Builder> describeFeatureGroupRequest) {
        return describeFeatureGroup(DescribeFeatureGroupRequest.builder().applyMutation(describeFeatureGroupRequest).build());
    }

    /**
     * <p>
     * Shows the metadata for a feature within a feature group.
     * </p>
     *
     * @param describeFeatureMetadataRequest
     * @return A Java Future containing the result of the DescribeFeatureMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeFeatureMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFeatureMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFeatureMetadataResponse> describeFeatureMetadata(
            DescribeFeatureMetadataRequest describeFeatureMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Shows the metadata for a feature within a feature group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFeatureMetadataRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeFeatureMetadataRequest#builder()}
     * </p>
     *
     * @param describeFeatureMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeFeatureMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeFeatureMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeFeatureMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFeatureMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFeatureMetadataResponse> describeFeatureMetadata(
            Consumer<DescribeFeatureMetadataRequest.Builder> describeFeatureMetadataRequest) {
        return describeFeatureMetadata(DescribeFeatureMetadataRequest.builder().applyMutation(describeFeatureMetadataRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the specified flow definition.
     * </p>
     *
     * @param describeFlowDefinitionRequest
     * @return A Java Future containing the result of the DescribeFlowDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFlowDefinitionResponse> describeFlowDefinition(
            DescribeFlowDefinitionRequest describeFlowDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified flow definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFlowDefinitionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFlowDefinitionRequest#builder()}
     * </p>
     *
     * @param describeFlowDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeFlowDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeFlowDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeFlowDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFlowDefinitionResponse> describeFlowDefinition(
            Consumer<DescribeFlowDefinitionRequest.Builder> describeFlowDefinitionRequest) {
        return describeFlowDefinition(DescribeFlowDefinitionRequest.builder().applyMutation(describeFlowDefinitionRequest)
                .build());
    }

    /**
     * <p>
     * Describes a hub.
     * </p>
     *
     * @param describeHubRequest
     * @return A Java Future containing the result of the DescribeHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHub" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeHubResponse> describeHub(DescribeHubRequest describeHubRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHubRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeHubRequest#builder()}
     * </p>
     *
     * @param describeHubRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeHubRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeHub operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHub" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeHubResponse> describeHub(Consumer<DescribeHubRequest.Builder> describeHubRequest) {
        return describeHub(DescribeHubRequest.builder().applyMutation(describeHubRequest).build());
    }

    /**
     * <p>
     * Describe the content of a hub.
     * </p>
     *
     * @param describeHubContentRequest
     * @return A Java Future containing the result of the DescribeHubContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeHubContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHubContent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeHubContentResponse> describeHubContent(DescribeHubContentRequest describeHubContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe the content of a hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHubContentRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeHubContentRequest#builder()}
     * </p>
     *
     * @param describeHubContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeHubContentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeHubContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeHubContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHubContent" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeHubContentResponse> describeHubContent(
            Consumer<DescribeHubContentRequest.Builder> describeHubContentRequest) {
        return describeHubContent(DescribeHubContentRequest.builder().applyMutation(describeHubContentRequest).build());
    }

    /**
     * <p>
     * Returns information about the requested human task user interface (worker task template).
     * </p>
     *
     * @param describeHumanTaskUiRequest
     * @return A Java Future containing the result of the DescribeHumanTaskUi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeHumanTaskUiResponse> describeHumanTaskUi(
            DescribeHumanTaskUiRequest describeHumanTaskUiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the requested human task user interface (worker task template).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHumanTaskUiRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeHumanTaskUiRequest#builder()}
     * </p>
     *
     * @param describeHumanTaskUiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeHumanTaskUiRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeHumanTaskUi operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeHumanTaskUi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHumanTaskUi" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeHumanTaskUiResponse> describeHumanTaskUi(
            Consumer<DescribeHumanTaskUiRequest.Builder> describeHumanTaskUiRequest) {
        return describeHumanTaskUi(DescribeHumanTaskUiRequest.builder().applyMutation(describeHumanTaskUiRequest).build());
    }

    /**
     * <p>
     * Returns a description of a hyperparameter tuning job, depending on the fields selected. These fields can include
     * the name, Amazon Resource Name (ARN), job status of your tuning job and more.
     * </p>
     *
     * @param describeHyperParameterTuningJobRequest
     * @return A Java Future containing the result of the DescribeHyperParameterTuningJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeHyperParameterTuningJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHyperParameterTuningJobResponse> describeHyperParameterTuningJob(
            DescribeHyperParameterTuningJobRequest describeHyperParameterTuningJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of a hyperparameter tuning job, depending on the fields selected. These fields can include
     * the name, Amazon Resource Name (ARN), job status of your tuning job and more.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHyperParameterTuningJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeHyperParameterTuningJobRequest#builder()}
     * </p>
     *
     * @param describeHyperParameterTuningJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeHyperParameterTuningJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeHyperParameterTuningJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeHyperParameterTuningJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeHyperParameterTuningJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeHyperParameterTuningJobResponse> describeHyperParameterTuningJob(
            Consumer<DescribeHyperParameterTuningJobRequest.Builder> describeHyperParameterTuningJobRequest) {
        return describeHyperParameterTuningJob(DescribeHyperParameterTuningJobRequest.builder()
                .applyMutation(describeHyperParameterTuningJobRequest).build());
    }

    /**
     * <p>
     * Describes a SageMaker AI image.
     * </p>
     *
     * @param describeImageRequest
     * @return A Java Future containing the result of the DescribeImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeImageResponse> describeImage(DescribeImageRequest describeImageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a SageMaker AI image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImageRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeImageRequest#builder()}
     * </p>
     *
     * @param describeImageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeImageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeImage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeImageResponse> describeImage(Consumer<DescribeImageRequest.Builder> describeImageRequest) {
        return describeImage(DescribeImageRequest.builder().applyMutation(describeImageRequest).build());
    }

    /**
     * <p>
     * Describes a version of a SageMaker AI image.
     * </p>
     *
     * @param describeImageVersionRequest
     * @return A Java Future containing the result of the DescribeImageVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeImageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeImageVersionResponse> describeImageVersion(
            DescribeImageVersionRequest describeImageVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a version of a SageMaker AI image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImageVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeImageVersionRequest#builder()}
     * </p>
     *
     * @param describeImageVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeImageVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeImageVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeImageVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeImageVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeImageVersionResponse> describeImageVersion(
            Consumer<DescribeImageVersionRequest.Builder> describeImageVersionRequest) {
        return describeImageVersion(DescribeImageVersionRequest.builder().applyMutation(describeImageVersionRequest).build());
    }

    /**
     * <p>
     * Returns information about an inference component.
     * </p>
     *
     * @param describeInferenceComponentRequest
     * @return A Java Future containing the result of the DescribeInferenceComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeInferenceComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeInferenceComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInferenceComponentResponse> describeInferenceComponent(
            DescribeInferenceComponentRequest describeInferenceComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an inference component.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInferenceComponentRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInferenceComponentRequest#builder()}
     * </p>
     *
     * @param describeInferenceComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeInferenceComponentRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeInferenceComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeInferenceComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeInferenceComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInferenceComponentResponse> describeInferenceComponent(
            Consumer<DescribeInferenceComponentRequest.Builder> describeInferenceComponentRequest) {
        return describeInferenceComponent(DescribeInferenceComponentRequest.builder()
                .applyMutation(describeInferenceComponentRequest).build());
    }

    /**
     * <p>
     * Returns details about an inference experiment.
     * </p>
     *
     * @param describeInferenceExperimentRequest
     * @return A Java Future containing the result of the DescribeInferenceExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeInferenceExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeInferenceExperiment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInferenceExperimentResponse> describeInferenceExperiment(
            DescribeInferenceExperimentRequest describeInferenceExperimentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about an inference experiment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInferenceExperimentRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInferenceExperimentRequest#builder()}
     * </p>
     *
     * @param describeInferenceExperimentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeInferenceExperimentRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeInferenceExperiment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeInferenceExperiment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeInferenceExperiment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInferenceExperimentResponse> describeInferenceExperiment(
            Consumer<DescribeInferenceExperimentRequest.Builder> describeInferenceExperimentRequest) {
        return describeInferenceExperiment(DescribeInferenceExperimentRequest.builder()
                .applyMutation(describeInferenceExperimentRequest).build());
    }

    /**
     * <p>
     * Provides the results of the Inference Recommender job. One or more recommendation jobs are returned.
     * </p>
     *
     * @param describeInferenceRecommendationsJobRequest
     * @return A Java Future containing the result of the DescribeInferenceRecommendationsJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeInferenceRecommendationsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeInferenceRecommendationsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInferenceRecommendationsJobResponse> describeInferenceRecommendationsJob(
            DescribeInferenceRecommendationsJobRequest describeInferenceRecommendationsJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the results of the Inference Recommender job. One or more recommendation jobs are returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInferenceRecommendationsJobRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInferenceRecommendationsJobRequest#builder()}
     * </p>
     *
     * @param describeInferenceRecommendationsJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeInferenceRecommendationsJobRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeInferenceRecommendationsJob operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeInferenceRecommendationsJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeInferenceRecommendationsJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInferenceRecommendationsJobResponse> describeInferenceRecommendationsJob(
            Consumer<DescribeInferenceRecommendationsJobRequest.Builder> describeInferenceRecommendationsJobRequest) {
        return describeInferenceRecommendationsJob(DescribeInferenceRecommendationsJobRequest.builder()
                .applyMutation(describeInferenceRecommendationsJobRequest).build());
    }

    /**
     * <p>
     * Gets information about a labeling job.
     * </p>
     *
     * @param describeLabelingJobRequest
     * @return A Java Future containing the result of the DescribeLabelingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeLabelingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeLabelingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeLabelingJobResponse> describeLabelingJob(
            DescribeLabelingJobRequest describeLabelingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a labeling job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLabelingJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLabelingJobRequest#builder()}
     * </p>
     *
     * @param describeLabelingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeLabelingJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeLabelingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeLabelingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeLabelingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeLabelingJobResponse> describeLabelingJob(
            Consumer<DescribeLabelingJobRequest.Builder> describeLabelingJobRequest) {
        return describeLabelingJob(DescribeLabelingJobRequest.builder().applyMutation(describeLabelingJobRequest).build());
    }

    /**
     * <p>
     * Provides a list of properties for the requested lineage group. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html"> Cross-Account Lineage
     * Tracking </a> in the <i>Amazon SageMaker Developer Guide</i>.
     * </p>
     *
     * @param describeLineageGroupRequest
     * @return A Java Future containing the result of the DescribeLineageGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeLineageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeLineageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLineageGroupResponse> describeLineageGroup(
            DescribeLineageGroupRequest describeLineageGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of properties for the requested lineage group. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/xaccount-lineage-tracking.html"> Cross-Account Lineage
     * Tracking </a> in the <i>Amazon SageMaker Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLineageGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeLineageGroupRequest#builder()}
     * </p>
     *
     * @param describeLineageGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeLineageGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeLineageGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeLineageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeLineageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLineageGroupResponse> describeLineageGroup(
            Consumer<DescribeLineageGroupRequest.Builder> describeLineageGroupRequest) {
        return describeLineageGroup(DescribeLineageGroupRequest.builder().applyMutation(describeLineageGroupRequest).build());
    }

    /**
     * <p>
     * Returns information about an MLflow Tracking Server.
     * </p>
     *
     * @param describeMlflowTrackingServerRequest
     * @return A Java Future containing the result of the DescribeMlflowTrackingServer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeMlflowTrackingServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeMlflowTrackingServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMlflowTrackingServerResponse> describeMlflowTrackingServer(
            DescribeMlflowTrackingServerRequest describeMlflowTrackingServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an MLflow Tracking Server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMlflowTrackingServerRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMlflowTrackingServerRequest#builder()}
     * </p>
     *
     * @param describeMlflowTrackingServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeMlflowTrackingServerRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeMlflowTrackingServer operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeMlflowTrackingServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeMlflowTrackingServer"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMlflowTrackingServerResponse> describeMlflowTrackingServer(
            Consumer<DescribeMlflowTrackingServerRequest.Builder> describeMlflowTrackingServerRequest) {
        return describeMlflowTrackingServer(DescribeMlflowTrackingServerRequest.builder()
                .applyMutation(describeMlflowTrackingServerRequest).build());
    }

    /**
     * <p>
     * Describes a model that you created using the <code>CreateModel</code> API.
     * </p>
     *
     * @param describeModelRequest
     * @return A Java Future containing the result of the DescribeModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeModelResponse> describeModel(DescribeModelRequest describeModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a model that you created using the <code>CreateModel</code> API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeModelRequest#builder()}
     * </p>
     *
     * @param describeModelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeModelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeModelResponse> describeModel(Consumer<DescribeModelRequest.Builder> describeModelRequest) {
        return describeModel(DescribeModelRequest.builder().applyMutation(describeModelRequest).build());
    }

    /**
     * <p>
     * Returns a description of a model bias job definition.
     * </p>
     *
     * @param describeModelBiasJobDefinitionRequest
     * @return A Java Future containing the result of the DescribeModelBiasJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeModelBiasJobDefinitionResponse> describeModelBiasJobDefinition(
            DescribeModelBiasJobDefinitionRequest describeModelBiasJobDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of a model bias job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelBiasJobDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeModelBiasJobDefinitionRequest#builder()}
     * </p>
     *
     * @param describeModelBiasJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeModelBiasJobDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeModelBiasJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelBiasJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelBiasJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeModelBiasJobDefinitionResponse> describeModelBiasJobDefinition(
            Consumer<DescribeModelBiasJobDefinitionRequest.Builder> describeModelBiasJobDefinitionRequest) {
        return describeModelBiasJobDefinition(DescribeModelBiasJobDefinitionRequest.builder()
                .applyMutation(describeModelBiasJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Describes the content, creation time, and security configuration of an Amazon SageMaker Model Card.
     * </p>
     *
     * @param describeModelCardRequest
     * @return A Java Future containing the result of the DescribeModelCard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelCard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelCard" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeModelCardResponse> describeModelCard(DescribeModelCardRequest describeModelCardRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the content, creation time, and security configuration of an Amazon SageMaker Model Card.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelCardRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeModelCardRequest#builder()}
     * </p>
     *
     * @param describeModelCardRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeModelCardRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeModelCard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelCard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelCard" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeModelCardResponse> describeModelCard(
            Consumer<DescribeModelCardRequest.Builder> describeModelCardRequest) {
        return describeModelCard(DescribeModelCardRequest.builder().applyMutation(describeModelCardRequest).build());
    }

    /**
     * <p>
     * Describes an Amazon SageMaker Model Card export job.
     * </p>
     *
     * @param describeModelCardExportJobRequest
     * @return A Java Future containing the result of the DescribeModelCardExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelCardExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelCardExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeModelCardExportJobResponse> describeModelCardExportJob(
            DescribeModelCardExportJobRequest describeModelCardExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an Amazon SageMaker Model Card export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelCardExportJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeModelCardExportJobRequest#builder()}
     * </p>
     *
     * @param describeModelCardExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeModelCardExportJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeModelCardExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelCardExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelCardExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeModelCardExportJobResponse> describeModelCardExportJob(
            Consumer<DescribeModelCardExportJobRequest.Builder> describeModelCardExportJobRequest) {
        return describeModelCardExportJob(DescribeModelCardExportJobRequest.builder()
                .applyMutation(describeModelCardExportJobRequest).build());
    }

    /**
     * <p>
     * Returns a description of a model explainability job definition.
     * </p>
     *
     * @param describeModelExplainabilityJobDefinitionRequest
     * @return A Java Future containing the result of the DescribeModelExplainabilityJobDefinition operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeModelExplainabilityJobDefinitionResponse> describeModelExplainabilityJobDefinition(
            DescribeModelExplainabilityJobDefinitionRequest describeModelExplainabilityJobDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of a model explainability job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeModelExplainabilityJobDefinitionRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeModelExplainabilityJobDefinitionRequest#builder()}
     * </p>
     *
     * @param describeModelExplainabilityJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeModelExplainabilityJobDefinitionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeModelExplainabilityJobDefinition operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelExplainabilityJobDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelExplainabilityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeModelExplainabilityJobDefinitionResponse> describeModelExplainabilityJobDefinition(
            Consumer<DescribeModelExplainabilityJobDefinitionRequest.Builder> describeModelExplainabilityJobDefinitionRequest) {
        return describeModelExplainabilityJobDefinition(DescribeModelExplainabilityJobDefinitionRequest.builder()
                .applyMutation(describeModelExplainabilityJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Returns a description of the specified model package, which is used to create SageMaker models or list them on
     * Amazon Web Services Marketplace.
     * </p>
     * <important>
     * <p>
     * If you provided a KMS Key ID when you created your model package, you will see the <a
     * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Decrypt.html">KMS Decrypt</a> API call in your
     * CloudTrail logs when you use this API.
     * </p>
     * </important>
     * <p>
     * To create models in SageMaker, buyers can subscribe to model packages listed on Amazon Web Services Marketplace.
     * </p>
     *
     * @param describeModelPackageRequest
     * @return A Java Future containing the result of the DescribeModelPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeModelPackageResponse> describeModelPackage(
            DescribeModelPackageRequest describeModelPackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of the specified model package, which is used to create SageMaker models or list them on
     * Amazon Web Services Marketplace.
     * </p>
     * <important>
     * <p>
     * If you provided a KMS Key ID when you created your model package, you will see the <a
     * href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Decrypt.html">KMS Decrypt</a> API call in your
     * CloudTrail logs when you use this API.
     * </p>
     * </important>
     * <p>
     * To create models in SageMaker, buyers can subscribe to model packages listed on Amazon Web Services Marketplace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelPackageRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeModelPackageRequest#builder()}
     * </p>
     *
     * @param describeModelPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeModelPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackage"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeModelPackageResponse> describeModelPackage(
            Consumer<DescribeModelPackageRequest.Builder> describeModelPackageRequest) {
        return describeModelPackage(DescribeModelPackageRequest.builder().applyMutation(describeModelPackageRequest).build());
    }

    /**
     * <p>
     * Gets a description for the specified model group.
     * </p>
     *
     * @param describeModelPackageGroupRequest
     * @return A Java Future containing the result of the DescribeModelPackageGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeModelPackageGroupResponse> describeModelPackageGroup(
            DescribeModelPackageGroupRequest describeModelPackageGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a description for the specified model group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelPackageGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeModelPackageGroupRequest#builder()}
     * </p>
     *
     * @param describeModelPackageGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeModelPackageGroupRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeModelPackageGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelPackageGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelPackageGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeModelPackageGroupResponse> describeModelPackageGroup(
            Consumer<DescribeModelPackageGroupRequest.Builder> describeModelPackageGroupRequest) {
        return describeModelPackageGroup(DescribeModelPackageGroupRequest.builder()
                .applyMutation(describeModelPackageGroupRequest).build());
    }

    /**
     * <p>
     * Returns a description of a model quality job definition.
     * </p>
     *
     * @param describeModelQualityJobDefinitionRequest
     * @return A Java Future containing the result of the DescribeModelQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeModelQualityJobDefinitionResponse> describeModelQualityJobDefinition(
            DescribeModelQualityJobDefinitionRequest describeModelQualityJobDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of a model quality job definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelQualityJobDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeModelQualityJobDefinitionRequest#builder()}
     * </p>
     *
     * @param describeModelQualityJobDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeModelQualityJobDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeModelQualityJobDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeModelQualityJobDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeModelQualityJobDefinitionResponse> describeModelQualityJobDefinition(
            Consumer<DescribeModelQualityJobDefinitionRequest.Builder> describeModelQualityJobDefinitionRequest) {
        return describeModelQualityJobDefinition(DescribeModelQualityJobDefinitionRequest.builder()
                .applyMutation(describeModelQualityJobDefinitionRequest).build());
    }

    /**
     * <p>
     * Describes the schedule for a monitoring job.
     * </p>
     *
     * @param describeMonitoringScheduleRequest
     * @return A Java Future containing the result of the DescribeMonitoringSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMonitoringScheduleResponse> describeMonitoringSchedule(
            DescribeMonitoringScheduleRequest describeMonitoringScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the schedule for a monitoring job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMonitoringScheduleRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeMonitoringScheduleRequest#builder()}
     * </p>
     *
     * @param describeMonitoringScheduleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeMonitoringScheduleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeMonitoringSchedule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeMonitoringSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeMonitoringSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMonitoringScheduleResponse> describeMonitoringSchedule(
            Consumer<DescribeMonitoringScheduleRequest.Builder> describeMonitoringScheduleRequest) {
        return describeMonitoringSchedule(DescribeMonitoringScheduleRequest.builder()
                .applyMutation(describeMonitoringScheduleRequest).build());
    }

    /**
     * <p>
     * Returns information about a notebook instance.
     * </p>
     *
     * @param describeNotebookInstanceRequest
     * @return A Java Future containing the result of the DescribeNotebookInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeNotebookInstanceResponse> describeNotebookInstance(
            DescribeNotebookInstanceRequest describeNotebookInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a notebook instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNotebookInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeNotebookInstanceRequest#builder()}
     * </p>
     *
     * @param describeNotebookInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeNotebookInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeNotebookInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeNotebookInstanceResponse> describeNotebookInstance(
            Consumer<DescribeNotebookInstanceRequest.Builder> describeNotebookInstanceRequest) {
        return describeNotebookInstance(DescribeNotebookInstanceRequest.builder().applyMutation(describeNotebookInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Returns a description of a notebook instance lifecycle configuration.
     * </p>
     * <p>
     * For information about notebook instance lifestyle configurations, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance</a>.
     * </p>
     *
     * @param describeNotebookInstanceLifecycleConfigRequest
     * @return A Java Future containing the result of the DescribeNotebookInstanceLifecycleConfig operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeNotebookInstanceLifecycleConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeNotebookInstanceLifecycleConfigResponse> describeNotebookInstanceLifecycleConfig(
            DescribeNotebookInstanceLifecycleConfigRequest describeNotebookInstanceLifecycleConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of a notebook instance lifecycle configuration.
     * </p>
     * <p>
     * For information about notebook instance lifestyle configurations, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeNotebookInstanceLifecycleConfigRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeNotebookInstanceLifecycleConfigRequest#builder()}
     * </p>
     *
     * @param describeNotebookInstanceLifecycleConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeNotebookInstanceLifecycleConfigRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeNotebookInstanceLifecycleConfig operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeNotebookInstanceLifecycleConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeNotebookInstanceLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeNotebookInstanceLifecycleConfigResponse> describeNotebookInstanceLifecycleConfig(
            Consumer<DescribeNotebookInstanceLifecycleConfigRequest.Builder> describeNotebookInstanceLifecycleConfigRequest) {
        return describeNotebookInstanceLifecycleConfig(DescribeNotebookInstanceLifecycleConfigRequest.builder()
                .applyMutation(describeNotebookInstanceLifecycleConfigRequest).build());
    }

    /**
     * <p>
     * Provides the properties of the specified optimization job.
     * </p>
     *
     * @param describeOptimizationJobRequest
     * @return A Java Future containing the result of the DescribeOptimizationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeOptimizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeOptimizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOptimizationJobResponse> describeOptimizationJob(
            DescribeOptimizationJobRequest describeOptimizationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the properties of the specified optimization job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOptimizationJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeOptimizationJobRequest#builder()}
     * </p>
     *
     * @param describeOptimizationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeOptimizationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeOptimizationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeOptimizationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeOptimizationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOptimizationJobResponse> describeOptimizationJob(
            Consumer<DescribeOptimizationJobRequest.Builder> describeOptimizationJobRequest) {
        return describeOptimizationJob(DescribeOptimizationJobRequest.builder().applyMutation(describeOptimizationJobRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a SageMaker Partner AI App.
     * </p>
     *
     * @param describePartnerAppRequest
     * @return A Java Future containing the result of the DescribePartnerApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribePartnerApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePartnerApp" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePartnerAppResponse> describePartnerApp(DescribePartnerAppRequest describePartnerAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a SageMaker Partner AI App.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePartnerAppRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePartnerAppRequest#builder()}
     * </p>
     *
     * @param describePartnerAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribePartnerAppRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePartnerApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribePartnerApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePartnerApp" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePartnerAppResponse> describePartnerApp(
            Consumer<DescribePartnerAppRequest.Builder> describePartnerAppRequest) {
        return describePartnerApp(DescribePartnerAppRequest.builder().applyMutation(describePartnerAppRequest).build());
    }

    /**
     * <p>
     * Describes the details of a pipeline.
     * </p>
     *
     * @param describePipelineRequest
     * @return A Java Future containing the result of the DescribePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePipelineResponse> describePipeline(DescribePipelineRequest describePipelineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the details of a pipeline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePipelineRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePipelineRequest#builder()}
     * </p>
     *
     * @param describePipelineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribePipelineRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePipeline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribePipeline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipeline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePipelineResponse> describePipeline(
            Consumer<DescribePipelineRequest.Builder> describePipelineRequest) {
        return describePipeline(DescribePipelineRequest.builder().applyMutation(describePipelineRequest).build());
    }

    /**
     * <p>
     * Describes the details of an execution's pipeline definition.
     * </p>
     *
     * @param describePipelineDefinitionForExecutionRequest
     * @return A Java Future containing the result of the DescribePipelineDefinitionForExecution operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribePipelineDefinitionForExecution
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipelineDefinitionForExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePipelineDefinitionForExecutionResponse> describePipelineDefinitionForExecution(
            DescribePipelineDefinitionForExecutionRequest describePipelineDefinitionForExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the details of an execution's pipeline definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribePipelineDefinitionForExecutionRequest.Builder} avoiding the need to create one manually via
     * {@link DescribePipelineDefinitionForExecutionRequest#builder()}
     * </p>
     *
     * @param describePipelineDefinitionForExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribePipelineDefinitionForExecutionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribePipelineDefinitionForExecution operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribePipelineDefinitionForExecution
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipelineDefinitionForExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePipelineDefinitionForExecutionResponse> describePipelineDefinitionForExecution(
            Consumer<DescribePipelineDefinitionForExecutionRequest.Builder> describePipelineDefinitionForExecutionRequest) {
        return describePipelineDefinitionForExecution(DescribePipelineDefinitionForExecutionRequest.builder()
                .applyMutation(describePipelineDefinitionForExecutionRequest).build());
    }

    /**
     * <p>
     * Describes the details of a pipeline execution.
     * </p>
     *
     * @param describePipelineExecutionRequest
     * @return A Java Future containing the result of the DescribePipelineExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribePipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePipelineExecutionResponse> describePipelineExecution(
            DescribePipelineExecutionRequest describePipelineExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the details of a pipeline execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePipelineExecutionRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePipelineExecutionRequest#builder()}
     * </p>
     *
     * @param describePipelineExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribePipelineExecutionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribePipelineExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribePipelineExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribePipelineExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePipelineExecutionResponse> describePipelineExecution(
            Consumer<DescribePipelineExecutionRequest.Builder> describePipelineExecutionRequest) {
        return describePipelineExecution(DescribePipelineExecutionRequest.builder()
                .applyMutation(describePipelineExecutionRequest).build());
    }

    /**
     * <p>
     * Returns a description of a processing job.
     * </p>
     *
     * @param describeProcessingJobRequest
     * @return A Java Future containing the result of the DescribeProcessingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProcessingJobResponse> describeProcessingJob(
            DescribeProcessingJobRequest describeProcessingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a description of a processing job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProcessingJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeProcessingJobRequest#builder()}
     * </p>
     *
     * @param describeProcessingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeProcessingJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeProcessingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProcessingJobResponse> describeProcessingJob(
            Consumer<DescribeProcessingJobRequest.Builder> describeProcessingJobRequest) {
        return describeProcessingJob(DescribeProcessingJobRequest.builder().applyMutation(describeProcessingJobRequest).build());
    }

    /**
     * <p>
     * Describes the details of a project.
     * </p>
     *
     * @param describeProjectRequest
     * @return A Java Future containing the result of the DescribeProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeProjectResponse> describeProject(DescribeProjectRequest describeProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the details of a project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProjectRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProjectRequest#builder()}
     * </p>
     *
     * @param describeProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeProjectRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeProject" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeProjectResponse> describeProject(
            Consumer<DescribeProjectRequest.Builder> describeProjectRequest) {
        return describeProject(DescribeProjectRequest.builder().applyMutation(describeProjectRequest).build());
    }

    /**
     * <p>
     * Retrieves details about a reserved capacity.
     * </p>
     *
     * @param describeReservedCapacityRequest
     * @return A Java Future containing the result of the DescribeReservedCapacity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeReservedCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeReservedCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedCapacityResponse> describeReservedCapacity(
            DescribeReservedCapacityRequest describeReservedCapacityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about a reserved capacity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedCapacityRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReservedCapacityRequest#builder()}
     * </p>
     *
     * @param describeReservedCapacityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeReservedCapacityRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeReservedCapacity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeReservedCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeReservedCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReservedCapacityResponse> describeReservedCapacity(
            Consumer<DescribeReservedCapacityRequest.Builder> describeReservedCapacityRequest) {
        return describeReservedCapacity(DescribeReservedCapacityRequest.builder().applyMutation(describeReservedCapacityRequest)
                .build());
    }

    /**
     * <p>
     * Describes the space.
     * </p>
     *
     * @param describeSpaceRequest
     * @return A Java Future containing the result of the DescribeSpace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeSpace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSpaceResponse> describeSpace(DescribeSpaceRequest describeSpaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the space.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSpaceRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeSpaceRequest#builder()}
     * </p>
     *
     * @param describeSpaceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeSpaceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeSpace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeSpace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeSpace" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSpaceResponse> describeSpace(Consumer<DescribeSpaceRequest.Builder> describeSpaceRequest) {
        return describeSpace(DescribeSpaceRequest.builder().applyMutation(describeSpaceRequest).build());
    }

    /**
     * <p>
     * Describes the Amazon SageMaker AI Studio Lifecycle Configuration.
     * </p>
     *
     * @param describeStudioLifecycleConfigRequest
     * @return A Java Future containing the result of the DescribeStudioLifecycleConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStudioLifecycleConfigResponse> describeStudioLifecycleConfig(
            DescribeStudioLifecycleConfigRequest describeStudioLifecycleConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the Amazon SageMaker AI Studio Lifecycle Configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStudioLifecycleConfigRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeStudioLifecycleConfigRequest#builder()}
     * </p>
     *
     * @param describeStudioLifecycleConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeStudioLifecycleConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeStudioLifecycleConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeStudioLifecycleConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeStudioLifecycleConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStudioLifecycleConfigResponse> describeStudioLifecycleConfig(
            Consumer<DescribeStudioLifecycleConfigRequest.Builder> describeStudioLifecycleConfigRequest) {
        return describeStudioLifecycleConfig(DescribeStudioLifecycleConfigRequest.builder()
                .applyMutation(describeStudioLifecycleConfigRequest).build());
    }

    /**
     * <p>
     * Gets information about a work team provided by a vendor. It returns details about the subscription with a vendor
     * in the Amazon Web Services Marketplace.
     * </p>
     *
     * @param describeSubscribedWorkteamRequest
     * @return A Java Future containing the result of the DescribeSubscribedWorkteam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeSubscribedWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeSubscribedWorkteam"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSubscribedWorkteamResponse> describeSubscribedWorkteam(
            DescribeSubscribedWorkteamRequest describeSubscribedWorkteamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a work team provided by a vendor. It returns details about the subscription with a vendor
     * in the Amazon Web Services Marketplace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSubscribedWorkteamRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSubscribedWorkteamRequest#builder()}
     * </p>
     *
     * @param describeSubscribedWorkteamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeSubscribedWorkteamRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeSubscribedWorkteam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeSubscribedWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeSubscribedWorkteam"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeSubscribedWorkteamResponse> describeSubscribedWorkteam(
            Consumer<DescribeSubscribedWorkteamRequest.Builder> describeSubscribedWorkteamRequest) {
        return describeSubscribedWorkteam(DescribeSubscribedWorkteamRequest.builder()
                .applyMutation(describeSubscribedWorkteamRequest).build());
    }

    /**
     * <p>
     * Returns information about a training job.
     * </p>
     * <p>
     * Some of the attributes below only appear if the training job successfully starts. If the training job fails,
     * <code>TrainingJobStatus</code> is <code>Failed</code> and, depending on the <code>FailureReason</code>,
     * attributes like <code>TrainingStartTime</code>, <code>TrainingTimeInSeconds</code>, <code>TrainingEndTime</code>,
     * and <code>BillableTimeInSeconds</code> may not be present in the response.
     * </p>
     *
     * @param describeTrainingJobRequest
     * @return A Java Future containing the result of the DescribeTrainingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeTrainingJobResponse> describeTrainingJob(
            DescribeTrainingJobRequest describeTrainingJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a training job.
     * </p>
     * <p>
     * Some of the attributes below only appear if the training job successfully starts. If the training job fails,
     * <code>TrainingJobStatus</code> is <code>Failed</code> and, depending on the <code>FailureReason</code>,
     * attributes like <code>TrainingStartTime</code>, <code>TrainingTimeInSeconds</code>, <code>TrainingEndTime</code>,
     * and <code>BillableTimeInSeconds</code> may not be present in the response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrainingJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTrainingJobRequest#builder()}
     * </p>
     *
     * @param describeTrainingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeTrainingJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeTrainingJobResponse> describeTrainingJob(
            Consumer<DescribeTrainingJobRequest.Builder> describeTrainingJobRequest) {
        return describeTrainingJob(DescribeTrainingJobRequest.builder().applyMutation(describeTrainingJobRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specific training plan.
     * </p>
     *
     * @param describeTrainingPlanRequest
     * @return A Java Future containing the result of the DescribeTrainingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeTrainingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrainingPlanResponse> describeTrainingPlan(
            DescribeTrainingPlanRequest describeTrainingPlanRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specific training plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrainingPlanRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTrainingPlanRequest#builder()}
     * </p>
     *
     * @param describeTrainingPlanRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeTrainingPlanRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeTrainingPlan operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeTrainingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrainingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrainingPlanResponse> describeTrainingPlan(
            Consumer<DescribeTrainingPlanRequest.Builder> describeTrainingPlanRequest) {
        return describeTrainingPlan(DescribeTrainingPlanRequest.builder().applyMutation(describeTrainingPlanRequest).build());
    }

    /**
     * <p>
     * Returns information about a transform job.
     * </p>
     *
     * @param describeTransformJobRequest
     * @return A Java Future containing the result of the DescribeTransformJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTransformJobResponse> describeTransformJob(
            DescribeTransformJobRequest describeTransformJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a transform job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTransformJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTransformJobRequest#builder()}
     * </p>
     *
     * @param describeTransformJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeTransformJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeTransformJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTransformJobResponse> describeTransformJob(
            Consumer<DescribeTransformJobRequest.Builder> describeTransformJobRequest) {
        return describeTransformJob(DescribeTransformJobRequest.builder().applyMutation(describeTransformJobRequest).build());
    }

    /**
     * <p>
     * Provides a list of a trial's properties.
     * </p>
     *
     * @param describeTrialRequest
     * @return A Java Future containing the result of the DescribeTrial operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrial" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTrialResponse> describeTrial(DescribeTrialRequest describeTrialRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of a trial's properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrialRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTrialRequest#builder()}
     * </p>
     *
     * @param describeTrialRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeTrialRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeTrial operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeTrial
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrial" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeTrialResponse> describeTrial(Consumer<DescribeTrialRequest.Builder> describeTrialRequest) {
        return describeTrial(DescribeTrialRequest.builder().applyMutation(describeTrialRequest).build());
    }

    /**
     * <p>
     * Provides a list of a trials component's properties.
     * </p>
     *
     * @param describeTrialComponentRequest
     * @return A Java Future containing the result of the DescribeTrialComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrialComponentResponse> describeTrialComponent(
            DescribeTrialComponentRequest describeTrialComponentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of a trials component's properties.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTrialComponentRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeTrialComponentRequest#builder()}
     * </p>
     *
     * @param describeTrialComponentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeTrialComponent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeTrialComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeTrialComponent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTrialComponentResponse> describeTrialComponent(
            Consumer<DescribeTrialComponentRequest.Builder> describeTrialComponentRequest) {
        return describeTrialComponent(DescribeTrialComponentRequest.builder().applyMutation(describeTrialComponentRequest)
                .build());
    }

    /**
     * <p>
     * Describes a user profile. For more information, see <code>CreateUserProfile</code>.
     * </p>
     *
     * @param describeUserProfileRequest
     * @return A Java Future containing the result of the DescribeUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeUserProfileResponse> describeUserProfile(
            DescribeUserProfileRequest describeUserProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a user profile. For more information, see <code>CreateUserProfile</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeUserProfileRequest#builder()}
     * </p>
     *
     * @param describeUserProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeUserProfileRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeUserProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Resource being access is not found.</li>
     *         <li>ResourceLimitExceededException You have exceeded an SageMaker resource limit. For example, you might
     *         have too many training jobs created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeUserProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeUserProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeUserProfileResponse> describeUserProfile(
            Consumer<DescribeUserProfileRequest.Builder> describeUserProfileRequest) {
        return describeUserProfile(DescribeUserProfileRequest.builder().applyMutation(describeUserProfileRequest).build());
    }

    /**
     * <p>
     * Lists private workforce information, including workforce name, Amazon Resource Name (ARN), and, if applicable,
     * allowed IP address ranges (<a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>). Allowable IP address ranges
     * are the IP addresses that workers can use to access tasks.
     * </p>
     * <important>
     * <p>
     * This operation applies only to private workforces.
     * </p>
     * </important>
     *
     * @param describeWorkforceRequest
     * @return A Java Future containing the result of the DescribeWorkforce operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkforce" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeWorkforceResponse> describeWorkforce(DescribeWorkforceRequest describeWorkforceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists private workforce information, including workforce name, Amazon Resource Name (ARN), and, if applicable,
     * allowed IP address ranges (<a
     * href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">CIDRs</a>). Allowable IP address ranges
     * are the IP addresses that workers can use to access tasks.
     * </p>
     * <important>
     * <p>
     * This operation applies only to private workforces.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkforceRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeWorkforceRequest#builder()}
     * </p>
     *
     * @param describeWorkforceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeWorkforceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeWorkforce operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeWorkforce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkforce" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeWorkforceResponse> describeWorkforce(
            Consumer<DescribeWorkforceRequest.Builder> describeWorkforceRequest) {
        return describeWorkforce(DescribeWorkforceRequest.builder().applyMutation(describeWorkforceRequest).build());
    }

    /**
     * <p>
     * Gets information about a specific work team. You can see information such as the creation date, the last updated
     * date, membership information, and the work team's Amazon Resource Name (ARN).
     * </p>
     *
     * @param describeWorkteamRequest
     * @return A Java Future containing the result of the DescribeWorkteam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkteam" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeWorkteamResponse> describeWorkteam(DescribeWorkteamRequest describeWorkteamRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specific work team. You can see information such as the creation date, the last updated
     * date, membership information, and the work team's Amazon Resource Name (ARN).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorkteamRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeWorkteamRequest#builder()}
     * </p>
     *
     * @param describeWorkteamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sagemaker.model.DescribeWorkteamRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeWorkteam operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SageMakerException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SageMakerAsyncClient.DescribeWorkteam
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/DescribeWorkteam" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeWorkteamResponse> describeWorkteam(
            Consumer<DescribeWorkteamRequest.Builder> describeWorkteamRequest) {
        return describeWorkteam(DescribeWorkteamRequest.builder().applyMutation(describeWorkteamRequest).build());
    }

    /**
     * <p>
     * Detaches your Amazon Elastic Block Store (Amazon EBS) volume from a node in your EKS orchestrated SageMaker
     * HyperPod cluster.
     * </p>
     * <p>
     * This API works with the Amazon Elastic Block Store (Amazon EBS) Container Storage Interface (CSI) driver to
     * manage the lifecycle of persistent storage in your HyperPod EKS clusters.
     * </p>
     *
     * @param detachClusterNodeVolumeRequest
     * @return A Java Future containing the result of the DetachClusterNodeVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         ex