/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachClusterNodeVolumeResponse extends SageMakerResponse implements
        ToCopyableBuilder<AttachClusterNodeVolumeResponse.Builder, AttachClusterNodeVolumeResponse> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(AttachClusterNodeVolumeResponse::clusterArn))
            .setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NodeId")
            .getter(getter(AttachClusterNodeVolumeResponse::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeId").getter(getter(AttachClusterNodeVolumeResponse::volumeId)).setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()).build();

    private static final SdkField<Instant> ATTACH_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("AttachTime").getter(getter(AttachClusterNodeVolumeResponse::attachTime))
            .setter(setter(Builder::attachTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AttachClusterNodeVolumeResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceName").getter(getter(AttachClusterNodeVolumeResponse::deviceName))
            .setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            NODE_ID_FIELD, VOLUME_ID_FIELD, ATTACH_TIME_FIELD, STATUS_FIELD, DEVICE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterArn;

    private final String nodeId;

    private final String volumeId;

    private final Instant attachTime;

    private final String status;

    private final String deviceName;

    private AttachClusterNodeVolumeResponse(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.nodeId = builder.nodeId;
        this.volumeId = builder.volumeId;
        this.attachTime = builder.attachTime;
        this.status = builder.status;
        this.deviceName = builder.deviceName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of your SageMaker HyperPod cluster where the volume attachment operation was
     * performed.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of your SageMaker HyperPod cluster where the volume attachment operation
     *         was performed.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The unique identifier of the cluster node where your volume was attached.
     * </p>
     * 
     * @return The unique identifier of the cluster node where your volume was attached.
     */
    public final String nodeId() {
        return nodeId;
    }

    /**
     * <p>
     * The unique identifier of your EBS volume that was attached.
     * </p>
     * 
     * @return The unique identifier of your EBS volume that was attached.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The timestamp when the volume attachment operation was initiated by the SageMaker HyperPod service.
     * </p>
     * 
     * @return The timestamp when the volume attachment operation was initiated by the SageMaker HyperPod service.
     */
    public final Instant attachTime() {
        return attachTime;
    }

    /**
     * <p>
     * The current status of your volume attachment operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VolumeAttachmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of your volume attachment operation.
     * @see VolumeAttachmentStatus
     */
    public final VolumeAttachmentStatus status() {
        return VolumeAttachmentStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of your volume attachment operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VolumeAttachmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of your volume attachment operation.
     * @see VolumeAttachmentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The device name assigned to your attached volume on the target instance.
     * </p>
     * 
     * @return The device name assigned to your attached volume on the target instance.
     */
    public final String deviceName() {
        return deviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(attachTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachClusterNodeVolumeResponse)) {
            return false;
        }
        AttachClusterNodeVolumeResponse other = (AttachClusterNodeVolumeResponse) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(nodeId(), other.nodeId())
                && Objects.equals(volumeId(), other.volumeId()) && Objects.equals(attachTime(), other.attachTime())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(deviceName(), other.deviceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttachClusterNodeVolumeResponse").add("ClusterArn", clusterArn()).add("NodeId", nodeId())
                .add("VolumeId", volumeId()).add("AttachTime", attachTime()).add("Status", statusAsString())
                .add("DeviceName", deviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "NodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "AttachTime":
            return Optional.ofNullable(clazz.cast(attachTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterArn", CLUSTER_ARN_FIELD);
        map.put("NodeId", NODE_ID_FIELD);
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("AttachTime", ATTACH_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("DeviceName", DEVICE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttachClusterNodeVolumeResponse, T> g) {
        return obj -> g.apply((AttachClusterNodeVolumeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AttachClusterNodeVolumeResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of your SageMaker HyperPod cluster where the volume attachment operation was
         * performed.
         * </p>
         * 
         * @param clusterArn
         *        The Amazon Resource Name (ARN) of your SageMaker HyperPod cluster where the volume attachment
         *        operation was performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The unique identifier of the cluster node where your volume was attached.
         * </p>
         * 
         * @param nodeId
         *        The unique identifier of the cluster node where your volume was attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);

        /**
         * <p>
         * The unique identifier of your EBS volume that was attached.
         * </p>
         * 
         * @param volumeId
         *        The unique identifier of your EBS volume that was attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The timestamp when the volume attachment operation was initiated by the SageMaker HyperPod service.
         * </p>
         * 
         * @param attachTime
         *        The timestamp when the volume attachment operation was initiated by the SageMaker HyperPod service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachTime(Instant attachTime);

        /**
         * <p>
         * The current status of your volume attachment operation.
         * </p>
         * 
         * @param status
         *        The current status of your volume attachment operation.
         * @see VolumeAttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeAttachmentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of your volume attachment operation.
         * </p>
         * 
         * @param status
         *        The current status of your volume attachment operation.
         * @see VolumeAttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeAttachmentStatus
         */
        Builder status(VolumeAttachmentStatus status);

        /**
         * <p>
         * The device name assigned to your attached volume on the target instance.
         * </p>
         * 
         * @param deviceName
         *        The device name assigned to your attached volume on the target instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String clusterArn;

        private String nodeId;

        private String volumeId;

        private Instant attachTime;

        private String status;

        private String deviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachClusterNodeVolumeResponse model) {
            super(model);
            clusterArn(model.clusterArn);
            nodeId(model.nodeId);
            volumeId(model.volumeId);
            attachTime(model.attachTime);
            status(model.status);
            deviceName(model.deviceName);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getNodeId() {
            return nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final Instant getAttachTime() {
            return attachTime;
        }

        public final void setAttachTime(Instant attachTime) {
            this.attachTime = attachTime;
        }

        @Override
        public final Builder attachTime(Instant attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VolumeAttachmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        @Override
        public AttachClusterNodeVolumeResponse build() {
            return new AttachClusterNodeVolumeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
