/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a presigned URL and its associated local file path for downloading hub content artifacts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizedUrl implements SdkPojo, Serializable, ToCopyableBuilder<AuthorizedUrl.Builder, AuthorizedUrl> {
    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(AuthorizedUrl::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<String> LOCAL_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocalPath").getter(getter(AuthorizedUrl::localPath)).setter(setter(Builder::localPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, LOCAL_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String url;

    private final String localPath;

    private AuthorizedUrl(BuilderImpl builder) {
        this.url = builder.url;
        this.localPath = builder.localPath;
    }

    /**
     * <p>
     * The presigned S3 URL that provides temporary, secure access to download the file. URLs expire within 15 minutes
     * for security purposes.
     * </p>
     * 
     * @return The presigned S3 URL that provides temporary, secure access to download the file. URLs expire within 15
     *         minutes for security purposes.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The recommended local file path where the downloaded file should be stored to maintain proper directory structure
     * and file organization.
     * </p>
     * 
     * @return The recommended local file path where the downloaded file should be stored to maintain proper directory
     *         structure and file organization.
     */
    public final String localPath() {
        return localPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(localPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizedUrl)) {
            return false;
        }
        AuthorizedUrl other = (AuthorizedUrl) obj;
        return Objects.equals(url(), other.url()) && Objects.equals(localPath(), other.localPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthorizedUrl").add("Url", url()).add("LocalPath", localPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "LocalPath":
            return Optional.ofNullable(clazz.cast(localPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Url", URL_FIELD);
        map.put("LocalPath", LOCAL_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthorizedUrl, T> g) {
        return obj -> g.apply((AuthorizedUrl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthorizedUrl> {
        /**
         * <p>
         * The presigned S3 URL that provides temporary, secure access to download the file. URLs expire within 15
         * minutes for security purposes.
         * </p>
         * 
         * @param url
         *        The presigned S3 URL that provides temporary, secure access to download the file. URLs expire within
         *        15 minutes for security purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The recommended local file path where the downloaded file should be stored to maintain proper directory
         * structure and file organization.
         * </p>
         * 
         * @param localPath
         *        The recommended local file path where the downloaded file should be stored to maintain proper
         *        directory structure and file organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localPath(String localPath);
    }

    static final class BuilderImpl implements Builder {
        private String url;

        private String localPath;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizedUrl model) {
            url(model.url);
            localPath(model.localPath);
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getLocalPath() {
            return localPath;
        }

        public final void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        @Override
        public final Builder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        @Override
        public AuthorizedUrl build() {
            return new AuthorizedUrl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
