/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class AutoMLInferenceContainerDefinitionsCopier {
    static Map<String, List<AutoMLContainerDefinition>> copy(
            Map<String, ? extends Collection<? extends AutoMLContainerDefinition>> autoMLInferenceContainerDefinitionsParam) {
        Map<String, List<AutoMLContainerDefinition>> map;
        if (autoMLInferenceContainerDefinitionsParam == null
                || autoMLInferenceContainerDefinitionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<AutoMLContainerDefinition>> modifiableMap = new LinkedHashMap<>(
                    autoMLInferenceContainerDefinitionsParam.size());
            autoMLInferenceContainerDefinitionsParam.forEach((key, value) -> {
                List<AutoMLContainerDefinition> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<AutoMLContainerDefinition> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        modifiableList.add(entry);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<AutoMLContainerDefinition>> copyFromBuilder(
            Map<String, ? extends Collection<? extends AutoMLContainerDefinition.Builder>> autoMLInferenceContainerDefinitionsParam) {
        Map<String, List<AutoMLContainerDefinition>> map;
        if (autoMLInferenceContainerDefinitionsParam == null
                || autoMLInferenceContainerDefinitionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<AutoMLContainerDefinition>> modifiableMap = new LinkedHashMap<>(
                    autoMLInferenceContainerDefinitionsParam.size());
            autoMLInferenceContainerDefinitionsParam.forEach((key, value) -> {
                List<AutoMLContainerDefinition> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<AutoMLContainerDefinition> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        AutoMLContainerDefinition member = entry == null ? null : entry.build();
                        modifiableList.add(member);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<AutoMLContainerDefinition.Builder>> copyToBuilder(
            Map<String, ? extends Collection<? extends AutoMLContainerDefinition>> autoMLInferenceContainerDefinitionsParam) {
        Map<String, List<AutoMLContainerDefinition.Builder>> map;
        if (autoMLInferenceContainerDefinitionsParam == null
                || autoMLInferenceContainerDefinitionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<AutoMLContainerDefinition.Builder>> modifiableMap = new LinkedHashMap<>(
                    autoMLInferenceContainerDefinitionsParam.size());
            autoMLInferenceContainerDefinitionsParam.forEach((key, value) -> {
                List<AutoMLContainerDefinition.Builder> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<AutoMLContainerDefinition.Builder> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        AutoMLContainerDefinition.Builder member = entry == null ? null : entry.toBuilder();
                        modifiableList.add(member);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<AutoMLContainerDefinition>> copyEnumToString(
            Map<AutoMLProcessingUnit, ? extends Collection<? extends AutoMLContainerDefinition>> autoMLInferenceContainerDefinitionsParam) {
        Map<String, List<AutoMLContainerDefinition>> map;
        if (autoMLInferenceContainerDefinitionsParam == null
                || autoMLInferenceContainerDefinitionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<AutoMLContainerDefinition>> modifiableMap = new LinkedHashMap<>(
                    autoMLInferenceContainerDefinitionsParam.size());
            autoMLInferenceContainerDefinitionsParam.forEach((key, value) -> {
                String result = key == null ? null : key.toString();
                List<AutoMLContainerDefinition> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<AutoMLContainerDefinition> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        modifiableList.add(entry);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(result, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<AutoMLProcessingUnit, List<AutoMLContainerDefinition>> copyStringToEnum(
            Map<String, ? extends Collection<? extends AutoMLContainerDefinition>> autoMLInferenceContainerDefinitionsParam) {
        Map<AutoMLProcessingUnit, List<AutoMLContainerDefinition>> map;
        if (autoMLInferenceContainerDefinitionsParam == null
                || autoMLInferenceContainerDefinitionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<AutoMLProcessingUnit, List<AutoMLContainerDefinition>> modifiableMap = new LinkedHashMap<>(
                    autoMLInferenceContainerDefinitionsParam.size());
            autoMLInferenceContainerDefinitionsParam.forEach((key, value) -> {
                AutoMLProcessingUnit result = AutoMLProcessingUnit.fromValue(key);
                List<AutoMLContainerDefinition> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<AutoMLContainerDefinition> modifiableList = new ArrayList<>(value.size());
                    value.forEach(entry -> {
                        modifiableList.add(entry);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                if (result != AutoMLProcessingUnit.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, list);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
