/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an error that occurred during the node addition operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAddClusterNodesError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchAddClusterNodesError.Builder, BatchAddClusterNodesError> {
    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceGroupName").getter(getter(BatchAddClusterNodesError::instanceGroupName))
            .setter(setter(Builder::instanceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(BatchAddClusterNodesError::errorCodeAsString))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<Integer> FAILED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FailedCount").getter(getter(BatchAddClusterNodesError::failedCount))
            .setter(setter(Builder::failedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedCount").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(BatchAddClusterNodesError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_GROUP_NAME_FIELD,
            ERROR_CODE_FIELD, FAILED_COUNT_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceGroupName;

    private final String errorCode;

    private final Integer failedCount;

    private final String message;

    private BatchAddClusterNodesError(BuilderImpl builder) {
        this.instanceGroupName = builder.instanceGroupName;
        this.errorCode = builder.errorCode;
        this.failedCount = builder.failedCount;
        this.message = builder.message;
    }

    /**
     * <p>
     * The name of the instance group for which the error occurred.
     * </p>
     * 
     * @return The name of the instance group for which the error occurred.
     */
    public final String instanceGroupName() {
        return instanceGroupName;
    }

    /**
     * <p>
     * The error code associated with the failure. Possible values include <code>InstanceGroupNotFound</code> and
     * <code>InvalidInstanceGroupState</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link BatchAddClusterNodesErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code associated with the failure. Possible values include <code>InstanceGroupNotFound</code>
     *         and <code>InvalidInstanceGroupState</code>.
     * @see BatchAddClusterNodesErrorCode
     */
    public final BatchAddClusterNodesErrorCode errorCode() {
        return BatchAddClusterNodesErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The error code associated with the failure. Possible values include <code>InstanceGroupNotFound</code> and
     * <code>InvalidInstanceGroupState</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link BatchAddClusterNodesErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code associated with the failure. Possible values include <code>InstanceGroupNotFound</code>
     *         and <code>InvalidInstanceGroupState</code>.
     * @see BatchAddClusterNodesErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * The number of nodes that failed to be added to the specified instance group.
     * </p>
     * 
     * @return The number of nodes that failed to be added to the specified instance group.
     */
    public final Integer failedCount() {
        return failedCount;
    }

    /**
     * <p>
     * A descriptive message providing additional details about the error.
     * </p>
     * 
     * @return A descriptive message providing additional details about the error.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failedCount());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAddClusterNodesError)) {
            return false;
        }
        BatchAddClusterNodesError other = (BatchAddClusterNodesError) obj;
        return Objects.equals(instanceGroupName(), other.instanceGroupName())
                && Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(failedCount(), other.failedCount()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchAddClusterNodesError").add("InstanceGroupName", instanceGroupName())
                .add("ErrorCode", errorCodeAsString()).add("FailedCount", failedCount()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceGroupName":
            return Optional.ofNullable(clazz.cast(instanceGroupName()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "FailedCount":
            return Optional.ofNullable(clazz.cast(failedCount()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceGroupName", INSTANCE_GROUP_NAME_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("FailedCount", FAILED_COUNT_FIELD);
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAddClusterNodesError, T> g) {
        return obj -> g.apply((BatchAddClusterNodesError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchAddClusterNodesError> {
        /**
         * <p>
         * The name of the instance group for which the error occurred.
         * </p>
         * 
         * @param instanceGroupName
         *        The name of the instance group for which the error occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupName(String instanceGroupName);

        /**
         * <p>
         * The error code associated with the failure. Possible values include <code>InstanceGroupNotFound</code> and
         * <code>InvalidInstanceGroupState</code>.
         * </p>
         * 
         * @param errorCode
         *        The error code associated with the failure. Possible values include <code>InstanceGroupNotFound</code>
         *        and <code>InvalidInstanceGroupState</code>.
         * @see BatchAddClusterNodesErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchAddClusterNodesErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error code associated with the failure. Possible values include <code>InstanceGroupNotFound</code> and
         * <code>InvalidInstanceGroupState</code>.
         * </p>
         * 
         * @param errorCode
         *        The error code associated with the failure. Possible values include <code>InstanceGroupNotFound</code>
         *        and <code>InvalidInstanceGroupState</code>.
         * @see BatchAddClusterNodesErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchAddClusterNodesErrorCode
         */
        Builder errorCode(BatchAddClusterNodesErrorCode errorCode);

        /**
         * <p>
         * The number of nodes that failed to be added to the specified instance group.
         * </p>
         * 
         * @param failedCount
         *        The number of nodes that failed to be added to the specified instance group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedCount(Integer failedCount);

        /**
         * <p>
         * A descriptive message providing additional details about the error.
         * </p>
         * 
         * @param message
         *        A descriptive message providing additional details about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String instanceGroupName;

        private String errorCode;

        private Integer failedCount;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAddClusterNodesError model) {
            instanceGroupName(model.instanceGroupName);
            errorCode(model.errorCode);
            failedCount(model.failedCount);
            message(model.message);
        }

        public final String getInstanceGroupName() {
            return instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(BatchAddClusterNodesErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final Integer getFailedCount() {
            return failedCount;
        }

        public final void setFailedCount(Integer failedCount) {
            this.failedCount = failedCount;
        }

        @Override
        public final Builder failedCount(Integer failedCount) {
            this.failedCount = failedCount;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BatchAddClusterNodesError build() {
            return new BatchAddClusterNodesError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
