/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAddClusterNodesRequest extends SageMakerRequest implements
        ToCopyableBuilder<BatchAddClusterNodesRequest.Builder, BatchAddClusterNodesRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(BatchAddClusterNodesRequest::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(BatchAddClusterNodesRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<AddClusterNodeSpecification>> NODES_TO_ADD_FIELD = SdkField
            .<List<AddClusterNodeSpecification>> builder(MarshallingType.LIST)
            .memberName("NodesToAdd")
            .getter(getter(BatchAddClusterNodesRequest::nodesToAdd))
            .setter(setter(Builder::nodesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodesToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AddClusterNodeSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(AddClusterNodeSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            CLIENT_TOKEN_FIELD, NODES_TO_ADD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterName;

    private final String clientToken;

    private final List<AddClusterNodeSpecification> nodesToAdd;

    private BatchAddClusterNodesRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.clientToken = builder.clientToken;
        this.nodesToAdd = builder.nodesToAdd;
    }

    /**
     * <p>
     * The name of the HyperPod cluster to which you want to add nodes.
     * </p>
     * 
     * @return The name of the HyperPod cluster to which you want to add nodes.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This token is
     * valid for 8 hours. If you retry the request with the same client token within this timeframe and the same
     * parameters, the API returns the same set of <code>NodeLogicalIds</code> with their latest status.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This token
     *         is valid for 8 hours. If you retry the request with the same client token within this timeframe and the
     *         same parameters, the API returns the same set of <code>NodeLogicalIds</code> with their latest status.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodesToAdd property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNodesToAdd() {
        return nodesToAdd != null && !(nodesToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of instance groups and the number of nodes to add to each. You can specify up to 5 instance groups in a
     * single request, with a maximum of 50 nodes total across all instance groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodesToAdd} method.
     * </p>
     * 
     * @return A list of instance groups and the number of nodes to add to each. You can specify up to 5 instance groups
     *         in a single request, with a maximum of 50 nodes total across all instance groups.
     */
    public final List<AddClusterNodeSpecification> nodesToAdd() {
        return nodesToAdd;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasNodesToAdd() ? nodesToAdd() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAddClusterNodesRequest)) {
            return false;
        }
        BatchAddClusterNodesRequest other = (BatchAddClusterNodesRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(clientToken(), other.clientToken())
                && hasNodesToAdd() == other.hasNodesToAdd() && Objects.equals(nodesToAdd(), other.nodesToAdd());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchAddClusterNodesRequest").add("ClusterName", clusterName())
                .add("ClientToken", clientToken()).add("NodesToAdd", hasNodesToAdd() ? nodesToAdd() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "NodesToAdd":
            return Optional.ofNullable(clazz.cast(nodesToAdd()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterName", CLUSTER_NAME_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("NodesToAdd", NODES_TO_ADD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAddClusterNodesRequest, T> g) {
        return obj -> g.apply((BatchAddClusterNodesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchAddClusterNodesRequest> {
        /**
         * <p>
         * The name of the HyperPod cluster to which you want to add nodes.
         * </p>
         * 
         * @param clusterName
         *        The name of the HyperPod cluster to which you want to add nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This token is
         * valid for 8 hours. If you retry the request with the same client token within this timeframe and the same
         * parameters, the API returns the same set of <code>NodeLogicalIds</code> with their latest status.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This
         *        token is valid for 8 hours. If you retry the request with the same client token within this timeframe
         *        and the same parameters, the API returns the same set of <code>NodeLogicalIds</code> with their latest
         *        status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A list of instance groups and the number of nodes to add to each. You can specify up to 5 instance groups in
         * a single request, with a maximum of 50 nodes total across all instance groups.
         * </p>
         * 
         * @param nodesToAdd
         *        A list of instance groups and the number of nodes to add to each. You can specify up to 5 instance
         *        groups in a single request, with a maximum of 50 nodes total across all instance groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodesToAdd(Collection<AddClusterNodeSpecification> nodesToAdd);

        /**
         * <p>
         * A list of instance groups and the number of nodes to add to each. You can specify up to 5 instance groups in
         * a single request, with a maximum of 50 nodes total across all instance groups.
         * </p>
         * 
         * @param nodesToAdd
         *        A list of instance groups and the number of nodes to add to each. You can specify up to 5 instance
         *        groups in a single request, with a maximum of 50 nodes total across all instance groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodesToAdd(AddClusterNodeSpecification... nodesToAdd);

        /**
         * <p>
         * A list of instance groups and the number of nodes to add to each. You can specify up to 5 instance groups in
         * a single request, with a maximum of 50 nodes total across all instance groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.AddClusterNodeSpecification.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.AddClusterNodeSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.AddClusterNodeSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #nodesToAdd(List<AddClusterNodeSpecification>)}.
         * 
         * @param nodesToAdd
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.AddClusterNodeSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodesToAdd(java.util.Collection<AddClusterNodeSpecification>)
         */
        Builder nodesToAdd(Consumer<AddClusterNodeSpecification.Builder>... nodesToAdd);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String clientToken;

        private List<AddClusterNodeSpecification> nodesToAdd = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAddClusterNodesRequest model) {
            super(model);
            clusterName(model.clusterName);
            clientToken(model.clientToken);
            nodesToAdd(model.nodesToAdd);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<AddClusterNodeSpecification.Builder> getNodesToAdd() {
            List<AddClusterNodeSpecification.Builder> result = AddClusterNodeSpecificationListCopier
                    .copyToBuilder(this.nodesToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodesToAdd(Collection<AddClusterNodeSpecification.BuilderImpl> nodesToAdd) {
            this.nodesToAdd = AddClusterNodeSpecificationListCopier.copyFromBuilder(nodesToAdd);
        }

        @Override
        public final Builder nodesToAdd(Collection<AddClusterNodeSpecification> nodesToAdd) {
            this.nodesToAdd = AddClusterNodeSpecificationListCopier.copy(nodesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodesToAdd(AddClusterNodeSpecification... nodesToAdd) {
            nodesToAdd(Arrays.asList(nodesToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodesToAdd(Consumer<AddClusterNodeSpecification.Builder>... nodesToAdd) {
            nodesToAdd(Stream.of(nodesToAdd).map(c -> AddClusterNodeSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchAddClusterNodesRequest build() {
            return new BatchAddClusterNodesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
