/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an error that occurred when attempting to delete a node identified by its
 * <code>NodeLogicalId</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteClusterNodeLogicalIdsError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDeleteClusterNodeLogicalIdsError.Builder, BatchDeleteClusterNodeLogicalIdsError> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(BatchDeleteClusterNodeLogicalIdsError::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(BatchDeleteClusterNodeLogicalIdsError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> NODE_LOGICAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeLogicalId").getter(getter(BatchDeleteClusterNodeLogicalIdsError::nodeLogicalId))
            .setter(setter(Builder::nodeLogicalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeLogicalId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, MESSAGE_FIELD,
            NODE_LOGICAL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String message;

    private final String nodeLogicalId;

    private BatchDeleteClusterNodeLogicalIdsError(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
        this.nodeLogicalId = builder.nodeLogicalId;
    }

    /**
     * <p>
     * The error code associated with the failure. Possible values include <code>NodeLogicalIdNotFound</code>,
     * <code>InvalidNodeStatus</code>, and <code>InternalError</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link BatchDeleteClusterNodesErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #codeAsString}.
     * </p>
     * 
     * @return The error code associated with the failure. Possible values include <code>NodeLogicalIdNotFound</code>,
     *         <code>InvalidNodeStatus</code>, and <code>InternalError</code>.
     * @see BatchDeleteClusterNodesErrorCode
     */
    public final BatchDeleteClusterNodesErrorCode code() {
        return BatchDeleteClusterNodesErrorCode.fromValue(code);
    }

    /**
     * <p>
     * The error code associated with the failure. Possible values include <code>NodeLogicalIdNotFound</code>,
     * <code>InvalidNodeStatus</code>, and <code>InternalError</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link BatchDeleteClusterNodesErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #codeAsString}.
     * </p>
     * 
     * @return The error code associated with the failure. Possible values include <code>NodeLogicalIdNotFound</code>,
     *         <code>InvalidNodeStatus</code>, and <code>InternalError</code>.
     * @see BatchDeleteClusterNodesErrorCode
     */
    public final String codeAsString() {
        return code;
    }

    /**
     * <p>
     * A descriptive message providing additional details about the error.
     * </p>
     * 
     * @return A descriptive message providing additional details about the error.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The <code>NodeLogicalId</code> of the node that could not be deleted.
     * </p>
     * 
     * @return The <code>NodeLogicalId</code> of the node that could not be deleted.
     */
    public final String nodeLogicalId() {
        return nodeLogicalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(nodeLogicalId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteClusterNodeLogicalIdsError)) {
            return false;
        }
        BatchDeleteClusterNodeLogicalIdsError other = (BatchDeleteClusterNodeLogicalIdsError) obj;
        return Objects.equals(codeAsString(), other.codeAsString()) && Objects.equals(message(), other.message())
                && Objects.equals(nodeLogicalId(), other.nodeLogicalId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteClusterNodeLogicalIdsError").add("Code", codeAsString()).add("Message", message())
                .add("NodeLogicalId", nodeLogicalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "NodeLogicalId":
            return Optional.ofNullable(clazz.cast(nodeLogicalId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Code", CODE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("NodeLogicalId", NODE_LOGICAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteClusterNodeLogicalIdsError, T> g) {
        return obj -> g.apply((BatchDeleteClusterNodeLogicalIdsError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDeleteClusterNodeLogicalIdsError> {
        /**
         * <p>
         * The error code associated with the failure. Possible values include <code>NodeLogicalIdNotFound</code>,
         * <code>InvalidNodeStatus</code>, and <code>InternalError</code>.
         * </p>
         * 
         * @param code
         *        The error code associated with the failure. Possible values include <code>NodeLogicalIdNotFound</code>
         *        , <code>InvalidNodeStatus</code>, and <code>InternalError</code>.
         * @see BatchDeleteClusterNodesErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchDeleteClusterNodesErrorCode
         */
        Builder code(String code);

        /**
         * <p>
         * The error code associated with the failure. Possible values include <code>NodeLogicalIdNotFound</code>,
         * <code>InvalidNodeStatus</code>, and <code>InternalError</code>.
         * </p>
         * 
         * @param code
         *        The error code associated with the failure. Possible values include <code>NodeLogicalIdNotFound</code>
         *        , <code>InvalidNodeStatus</code>, and <code>InternalError</code>.
         * @see BatchDeleteClusterNodesErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchDeleteClusterNodesErrorCode
         */
        Builder code(BatchDeleteClusterNodesErrorCode code);

        /**
         * <p>
         * A descriptive message providing additional details about the error.
         * </p>
         * 
         * @param message
         *        A descriptive message providing additional details about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The <code>NodeLogicalId</code> of the node that could not be deleted.
         * </p>
         * 
         * @param nodeLogicalId
         *        The <code>NodeLogicalId</code> of the node that could not be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeLogicalId(String nodeLogicalId);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private String nodeLogicalId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteClusterNodeLogicalIdsError model) {
            code(model.code);
            message(model.message);
            nodeLogicalId(model.nodeLogicalId);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(BatchDeleteClusterNodesErrorCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getNodeLogicalId() {
            return nodeLogicalId;
        }

        public final void setNodeLogicalId(String nodeLogicalId) {
            this.nodeLogicalId = nodeLogicalId;
        }

        @Override
        public final Builder nodeLogicalId(String nodeLogicalId) {
            this.nodeLogicalId = nodeLogicalId;
            return this;
        }

        @Override
        public BatchDeleteClusterNodeLogicalIdsError build() {
            return new BatchDeleteClusterNodeLogicalIdsError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
