/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteClusterNodesRequest extends SageMakerRequest implements
        ToCopyableBuilder<BatchDeleteClusterNodesRequest.Builder, BatchDeleteClusterNodesRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(BatchDeleteClusterNodesRequest::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<List<String>> NODE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NodeIds")
            .getter(getter(BatchDeleteClusterNodesRequest::nodeIds))
            .setter(setter(Builder::nodeIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NODE_LOGICAL_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NodeLogicalIds")
            .getter(getter(BatchDeleteClusterNodesRequest::nodeLogicalIds))
            .setter(setter(Builder::nodeLogicalIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeLogicalIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            NODE_IDS_FIELD, NODE_LOGICAL_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterName;

    private final List<String> nodeIds;

    private final List<String> nodeLogicalIds;

    private BatchDeleteClusterNodesRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.nodeIds = builder.nodeIds;
        this.nodeLogicalIds = builder.nodeLogicalIds;
    }

    /**
     * <p>
     * The name of the SageMaker HyperPod cluster from which to delete the specified nodes.
     * </p>
     * 
     * @return The name of the SageMaker HyperPod cluster from which to delete the specified nodes.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodeIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNodeIds() {
        return nodeIds != null && !(nodeIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of node IDs to be deleted from the specified cluster.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * For SageMaker HyperPod clusters using the Slurm workload manager, you cannot remove instances that are configured
     * as Slurm controller nodes.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you need to delete more than 99 instances, contact <a href="http://aws.amazon.com/contact-us/">Support</a> for
     * assistance.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodeIds} method.
     * </p>
     * 
     * @return A list of node IDs to be deleted from the specified cluster.</p> <note>
     *         <ul>
     *         <li>
     *         <p>
     *         For SageMaker HyperPod clusters using the Slurm workload manager, you cannot remove instances that are
     *         configured as Slurm controller nodes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you need to delete more than 99 instances, contact <a
     *         href="http://aws.amazon.com/contact-us/">Support</a> for assistance.
     *         </p>
     *         </li>
     *         </ul>
     */
    public final List<String> nodeIds() {
        return nodeIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the NodeLogicalIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNodeLogicalIds() {
        return nodeLogicalIds != null && !(nodeLogicalIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>NodeLogicalIds</code> identifying the nodes to be deleted. You can specify up to 50
     * <code>NodeLogicalIds</code>. You must specify either <code>NodeLogicalIds</code>, <code>InstanceIds</code>, or
     * both, with a combined maximum of 50 identifiers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNodeLogicalIds} method.
     * </p>
     * 
     * @return A list of <code>NodeLogicalIds</code> identifying the nodes to be deleted. You can specify up to 50
     *         <code>NodeLogicalIds</code>. You must specify either <code>NodeLogicalIds</code>,
     *         <code>InstanceIds</code>, or both, with a combined maximum of 50 identifiers.
     */
    public final List<String> nodeLogicalIds() {
        return nodeLogicalIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeIds() ? nodeIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNodeLogicalIds() ? nodeLogicalIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteClusterNodesRequest)) {
            return false;
        }
        BatchDeleteClusterNodesRequest other = (BatchDeleteClusterNodesRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && hasNodeIds() == other.hasNodeIds()
                && Objects.equals(nodeIds(), other.nodeIds()) && hasNodeLogicalIds() == other.hasNodeLogicalIds()
                && Objects.equals(nodeLogicalIds(), other.nodeLogicalIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteClusterNodesRequest").add("ClusterName", clusterName())
                .add("NodeIds", hasNodeIds() ? nodeIds() : null)
                .add("NodeLogicalIds", hasNodeLogicalIds() ? nodeLogicalIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "NodeIds":
            return Optional.ofNullable(clazz.cast(nodeIds()));
        case "NodeLogicalIds":
            return Optional.ofNullable(clazz.cast(nodeLogicalIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterName", CLUSTER_NAME_FIELD);
        map.put("NodeIds", NODE_IDS_FIELD);
        map.put("NodeLogicalIds", NODE_LOGICAL_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteClusterNodesRequest, T> g) {
        return obj -> g.apply((BatchDeleteClusterNodesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchDeleteClusterNodesRequest> {
        /**
         * <p>
         * The name of the SageMaker HyperPod cluster from which to delete the specified nodes.
         * </p>
         * 
         * @param clusterName
         *        The name of the SageMaker HyperPod cluster from which to delete the specified nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * A list of node IDs to be deleted from the specified cluster.
         * </p>
         * <note>
         * <ul>
         * <li>
         * <p>
         * For SageMaker HyperPod clusters using the Slurm workload manager, you cannot remove instances that are
         * configured as Slurm controller nodes.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you need to delete more than 99 instances, contact <a href="http://aws.amazon.com/contact-us/">Support</a>
         * for assistance.
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param nodeIds
         *        A list of node IDs to be deleted from the specified cluster.</p> <note>
         *        <ul>
         *        <li>
         *        <p>
         *        For SageMaker HyperPod clusters using the Slurm workload manager, you cannot remove instances that are
         *        configured as Slurm controller nodes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you need to delete more than 99 instances, contact <a
         *        href="http://aws.amazon.com/contact-us/">Support</a> for assistance.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeIds(Collection<String> nodeIds);

        /**
         * <p>
         * A list of node IDs to be deleted from the specified cluster.
         * </p>
         * <note>
         * <ul>
         * <li>
         * <p>
         * For SageMaker HyperPod clusters using the Slurm workload manager, you cannot remove instances that are
         * configured as Slurm controller nodes.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you need to delete more than 99 instances, contact <a href="http://aws.amazon.com/contact-us/">Support</a>
         * for assistance.
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param nodeIds
         *        A list of node IDs to be deleted from the specified cluster.</p> <note>
         *        <ul>
         *        <li>
         *        <p>
         *        For SageMaker HyperPod clusters using the Slurm workload manager, you cannot remove instances that are
         *        configured as Slurm controller nodes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you need to delete more than 99 instances, contact <a
         *        href="http://aws.amazon.com/contact-us/">Support</a> for assistance.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeIds(String... nodeIds);

        /**
         * <p>
         * A list of <code>NodeLogicalIds</code> identifying the nodes to be deleted. You can specify up to 50
         * <code>NodeLogicalIds</code>. You must specify either <code>NodeLogicalIds</code>, <code>InstanceIds</code>,
         * or both, with a combined maximum of 50 identifiers.
         * </p>
         * 
         * @param nodeLogicalIds
         *        A list of <code>NodeLogicalIds</code> identifying the nodes to be deleted. You can specify up to 50
         *        <code>NodeLogicalIds</code>. You must specify either <code>NodeLogicalIds</code>,
         *        <code>InstanceIds</code>, or both, with a combined maximum of 50 identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeLogicalIds(Collection<String> nodeLogicalIds);

        /**
         * <p>
         * A list of <code>NodeLogicalIds</code> identifying the nodes to be deleted. You can specify up to 50
         * <code>NodeLogicalIds</code>. You must specify either <code>NodeLogicalIds</code>, <code>InstanceIds</code>,
         * or both, with a combined maximum of 50 identifiers.
         * </p>
         * 
         * @param nodeLogicalIds
         *        A list of <code>NodeLogicalIds</code> identifying the nodes to be deleted. You can specify up to 50
         *        <code>NodeLogicalIds</code>. You must specify either <code>NodeLogicalIds</code>,
         *        <code>InstanceIds</code>, or both, with a combined maximum of 50 identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeLogicalIds(String... nodeLogicalIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String clusterName;

        private List<String> nodeIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> nodeLogicalIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteClusterNodesRequest model) {
            super(model);
            clusterName(model.clusterName);
            nodeIds(model.nodeIds);
            nodeLogicalIds(model.nodeLogicalIds);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final Collection<String> getNodeIds() {
            if (nodeIds instanceof SdkAutoConstructList) {
                return null;
            }
            return nodeIds;
        }

        public final void setNodeIds(Collection<String> nodeIds) {
            this.nodeIds = ClusterNodeIdsCopier.copy(nodeIds);
        }

        @Override
        public final Builder nodeIds(Collection<String> nodeIds) {
            this.nodeIds = ClusterNodeIdsCopier.copy(nodeIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeIds(String... nodeIds) {
            nodeIds(Arrays.asList(nodeIds));
            return this;
        }

        public final Collection<String> getNodeLogicalIds() {
            if (nodeLogicalIds instanceof SdkAutoConstructList) {
                return null;
            }
            return nodeLogicalIds;
        }

        public final void setNodeLogicalIds(Collection<String> nodeLogicalIds) {
            this.nodeLogicalIds = ClusterNodeLogicalIdListCopier.copy(nodeLogicalIds);
        }

        @Override
        public final Builder nodeLogicalIds(Collection<String> nodeLogicalIds) {
            this.nodeLogicalIds = ClusterNodeLogicalIdListCopier.copy(nodeLogicalIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeLogicalIds(String... nodeLogicalIds) {
            nodeLogicalIds(Arrays.asList(nodeLogicalIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteClusterNodesRequest build() {
            return new BatchDeleteClusterNodesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
