/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CloudFormation template provider configuration for creating infrastructure resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CfnCreateTemplateProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<CfnCreateTemplateProvider.Builder, CfnCreateTemplateProvider> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(CfnCreateTemplateProvider::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateURL").getter(getter(CfnCreateTemplateProvider::templateURL))
            .setter(setter(Builder::templateURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateURL").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(CfnCreateTemplateProvider::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<List<CfnStackCreateParameter>> PARAMETERS_FIELD = SdkField
            .<List<CfnStackCreateParameter>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(CfnCreateTemplateProvider::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CfnStackCreateParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CfnStackCreateParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD,
            TEMPLATE_URL_FIELD, ROLE_ARN_FIELD, PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String templateName;

    private final String templateURL;

    private final String roleARN;

    private final List<CfnStackCreateParameter> parameters;

    private CfnCreateTemplateProvider(BuilderImpl builder) {
        this.templateName = builder.templateName;
        this.templateURL = builder.templateURL;
        this.roleARN = builder.roleARN;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * A unique identifier for the template within the project.
     * </p>
     * 
     * @return A unique identifier for the template within the project.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The Amazon S3 URL of the CloudFormation template.
     * </p>
     * 
     * @return The Amazon S3 URL of the CloudFormation template.
     */
    public final String templateURL() {
        return templateURL;
    }

    /**
     * <p>
     * The IAM role that CloudFormation assumes when creating the stack.
     * </p>
     * 
     * @return The IAM role that CloudFormation assumes when creating the stack.
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of CloudFormation stack parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return An array of CloudFormation stack parameters.
     */
    public final List<CfnStackCreateParameter> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(templateURL());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CfnCreateTemplateProvider)) {
            return false;
        }
        CfnCreateTemplateProvider other = (CfnCreateTemplateProvider) obj;
        return Objects.equals(templateName(), other.templateName()) && Objects.equals(templateURL(), other.templateURL())
                && Objects.equals(roleARN(), other.roleARN()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CfnCreateTemplateProvider").add("TemplateName", templateName())
                .add("TemplateURL", templateURL()).add("RoleARN", roleARN())
                .add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "TemplateURL":
            return Optional.ofNullable(clazz.cast(templateURL()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TemplateName", TEMPLATE_NAME_FIELD);
        map.put("TemplateURL", TEMPLATE_URL_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CfnCreateTemplateProvider, T> g) {
        return obj -> g.apply((CfnCreateTemplateProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CfnCreateTemplateProvider> {
        /**
         * <p>
         * A unique identifier for the template within the project.
         * </p>
         * 
         * @param templateName
         *        A unique identifier for the template within the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The Amazon S3 URL of the CloudFormation template.
         * </p>
         * 
         * @param templateURL
         *        The Amazon S3 URL of the CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateURL(String templateURL);

        /**
         * <p>
         * The IAM role that CloudFormation assumes when creating the stack.
         * </p>
         * 
         * @param roleARN
         *        The IAM role that CloudFormation assumes when creating the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * An array of CloudFormation stack parameters.
         * </p>
         * 
         * @param parameters
         *        An array of CloudFormation stack parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<CfnStackCreateParameter> parameters);

        /**
         * <p>
         * An array of CloudFormation stack parameters.
         * </p>
         * 
         * @param parameters
         *        An array of CloudFormation stack parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(CfnStackCreateParameter... parameters);

        /**
         * <p>
         * An array of CloudFormation stack parameters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.CfnStackCreateParameter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.CfnStackCreateParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.CfnStackCreateParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #parameters(List<CfnStackCreateParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.CfnStackCreateParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<CfnStackCreateParameter>)
         */
        Builder parameters(Consumer<CfnStackCreateParameter.Builder>... parameters);
    }

    static final class BuilderImpl implements Builder {
        private String templateName;

        private String templateURL;

        private String roleARN;

        private List<CfnStackCreateParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CfnCreateTemplateProvider model) {
            templateName(model.templateName);
            templateURL(model.templateURL);
            roleARN(model.roleARN);
            parameters(model.parameters);
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateURL() {
            return templateURL;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final List<CfnStackCreateParameter.Builder> getParameters() {
            List<CfnStackCreateParameter.Builder> result = CfnStackCreateParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<CfnStackCreateParameter.BuilderImpl> parameters) {
            this.parameters = CfnStackCreateParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<CfnStackCreateParameter> parameters) {
            this.parameters = CfnStackCreateParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(CfnStackCreateParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<CfnStackCreateParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> CfnStackCreateParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CfnCreateTemplateProvider build() {
            return new CfnCreateTemplateProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
