/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration details for updating an existing CloudFormation template provider in the project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CfnUpdateTemplateProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<CfnUpdateTemplateProvider.Builder, CfnUpdateTemplateProvider> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(CfnUpdateTemplateProvider::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateURL").getter(getter(CfnUpdateTemplateProvider::templateURL))
            .setter(setter(Builder::templateURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateURL").build()).build();

    private static final SdkField<List<CfnStackUpdateParameter>> PARAMETERS_FIELD = SdkField
            .<List<CfnStackUpdateParameter>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(CfnUpdateTemplateProvider::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CfnStackUpdateParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CfnStackUpdateParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD,
            TEMPLATE_URL_FIELD, PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String templateName;

    private final String templateURL;

    private final List<CfnStackUpdateParameter> parameters;

    private CfnUpdateTemplateProvider(BuilderImpl builder) {
        this.templateName = builder.templateName;
        this.templateURL = builder.templateURL;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The unique identifier of the template to update within the project.
     * </p>
     * 
     * @return The unique identifier of the template to update within the project.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The Amazon S3 URL of the CloudFormation template.
     * </p>
     * 
     * @return The Amazon S3 URL of the CloudFormation template.
     */
    public final String templateURL() {
        return templateURL;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of CloudFormation stack parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return An array of CloudFormation stack parameters.
     */
    public final List<CfnStackUpdateParameter> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(templateURL());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CfnUpdateTemplateProvider)) {
            return false;
        }
        CfnUpdateTemplateProvider other = (CfnUpdateTemplateProvider) obj;
        return Objects.equals(templateName(), other.templateName()) && Objects.equals(templateURL(), other.templateURL())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CfnUpdateTemplateProvider").add("TemplateName", templateName())
                .add("TemplateURL", templateURL()).add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "TemplateURL":
            return Optional.ofNullable(clazz.cast(templateURL()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TemplateName", TEMPLATE_NAME_FIELD);
        map.put("TemplateURL", TEMPLATE_URL_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CfnUpdateTemplateProvider, T> g) {
        return obj -> g.apply((CfnUpdateTemplateProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CfnUpdateTemplateProvider> {
        /**
         * <p>
         * The unique identifier of the template to update within the project.
         * </p>
         * 
         * @param templateName
         *        The unique identifier of the template to update within the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The Amazon S3 URL of the CloudFormation template.
         * </p>
         * 
         * @param templateURL
         *        The Amazon S3 URL of the CloudFormation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateURL(String templateURL);

        /**
         * <p>
         * An array of CloudFormation stack parameters.
         * </p>
         * 
         * @param parameters
         *        An array of CloudFormation stack parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<CfnStackUpdateParameter> parameters);

        /**
         * <p>
         * An array of CloudFormation stack parameters.
         * </p>
         * 
         * @param parameters
         *        An array of CloudFormation stack parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(CfnStackUpdateParameter... parameters);

        /**
         * <p>
         * An array of CloudFormation stack parameters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.CfnStackUpdateParameter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.CfnStackUpdateParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.CfnStackUpdateParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #parameters(List<CfnStackUpdateParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.CfnStackUpdateParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<CfnStackUpdateParameter>)
         */
        Builder parameters(Consumer<CfnStackUpdateParameter.Builder>... parameters);
    }

    static final class BuilderImpl implements Builder {
        private String templateName;

        private String templateURL;

        private List<CfnStackUpdateParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CfnUpdateTemplateProvider model) {
            templateName(model.templateName);
            templateURL(model.templateURL);
            parameters(model.parameters);
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateURL() {
            return templateURL;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final List<CfnStackUpdateParameter.Builder> getParameters() {
            List<CfnStackUpdateParameter.Builder> result = CfnStackUpdateParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<CfnStackUpdateParameter.BuilderImpl> parameters) {
            this.parameters = CfnStackUpdateParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<CfnStackUpdateParameter> parameters) {
            this.parameters = CfnStackUpdateParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(CfnStackUpdateParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<CfnStackUpdateParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> CfnStackUpdateParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CfnUpdateTemplateProvider build() {
            return new CfnUpdateTemplateProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
