/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration parameters for the SageMaker Clarify explainer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClarifyExplainerConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ClarifyExplainerConfig.Builder, ClarifyExplainerConfig> {
    private static final SdkField<String> ENABLE_EXPLANATIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnableExplanations").getter(getter(ClarifyExplainerConfig::enableExplanations))
            .setter(setter(Builder::enableExplanations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableExplanations").build())
            .build();

    private static final SdkField<ClarifyInferenceConfig> INFERENCE_CONFIG_FIELD = SdkField
            .<ClarifyInferenceConfig> builder(MarshallingType.SDK_POJO).memberName("InferenceConfig")
            .getter(getter(ClarifyExplainerConfig::inferenceConfig)).setter(setter(Builder::inferenceConfig))
            .constructor(ClarifyInferenceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceConfig").build()).build();

    private static final SdkField<ClarifyShapConfig> SHAP_CONFIG_FIELD = SdkField
            .<ClarifyShapConfig> builder(MarshallingType.SDK_POJO).memberName("ShapConfig")
            .getter(getter(ClarifyExplainerConfig::shapConfig)).setter(setter(Builder::shapConfig))
            .constructor(ClarifyShapConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShapConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_EXPLANATIONS_FIELD,
            INFERENCE_CONFIG_FIELD, SHAP_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String enableExplanations;

    private final ClarifyInferenceConfig inferenceConfig;

    private final ClarifyShapConfig shapConfig;

    private ClarifyExplainerConfig(BuilderImpl builder) {
        this.enableExplanations = builder.enableExplanations;
        this.inferenceConfig = builder.inferenceConfig;
        this.shapConfig = builder.shapConfig;
    }

    /**
     * <p>
     * A JMESPath boolean expression used to filter which records to explain. Explanations are activated by default. See
     * <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-enable"
     * > <code>EnableExplanations</code> </a>for additional information.
     * </p>
     * 
     * @return A JMESPath boolean expression used to filter which records to explain. Explanations are activated by
     *         default. See <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-enable"
     *         > <code>EnableExplanations</code> </a>for additional information.
     */
    public final String enableExplanations() {
        return enableExplanations;
    }

    /**
     * <p>
     * The inference configuration parameter for the model container.
     * </p>
     * 
     * @return The inference configuration parameter for the model container.
     */
    public final ClarifyInferenceConfig inferenceConfig() {
        return inferenceConfig;
    }

    /**
     * <p>
     * The configuration for SHAP analysis.
     * </p>
     * 
     * @return The configuration for SHAP analysis.
     */
    public final ClarifyShapConfig shapConfig() {
        return shapConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableExplanations());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(shapConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClarifyExplainerConfig)) {
            return false;
        }
        ClarifyExplainerConfig other = (ClarifyExplainerConfig) obj;
        return Objects.equals(enableExplanations(), other.enableExplanations())
                && Objects.equals(inferenceConfig(), other.inferenceConfig()) && Objects.equals(shapConfig(), other.shapConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClarifyExplainerConfig").add("EnableExplanations", enableExplanations())
                .add("InferenceConfig", inferenceConfig()).add("ShapConfig", shapConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableExplanations":
            return Optional.ofNullable(clazz.cast(enableExplanations()));
        case "InferenceConfig":
            return Optional.ofNullable(clazz.cast(inferenceConfig()));
        case "ShapConfig":
            return Optional.ofNullable(clazz.cast(shapConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnableExplanations", ENABLE_EXPLANATIONS_FIELD);
        map.put("InferenceConfig", INFERENCE_CONFIG_FIELD);
        map.put("ShapConfig", SHAP_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClarifyExplainerConfig, T> g) {
        return obj -> g.apply((ClarifyExplainerConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClarifyExplainerConfig> {
        /**
         * <p>
         * A JMESPath boolean expression used to filter which records to explain. Explanations are activated by default.
         * See <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-enable"
         * > <code>EnableExplanations</code> </a>for additional information.
         * </p>
         * 
         * @param enableExplanations
         *        A JMESPath boolean expression used to filter which records to explain. Explanations are activated by
         *        default. See <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/clarify-online-explainability-create-endpoint.html#clarify-online-explainability-create-endpoint-enable"
         *        > <code>EnableExplanations</code> </a>for additional information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableExplanations(String enableExplanations);

        /**
         * <p>
         * The inference configuration parameter for the model container.
         * </p>
         * 
         * @param inferenceConfig
         *        The inference configuration parameter for the model container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceConfig(ClarifyInferenceConfig inferenceConfig);

        /**
         * <p>
         * The inference configuration parameter for the model container.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClarifyInferenceConfig.Builder} avoiding
         * the need to create one manually via {@link ClarifyInferenceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClarifyInferenceConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #inferenceConfig(ClarifyInferenceConfig)}.
         * 
         * @param inferenceConfig
         *        a consumer that will call methods on {@link ClarifyInferenceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceConfig(ClarifyInferenceConfig)
         */
        default Builder inferenceConfig(Consumer<ClarifyInferenceConfig.Builder> inferenceConfig) {
            return inferenceConfig(ClarifyInferenceConfig.builder().applyMutation(inferenceConfig).build());
        }

        /**
         * <p>
         * The configuration for SHAP analysis.
         * </p>
         * 
         * @param shapConfig
         *        The configuration for SHAP analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shapConfig(ClarifyShapConfig shapConfig);

        /**
         * <p>
         * The configuration for SHAP analysis.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClarifyShapConfig.Builder} avoiding the
         * need to create one manually via {@link ClarifyShapConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClarifyShapConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #shapConfig(ClarifyShapConfig)}.
         * 
         * @param shapConfig
         *        a consumer that will call methods on {@link ClarifyShapConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shapConfig(ClarifyShapConfig)
         */
        default Builder shapConfig(Consumer<ClarifyShapConfig.Builder> shapConfig) {
            return shapConfig(ClarifyShapConfig.builder().applyMutation(shapConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String enableExplanations;

        private ClarifyInferenceConfig inferenceConfig;

        private ClarifyShapConfig shapConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ClarifyExplainerConfig model) {
            enableExplanations(model.enableExplanations);
            inferenceConfig(model.inferenceConfig);
            shapConfig(model.shapConfig);
        }

        public final String getEnableExplanations() {
            return enableExplanations;
        }

        public final void setEnableExplanations(String enableExplanations) {
            this.enableExplanations = enableExplanations;
        }

        @Override
        public final Builder enableExplanations(String enableExplanations) {
            this.enableExplanations = enableExplanations;
            return this;
        }

        public final ClarifyInferenceConfig.Builder getInferenceConfig() {
            return inferenceConfig != null ? inferenceConfig.toBuilder() : null;
        }

        public final void setInferenceConfig(ClarifyInferenceConfig.BuilderImpl inferenceConfig) {
            this.inferenceConfig = inferenceConfig != null ? inferenceConfig.build() : null;
        }

        @Override
        public final Builder inferenceConfig(ClarifyInferenceConfig inferenceConfig) {
            this.inferenceConfig = inferenceConfig;
            return this;
        }

        public final ClarifyShapConfig.Builder getShapConfig() {
            return shapConfig != null ? shapConfig.toBuilder() : null;
        }

        public final void setShapConfig(ClarifyShapConfig.BuilderImpl shapConfig) {
            this.shapConfig = shapConfig != null ? shapConfig.build() : null;
        }

        @Override
        public final Builder shapConfig(ClarifyShapConfig shapConfig) {
            this.shapConfig = shapConfig;
            return this;
        }

        @Override
        public ClarifyExplainerConfig build() {
            return new ClarifyExplainerConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
