/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the autoscaling configuration for a HyperPod cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterAutoScalingConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterAutoScalingConfig.Builder, ClusterAutoScalingConfig> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(ClusterAutoScalingConfig::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<String> AUTO_SCALER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalerType").getter(getter(ClusterAutoScalingConfig::autoScalerTypeAsString))
            .setter(setter(Builder::autoScalerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalerType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD,
            AUTO_SCALER_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mode;

    private final String autoScalerType;

    private ClusterAutoScalingConfig(BuilderImpl builder) {
        this.mode = builder.mode;
        this.autoScalerType = builder.autoScalerType;
    }

    /**
     * <p>
     * Describes whether autoscaling is enabled or disabled for the cluster. Valid values are <code>Enable</code> and
     * <code>Disable</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ClusterAutoScalingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Describes whether autoscaling is enabled or disabled for the cluster. Valid values are
     *         <code>Enable</code> and <code>Disable</code>.
     * @see ClusterAutoScalingMode
     */
    public final ClusterAutoScalingMode mode() {
        return ClusterAutoScalingMode.fromValue(mode);
    }

    /**
     * <p>
     * Describes whether autoscaling is enabled or disabled for the cluster. Valid values are <code>Enable</code> and
     * <code>Disable</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ClusterAutoScalingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Describes whether autoscaling is enabled or disabled for the cluster. Valid values are
     *         <code>Enable</code> and <code>Disable</code>.
     * @see ClusterAutoScalingMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The type of autoscaler to use. Currently supported value is <code>Karpenter</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoScalerType}
     * will return {@link ClusterAutoScalerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #autoScalerTypeAsString}.
     * </p>
     * 
     * @return The type of autoscaler to use. Currently supported value is <code>Karpenter</code>.
     * @see ClusterAutoScalerType
     */
    public final ClusterAutoScalerType autoScalerType() {
        return ClusterAutoScalerType.fromValue(autoScalerType);
    }

    /**
     * <p>
     * The type of autoscaler to use. Currently supported value is <code>Karpenter</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoScalerType}
     * will return {@link ClusterAutoScalerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #autoScalerTypeAsString}.
     * </p>
     * 
     * @return The type of autoscaler to use. Currently supported value is <code>Karpenter</code>.
     * @see ClusterAutoScalerType
     */
    public final String autoScalerTypeAsString() {
        return autoScalerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalerTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterAutoScalingConfig)) {
            return false;
        }
        ClusterAutoScalingConfig other = (ClusterAutoScalingConfig) obj;
        return Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(autoScalerTypeAsString(), other.autoScalerTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterAutoScalingConfig").add("Mode", modeAsString())
                .add("AutoScalerType", autoScalerTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "AutoScalerType":
            return Optional.ofNullable(clazz.cast(autoScalerTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Mode", MODE_FIELD);
        map.put("AutoScalerType", AUTO_SCALER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterAutoScalingConfig, T> g) {
        return obj -> g.apply((ClusterAutoScalingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterAutoScalingConfig> {
        /**
         * <p>
         * Describes whether autoscaling is enabled or disabled for the cluster. Valid values are <code>Enable</code>
         * and <code>Disable</code>.
         * </p>
         * 
         * @param mode
         *        Describes whether autoscaling is enabled or disabled for the cluster. Valid values are
         *        <code>Enable</code> and <code>Disable</code>.
         * @see ClusterAutoScalingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterAutoScalingMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * Describes whether autoscaling is enabled or disabled for the cluster. Valid values are <code>Enable</code>
         * and <code>Disable</code>.
         * </p>
         * 
         * @param mode
         *        Describes whether autoscaling is enabled or disabled for the cluster. Valid values are
         *        <code>Enable</code> and <code>Disable</code>.
         * @see ClusterAutoScalingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterAutoScalingMode
         */
        Builder mode(ClusterAutoScalingMode mode);

        /**
         * <p>
         * The type of autoscaler to use. Currently supported value is <code>Karpenter</code>.
         * </p>
         * 
         * @param autoScalerType
         *        The type of autoscaler to use. Currently supported value is <code>Karpenter</code>.
         * @see ClusterAutoScalerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterAutoScalerType
         */
        Builder autoScalerType(String autoScalerType);

        /**
         * <p>
         * The type of autoscaler to use. Currently supported value is <code>Karpenter</code>.
         * </p>
         * 
         * @param autoScalerType
         *        The type of autoscaler to use. Currently supported value is <code>Karpenter</code>.
         * @see ClusterAutoScalerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterAutoScalerType
         */
        Builder autoScalerType(ClusterAutoScalerType autoScalerType);
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private String autoScalerType;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterAutoScalingConfig model) {
            mode(model.mode);
            autoScalerType(model.autoScalerType);
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ClusterAutoScalingMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getAutoScalerType() {
            return autoScalerType;
        }

        public final void setAutoScalerType(String autoScalerType) {
            this.autoScalerType = autoScalerType;
        }

        @Override
        public final Builder autoScalerType(String autoScalerType) {
            this.autoScalerType = autoScalerType;
            return this;
        }

        @Override
        public final Builder autoScalerType(ClusterAutoScalerType autoScalerType) {
            this.autoScalerType(autoScalerType == null ? null : autoScalerType.toString());
            return this;
        }

        @Override
        public ClusterAutoScalingConfig build() {
            return new ClusterAutoScalingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
