/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The autoscaling configuration and status information for a HyperPod cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterAutoScalingConfigOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterAutoScalingConfigOutput.Builder, ClusterAutoScalingConfigOutput> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(ClusterAutoScalingConfigOutput::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<String> AUTO_SCALER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalerType").getter(getter(ClusterAutoScalingConfigOutput::autoScalerTypeAsString))
            .setter(setter(Builder::autoScalerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalerType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ClusterAutoScalingConfigOutput::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMessage").getter(getter(ClusterAutoScalingConfigOutput::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD,
            AUTO_SCALER_TYPE_FIELD, STATUS_FIELD, FAILURE_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mode;

    private final String autoScalerType;

    private final String status;

    private final String failureMessage;

    private ClusterAutoScalingConfigOutput(BuilderImpl builder) {
        this.mode = builder.mode;
        this.autoScalerType = builder.autoScalerType;
        this.status = builder.status;
        this.failureMessage = builder.failureMessage;
    }

    /**
     * <p>
     * Describes whether autoscaling is enabled or disabled for the cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ClusterAutoScalingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Describes whether autoscaling is enabled or disabled for the cluster.
     * @see ClusterAutoScalingMode
     */
    public final ClusterAutoScalingMode mode() {
        return ClusterAutoScalingMode.fromValue(mode);
    }

    /**
     * <p>
     * Describes whether autoscaling is enabled or disabled for the cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ClusterAutoScalingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Describes whether autoscaling is enabled or disabled for the cluster.
     * @see ClusterAutoScalingMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The type of autoscaler configured for the cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoScalerType}
     * will return {@link ClusterAutoScalerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #autoScalerTypeAsString}.
     * </p>
     * 
     * @return The type of autoscaler configured for the cluster.
     * @see ClusterAutoScalerType
     */
    public final ClusterAutoScalerType autoScalerType() {
        return ClusterAutoScalerType.fromValue(autoScalerType);
    }

    /**
     * <p>
     * The type of autoscaler configured for the cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoScalerType}
     * will return {@link ClusterAutoScalerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #autoScalerTypeAsString}.
     * </p>
     * 
     * @return The type of autoscaler configured for the cluster.
     * @see ClusterAutoScalerType
     */
    public final String autoScalerTypeAsString() {
        return autoScalerType;
    }

    /**
     * <p>
     * The current status of the autoscaling configuration. Valid values are <code>InService</code>, <code>Failed</code>, <code>Creating</code>, and <code>Deleting</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ClusterAutoScalingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the autoscaling configuration. Valid values are <code>InService</code>,
     *         <code>Failed</code>, <code>Creating</code>, and <code>Deleting</code>.
     * @see ClusterAutoScalingStatus
     */
    public final ClusterAutoScalingStatus status() {
        return ClusterAutoScalingStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the autoscaling configuration. Valid values are <code>InService</code>, <code>Failed</code>, <code>Creating</code>, and <code>Deleting</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ClusterAutoScalingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the autoscaling configuration. Valid values are <code>InService</code>,
     *         <code>Failed</code>, <code>Creating</code>, and <code>Deleting</code>.
     * @see ClusterAutoScalingStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * If the autoscaling status is <code>Failed</code>, this field contains a message describing the failure.
     * </p>
     * 
     * @return If the autoscaling status is <code>Failed</code>, this field contains a message describing the failure.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterAutoScalingConfigOutput)) {
            return false;
        }
        ClusterAutoScalingConfigOutput other = (ClusterAutoScalingConfigOutput) obj;
        return Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(autoScalerTypeAsString(), other.autoScalerTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureMessage(), other.failureMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterAutoScalingConfigOutput").add("Mode", modeAsString())
                .add("AutoScalerType", autoScalerTypeAsString()).add("Status", statusAsString())
                .add("FailureMessage", failureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "AutoScalerType":
            return Optional.ofNullable(clazz.cast(autoScalerTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "FailureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Mode", MODE_FIELD);
        map.put("AutoScalerType", AUTO_SCALER_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("FailureMessage", FAILURE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterAutoScalingConfigOutput, T> g) {
        return obj -> g.apply((ClusterAutoScalingConfigOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterAutoScalingConfigOutput> {
        /**
         * <p>
         * Describes whether autoscaling is enabled or disabled for the cluster.
         * </p>
         * 
         * @param mode
         *        Describes whether autoscaling is enabled or disabled for the cluster.
         * @see ClusterAutoScalingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterAutoScalingMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * Describes whether autoscaling is enabled or disabled for the cluster.
         * </p>
         * 
         * @param mode
         *        Describes whether autoscaling is enabled or disabled for the cluster.
         * @see ClusterAutoScalingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterAutoScalingMode
         */
        Builder mode(ClusterAutoScalingMode mode);

        /**
         * <p>
         * The type of autoscaler configured for the cluster.
         * </p>
         * 
         * @param autoScalerType
         *        The type of autoscaler configured for the cluster.
         * @see ClusterAutoScalerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterAutoScalerType
         */
        Builder autoScalerType(String autoScalerType);

        /**
         * <p>
         * The type of autoscaler configured for the cluster.
         * </p>
         * 
         * @param autoScalerType
         *        The type of autoscaler configured for the cluster.
         * @see ClusterAutoScalerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterAutoScalerType
         */
        Builder autoScalerType(ClusterAutoScalerType autoScalerType);

        /**
         * <p>
         * The current status of the autoscaling configuration. Valid values are <code>InService</code>,
         * <code>Failed</code>, <code>Creating</code>, and <code>Deleting</code>.
         * </p>
         * 
         * @param status
         *        The current status of the autoscaling configuration. Valid values are <code>InService</code>,
         *        <code>Failed</code>, <code>Creating</code>, and <code>Deleting</code>.
         * @see ClusterAutoScalingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterAutoScalingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the autoscaling configuration. Valid values are <code>InService</code>,
         * <code>Failed</code>, <code>Creating</code>, and <code>Deleting</code>.
         * </p>
         * 
         * @param status
         *        The current status of the autoscaling configuration. Valid values are <code>InService</code>,
         *        <code>Failed</code>, <code>Creating</code>, and <code>Deleting</code>.
         * @see ClusterAutoScalingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterAutoScalingStatus
         */
        Builder status(ClusterAutoScalingStatus status);

        /**
         * <p>
         * If the autoscaling status is <code>Failed</code>, this field contains a message describing the failure.
         * </p>
         * 
         * @param failureMessage
         *        If the autoscaling status is <code>Failed</code>, this field contains a message describing the
         *        failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private String autoScalerType;

        private String status;

        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterAutoScalingConfigOutput model) {
            mode(model.mode);
            autoScalerType(model.autoScalerType);
            status(model.status);
            failureMessage(model.failureMessage);
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ClusterAutoScalingMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getAutoScalerType() {
            return autoScalerType;
        }

        public final void setAutoScalerType(String autoScalerType) {
            this.autoScalerType = autoScalerType;
        }

        @Override
        public final Builder autoScalerType(String autoScalerType) {
            this.autoScalerType = autoScalerType;
            return this;
        }

        @Override
        public final Builder autoScalerType(ClusterAutoScalerType autoScalerType) {
            this.autoScalerType(autoScalerType == null ? null : autoScalerType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClusterAutoScalingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        @Override
        public ClusterAutoScalingConfigOutput build() {
            return new ClusterAutoScalingConfigOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
