/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information about a specific event in a HyperPod cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterEventDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterEventDetail.Builder, ClusterEventDetail> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventId").getter(getter(ClusterEventDetail::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(ClusterEventDetail::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(ClusterEventDetail::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceGroupName").getter(getter(ClusterEventDetail::instanceGroupName))
            .setter(setter(Builder::instanceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(ClusterEventDetail::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ClusterEventDetail::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EventTime").getter(getter(ClusterEventDetail::eventTime)).setter(setter(Builder::eventTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTime").build()).build();

    private static final SdkField<EventDetails> EVENT_DETAILS_FIELD = SdkField.<EventDetails> builder(MarshallingType.SDK_POJO)
            .memberName("EventDetails").getter(getter(ClusterEventDetail::eventDetails)).setter(setter(Builder::eventDetails))
            .constructor(EventDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDetails").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ClusterEventDetail::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD,
            CLUSTER_ARN_FIELD, CLUSTER_NAME_FIELD, INSTANCE_GROUP_NAME_FIELD, INSTANCE_ID_FIELD, RESOURCE_TYPE_FIELD,
            EVENT_TIME_FIELD, EVENT_DETAILS_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String eventId;

    private final String clusterArn;

    private final String clusterName;

    private final String instanceGroupName;

    private final String instanceId;

    private final String resourceType;

    private final Instant eventTime;

    private final EventDetails eventDetails;

    private final String description;

    private ClusterEventDetail(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.clusterArn = builder.clusterArn;
        this.clusterName = builder.clusterName;
        this.instanceGroupName = builder.instanceGroupName;
        this.instanceId = builder.instanceId;
        this.resourceType = builder.resourceType;
        this.eventTime = builder.eventTime;
        this.eventDetails = builder.eventDetails;
        this.description = builder.description;
    }

    /**
     * <p>
     * The unique identifier (UUID) of the event.
     * </p>
     * 
     * @return The unique identifier (UUID) of the event.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the HyperPod cluster associated with the event.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the HyperPod cluster associated with the event.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The name of the HyperPod cluster associated with the event.
     * </p>
     * 
     * @return The name of the HyperPod cluster associated with the event.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The name of the instance group associated with the event, if applicable.
     * </p>
     * 
     * @return The name of the instance group associated with the event, if applicable.
     */
    public final String instanceGroupName() {
        return instanceGroupName;
    }

    /**
     * <p>
     * The EC2 instance ID associated with the event, if applicable.
     * </p>
     * 
     * @return The EC2 instance ID associated with the event, if applicable.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The type of resource associated with the event. Valid values are <code>Cluster</code>, <code>InstanceGroup</code>
     * , or <code>Instance</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ClusterEventResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource associated with the event. Valid values are <code>Cluster</code>,
     *         <code>InstanceGroup</code>, or <code>Instance</code>.
     * @see ClusterEventResourceType
     */
    public final ClusterEventResourceType resourceType() {
        return ClusterEventResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource associated with the event. Valid values are <code>Cluster</code>, <code>InstanceGroup</code>
     * , or <code>Instance</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ClusterEventResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource associated with the event. Valid values are <code>Cluster</code>,
     *         <code>InstanceGroup</code>, or <code>Instance</code>.
     * @see ClusterEventResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The timestamp when the event occurred.
     * </p>
     * 
     * @return The timestamp when the event occurred.
     */
    public final Instant eventTime() {
        return eventTime;
    }

    /**
     * <p>
     * Additional details about the event, including event-specific metadata.
     * </p>
     * 
     * @return Additional details about the event, including event-specific metadata.
     */
    public final EventDetails eventDetails() {
        return eventDetails;
    }

    /**
     * <p>
     * A human-readable description of the event.
     * </p>
     * 
     * @return A human-readable description of the event.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(eventDetails());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterEventDetail)) {
            return false;
        }
        ClusterEventDetail other = (ClusterEventDetail) obj;
        return Objects.equals(eventId(), other.eventId()) && Objects.equals(clusterArn(), other.clusterArn())
                && Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(instanceGroupName(), other.instanceGroupName())
                && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(eventTime(), other.eventTime()) && Objects.equals(eventDetails(), other.eventDetails())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterEventDetail").add("EventId", eventId()).add("ClusterArn", clusterArn())
                .add("ClusterName", clusterName()).add("InstanceGroupName", instanceGroupName()).add("InstanceId", instanceId())
                .add("ResourceType", resourceTypeAsString()).add("EventTime", eventTime()).add("EventDetails", eventDetails())
                .add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "InstanceGroupName":
            return Optional.ofNullable(clazz.cast(instanceGroupName()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "EventTime":
            return Optional.ofNullable(clazz.cast(eventTime()));
        case "EventDetails":
            return Optional.ofNullable(clazz.cast(eventDetails()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventId", EVENT_ID_FIELD);
        map.put("ClusterArn", CLUSTER_ARN_FIELD);
        map.put("ClusterName", CLUSTER_NAME_FIELD);
        map.put("InstanceGroupName", INSTANCE_GROUP_NAME_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("EventTime", EVENT_TIME_FIELD);
        map.put("EventDetails", EVENT_DETAILS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterEventDetail, T> g) {
        return obj -> g.apply((ClusterEventDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterEventDetail> {
        /**
         * <p>
         * The unique identifier (UUID) of the event.
         * </p>
         * 
         * @param eventId
         *        The unique identifier (UUID) of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the HyperPod cluster associated with the event.
         * </p>
         * 
         * @param clusterArn
         *        The Amazon Resource Name (ARN) of the HyperPod cluster associated with the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The name of the HyperPod cluster associated with the event.
         * </p>
         * 
         * @param clusterName
         *        The name of the HyperPod cluster associated with the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The name of the instance group associated with the event, if applicable.
         * </p>
         * 
         * @param instanceGroupName
         *        The name of the instance group associated with the event, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupName(String instanceGroupName);

        /**
         * <p>
         * The EC2 instance ID associated with the event, if applicable.
         * </p>
         * 
         * @param instanceId
         *        The EC2 instance ID associated with the event, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The type of resource associated with the event. Valid values are <code>Cluster</code>,
         * <code>InstanceGroup</code>, or <code>Instance</code>.
         * </p>
         * 
         * @param resourceType
         *        The type of resource associated with the event. Valid values are <code>Cluster</code>,
         *        <code>InstanceGroup</code>, or <code>Instance</code>.
         * @see ClusterEventResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterEventResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource associated with the event. Valid values are <code>Cluster</code>,
         * <code>InstanceGroup</code>, or <code>Instance</code>.
         * </p>
         * 
         * @param resourceType
         *        The type of resource associated with the event. Valid values are <code>Cluster</code>,
         *        <code>InstanceGroup</code>, or <code>Instance</code>.
         * @see ClusterEventResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterEventResourceType
         */
        Builder resourceType(ClusterEventResourceType resourceType);

        /**
         * <p>
         * The timestamp when the event occurred.
         * </p>
         * 
         * @param eventTime
         *        The timestamp when the event occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTime(Instant eventTime);

        /**
         * <p>
         * Additional details about the event, including event-specific metadata.
         * </p>
         * 
         * @param eventDetails
         *        Additional details about the event, including event-specific metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDetails(EventDetails eventDetails);

        /**
         * <p>
         * Additional details about the event, including event-specific metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventDetails.Builder} avoiding the need
         * to create one manually via {@link EventDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #eventDetails(EventDetails)}.
         * 
         * @param eventDetails
         *        a consumer that will call methods on {@link EventDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventDetails(EventDetails)
         */
        default Builder eventDetails(Consumer<EventDetails.Builder> eventDetails) {
            return eventDetails(EventDetails.builder().applyMutation(eventDetails).build());
        }

        /**
         * <p>
         * A human-readable description of the event.
         * </p>
         * 
         * @param description
         *        A human-readable description of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String eventId;

        private String clusterArn;

        private String clusterName;

        private String instanceGroupName;

        private String instanceId;

        private String resourceType;

        private Instant eventTime;

        private EventDetails eventDetails;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterEventDetail model) {
            eventId(model.eventId);
            clusterArn(model.clusterArn);
            clusterName(model.clusterName);
            instanceGroupName(model.instanceGroupName);
            instanceId(model.instanceId);
            resourceType(model.resourceType);
            eventTime(model.eventTime);
            eventDetails(model.eventDetails);
            description(model.description);
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getInstanceGroupName() {
            return instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ClusterEventResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Instant getEventTime() {
            return eventTime;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final EventDetails.Builder getEventDetails() {
            return eventDetails != null ? eventDetails.toBuilder() : null;
        }

        public final void setEventDetails(EventDetails.BuilderImpl eventDetails) {
            this.eventDetails = eventDetails != null ? eventDetails.build() : null;
        }

        @Override
        public final Builder eventDetails(EventDetails eventDetails) {
            this.eventDetails = eventDetails;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public ClusterEventDetail build() {
            return new ClusterEventDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
