/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration of the resources used for the compute allocation definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeQuotaResourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputeQuotaResourceConfig.Builder, ComputeQuotaResourceConfig> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(ComputeQuotaResourceConfig::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Count")
            .getter(getter(ComputeQuotaResourceConfig::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()).build();

    private static final SdkField<Integer> ACCELERATORS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Accelerators").getter(getter(ComputeQuotaResourceConfig::accelerators))
            .setter(setter(Builder::accelerators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accelerators").build()).build();

    private static final SdkField<Float> V_CPU_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT).memberName("VCpu")
            .getter(getter(ComputeQuotaResourceConfig::vCpu)).setter(setter(Builder::vCpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VCpu").build()).build();

    private static final SdkField<Float> MEMORY_IN_GIB_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("MemoryInGiB").getter(getter(ComputeQuotaResourceConfig::memoryInGiB))
            .setter(setter(Builder::memoryInGiB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryInGiB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD,
            COUNT_FIELD, ACCELERATORS_FIELD, V_CPU_FIELD, MEMORY_IN_GIB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceType;

    private final Integer count;

    private final Integer accelerators;

    private final Float vCpu;

    private final Float memoryInGiB;

    private ComputeQuotaResourceConfig(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.count = builder.count;
        this.accelerators = builder.accelerators;
        this.vCpu = builder.vCpu;
        this.memoryInGiB = builder.memoryInGiB;
    }

    /**
     * <p>
     * The instance type of the instance group for the cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ClusterInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type of the instance group for the cluster.
     * @see ClusterInstanceType
     */
    public final ClusterInstanceType instanceType() {
        return ClusterInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type of the instance group for the cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ClusterInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type of the instance group for the cluster.
     * @see ClusterInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The number of instances to add to the instance group of a SageMaker HyperPod cluster.
     * </p>
     * 
     * @return The number of instances to add to the instance group of a SageMaker HyperPod cluster.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The number of accelerators to allocate. If you don't specify a value for vCPU and MemoryInGiB, SageMaker AI
     * automatically allocates ratio-based values for those parameters based on the number of accelerators you provide.
     * For example, if you allocate 16 out of 32 total accelerators, SageMaker AI uses the ratio of 0.5 and allocates
     * values to vCPU and MemoryInGiB.
     * </p>
     * 
     * @return The number of accelerators to allocate. If you don't specify a value for vCPU and MemoryInGiB, SageMaker
     *         AI automatically allocates ratio-based values for those parameters based on the number of accelerators
     *         you provide. For example, if you allocate 16 out of 32 total accelerators, SageMaker AI uses the ratio of
     *         0.5 and allocates values to vCPU and MemoryInGiB.
     */
    public final Integer accelerators() {
        return accelerators;
    }

    /**
     * <p>
     * The number of vCPU to allocate. If you specify a value only for vCPU, SageMaker AI automatically allocates
     * ratio-based values for MemoryInGiB based on this vCPU parameter. For example, if you allocate 20 out of 40 total
     * vCPU, SageMaker AI uses the ratio of 0.5 and allocates values to MemoryInGiB. Accelerators are set to 0.
     * </p>
     * 
     * @return The number of vCPU to allocate. If you specify a value only for vCPU, SageMaker AI automatically
     *         allocates ratio-based values for MemoryInGiB based on this vCPU parameter. For example, if you allocate
     *         20 out of 40 total vCPU, SageMaker AI uses the ratio of 0.5 and allocates values to MemoryInGiB.
     *         Accelerators are set to 0.
     */
    public final Float vCpu() {
        return vCpu;
    }

    /**
     * <p>
     * The amount of memory in GiB to allocate. If you specify a value only for this parameter, SageMaker AI
     * automatically allocates a ratio-based value for vCPU based on this memory that you provide. For example, if you
     * allocate 200 out of 400 total memory in GiB, SageMaker AI uses the ratio of 0.5 and allocates values to vCPU.
     * Accelerators are set to 0.
     * </p>
     * 
     * @return The amount of memory in GiB to allocate. If you specify a value only for this parameter, SageMaker AI
     *         automatically allocates a ratio-based value for vCPU based on this memory that you provide. For example,
     *         if you allocate 200 out of 400 total memory in GiB, SageMaker AI uses the ratio of 0.5 and allocates
     *         values to vCPU. Accelerators are set to 0.
     */
    public final Float memoryInGiB() {
        return memoryInGiB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(accelerators());
        hashCode = 31 * hashCode + Objects.hashCode(vCpu());
        hashCode = 31 * hashCode + Objects.hashCode(memoryInGiB());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeQuotaResourceConfig)) {
            return false;
        }
        ComputeQuotaResourceConfig other = (ComputeQuotaResourceConfig) obj;
        return Objects.equals(instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(count(), other.count())
                && Objects.equals(accelerators(), other.accelerators()) && Objects.equals(vCpu(), other.vCpu())
                && Objects.equals(memoryInGiB(), other.memoryInGiB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputeQuotaResourceConfig").add("InstanceType", instanceTypeAsString()).add("Count", count())
                .add("Accelerators", accelerators()).add("VCpu", vCpu()).add("MemoryInGiB", memoryInGiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "Accelerators":
            return Optional.ofNullable(clazz.cast(accelerators()));
        case "VCpu":
            return Optional.ofNullable(clazz.cast(vCpu()));
        case "MemoryInGiB":
            return Optional.ofNullable(clazz.cast(memoryInGiB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("Count", COUNT_FIELD);
        map.put("Accelerators", ACCELERATORS_FIELD);
        map.put("VCpu", V_CPU_FIELD);
        map.put("MemoryInGiB", MEMORY_IN_GIB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputeQuotaResourceConfig, T> g) {
        return obj -> g.apply((ComputeQuotaResourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeQuotaResourceConfig> {
        /**
         * <p>
         * The instance type of the instance group for the cluster.
         * </p>
         * 
         * @param instanceType
         *        The instance type of the instance group for the cluster.
         * @see ClusterInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type of the instance group for the cluster.
         * </p>
         * 
         * @param instanceType
         *        The instance type of the instance group for the cluster.
         * @see ClusterInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterInstanceType
         */
        Builder instanceType(ClusterInstanceType instanceType);

        /**
         * <p>
         * The number of instances to add to the instance group of a SageMaker HyperPod cluster.
         * </p>
         * 
         * @param count
         *        The number of instances to add to the instance group of a SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The number of accelerators to allocate. If you don't specify a value for vCPU and MemoryInGiB, SageMaker AI
         * automatically allocates ratio-based values for those parameters based on the number of accelerators you
         * provide. For example, if you allocate 16 out of 32 total accelerators, SageMaker AI uses the ratio of 0.5 and
         * allocates values to vCPU and MemoryInGiB.
         * </p>
         * 
         * @param accelerators
         *        The number of accelerators to allocate. If you don't specify a value for vCPU and MemoryInGiB,
         *        SageMaker AI automatically allocates ratio-based values for those parameters based on the number of
         *        accelerators you provide. For example, if you allocate 16 out of 32 total accelerators, SageMaker AI
         *        uses the ratio of 0.5 and allocates values to vCPU and MemoryInGiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accelerators(Integer accelerators);

        /**
         * <p>
         * The number of vCPU to allocate. If you specify a value only for vCPU, SageMaker AI automatically allocates
         * ratio-based values for MemoryInGiB based on this vCPU parameter. For example, if you allocate 20 out of 40
         * total vCPU, SageMaker AI uses the ratio of 0.5 and allocates values to MemoryInGiB. Accelerators are set to
         * 0.
         * </p>
         * 
         * @param vCpu
         *        The number of vCPU to allocate. If you specify a value only for vCPU, SageMaker AI automatically
         *        allocates ratio-based values for MemoryInGiB based on this vCPU parameter. For example, if you
         *        allocate 20 out of 40 total vCPU, SageMaker AI uses the ratio of 0.5 and allocates values to
         *        MemoryInGiB. Accelerators are set to 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vCpu(Float vCpu);

        /**
         * <p>
         * The amount of memory in GiB to allocate. If you specify a value only for this parameter, SageMaker AI
         * automatically allocates a ratio-based value for vCPU based on this memory that you provide. For example, if
         * you allocate 200 out of 400 total memory in GiB, SageMaker AI uses the ratio of 0.5 and allocates values to
         * vCPU. Accelerators are set to 0.
         * </p>
         * 
         * @param memoryInGiB
         *        The amount of memory in GiB to allocate. If you specify a value only for this parameter, SageMaker AI
         *        automatically allocates a ratio-based value for vCPU based on this memory that you provide. For
         *        example, if you allocate 200 out of 400 total memory in GiB, SageMaker AI uses the ratio of 0.5 and
         *        allocates values to vCPU. Accelerators are set to 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryInGiB(Float memoryInGiB);
    }

    static final class BuilderImpl implements Builder {
        private String instanceType;

        private Integer count;

        private Integer accelerators;

        private Float vCpu;

        private Float memoryInGiB;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeQuotaResourceConfig model) {
            instanceType(model.instanceType);
            count(model.count);
            accelerators(model.accelerators);
            vCpu(model.vCpu);
            memoryInGiB(model.memoryInGiB);
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ClusterInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Integer getAccelerators() {
            return accelerators;
        }

        public final void setAccelerators(Integer accelerators) {
            this.accelerators = accelerators;
        }

        @Override
        public final Builder accelerators(Integer accelerators) {
            this.accelerators = accelerators;
            return this;
        }

        public final Float getVCpu() {
            return vCpu;
        }

        public final void setVCpu(Float vCpu) {
            this.vCpu = vCpu;
        }

        @Override
        public final Builder vCpu(Float vCpu) {
            this.vCpu = vCpu;
            return this;
        }

        public final Float getMemoryInGiB() {
            return memoryInGiB;
        }

        public final void setMemoryInGiB(Float memoryInGiB) {
            this.memoryInGiB = memoryInGiB;
        }

        @Override
        public final Builder memoryInGiB(Float memoryInGiB) {
            this.memoryInGiB = memoryInGiB;
            return this;
        }

        @Override
        public ComputeQuotaResourceConfig build() {
            return new ComputeQuotaResourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
