/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEndpointRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateEndpointRequest.Builder, CreateEndpointRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(CreateEndpointRequest::endpointName)).setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> ENDPOINT_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointConfigName").getter(getter(CreateEndpointRequest::endpointConfigName))
            .setter(setter(Builder::endpointConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigName").build())
            .build();

    private static final SdkField<DeploymentConfig> DEPLOYMENT_CONFIG_FIELD = SdkField
            .<DeploymentConfig> builder(MarshallingType.SDK_POJO).memberName("DeploymentConfig")
            .getter(getter(CreateEndpointRequest::deploymentConfig)).setter(setter(Builder::deploymentConfig))
            .constructor(DeploymentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentConfig").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateEndpointRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD,
            ENDPOINT_CONFIG_NAME_FIELD, DEPLOYMENT_CONFIG_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String endpointName;

    private final String endpointConfigName;

    private final DeploymentConfig deploymentConfig;

    private final List<Tag> tags;

    private CreateEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.endpointConfigName = builder.endpointConfigName;
        this.deploymentConfig = builder.deploymentConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the endpoint.The name must be unique within an Amazon Web Services Region in your Amazon Web Services
     * account. The name is case-insensitive in <code>CreateEndpoint</code>, but the case is preserved and must be
     * matched in <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html">InvokeEndpoint
     * </a>.
     * </p>
     * 
     * @return The name of the endpoint.The name must be unique within an Amazon Web Services Region in your Amazon Web
     *         Services account. The name is case-insensitive in <code>CreateEndpoint</code>, but the case is preserved
     *         and must be matched in <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html"
     *         >InvokeEndpoint</a>.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * The name of an endpoint configuration. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
     * >CreateEndpointConfig</a>.
     * </p>
     * 
     * @return The name of an endpoint configuration. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
     *         >CreateEndpointConfig</a>.
     */
    public final String endpointConfigName() {
        return endpointConfigName;
    }

    /**
     * Returns the value of the DeploymentConfig property for this object.
     * 
     * @return The value of the DeploymentConfig property for this object.
     */
    public final DeploymentConfig deploymentConfig() {
        return deploymentConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways,
     * for example, by purpose, owner, or environment. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
     *         different ways, for example, by purpose, owner, or environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         Resources</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEndpointRequest)) {
            return false;
        }
        CreateEndpointRequest other = (CreateEndpointRequest) obj;
        return Objects.equals(endpointName(), other.endpointName())
                && Objects.equals(endpointConfigName(), other.endpointConfigName())
                && Objects.equals(deploymentConfig(), other.deploymentConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEndpointRequest").add("EndpointName", endpointName())
                .add("EndpointConfigName", endpointConfigName()).add("DeploymentConfig", deploymentConfig())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "EndpointConfigName":
            return Optional.ofNullable(clazz.cast(endpointConfigName()));
        case "DeploymentConfig":
            return Optional.ofNullable(clazz.cast(deploymentConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EndpointName", ENDPOINT_NAME_FIELD);
        map.put("EndpointConfigName", ENDPOINT_CONFIG_NAME_FIELD);
        map.put("DeploymentConfig", DEPLOYMENT_CONFIG_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEndpointRequest, T> g) {
        return obj -> g.apply((CreateEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEndpointRequest> {
        /**
         * <p>
         * The name of the endpoint.The name must be unique within an Amazon Web Services Region in your Amazon Web
         * Services account. The name is case-insensitive in <code>CreateEndpoint</code>, but the case is preserved and
         * must be matched in <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html"
         * >InvokeEndpoint</a>.
         * </p>
         * 
         * @param endpointName
         *        The name of the endpoint.The name must be unique within an Amazon Web Services Region in your Amazon
         *        Web Services account. The name is case-insensitive in <code>CreateEndpoint</code>, but the case is
         *        preserved and must be matched in <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_runtime_InvokeEndpoint.html"
         *        >InvokeEndpoint</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * The name of an endpoint configuration. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
         * >CreateEndpointConfig</a>.
         * </p>
         * 
         * @param endpointConfigName
         *        The name of an endpoint configuration. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateEndpointConfig.html"
         *        >CreateEndpointConfig</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfigName(String endpointConfigName);

        /**
         * Sets the value of the DeploymentConfig property for this object.
         *
         * @param deploymentConfig
         *        The new value for the DeploymentConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfig(DeploymentConfig deploymentConfig);

        /**
         * Sets the value of the DeploymentConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DeploymentConfig.Builder} avoiding the
         * need to create one manually via {@link DeploymentConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #deploymentConfig(DeploymentConfig)}.
         * 
         * @param deploymentConfig
         *        a consumer that will call methods on {@link DeploymentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfig(DeploymentConfig)
         */
        default Builder deploymentConfig(Consumer<DeploymentConfig.Builder> deploymentConfig) {
            return deploymentConfig(DeploymentConfig.builder().applyMutation(deploymentConfig).build());
        }

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, for example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, for example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String endpointName;

        private String endpointConfigName;

        private DeploymentConfig deploymentConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEndpointRequest model) {
            super(model);
            endpointName(model.endpointName);
            endpointConfigName(model.endpointConfigName);
            deploymentConfig(model.deploymentConfig);
            tags(model.tags);
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getEndpointConfigName() {
            return endpointConfigName;
        }

        public final void setEndpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
        }

        @Override
        public final Builder endpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        public final DeploymentConfig.Builder getDeploymentConfig() {
            return deploymentConfig != null ? deploymentConfig.toBuilder() : null;
        }

        public final void setDeploymentConfig(DeploymentConfig.BuilderImpl deploymentConfig) {
            this.deploymentConfig = deploymentConfig != null ? deploymentConfig.build() : null;
        }

        @Override
        public final Builder deploymentConfig(DeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEndpointRequest build() {
            return new CreateEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
