/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHubContentPresignedUrlsRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateHubContentPresignedUrlsRequest.Builder, CreateHubContentPresignedUrlsRequest> {
    private static final SdkField<String> HUB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubName").getter(getter(CreateHubContentPresignedUrlsRequest::hubName)).setter(setter(Builder::hubName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubName").build()).build();

    private static final SdkField<String> HUB_CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentType").getter(getter(CreateHubContentPresignedUrlsRequest::hubContentTypeAsString))
            .setter(setter(Builder::hubContentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentType").build()).build();

    private static final SdkField<String> HUB_CONTENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentName").getter(getter(CreateHubContentPresignedUrlsRequest::hubContentName))
            .setter(setter(Builder::hubContentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentName").build()).build();

    private static final SdkField<String> HUB_CONTENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentVersion").getter(getter(CreateHubContentPresignedUrlsRequest::hubContentVersion))
            .setter(setter(Builder::hubContentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentVersion").build()).build();

    private static final SdkField<PresignedUrlAccessConfig> ACCESS_CONFIG_FIELD = SdkField
            .<PresignedUrlAccessConfig> builder(MarshallingType.SDK_POJO).memberName("AccessConfig")
            .getter(getter(CreateHubContentPresignedUrlsRequest::accessConfig)).setter(setter(Builder::accessConfig))
            .constructor(PresignedUrlAccessConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessConfig").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(CreateHubContentPresignedUrlsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(CreateHubContentPresignedUrlsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_NAME_FIELD,
            HUB_CONTENT_TYPE_FIELD, HUB_CONTENT_NAME_FIELD, HUB_CONTENT_VERSION_FIELD, ACCESS_CONFIG_FIELD, MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hubName;

    private final String hubContentType;

    private final String hubContentName;

    private final String hubContentVersion;

    private final PresignedUrlAccessConfig accessConfig;

    private final Integer maxResults;

    private final String nextToken;

    private CreateHubContentPresignedUrlsRequest(BuilderImpl builder) {
        super(builder);
        this.hubName = builder.hubName;
        this.hubContentType = builder.hubContentType;
        this.hubContentName = builder.hubContentName;
        this.hubContentVersion = builder.hubContentVersion;
        this.accessConfig = builder.accessConfig;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the hub that contains the content. For public content, use
     * <code>SageMakerPublicHub</code>.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the hub that contains the content. For public content, use
     *         <code>SageMakerPublicHub</code>.
     */
    public final String hubName() {
        return hubName;
    }

    /**
     * <p>
     * The type of hub content to access. Valid values include <code>Model</code>, <code>Notebook</code>, and
     * <code>ModelReference</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubContentType}
     * will return {@link HubContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hubContentTypeAsString}.
     * </p>
     * 
     * @return The type of hub content to access. Valid values include <code>Model</code>, <code>Notebook</code>, and
     *         <code>ModelReference</code>.
     * @see HubContentType
     */
    public final HubContentType hubContentType() {
        return HubContentType.fromValue(hubContentType);
    }

    /**
     * <p>
     * The type of hub content to access. Valid values include <code>Model</code>, <code>Notebook</code>, and
     * <code>ModelReference</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubContentType}
     * will return {@link HubContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hubContentTypeAsString}.
     * </p>
     * 
     * @return The type of hub content to access. Valid values include <code>Model</code>, <code>Notebook</code>, and
     *         <code>ModelReference</code>.
     * @see HubContentType
     */
    public final String hubContentTypeAsString() {
        return hubContentType;
    }

    /**
     * <p>
     * The name of the hub content for which to generate presigned URLs. This identifies the specific model or content
     * within the hub.
     * </p>
     * 
     * @return The name of the hub content for which to generate presigned URLs. This identifies the specific model or
     *         content within the hub.
     */
    public final String hubContentName() {
        return hubContentName;
    }

    /**
     * <p>
     * The version of the hub content. If not specified, the latest version is used.
     * </p>
     * 
     * @return The version of the hub content. If not specified, the latest version is used.
     */
    public final String hubContentVersion() {
        return hubContentVersion;
    }

    /**
     * <p>
     * Configuration settings for accessing the hub content, including end-user license agreement acceptance for gated
     * models and expected S3 URL validation.
     * </p>
     * 
     * @return Configuration settings for accessing the hub content, including end-user license agreement acceptance for
     *         gated models and expected S3 URL validation.
     */
    public final PresignedUrlAccessConfig accessConfig() {
        return accessConfig;
    }

    /**
     * <p>
     * The maximum number of presigned URLs to return in the response. Default value is 100. Large models may contain
     * hundreds of files, requiring pagination to retrieve all URLs.
     * </p>
     * 
     * @return The maximum number of presigned URLs to return in the response. Default value is 100. Large models may
     *         contain hundreds of files, requiring pagination to retrieve all URLs.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token for pagination. Use this token to retrieve the next set of presigned URLs when the response is truncated.
     * </p>
     * 
     * @return A token for pagination. Use this token to retrieve the next set of presigned URLs when the response is
     *         truncated.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hubName());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentName());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(accessConfig());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHubContentPresignedUrlsRequest)) {
            return false;
        }
        CreateHubContentPresignedUrlsRequest other = (CreateHubContentPresignedUrlsRequest) obj;
        return Objects.equals(hubName(), other.hubName())
                && Objects.equals(hubContentTypeAsString(), other.hubContentTypeAsString())
                && Objects.equals(hubContentName(), other.hubContentName())
                && Objects.equals(hubContentVersion(), other.hubContentVersion())
                && Objects.equals(accessConfig(), other.accessConfig()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateHubContentPresignedUrlsRequest").add("HubName", hubName())
                .add("HubContentType", hubContentTypeAsString()).add("HubContentName", hubContentName())
                .add("HubContentVersion", hubContentVersion()).add("AccessConfig", accessConfig())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HubName":
            return Optional.ofNullable(clazz.cast(hubName()));
        case "HubContentType":
            return Optional.ofNullable(clazz.cast(hubContentTypeAsString()));
        case "HubContentName":
            return Optional.ofNullable(clazz.cast(hubContentName()));
        case "HubContentVersion":
            return Optional.ofNullable(clazz.cast(hubContentVersion()));
        case "AccessConfig":
            return Optional.ofNullable(clazz.cast(accessConfig()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HubName", HUB_NAME_FIELD);
        map.put("HubContentType", HUB_CONTENT_TYPE_FIELD);
        map.put("HubContentName", HUB_CONTENT_NAME_FIELD);
        map.put("HubContentVersion", HUB_CONTENT_VERSION_FIELD);
        map.put("AccessConfig", ACCESS_CONFIG_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateHubContentPresignedUrlsRequest, T> g) {
        return obj -> g.apply((CreateHubContentPresignedUrlsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateHubContentPresignedUrlsRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the hub that contains the content. For public content, use
         * <code>SageMakerPublicHub</code>.
         * </p>
         * 
         * @param hubName
         *        The name or Amazon Resource Name (ARN) of the hub that contains the content. For public content, use
         *        <code>SageMakerPublicHub</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubName(String hubName);

        /**
         * <p>
         * The type of hub content to access. Valid values include <code>Model</code>, <code>Notebook</code>, and
         * <code>ModelReference</code>.
         * </p>
         * 
         * @param hubContentType
         *        The type of hub content to access. Valid values include <code>Model</code>, <code>Notebook</code>, and
         *        <code>ModelReference</code>.
         * @see HubContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubContentType
         */
        Builder hubContentType(String hubContentType);

        /**
         * <p>
         * The type of hub content to access. Valid values include <code>Model</code>, <code>Notebook</code>, and
         * <code>ModelReference</code>.
         * </p>
         * 
         * @param hubContentType
         *        The type of hub content to access. Valid values include <code>Model</code>, <code>Notebook</code>, and
         *        <code>ModelReference</code>.
         * @see HubContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubContentType
         */
        Builder hubContentType(HubContentType hubContentType);

        /**
         * <p>
         * The name of the hub content for which to generate presigned URLs. This identifies the specific model or
         * content within the hub.
         * </p>
         * 
         * @param hubContentName
         *        The name of the hub content for which to generate presigned URLs. This identifies the specific model
         *        or content within the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentName(String hubContentName);

        /**
         * <p>
         * The version of the hub content. If not specified, the latest version is used.
         * </p>
         * 
         * @param hubContentVersion
         *        The version of the hub content. If not specified, the latest version is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentVersion(String hubContentVersion);

        /**
         * <p>
         * Configuration settings for accessing the hub content, including end-user license agreement acceptance for
         * gated models and expected S3 URL validation.
         * </p>
         * 
         * @param accessConfig
         *        Configuration settings for accessing the hub content, including end-user license agreement acceptance
         *        for gated models and expected S3 URL validation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessConfig(PresignedUrlAccessConfig accessConfig);

        /**
         * <p>
         * Configuration settings for accessing the hub content, including end-user license agreement acceptance for
         * gated models and expected S3 URL validation.
         * </p>
         * This is a convenience method that creates an instance of the {@link PresignedUrlAccessConfig.Builder}
         * avoiding the need to create one manually via {@link PresignedUrlAccessConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PresignedUrlAccessConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #accessConfig(PresignedUrlAccessConfig)}.
         * 
         * @param accessConfig
         *        a consumer that will call methods on {@link PresignedUrlAccessConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessConfig(PresignedUrlAccessConfig)
         */
        default Builder accessConfig(Consumer<PresignedUrlAccessConfig.Builder> accessConfig) {
            return accessConfig(PresignedUrlAccessConfig.builder().applyMutation(accessConfig).build());
        }

        /**
         * <p>
         * The maximum number of presigned URLs to return in the response. Default value is 100. Large models may
         * contain hundreds of files, requiring pagination to retrieve all URLs.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of presigned URLs to return in the response. Default value is 100. Large models may
         *        contain hundreds of files, requiring pagination to retrieve all URLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token for pagination. Use this token to retrieve the next set of presigned URLs when the response is
         * truncated.
         * </p>
         * 
         * @param nextToken
         *        A token for pagination. Use this token to retrieve the next set of presigned URLs when the response is
         *        truncated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String hubName;

        private String hubContentType;

        private String hubContentName;

        private String hubContentVersion;

        private PresignedUrlAccessConfig accessConfig;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHubContentPresignedUrlsRequest model) {
            super(model);
            hubName(model.hubName);
            hubContentType(model.hubContentType);
            hubContentName(model.hubContentName);
            hubContentVersion(model.hubContentVersion);
            accessConfig(model.accessConfig);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getHubName() {
            return hubName;
        }

        public final void setHubName(String hubName) {
            this.hubName = hubName;
        }

        @Override
        public final Builder hubName(String hubName) {
            this.hubName = hubName;
            return this;
        }

        public final String getHubContentType() {
            return hubContentType;
        }

        public final void setHubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
        }

        @Override
        public final Builder hubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
            return this;
        }

        @Override
        public final Builder hubContentType(HubContentType hubContentType) {
            this.hubContentType(hubContentType == null ? null : hubContentType.toString());
            return this;
        }

        public final String getHubContentName() {
            return hubContentName;
        }

        public final void setHubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
        }

        @Override
        public final Builder hubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
            return this;
        }

        public final String getHubContentVersion() {
            return hubContentVersion;
        }

        public final void setHubContentVersion(String hubContentVersion) {
            this.hubContentVersion = hubContentVersion;
        }

        @Override
        public final Builder hubContentVersion(String hubContentVersion) {
            this.hubContentVersion = hubContentVersion;
            return this;
        }

        public final PresignedUrlAccessConfig.Builder getAccessConfig() {
            return accessConfig != null ? accessConfig.toBuilder() : null;
        }

        public final void setAccessConfig(PresignedUrlAccessConfig.BuilderImpl accessConfig) {
            this.accessConfig = accessConfig != null ? accessConfig.build() : null;
        }

        @Override
        public final Builder accessConfig(PresignedUrlAccessConfig accessConfig) {
            this.accessConfig = accessConfig;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHubContentPresignedUrlsRequest build() {
            return new CreateHubContentPresignedUrlsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
