/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHubContentPresignedUrlsResponse extends SageMakerResponse implements
        ToCopyableBuilder<CreateHubContentPresignedUrlsResponse.Builder, CreateHubContentPresignedUrlsResponse> {
    private static final SdkField<List<AuthorizedUrl>> AUTHORIZED_URL_CONFIGS_FIELD = SdkField
            .<List<AuthorizedUrl>> builder(MarshallingType.LIST)
            .memberName("AuthorizedUrlConfigs")
            .getter(getter(CreateHubContentPresignedUrlsResponse::authorizedUrlConfigs))
            .setter(setter(Builder::authorizedUrlConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedUrlConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuthorizedUrl> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuthorizedUrl::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(CreateHubContentPresignedUrlsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZED_URL_CONFIGS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AuthorizedUrl> authorizedUrlConfigs;

    private final String nextToken;

    private CreateHubContentPresignedUrlsResponse(BuilderImpl builder) {
        super(builder);
        this.authorizedUrlConfigs = builder.authorizedUrlConfigs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthorizedUrlConfigs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthorizedUrlConfigs() {
        return authorizedUrlConfigs != null && !(authorizedUrlConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of authorized URL configurations, each containing a presigned URL and its corresponding local file path
     * for proper file organization during download.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorizedUrlConfigs} method.
     * </p>
     * 
     * @return An array of authorized URL configurations, each containing a presigned URL and its corresponding local
     *         file path for proper file organization during download.
     */
    public final List<AuthorizedUrl> authorizedUrlConfigs() {
        return authorizedUrlConfigs;
    }

    /**
     * <p>
     * A token for pagination. If present, indicates that more presigned URLs are available. Use this token in a
     * subsequent request to retrieve additional URLs.
     * </p>
     * 
     * @return A token for pagination. If present, indicates that more presigned URLs are available. Use this token in a
     *         subsequent request to retrieve additional URLs.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizedUrlConfigs() ? authorizedUrlConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHubContentPresignedUrlsResponse)) {
            return false;
        }
        CreateHubContentPresignedUrlsResponse other = (CreateHubContentPresignedUrlsResponse) obj;
        return hasAuthorizedUrlConfigs() == other.hasAuthorizedUrlConfigs()
                && Objects.equals(authorizedUrlConfigs(), other.authorizedUrlConfigs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateHubContentPresignedUrlsResponse")
                .add("AuthorizedUrlConfigs", hasAuthorizedUrlConfigs() ? authorizedUrlConfigs() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthorizedUrlConfigs":
            return Optional.ofNullable(clazz.cast(authorizedUrlConfigs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AuthorizedUrlConfigs", AUTHORIZED_URL_CONFIGS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateHubContentPresignedUrlsResponse, T> g) {
        return obj -> g.apply((CreateHubContentPresignedUrlsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateHubContentPresignedUrlsResponse> {
        /**
         * <p>
         * An array of authorized URL configurations, each containing a presigned URL and its corresponding local file
         * path for proper file organization during download.
         * </p>
         * 
         * @param authorizedUrlConfigs
         *        An array of authorized URL configurations, each containing a presigned URL and its corresponding local
         *        file path for proper file organization during download.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedUrlConfigs(Collection<AuthorizedUrl> authorizedUrlConfigs);

        /**
         * <p>
         * An array of authorized URL configurations, each containing a presigned URL and its corresponding local file
         * path for proper file organization during download.
         * </p>
         * 
         * @param authorizedUrlConfigs
         *        An array of authorized URL configurations, each containing a presigned URL and its corresponding local
         *        file path for proper file organization during download.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedUrlConfigs(AuthorizedUrl... authorizedUrlConfigs);

        /**
         * <p>
         * An array of authorized URL configurations, each containing a presigned URL and its corresponding local file
         * path for proper file organization during download.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.AuthorizedUrl.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sagemaker.model.AuthorizedUrl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.AuthorizedUrl.Builder#build()} is called immediately
         * and its result is passed to {@link #authorizedUrlConfigs(List<AuthorizedUrl>)}.
         * 
         * @param authorizedUrlConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.AuthorizedUrl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizedUrlConfigs(java.util.Collection<AuthorizedUrl>)
         */
        Builder authorizedUrlConfigs(Consumer<AuthorizedUrl.Builder>... authorizedUrlConfigs);

        /**
         * <p>
         * A token for pagination. If present, indicates that more presigned URLs are available. Use this token in a
         * subsequent request to retrieve additional URLs.
         * </p>
         * 
         * @param nextToken
         *        A token for pagination. If present, indicates that more presigned URLs are available. Use this token
         *        in a subsequent request to retrieve additional URLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<AuthorizedUrl> authorizedUrlConfigs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHubContentPresignedUrlsResponse model) {
            super(model);
            authorizedUrlConfigs(model.authorizedUrlConfigs);
            nextToken(model.nextToken);
        }

        public final List<AuthorizedUrl.Builder> getAuthorizedUrlConfigs() {
            List<AuthorizedUrl.Builder> result = AuthorizedUrlConfigsCopier.copyToBuilder(this.authorizedUrlConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthorizedUrlConfigs(Collection<AuthorizedUrl.BuilderImpl> authorizedUrlConfigs) {
            this.authorizedUrlConfigs = AuthorizedUrlConfigsCopier.copyFromBuilder(authorizedUrlConfigs);
        }

        @Override
        public final Builder authorizedUrlConfigs(Collection<AuthorizedUrl> authorizedUrlConfigs) {
            this.authorizedUrlConfigs = AuthorizedUrlConfigsCopier.copy(authorizedUrlConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedUrlConfigs(AuthorizedUrl... authorizedUrlConfigs) {
            authorizedUrlConfigs(Arrays.asList(authorizedUrlConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedUrlConfigs(Consumer<AuthorizedUrl.Builder>... authorizedUrlConfigs) {
            authorizedUrlConfigs(Stream.of(authorizedUrlConfigs).map(c -> AuthorizedUrl.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public CreateHubContentPresignedUrlsResponse build() {
            return new CreateHubContentPresignedUrlsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
