/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePresignedNotebookInstanceUrlRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreatePresignedNotebookInstanceUrlRequest.Builder, CreatePresignedNotebookInstanceUrlRequest> {
    private static final SdkField<String> NOTEBOOK_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotebookInstanceName").getter(getter(CreatePresignedNotebookInstanceUrlRequest::notebookInstanceName))
            .setter(setter(Builder::notebookInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceName").build())
            .build();

    private static final SdkField<Integer> SESSION_EXPIRATION_DURATION_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SessionExpirationDurationInSeconds")
            .getter(getter(CreatePresignedNotebookInstanceUrlRequest::sessionExpirationDurationInSeconds))
            .setter(setter(Builder::sessionExpirationDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionExpirationDurationInSeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_INSTANCE_NAME_FIELD,
            SESSION_EXPIRATION_DURATION_IN_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String notebookInstanceName;

    private final Integer sessionExpirationDurationInSeconds;

    private CreatePresignedNotebookInstanceUrlRequest(BuilderImpl builder) {
        super(builder);
        this.notebookInstanceName = builder.notebookInstanceName;
        this.sessionExpirationDurationInSeconds = builder.sessionExpirationDurationInSeconds;
    }

    /**
     * <p>
     * The name of the notebook instance.
     * </p>
     * 
     * @return The name of the notebook instance.
     */
    public final String notebookInstanceName() {
        return notebookInstanceName;
    }

    /**
     * <p>
     * The duration of the session, in seconds. The default is 12 hours.
     * </p>
     * 
     * @return The duration of the session, in seconds. The default is 12 hours.
     */
    public final Integer sessionExpirationDurationInSeconds() {
        return sessionExpirationDurationInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(sessionExpirationDurationInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePresignedNotebookInstanceUrlRequest)) {
            return false;
        }
        CreatePresignedNotebookInstanceUrlRequest other = (CreatePresignedNotebookInstanceUrlRequest) obj;
        return Objects.equals(notebookInstanceName(), other.notebookInstanceName())
                && Objects.equals(sessionExpirationDurationInSeconds(), other.sessionExpirationDurationInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePresignedNotebookInstanceUrlRequest").add("NotebookInstanceName", notebookInstanceName())
                .add("SessionExpirationDurationInSeconds", sessionExpirationDurationInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotebookInstanceName":
            return Optional.ofNullable(clazz.cast(notebookInstanceName()));
        case "SessionExpirationDurationInSeconds":
            return Optional.ofNullable(clazz.cast(sessionExpirationDurationInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NotebookInstanceName", NOTEBOOK_INSTANCE_NAME_FIELD);
        map.put("SessionExpirationDurationInSeconds", SESSION_EXPIRATION_DURATION_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePresignedNotebookInstanceUrlRequest, T> g) {
        return obj -> g.apply((CreatePresignedNotebookInstanceUrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePresignedNotebookInstanceUrlRequest> {
        /**
         * <p>
         * The name of the notebook instance.
         * </p>
         * 
         * @param notebookInstanceName
         *        The name of the notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceName(String notebookInstanceName);

        /**
         * <p>
         * The duration of the session, in seconds. The default is 12 hours.
         * </p>
         * 
         * @param sessionExpirationDurationInSeconds
         *        The duration of the session, in seconds. The default is 12 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionExpirationDurationInSeconds(Integer sessionExpirationDurationInSeconds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String notebookInstanceName;

        private Integer sessionExpirationDurationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePresignedNotebookInstanceUrlRequest model) {
            super(model);
            notebookInstanceName(model.notebookInstanceName);
            sessionExpirationDurationInSeconds(model.sessionExpirationDurationInSeconds);
        }

        public final String getNotebookInstanceName() {
            return notebookInstanceName;
        }

        public final void setNotebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
        }

        @Override
        public final Builder notebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
            return this;
        }

        public final Integer getSessionExpirationDurationInSeconds() {
            return sessionExpirationDurationInSeconds;
        }

        public final void setSessionExpirationDurationInSeconds(Integer sessionExpirationDurationInSeconds) {
            this.sessionExpirationDurationInSeconds = sessionExpirationDurationInSeconds;
        }

        @Override
        public final Builder sessionExpirationDurationInSeconds(Integer sessionExpirationDurationInSeconds) {
            this.sessionExpirationDurationInSeconds = sessionExpirationDurationInSeconds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePresignedNotebookInstanceUrlRequest build() {
            return new CreatePresignedNotebookInstanceUrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
