/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration details for a template provider. Only one type of template provider can be specified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTemplateProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateTemplateProvider.Builder, CreateTemplateProvider> {
    private static final SdkField<CfnCreateTemplateProvider> CFN_TEMPLATE_PROVIDER_FIELD = SdkField
            .<CfnCreateTemplateProvider> builder(MarshallingType.SDK_POJO).memberName("CfnTemplateProvider")
            .getter(getter(CreateTemplateProvider::cfnTemplateProvider)).setter(setter(Builder::cfnTemplateProvider))
            .constructor(CfnCreateTemplateProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CfnTemplateProvider").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CFN_TEMPLATE_PROVIDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CfnCreateTemplateProvider cfnTemplateProvider;

    private CreateTemplateProvider(BuilderImpl builder) {
        this.cfnTemplateProvider = builder.cfnTemplateProvider;
    }

    /**
     * <p>
     * The CloudFormation template provider configuration for creating infrastructure resources.
     * </p>
     * 
     * @return The CloudFormation template provider configuration for creating infrastructure resources.
     */
    public final CfnCreateTemplateProvider cfnTemplateProvider() {
        return cfnTemplateProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cfnTemplateProvider());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTemplateProvider)) {
            return false;
        }
        CreateTemplateProvider other = (CreateTemplateProvider) obj;
        return Objects.equals(cfnTemplateProvider(), other.cfnTemplateProvider());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTemplateProvider").add("CfnTemplateProvider", cfnTemplateProvider()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CfnTemplateProvider":
            return Optional.ofNullable(clazz.cast(cfnTemplateProvider()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CfnTemplateProvider", CFN_TEMPLATE_PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTemplateProvider, T> g) {
        return obj -> g.apply((CreateTemplateProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateTemplateProvider> {
        /**
         * <p>
         * The CloudFormation template provider configuration for creating infrastructure resources.
         * </p>
         * 
         * @param cfnTemplateProvider
         *        The CloudFormation template provider configuration for creating infrastructure resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cfnTemplateProvider(CfnCreateTemplateProvider cfnTemplateProvider);

        /**
         * <p>
         * The CloudFormation template provider configuration for creating infrastructure resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link CfnCreateTemplateProvider.Builder}
         * avoiding the need to create one manually via {@link CfnCreateTemplateProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CfnCreateTemplateProvider.Builder#build()} is called immediately
         * and its result is passed to {@link #cfnTemplateProvider(CfnCreateTemplateProvider)}.
         * 
         * @param cfnTemplateProvider
         *        a consumer that will call methods on {@link CfnCreateTemplateProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cfnTemplateProvider(CfnCreateTemplateProvider)
         */
        default Builder cfnTemplateProvider(Consumer<CfnCreateTemplateProvider.Builder> cfnTemplateProvider) {
            return cfnTemplateProvider(CfnCreateTemplateProvider.builder().applyMutation(cfnTemplateProvider).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CfnCreateTemplateProvider cfnTemplateProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTemplateProvider model) {
            cfnTemplateProvider(model.cfnTemplateProvider);
        }

        public final CfnCreateTemplateProvider.Builder getCfnTemplateProvider() {
            return cfnTemplateProvider != null ? cfnTemplateProvider.toBuilder() : null;
        }

        public final void setCfnTemplateProvider(CfnCreateTemplateProvider.BuilderImpl cfnTemplateProvider) {
            this.cfnTemplateProvider = cfnTemplateProvider != null ? cfnTemplateProvider.build() : null;
        }

        @Override
        public final Builder cfnTemplateProvider(CfnCreateTemplateProvider cfnTemplateProvider) {
            this.cfnTemplateProvider = cfnTemplateProvider;
            return this;
        }

        @Override
        public CreateTemplateProvider build() {
            return new CreateTemplateProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
