/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrainingPlanResponse extends SageMakerResponse implements
        ToCopyableBuilder<CreateTrainingPlanResponse.Builder, CreateTrainingPlanResponse> {
    private static final SdkField<String> TRAINING_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrainingPlanArn").getter(getter(CreateTrainingPlanResponse::trainingPlanArn))
            .setter(setter(Builder::trainingPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingPlanArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_PLAN_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trainingPlanArn;

    private CreateTrainingPlanResponse(BuilderImpl builder) {
        super(builder);
        this.trainingPlanArn = builder.trainingPlanArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN); of the created training plan.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN); of the created training plan.
     */
    public final String trainingPlanArn() {
        return trainingPlanArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trainingPlanArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrainingPlanResponse)) {
            return false;
        }
        CreateTrainingPlanResponse other = (CreateTrainingPlanResponse) obj;
        return Objects.equals(trainingPlanArn(), other.trainingPlanArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrainingPlanResponse").add("TrainingPlanArn", trainingPlanArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrainingPlanArn":
            return Optional.ofNullable(clazz.cast(trainingPlanArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrainingPlanArn", TRAINING_PLAN_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTrainingPlanResponse, T> g) {
        return obj -> g.apply((CreateTrainingPlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrainingPlanResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN); of the created training plan.
         * </p>
         * 
         * @param trainingPlanArn
         *        The Amazon Resource Name (ARN); of the created training plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingPlanArn(String trainingPlanArn);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String trainingPlanArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrainingPlanResponse model) {
            super(model);
            trainingPlanArn(model.trainingPlanArn);
        }

        public final String getTrainingPlanArn() {
            return trainingPlanArn;
        }

        public final void setTrainingPlanArn(String trainingPlanArn) {
            this.trainingPlanArn = trainingPlanArn;
        }

        @Override
        public final Builder trainingPlanArn(String trainingPlanArn) {
            this.trainingPlanArn = trainingPlanArn;
            return this;
        }

        @Override
        public CreateTrainingPlanResponse build() {
            return new CreateTrainingPlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
