/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A file system, created by you, that you assign to a user profile or space for an Amazon SageMaker AI Domain.
 * Permitted users can access this file system in Amazon SageMaker AI Studio.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomFileSystem implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomFileSystem.Builder, CustomFileSystem> {
    private static final SdkField<EFSFileSystem> EFS_FILE_SYSTEM_FIELD = SdkField
            .<EFSFileSystem> builder(MarshallingType.SDK_POJO).memberName("EFSFileSystem")
            .getter(getter(CustomFileSystem::efsFileSystem)).setter(setter(Builder::efsFileSystem))
            .constructor(EFSFileSystem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EFSFileSystem").build()).build();

    private static final SdkField<FSxLustreFileSystem> F_SX_LUSTRE_FILE_SYSTEM_FIELD = SdkField
            .<FSxLustreFileSystem> builder(MarshallingType.SDK_POJO).memberName("FSxLustreFileSystem")
            .getter(getter(CustomFileSystem::fSxLustreFileSystem)).setter(setter(Builder::fSxLustreFileSystem))
            .constructor(FSxLustreFileSystem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FSxLustreFileSystem").build())
            .build();

    private static final SdkField<S3FileSystem> S3_FILE_SYSTEM_FIELD = SdkField.<S3FileSystem> builder(MarshallingType.SDK_POJO)
            .memberName("S3FileSystem").getter(getter(CustomFileSystem::s3FileSystem)).setter(setter(Builder::s3FileSystem))
            .constructor(S3FileSystem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3FileSystem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFS_FILE_SYSTEM_FIELD,
            F_SX_LUSTRE_FILE_SYSTEM_FIELD, S3_FILE_SYSTEM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EFSFileSystem efsFileSystem;

    private final FSxLustreFileSystem fSxLustreFileSystem;

    private final S3FileSystem s3FileSystem;

    private final Type type;

    private CustomFileSystem(BuilderImpl builder) {
        this.efsFileSystem = builder.efsFileSystem;
        this.fSxLustreFileSystem = builder.fSxLustreFileSystem;
        this.s3FileSystem = builder.s3FileSystem;
        this.type = builder.type;
    }

    /**
     * <p>
     * A custom file system in Amazon EFS.
     * </p>
     * 
     * @return A custom file system in Amazon EFS.
     */
    public final EFSFileSystem efsFileSystem() {
        return efsFileSystem;
    }

    /**
     * <p>
     * A custom file system in Amazon FSx for Lustre.
     * </p>
     * 
     * @return A custom file system in Amazon FSx for Lustre.
     */
    public final FSxLustreFileSystem fSxLustreFileSystem() {
        return fSxLustreFileSystem;
    }

    /**
     * <p>
     * A custom file system in Amazon S3. This is only supported in Amazon SageMaker Unified Studio.
     * </p>
     * 
     * @return A custom file system in Amazon S3. This is only supported in Amazon SageMaker Unified Studio.
     */
    public final S3FileSystem s3FileSystem() {
        return s3FileSystem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(efsFileSystem());
        hashCode = 31 * hashCode + Objects.hashCode(fSxLustreFileSystem());
        hashCode = 31 * hashCode + Objects.hashCode(s3FileSystem());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomFileSystem)) {
            return false;
        }
        CustomFileSystem other = (CustomFileSystem) obj;
        return Objects.equals(efsFileSystem(), other.efsFileSystem())
                && Objects.equals(fSxLustreFileSystem(), other.fSxLustreFileSystem())
                && Objects.equals(s3FileSystem(), other.s3FileSystem());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomFileSystem").add("EFSFileSystem", efsFileSystem())
                .add("FSxLustreFileSystem", fSxLustreFileSystem()).add("S3FileSystem", s3FileSystem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EFSFileSystem":
            return Optional.ofNullable(clazz.cast(efsFileSystem()));
        case "FSxLustreFileSystem":
            return Optional.ofNullable(clazz.cast(fSxLustreFileSystem()));
        case "S3FileSystem":
            return Optional.ofNullable(clazz.cast(s3FileSystem()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #efsFileSystem()} initialized to the given value.
     *
     * <p>
     * A custom file system in Amazon EFS.
     * </p>
     * 
     * @param efsFileSystem
     *        A custom file system in Amazon EFS.
     */
    public static CustomFileSystem fromEfsFileSystem(EFSFileSystem efsFileSystem) {
        return builder().efsFileSystem(efsFileSystem).build();
    }

    /**
     * Create an instance of this class with {@link #efsFileSystem()} initialized to the given value.
     *
     * <p>
     * A custom file system in Amazon EFS.
     * </p>
     * 
     * @param efsFileSystem
     *        A custom file system in Amazon EFS.
     */
    public static CustomFileSystem fromEfsFileSystem(Consumer<EFSFileSystem.Builder> efsFileSystem) {
        EFSFileSystem.Builder builder = EFSFileSystem.builder();
        efsFileSystem.accept(builder);
        return fromEfsFileSystem(builder.build());
    }

    /**
     * Create an instance of this class with {@link #fSxLustreFileSystem()} initialized to the given value.
     *
     * <p>
     * A custom file system in Amazon FSx for Lustre.
     * </p>
     * 
     * @param fSxLustreFileSystem
     *        A custom file system in Amazon FSx for Lustre.
     */
    public static CustomFileSystem fromFSxLustreFileSystem(FSxLustreFileSystem fSxLustreFileSystem) {
        return builder().fSxLustreFileSystem(fSxLustreFileSystem).build();
    }

    /**
     * Create an instance of this class with {@link #fSxLustreFileSystem()} initialized to the given value.
     *
     * <p>
     * A custom file system in Amazon FSx for Lustre.
     * </p>
     * 
     * @param fSxLustreFileSystem
     *        A custom file system in Amazon FSx for Lustre.
     */
    public static CustomFileSystem fromFSxLustreFileSystem(Consumer<FSxLustreFileSystem.Builder> fSxLustreFileSystem) {
        FSxLustreFileSystem.Builder builder = FSxLustreFileSystem.builder();
        fSxLustreFileSystem.accept(builder);
        return fromFSxLustreFileSystem(builder.build());
    }

    /**
     * Create an instance of this class with {@link #s3FileSystem()} initialized to the given value.
     *
     * <p>
     * A custom file system in Amazon S3. This is only supported in Amazon SageMaker Unified Studio.
     * </p>
     * 
     * @param s3FileSystem
     *        A custom file system in Amazon S3. This is only supported in Amazon SageMaker Unified Studio.
     */
    public static CustomFileSystem fromS3FileSystem(S3FileSystem s3FileSystem) {
        return builder().s3FileSystem(s3FileSystem).build();
    }

    /**
     * Create an instance of this class with {@link #s3FileSystem()} initialized to the given value.
     *
     * <p>
     * A custom file system in Amazon S3. This is only supported in Amazon SageMaker Unified Studio.
     * </p>
     * 
     * @param s3FileSystem
     *        A custom file system in Amazon S3. This is only supported in Amazon SageMaker Unified Studio.
     */
    public static CustomFileSystem fromS3FileSystem(Consumer<S3FileSystem.Builder> s3FileSystem) {
        S3FileSystem.Builder builder = S3FileSystem.builder();
        s3FileSystem.accept(builder);
        return fromS3FileSystem(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EFSFileSystem", EFS_FILE_SYSTEM_FIELD);
        map.put("FSxLustreFileSystem", F_SX_LUSTRE_FILE_SYSTEM_FIELD);
        map.put("S3FileSystem", S3_FILE_SYSTEM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomFileSystem, T> g) {
        return obj -> g.apply((CustomFileSystem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomFileSystem> {
        /**
         * <p>
         * A custom file system in Amazon EFS.
         * </p>
         * 
         * @param efsFileSystem
         *        A custom file system in Amazon EFS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder efsFileSystem(EFSFileSystem efsFileSystem);

        /**
         * <p>
         * A custom file system in Amazon EFS.
         * </p>
         * This is a convenience method that creates an instance of the {@link EFSFileSystem.Builder} avoiding the need
         * to create one manually via {@link EFSFileSystem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EFSFileSystem.Builder#build()} is called immediately and its
         * result is passed to {@link #efsFileSystem(EFSFileSystem)}.
         * 
         * @param efsFileSystem
         *        a consumer that will call methods on {@link EFSFileSystem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #efsFileSystem(EFSFileSystem)
         */
        default Builder efsFileSystem(Consumer<EFSFileSystem.Builder> efsFileSystem) {
            return efsFileSystem(EFSFileSystem.builder().applyMutation(efsFileSystem).build());
        }

        /**
         * <p>
         * A custom file system in Amazon FSx for Lustre.
         * </p>
         * 
         * @param fSxLustreFileSystem
         *        A custom file system in Amazon FSx for Lustre.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fSxLustreFileSystem(FSxLustreFileSystem fSxLustreFileSystem);

        /**
         * <p>
         * A custom file system in Amazon FSx for Lustre.
         * </p>
         * This is a convenience method that creates an instance of the {@link FSxLustreFileSystem.Builder} avoiding the
         * need to create one manually via {@link FSxLustreFileSystem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FSxLustreFileSystem.Builder#build()} is called immediately and
         * its result is passed to {@link #fSxLustreFileSystem(FSxLustreFileSystem)}.
         * 
         * @param fSxLustreFileSystem
         *        a consumer that will call methods on {@link FSxLustreFileSystem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fSxLustreFileSystem(FSxLustreFileSystem)
         */
        default Builder fSxLustreFileSystem(Consumer<FSxLustreFileSystem.Builder> fSxLustreFileSystem) {
            return fSxLustreFileSystem(FSxLustreFileSystem.builder().applyMutation(fSxLustreFileSystem).build());
        }

        /**
         * <p>
         * A custom file system in Amazon S3. This is only supported in Amazon SageMaker Unified Studio.
         * </p>
         * 
         * @param s3FileSystem
         *        A custom file system in Amazon S3. This is only supported in Amazon SageMaker Unified Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3FileSystem(S3FileSystem s3FileSystem);

        /**
         * <p>
         * A custom file system in Amazon S3. This is only supported in Amazon SageMaker Unified Studio.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3FileSystem.Builder} avoiding the need
         * to create one manually via {@link S3FileSystem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3FileSystem.Builder#build()} is called immediately and its
         * result is passed to {@link #s3FileSystem(S3FileSystem)}.
         * 
         * @param s3FileSystem
         *        a consumer that will call methods on {@link S3FileSystem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3FileSystem(S3FileSystem)
         */
        default Builder s3FileSystem(Consumer<S3FileSystem.Builder> s3FileSystem) {
            return s3FileSystem(S3FileSystem.builder().applyMutation(s3FileSystem).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EFSFileSystem efsFileSystem;

        private FSxLustreFileSystem fSxLustreFileSystem;

        private S3FileSystem s3FileSystem;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CustomFileSystem model) {
            efsFileSystem(model.efsFileSystem);
            fSxLustreFileSystem(model.fSxLustreFileSystem);
            s3FileSystem(model.s3FileSystem);
        }

        public final EFSFileSystem.Builder getEfsFileSystem() {
            return efsFileSystem != null ? efsFileSystem.toBuilder() : null;
        }

        public final void setEfsFileSystem(EFSFileSystem.BuilderImpl efsFileSystem) {
            Object oldValue = this.efsFileSystem;
            this.efsFileSystem = efsFileSystem != null ? efsFileSystem.build() : null;
            handleUnionValueChange(Type.EFS_FILE_SYSTEM, oldValue, this.efsFileSystem);
        }

        @Override
        public final Builder efsFileSystem(EFSFileSystem efsFileSystem) {
            Object oldValue = this.efsFileSystem;
            this.efsFileSystem = efsFileSystem;
            handleUnionValueChange(Type.EFS_FILE_SYSTEM, oldValue, this.efsFileSystem);
            return this;
        }

        public final FSxLustreFileSystem.Builder getFSxLustreFileSystem() {
            return fSxLustreFileSystem != null ? fSxLustreFileSystem.toBuilder() : null;
        }

        public final void setFSxLustreFileSystem(FSxLustreFileSystem.BuilderImpl fSxLustreFileSystem) {
            Object oldValue = this.fSxLustreFileSystem;
            this.fSxLustreFileSystem = fSxLustreFileSystem != null ? fSxLustreFileSystem.build() : null;
            handleUnionValueChange(Type.F_SX_LUSTRE_FILE_SYSTEM, oldValue, this.fSxLustreFileSystem);
        }

        @Override
        public final Builder fSxLustreFileSystem(FSxLustreFileSystem fSxLustreFileSystem) {
            Object oldValue = this.fSxLustreFileSystem;
            this.fSxLustreFileSystem = fSxLustreFileSystem;
            handleUnionValueChange(Type.F_SX_LUSTRE_FILE_SYSTEM, oldValue, this.fSxLustreFileSystem);
            return this;
        }

        public final S3FileSystem.Builder getS3FileSystem() {
            return s3FileSystem != null ? s3FileSystem.toBuilder() : null;
        }

        public final void setS3FileSystem(S3FileSystem.BuilderImpl s3FileSystem) {
            Object oldValue = this.s3FileSystem;
            this.s3FileSystem = s3FileSystem != null ? s3FileSystem.build() : null;
            handleUnionValueChange(Type.S3_FILE_SYSTEM, oldValue, this.s3FileSystem);
        }

        @Override
        public final Builder s3FileSystem(S3FileSystem s3FileSystem) {
            Object oldValue = this.s3FileSystem;
            this.s3FileSystem = s3FileSystem;
            handleUnionValueChange(Type.S3_FILE_SYSTEM, oldValue, this.s3FileSystem);
            return this;
        }

        @Override
        public CustomFileSystem build() {
            return new CustomFileSystem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CustomFileSystem#type()
     */
    public enum Type {
        EFS_FILE_SYSTEM,

        F_SX_LUSTRE_FILE_SYSTEM,

        S3_FILE_SYSTEM,

        UNKNOWN_TO_SDK_VERSION
    }
}
