/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration to use when updating the AMI versions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentConfiguration.Builder, DeploymentConfiguration> {
    private static final SdkField<RollingDeploymentPolicy> ROLLING_UPDATE_POLICY_FIELD = SdkField
            .<RollingDeploymentPolicy> builder(MarshallingType.SDK_POJO).memberName("RollingUpdatePolicy")
            .getter(getter(DeploymentConfiguration::rollingUpdatePolicy)).setter(setter(Builder::rollingUpdatePolicy))
            .constructor(RollingDeploymentPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollingUpdatePolicy").build())
            .build();

    private static final SdkField<Integer> WAIT_INTERVAL_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WaitIntervalInSeconds").getter(getter(DeploymentConfiguration::waitIntervalInSeconds))
            .setter(setter(Builder::waitIntervalInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitIntervalInSeconds").build())
            .build();

    private static final SdkField<List<AlarmDetails>> AUTO_ROLLBACK_CONFIGURATION_FIELD = SdkField
            .<List<AlarmDetails>> builder(MarshallingType.LIST)
            .memberName("AutoRollbackConfiguration")
            .getter(getter(DeploymentConfiguration::autoRollbackConfiguration))
            .setter(setter(Builder::autoRollbackConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRollbackConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AlarmDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AlarmDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLLING_UPDATE_POLICY_FIELD,
            WAIT_INTERVAL_IN_SECONDS_FIELD, AUTO_ROLLBACK_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RollingDeploymentPolicy rollingUpdatePolicy;

    private final Integer waitIntervalInSeconds;

    private final List<AlarmDetails> autoRollbackConfiguration;

    private DeploymentConfiguration(BuilderImpl builder) {
        this.rollingUpdatePolicy = builder.rollingUpdatePolicy;
        this.waitIntervalInSeconds = builder.waitIntervalInSeconds;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
    }

    /**
     * <p>
     * The policy that SageMaker uses when updating the AMI versions of the cluster.
     * </p>
     * 
     * @return The policy that SageMaker uses when updating the AMI versions of the cluster.
     */
    public final RollingDeploymentPolicy rollingUpdatePolicy() {
        return rollingUpdatePolicy;
    }

    /**
     * <p>
     * The duration in seconds that SageMaker waits before updating more instances in the cluster.
     * </p>
     * 
     * @return The duration in seconds that SageMaker waits before updating more instances in the cluster.
     */
    public final Integer waitIntervalInSeconds() {
        return waitIntervalInSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoRollbackConfiguration property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAutoRollbackConfiguration() {
        return autoRollbackConfiguration != null && !(autoRollbackConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains the alarms that SageMaker monitors to know whether to roll back the AMI update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoRollbackConfiguration} method.
     * </p>
     * 
     * @return An array that contains the alarms that SageMaker monitors to know whether to roll back the AMI update.
     */
    public final List<AlarmDetails> autoRollbackConfiguration() {
        return autoRollbackConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rollingUpdatePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(waitIntervalInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoRollbackConfiguration() ? autoRollbackConfiguration() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentConfiguration)) {
            return false;
        }
        DeploymentConfiguration other = (DeploymentConfiguration) obj;
        return Objects.equals(rollingUpdatePolicy(), other.rollingUpdatePolicy())
                && Objects.equals(waitIntervalInSeconds(), other.waitIntervalInSeconds())
                && hasAutoRollbackConfiguration() == other.hasAutoRollbackConfiguration()
                && Objects.equals(autoRollbackConfiguration(), other.autoRollbackConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentConfiguration").add("RollingUpdatePolicy", rollingUpdatePolicy())
                .add("WaitIntervalInSeconds", waitIntervalInSeconds())
                .add("AutoRollbackConfiguration", hasAutoRollbackConfiguration() ? autoRollbackConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RollingUpdatePolicy":
            return Optional.ofNullable(clazz.cast(rollingUpdatePolicy()));
        case "WaitIntervalInSeconds":
            return Optional.ofNullable(clazz.cast(waitIntervalInSeconds()));
        case "AutoRollbackConfiguration":
            return Optional.ofNullable(clazz.cast(autoRollbackConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RollingUpdatePolicy", ROLLING_UPDATE_POLICY_FIELD);
        map.put("WaitIntervalInSeconds", WAIT_INTERVAL_IN_SECONDS_FIELD);
        map.put("AutoRollbackConfiguration", AUTO_ROLLBACK_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentConfiguration, T> g) {
        return obj -> g.apply((DeploymentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentConfiguration> {
        /**
         * <p>
         * The policy that SageMaker uses when updating the AMI versions of the cluster.
         * </p>
         * 
         * @param rollingUpdatePolicy
         *        The policy that SageMaker uses when updating the AMI versions of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollingUpdatePolicy(RollingDeploymentPolicy rollingUpdatePolicy);

        /**
         * <p>
         * The policy that SageMaker uses when updating the AMI versions of the cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link RollingDeploymentPolicy.Builder} avoiding
         * the need to create one manually via {@link RollingDeploymentPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RollingDeploymentPolicy.Builder#build()} is called immediately
         * and its result is passed to {@link #rollingUpdatePolicy(RollingDeploymentPolicy)}.
         * 
         * @param rollingUpdatePolicy
         *        a consumer that will call methods on {@link RollingDeploymentPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rollingUpdatePolicy(RollingDeploymentPolicy)
         */
        default Builder rollingUpdatePolicy(Consumer<RollingDeploymentPolicy.Builder> rollingUpdatePolicy) {
            return rollingUpdatePolicy(RollingDeploymentPolicy.builder().applyMutation(rollingUpdatePolicy).build());
        }

        /**
         * <p>
         * The duration in seconds that SageMaker waits before updating more instances in the cluster.
         * </p>
         * 
         * @param waitIntervalInSeconds
         *        The duration in seconds that SageMaker waits before updating more instances in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitIntervalInSeconds(Integer waitIntervalInSeconds);

        /**
         * <p>
         * An array that contains the alarms that SageMaker monitors to know whether to roll back the AMI update.
         * </p>
         * 
         * @param autoRollbackConfiguration
         *        An array that contains the alarms that SageMaker monitors to know whether to roll back the AMI update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRollbackConfiguration(Collection<AlarmDetails> autoRollbackConfiguration);

        /**
         * <p>
         * An array that contains the alarms that SageMaker monitors to know whether to roll back the AMI update.
         * </p>
         * 
         * @param autoRollbackConfiguration
         *        An array that contains the alarms that SageMaker monitors to know whether to roll back the AMI update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRollbackConfiguration(AlarmDetails... autoRollbackConfiguration);

        /**
         * <p>
         * An array that contains the alarms that SageMaker monitors to know whether to roll back the AMI update.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.AlarmDetails.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sagemaker.model.AlarmDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.AlarmDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #autoRollbackConfiguration(List<AlarmDetails>)}.
         * 
         * @param autoRollbackConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.AlarmDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoRollbackConfiguration(java.util.Collection<AlarmDetails>)
         */
        Builder autoRollbackConfiguration(Consumer<AlarmDetails.Builder>... autoRollbackConfiguration);
    }

    static final class BuilderImpl implements Builder {
        private RollingDeploymentPolicy rollingUpdatePolicy;

        private Integer waitIntervalInSeconds;

        private List<AlarmDetails> autoRollbackConfiguration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentConfiguration model) {
            rollingUpdatePolicy(model.rollingUpdatePolicy);
            waitIntervalInSeconds(model.waitIntervalInSeconds);
            autoRollbackConfiguration(model.autoRollbackConfiguration);
        }

        public final RollingDeploymentPolicy.Builder getRollingUpdatePolicy() {
            return rollingUpdatePolicy != null ? rollingUpdatePolicy.toBuilder() : null;
        }

        public final void setRollingUpdatePolicy(RollingDeploymentPolicy.BuilderImpl rollingUpdatePolicy) {
            this.rollingUpdatePolicy = rollingUpdatePolicy != null ? rollingUpdatePolicy.build() : null;
        }

        @Override
        public final Builder rollingUpdatePolicy(RollingDeploymentPolicy rollingUpdatePolicy) {
            this.rollingUpdatePolicy = rollingUpdatePolicy;
            return this;
        }

        public final Integer getWaitIntervalInSeconds() {
            return waitIntervalInSeconds;
        }

        public final void setWaitIntervalInSeconds(Integer waitIntervalInSeconds) {
            this.waitIntervalInSeconds = waitIntervalInSeconds;
        }

        @Override
        public final Builder waitIntervalInSeconds(Integer waitIntervalInSeconds) {
            this.waitIntervalInSeconds = waitIntervalInSeconds;
            return this;
        }

        public final List<AlarmDetails.Builder> getAutoRollbackConfiguration() {
            List<AlarmDetails.Builder> result = AutoRollbackAlarmsCopier.copyToBuilder(this.autoRollbackConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutoRollbackConfiguration(Collection<AlarmDetails.BuilderImpl> autoRollbackConfiguration) {
            this.autoRollbackConfiguration = AutoRollbackAlarmsCopier.copyFromBuilder(autoRollbackConfiguration);
        }

        @Override
        public final Builder autoRollbackConfiguration(Collection<AlarmDetails> autoRollbackConfiguration) {
            this.autoRollbackConfiguration = AutoRollbackAlarmsCopier.copy(autoRollbackConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoRollbackConfiguration(AlarmDetails... autoRollbackConfiguration) {
            autoRollbackConfiguration(Arrays.asList(autoRollbackConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoRollbackConfiguration(Consumer<AlarmDetails.Builder>... autoRollbackConfiguration) {
            autoRollbackConfiguration(Stream.of(autoRollbackConfiguration)
                    .map(c -> AlarmDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeploymentConfiguration build() {
            return new DeploymentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
