/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeActionResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeActionResponse.Builder, DescribeActionResponse> {
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionName").getter(getter(DescribeActionResponse::actionName)).setter(setter(Builder::actionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionName").build()).build();

    private static final SdkField<String> ACTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionArn").getter(getter(DescribeActionResponse::actionArn)).setter(setter(Builder::actionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionArn").build()).build();

    private static final SdkField<ActionSource> SOURCE_FIELD = SdkField.<ActionSource> builder(MarshallingType.SDK_POJO)
            .memberName("Source").getter(getter(DescribeActionResponse::source)).setter(setter(Builder::source))
            .constructor(ActionSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionType").getter(getter(DescribeActionResponse::actionType)).setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeActionResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeActionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Properties")
            .getter(getter(DescribeActionResponse::properties))
            .setter(setter(Builder::properties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeActionResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(DescribeActionResponse::createdBy)).setter(setter(Builder::createdBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeActionResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("LastModifiedBy").getter(getter(DescribeActionResponse::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy)).constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<MetadataProperties> METADATA_PROPERTIES_FIELD = SdkField
            .<MetadataProperties> builder(MarshallingType.SDK_POJO).memberName("MetadataProperties")
            .getter(getter(DescribeActionResponse::metadataProperties)).setter(setter(Builder::metadataProperties))
            .constructor(MetadataProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataProperties").build())
            .build();

    private static final SdkField<String> LINEAGE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LineageGroupArn").getter(getter(DescribeActionResponse::lineageGroupArn))
            .setter(setter(Builder::lineageGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineageGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_NAME_FIELD,
            ACTION_ARN_FIELD, SOURCE_FIELD, ACTION_TYPE_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, PROPERTIES_FIELD,
            CREATION_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, METADATA_PROPERTIES_FIELD,
            LINEAGE_GROUP_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String actionName;

    private final String actionArn;

    private final ActionSource source;

    private final String actionType;

    private final String description;

    private final String status;

    private final Map<String, String> properties;

    private final Instant creationTime;

    private final UserContext createdBy;

    private final Instant lastModifiedTime;

    private final UserContext lastModifiedBy;

    private final MetadataProperties metadataProperties;

    private final String lineageGroupArn;

    private DescribeActionResponse(BuilderImpl builder) {
        super(builder);
        this.actionName = builder.actionName;
        this.actionArn = builder.actionArn;
        this.source = builder.source;
        this.actionType = builder.actionType;
        this.description = builder.description;
        this.status = builder.status;
        this.properties = builder.properties;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.metadataProperties = builder.metadataProperties;
        this.lineageGroupArn = builder.lineageGroupArn;
    }

    /**
     * <p>
     * The name of the action.
     * </p>
     * 
     * @return The name of the action.
     */
    public final String actionName() {
        return actionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the action.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the action.
     */
    public final String actionArn() {
        return actionArn;
    }

    /**
     * <p>
     * The source of the action.
     * </p>
     * 
     * @return The source of the action.
     */
    public final ActionSource source() {
        return source;
    }

    /**
     * <p>
     * The type of the action.
     * </p>
     * 
     * @return The type of the action.
     */
    public final String actionType() {
        return actionType;
    }

    /**
     * <p>
     * The description of the action.
     * </p>
     * 
     * @return The description of the action.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The status of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the action.
     * @see ActionStatus
     */
    public final ActionStatus status() {
        return ActionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the action.
     * @see ActionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Properties property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProperties() {
        return properties != null && !(properties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of the action's properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProperties} method.
     * </p>
     * 
     * @return A list of the action's properties.
     */
    public final Map<String, String> properties() {
        return properties;
    }

    /**
     * <p>
     * When the action was created.
     * </p>
     * 
     * @return When the action was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * When the action was last modified.
     * </p>
     * 
     * @return When the action was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the LastModifiedBy property for this object.
     * 
     * @return The value of the LastModifiedBy property for this object.
     */
    public final UserContext lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * Returns the value of the MetadataProperties property for this object.
     * 
     * @return The value of the MetadataProperties property for this object.
     */
    public final MetadataProperties metadataProperties() {
        return metadataProperties;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the lineage group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the lineage group.
     */
    public final String lineageGroupArn() {
        return lineageGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionName());
        hashCode = 31 * hashCode + Objects.hashCode(actionArn());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(actionType());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasProperties() ? properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(metadataProperties());
        hashCode = 31 * hashCode + Objects.hashCode(lineageGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActionResponse)) {
            return false;
        }
        DescribeActionResponse other = (DescribeActionResponse) obj;
        return Objects.equals(actionName(), other.actionName()) && Objects.equals(actionArn(), other.actionArn())
                && Objects.equals(source(), other.source()) && Objects.equals(actionType(), other.actionType())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasProperties() == other.hasProperties() && Objects.equals(properties(), other.properties())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(metadataProperties(), other.metadataProperties())
                && Objects.equals(lineageGroupArn(), other.lineageGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeActionResponse").add("ActionName", actionName()).add("ActionArn", actionArn())
                .add("Source", source()).add("ActionType", actionType()).add("Description", description())
                .add("Status", statusAsString()).add("Properties", hasProperties() ? properties() : null)
                .add("CreationTime", creationTime()).add("CreatedBy", createdBy()).add("LastModifiedTime", lastModifiedTime())
                .add("LastModifiedBy", lastModifiedBy()).add("MetadataProperties", metadataProperties())
                .add("LineageGroupArn", lineageGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActionName":
            return Optional.ofNullable(clazz.cast(actionName()));
        case "ActionArn":
            return Optional.ofNullable(clazz.cast(actionArn()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "ActionType":
            return Optional.ofNullable(clazz.cast(actionType()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Properties":
            return Optional.ofNullable(clazz.cast(properties()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "MetadataProperties":
            return Optional.ofNullable(clazz.cast(metadataProperties()));
        case "LineageGroupArn":
            return Optional.ofNullable(clazz.cast(lineageGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActionName", ACTION_NAME_FIELD);
        map.put("ActionArn", ACTION_ARN_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("ActionType", ACTION_TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Properties", PROPERTIES_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("MetadataProperties", METADATA_PROPERTIES_FIELD);
        map.put("LineageGroupArn", LINEAGE_GROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeActionResponse, T> g) {
        return obj -> g.apply((DescribeActionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeActionResponse> {
        /**
         * <p>
         * The name of the action.
         * </p>
         * 
         * @param actionName
         *        The name of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionName(String actionName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the action.
         * </p>
         * 
         * @param actionArn
         *        The Amazon Resource Name (ARN) of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionArn(String actionArn);

        /**
         * <p>
         * The source of the action.
         * </p>
         * 
         * @param source
         *        The source of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(ActionSource source);

        /**
         * <p>
         * The source of the action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionSource.Builder} avoiding the need
         * to create one manually via {@link ActionSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionSource.Builder#build()} is called immediately and its
         * result is passed to {@link #source(ActionSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link ActionSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(ActionSource)
         */
        default Builder source(Consumer<ActionSource.Builder> source) {
            return source(ActionSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The type of the action.
         * </p>
         * 
         * @param actionType
         *        The type of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The description of the action.
         * </p>
         * 
         * @param description
         *        The description of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of the action.
         * </p>
         * 
         * @param status
         *        The status of the action.
         * @see ActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the action.
         * </p>
         * 
         * @param status
         *        The status of the action.
         * @see ActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionStatus
         */
        Builder status(ActionStatus status);

        /**
         * <p>
         * A list of the action's properties.
         * </p>
         * 
         * @param properties
         *        A list of the action's properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(Map<String, String> properties);

        /**
         * <p>
         * When the action was created.
         * </p>
         * 
         * @param creationTime
         *        When the action was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * When the action was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        When the action was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * @param lastModifiedBy
         *        The new value for the LastModifiedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(UserContext lastModifiedBy);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #lastModifiedBy(UserContext)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(UserContext)
         */
        default Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return lastModifiedBy(UserContext.builder().applyMutation(lastModifiedBy).build());
        }

        /**
         * Sets the value of the MetadataProperties property for this object.
         *
         * @param metadataProperties
         *        The new value for the MetadataProperties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataProperties(MetadataProperties metadataProperties);

        /**
         * Sets the value of the MetadataProperties property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MetadataProperties.Builder} avoiding the
         * need to create one manually via {@link MetadataProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #metadataProperties(MetadataProperties)}.
         * 
         * @param metadataProperties
         *        a consumer that will call methods on {@link MetadataProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataProperties(MetadataProperties)
         */
        default Builder metadataProperties(Consumer<MetadataProperties.Builder> metadataProperties) {
            return metadataProperties(MetadataProperties.builder().applyMutation(metadataProperties).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the lineage group.
         * </p>
         * 
         * @param lineageGroupArn
         *        The Amazon Resource Name (ARN) of the lineage group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineageGroupArn(String lineageGroupArn);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String actionName;

        private String actionArn;

        private ActionSource source;

        private String actionType;

        private String description;

        private String status;

        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();

        private Instant creationTime;

        private UserContext createdBy;

        private Instant lastModifiedTime;

        private UserContext lastModifiedBy;

        private MetadataProperties metadataProperties;

        private String lineageGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActionResponse model) {
            super(model);
            actionName(model.actionName);
            actionArn(model.actionArn);
            source(model.source);
            actionType(model.actionType);
            description(model.description);
            status(model.status);
            properties(model.properties);
            creationTime(model.creationTime);
            createdBy(model.createdBy);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedBy(model.lastModifiedBy);
            metadataProperties(model.metadataProperties);
            lineageGroupArn(model.lineageGroupArn);
        }

        public final String getActionName() {
            return actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final String getActionArn() {
            return actionArn;
        }

        public final void setActionArn(String actionArn) {
            this.actionArn = actionArn;
        }

        @Override
        public final Builder actionArn(String actionArn) {
            this.actionArn = actionArn;
            return this;
        }

        public final ActionSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(ActionSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(ActionSource source) {
            this.source = source;
            return this;
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getProperties() {
            if (properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return properties;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = LineageEntityParametersCopier.copy(properties);
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = LineageEntityParametersCopier.copy(properties);
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final MetadataProperties.Builder getMetadataProperties() {
            return metadataProperties != null ? metadataProperties.toBuilder() : null;
        }

        public final void setMetadataProperties(MetadataProperties.BuilderImpl metadataProperties) {
            this.metadataProperties = metadataProperties != null ? metadataProperties.build() : null;
        }

        @Override
        public final Builder metadataProperties(MetadataProperties metadataProperties) {
            this.metadataProperties = metadataProperties;
            return this;
        }

        public final String getLineageGroupArn() {
            return lineageGroupArn;
        }

        public final void setLineageGroupArn(String lineageGroupArn) {
            this.lineageGroupArn = lineageGroupArn;
        }

        @Override
        public final Builder lineageGroupArn(String lineageGroupArn) {
            this.lineageGroupArn = lineageGroupArn;
            return this;
        }

        @Override
        public DescribeActionResponse build() {
            return new DescribeActionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
