/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterEventResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeClusterEventResponse.Builder, DescribeClusterEventResponse> {
    private static final SdkField<ClusterEventDetail> EVENT_DETAILS_FIELD = SdkField
            .<ClusterEventDetail> builder(MarshallingType.SDK_POJO).memberName("EventDetails")
            .getter(getter(DescribeClusterEventResponse::eventDetails)).setter(setter(Builder::eventDetails))
            .constructor(ClusterEventDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ClusterEventDetail eventDetails;

    private DescribeClusterEventResponse(BuilderImpl builder) {
        super(builder);
        this.eventDetails = builder.eventDetails;
    }

    /**
     * <p>
     * Detailed information about the requested cluster event, including event metadata for various resource types such
     * as <code>Cluster</code>, <code>InstanceGroup</code>, <code>Instance</code>, and their associated attributes.
     * </p>
     * 
     * @return Detailed information about the requested cluster event, including event metadata for various resource
     *         types such as <code>Cluster</code>, <code>InstanceGroup</code>, <code>Instance</code>, and their
     *         associated attributes.
     */
    public final ClusterEventDetail eventDetails() {
        return eventDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterEventResponse)) {
            return false;
        }
        DescribeClusterEventResponse other = (DescribeClusterEventResponse) obj;
        return Objects.equals(eventDetails(), other.eventDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClusterEventResponse").add("EventDetails", eventDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventDetails":
            return Optional.ofNullable(clazz.cast(eventDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EventDetails", EVENT_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterEventResponse, T> g) {
        return obj -> g.apply((DescribeClusterEventResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClusterEventResponse> {
        /**
         * <p>
         * Detailed information about the requested cluster event, including event metadata for various resource types
         * such as <code>Cluster</code>, <code>InstanceGroup</code>, <code>Instance</code>, and their associated
         * attributes.
         * </p>
         * 
         * @param eventDetails
         *        Detailed information about the requested cluster event, including event metadata for various resource
         *        types such as <code>Cluster</code>, <code>InstanceGroup</code>, <code>Instance</code>, and their
         *        associated attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDetails(ClusterEventDetail eventDetails);

        /**
         * <p>
         * Detailed information about the requested cluster event, including event metadata for various resource types
         * such as <code>Cluster</code>, <code>InstanceGroup</code>, <code>Instance</code>, and their associated
         * attributes.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterEventDetail.Builder} avoiding the
         * need to create one manually via {@link ClusterEventDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterEventDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #eventDetails(ClusterEventDetail)}.
         * 
         * @param eventDetails
         *        a consumer that will call methods on {@link ClusterEventDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventDetails(ClusterEventDetail)
         */
        default Builder eventDetails(Consumer<ClusterEventDetail.Builder> eventDetails) {
            return eventDetails(ClusterEventDetail.builder().applyMutation(eventDetails).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private ClusterEventDetail eventDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterEventResponse model) {
            super(model);
            eventDetails(model.eventDetails);
        }

        public final ClusterEventDetail.Builder getEventDetails() {
            return eventDetails != null ? eventDetails.toBuilder() : null;
        }

        public final void setEventDetails(ClusterEventDetail.BuilderImpl eventDetails) {
            this.eventDetails = eventDetails != null ? eventDetails.build() : null;
        }

        @Override
        public final Builder eventDetails(ClusterEventDetail eventDetails) {
            this.eventDetails = eventDetails;
            return this;
        }

        @Override
        public DescribeClusterEventResponse build() {
            return new DescribeClusterEventResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
