/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeClusterResponse.Builder, DescribeClusterResponse> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(DescribeClusterResponse::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(DescribeClusterResponse::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<String> CLUSTER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterStatus").getter(getter(DescribeClusterResponse::clusterStatusAsString))
            .setter(setter(Builder::clusterStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterStatus").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeClusterResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMessage").getter(getter(DescribeClusterResponse::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()).build();

    private static final SdkField<List<ClusterInstanceGroupDetails>> INSTANCE_GROUPS_FIELD = SdkField
            .<List<ClusterInstanceGroupDetails>> builder(MarshallingType.LIST)
            .memberName("InstanceGroups")
            .getter(getter(DescribeClusterResponse::instanceGroups))
            .setter(setter(Builder::instanceGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterInstanceGroupDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterInstanceGroupDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ClusterRestrictedInstanceGroupDetails>> RESTRICTED_INSTANCE_GROUPS_FIELD = SdkField
            .<List<ClusterRestrictedInstanceGroupDetails>> builder(MarshallingType.LIST)
            .memberName("RestrictedInstanceGroups")
            .getter(getter(DescribeClusterResponse::restrictedInstanceGroups))
            .setter(setter(Builder::restrictedInstanceGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestrictedInstanceGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterRestrictedInstanceGroupDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterRestrictedInstanceGroupDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(DescribeClusterResponse::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<ClusterOrchestrator> ORCHESTRATOR_FIELD = SdkField
            .<ClusterOrchestrator> builder(MarshallingType.SDK_POJO).memberName("Orchestrator")
            .getter(getter(DescribeClusterResponse::orchestrator)).setter(setter(Builder::orchestrator))
            .constructor(ClusterOrchestrator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Orchestrator").build()).build();

    private static final SdkField<ClusterTieredStorageConfig> TIERED_STORAGE_CONFIG_FIELD = SdkField
            .<ClusterTieredStorageConfig> builder(MarshallingType.SDK_POJO).memberName("TieredStorageConfig")
            .getter(getter(DescribeClusterResponse::tieredStorageConfig)).setter(setter(Builder::tieredStorageConfig))
            .constructor(ClusterTieredStorageConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieredStorageConfig").build())
            .build();

    private static final SdkField<String> NODE_RECOVERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeRecovery").getter(getter(DescribeClusterResponse::nodeRecoveryAsString))
            .setter(setter(Builder::nodeRecovery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeRecovery").build()).build();

    private static final SdkField<String> NODE_PROVISIONING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeProvisioningMode").getter(getter(DescribeClusterResponse::nodeProvisioningModeAsString))
            .setter(setter(Builder::nodeProvisioningMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeProvisioningMode").build())
            .build();

    private static final SdkField<String> CLUSTER_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterRole").getter(getter(DescribeClusterResponse::clusterRole)).setter(setter(Builder::clusterRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterRole").build()).build();

    private static final SdkField<ClusterAutoScalingConfigOutput> AUTO_SCALING_FIELD = SdkField
            .<ClusterAutoScalingConfigOutput> builder(MarshallingType.SDK_POJO).memberName("AutoScaling")
            .getter(getter(DescribeClusterResponse::autoScaling)).setter(setter(Builder::autoScaling))
            .constructor(ClusterAutoScalingConfigOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScaling").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            CLUSTER_NAME_FIELD, CLUSTER_STATUS_FIELD, CREATION_TIME_FIELD, FAILURE_MESSAGE_FIELD, INSTANCE_GROUPS_FIELD,
            RESTRICTED_INSTANCE_GROUPS_FIELD, VPC_CONFIG_FIELD, ORCHESTRATOR_FIELD, TIERED_STORAGE_CONFIG_FIELD,
            NODE_RECOVERY_FIELD, NODE_PROVISIONING_MODE_FIELD, CLUSTER_ROLE_FIELD, AUTO_SCALING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterArn;

    private final String clusterName;

    private final String clusterStatus;

    private final Instant creationTime;

    private final String failureMessage;

    private final List<ClusterInstanceGroupDetails> instanceGroups;

    private final List<ClusterRestrictedInstanceGroupDetails> restrictedInstanceGroups;

    private final VpcConfig vpcConfig;

    private final ClusterOrchestrator orchestrator;

    private final ClusterTieredStorageConfig tieredStorageConfig;

    private final String nodeRecovery;

    private final String nodeProvisioningMode;

    private final String clusterRole;

    private final ClusterAutoScalingConfigOutput autoScaling;

    private DescribeClusterResponse(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.clusterName = builder.clusterName;
        this.clusterStatus = builder.clusterStatus;
        this.creationTime = builder.creationTime;
        this.failureMessage = builder.failureMessage;
        this.instanceGroups = builder.instanceGroups;
        this.restrictedInstanceGroups = builder.restrictedInstanceGroups;
        this.vpcConfig = builder.vpcConfig;
        this.orchestrator = builder.orchestrator;
        this.tieredStorageConfig = builder.tieredStorageConfig;
        this.nodeRecovery = builder.nodeRecovery;
        this.nodeProvisioningMode = builder.nodeProvisioningMode;
        this.clusterRole = builder.clusterRole;
        this.autoScaling = builder.autoScaling;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The name of the SageMaker HyperPod cluster.
     * </p>
     * 
     * @return The name of the SageMaker HyperPod cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The status of the SageMaker HyperPod cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterStatus}
     * will return {@link ClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterStatusAsString}.
     * </p>
     * 
     * @return The status of the SageMaker HyperPod cluster.
     * @see ClusterStatus
     */
    public final ClusterStatus clusterStatus() {
        return ClusterStatus.fromValue(clusterStatus);
    }

    /**
     * <p>
     * The status of the SageMaker HyperPod cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterStatus}
     * will return {@link ClusterStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterStatusAsString}.
     * </p>
     * 
     * @return The status of the SageMaker HyperPod cluster.
     * @see ClusterStatus
     */
    public final String clusterStatusAsString() {
        return clusterStatus;
    }

    /**
     * <p>
     * The time when the SageMaker Cluster is created.
     * </p>
     * 
     * @return The time when the SageMaker Cluster is created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The failure message of the SageMaker HyperPod cluster.
     * </p>
     * 
     * @return The failure message of the SageMaker HyperPod cluster.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceGroups() {
        return instanceGroups != null && !(instanceGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instance groups of the SageMaker HyperPod cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceGroups} method.
     * </p>
     * 
     * @return The instance groups of the SageMaker HyperPod cluster.
     */
    public final List<ClusterInstanceGroupDetails> instanceGroups() {
        return instanceGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the RestrictedInstanceGroups property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRestrictedInstanceGroups() {
        return restrictedInstanceGroups != null && !(restrictedInstanceGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The specialized instance groups for training models like Amazon Nova to be created in the SageMaker HyperPod
     * cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRestrictedInstanceGroups} method.
     * </p>
     * 
     * @return The specialized instance groups for training models like Amazon Nova to be created in the SageMaker
     *         HyperPod cluster.
     */
    public final List<ClusterRestrictedInstanceGroupDetails> restrictedInstanceGroups() {
        return restrictedInstanceGroups;
    }

    /**
     * Returns the value of the VpcConfig property for this object.
     * 
     * @return The value of the VpcConfig property for this object.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The type of orchestrator used for the SageMaker HyperPod cluster.
     * </p>
     * 
     * @return The type of orchestrator used for the SageMaker HyperPod cluster.
     */
    public final ClusterOrchestrator orchestrator() {
        return orchestrator;
    }

    /**
     * <p>
     * The current configuration for managed tier checkpointing on the HyperPod cluster. For example, this shows whether
     * the feature is enabled and the percentage of cluster memory allocated for checkpoint storage.
     * </p>
     * 
     * @return The current configuration for managed tier checkpointing on the HyperPod cluster. For example, this shows
     *         whether the feature is enabled and the percentage of cluster memory allocated for checkpoint storage.
     */
    public final ClusterTieredStorageConfig tieredStorageConfig() {
        return tieredStorageConfig;
    }

    /**
     * <p>
     * The node recovery mode configured for the SageMaker HyperPod cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeRecovery} will
     * return {@link ClusterNodeRecovery#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nodeRecoveryAsString}.
     * </p>
     * 
     * @return The node recovery mode configured for the SageMaker HyperPod cluster.
     * @see ClusterNodeRecovery
     */
    public final ClusterNodeRecovery nodeRecovery() {
        return ClusterNodeRecovery.fromValue(nodeRecovery);
    }

    /**
     * <p>
     * The node recovery mode configured for the SageMaker HyperPod cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeRecovery} will
     * return {@link ClusterNodeRecovery#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nodeRecoveryAsString}.
     * </p>
     * 
     * @return The node recovery mode configured for the SageMaker HyperPod cluster.
     * @see ClusterNodeRecovery
     */
    public final String nodeRecoveryAsString() {
        return nodeRecovery;
    }

    /**
     * <p>
     * The mode used for provisioning nodes in the cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nodeProvisioningMode} will return {@link ClusterNodeProvisioningMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #nodeProvisioningModeAsString}.
     * </p>
     * 
     * @return The mode used for provisioning nodes in the cluster.
     * @see ClusterNodeProvisioningMode
     */
    public final ClusterNodeProvisioningMode nodeProvisioningMode() {
        return ClusterNodeProvisioningMode.fromValue(nodeProvisioningMode);
    }

    /**
     * <p>
     * The mode used for provisioning nodes in the cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #nodeProvisioningMode} will return {@link ClusterNodeProvisioningMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #nodeProvisioningModeAsString}.
     * </p>
     * 
     * @return The mode used for provisioning nodes in the cluster.
     * @see ClusterNodeProvisioningMode
     */
    public final String nodeProvisioningModeAsString() {
        return nodeProvisioningMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that HyperPod uses for cluster autoscaling operations.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that HyperPod uses for cluster autoscaling operations.
     */
    public final String clusterRole() {
        return clusterRole;
    }

    /**
     * <p>
     * The current autoscaling configuration and status for the autoscaler.
     * </p>
     * 
     * @return The current autoscaling configuration and status for the autoscaler.
     */
    public final ClusterAutoScalingConfigOutput autoScaling() {
        return autoScaling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(clusterStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceGroups() ? instanceGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRestrictedInstanceGroups() ? restrictedInstanceGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(orchestrator());
        hashCode = 31 * hashCode + Objects.hashCode(tieredStorageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(nodeRecoveryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nodeProvisioningModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clusterRole());
        hashCode = 31 * hashCode + Objects.hashCode(autoScaling());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterResponse)) {
            return false;
        }
        DescribeClusterResponse other = (DescribeClusterResponse) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(clusterStatusAsString(), other.clusterStatusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(failureMessage(), other.failureMessage()) && hasInstanceGroups() == other.hasInstanceGroups()
                && Objects.equals(instanceGroups(), other.instanceGroups())
                && hasRestrictedInstanceGroups() == other.hasRestrictedInstanceGroups()
                && Objects.equals(restrictedInstanceGroups(), other.restrictedInstanceGroups())
                && Objects.equals(vpcConfig(), other.vpcConfig()) && Objects.equals(orchestrator(), other.orchestrator())
                && Objects.equals(tieredStorageConfig(), other.tieredStorageConfig())
                && Objects.equals(nodeRecoveryAsString(), other.nodeRecoveryAsString())
                && Objects.equals(nodeProvisioningModeAsString(), other.nodeProvisioningModeAsString())
                && Objects.equals(clusterRole(), other.clusterRole()) && Objects.equals(autoScaling(), other.autoScaling());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClusterResponse").add("ClusterArn", clusterArn()).add("ClusterName", clusterName())
                .add("ClusterStatus", clusterStatusAsString()).add("CreationTime", creationTime())
                .add("FailureMessage", failureMessage()).add("InstanceGroups", hasInstanceGroups() ? instanceGroups() : null)
                .add("RestrictedInstanceGroups", hasRestrictedInstanceGroups() ? restrictedInstanceGroups() : null)
                .add("VpcConfig", vpcConfig()).add("Orchestrator", orchestrator())
                .add("TieredStorageConfig", tieredStorageConfig()).add("NodeRecovery", nodeRecoveryAsString())
                .add("NodeProvisioningMode", nodeProvisioningModeAsString()).add("ClusterRole", clusterRole())
                .add("AutoScaling", autoScaling()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "ClusterStatus":
            return Optional.ofNullable(clazz.cast(clusterStatusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "FailureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "InstanceGroups":
            return Optional.ofNullable(clazz.cast(instanceGroups()));
        case "RestrictedInstanceGroups":
            return Optional.ofNullable(clazz.cast(restrictedInstanceGroups()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "Orchestrator":
            return Optional.ofNullable(clazz.cast(orchestrator()));
        case "TieredStorageConfig":
            return Optional.ofNullable(clazz.cast(tieredStorageConfig()));
        case "NodeRecovery":
            return Optional.ofNullable(clazz.cast(nodeRecoveryAsString()));
        case "NodeProvisioningMode":
            return Optional.ofNullable(clazz.cast(nodeProvisioningModeAsString()));
        case "ClusterRole":
            return Optional.ofNullable(clazz.cast(clusterRole()));
        case "AutoScaling":
            return Optional.ofNullable(clazz.cast(autoScaling()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterArn", CLUSTER_ARN_FIELD);
        map.put("ClusterName", CLUSTER_NAME_FIELD);
        map.put("ClusterStatus", CLUSTER_STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("FailureMessage", FAILURE_MESSAGE_FIELD);
        map.put("InstanceGroups", INSTANCE_GROUPS_FIELD);
        map.put("RestrictedInstanceGroups", RESTRICTED_INSTANCE_GROUPS_FIELD);
        map.put("VpcConfig", VPC_CONFIG_FIELD);
        map.put("Orchestrator", ORCHESTRATOR_FIELD);
        map.put("TieredStorageConfig", TIERED_STORAGE_CONFIG_FIELD);
        map.put("NodeRecovery", NODE_RECOVERY_FIELD);
        map.put("NodeProvisioningMode", NODE_PROVISIONING_MODE_FIELD);
        map.put("ClusterRole", CLUSTER_ROLE_FIELD);
        map.put("AutoScaling", AUTO_SCALING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterResponse, T> g) {
        return obj -> g.apply((DescribeClusterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClusterResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param clusterArn
         *        The Amazon Resource Name (ARN) of the SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The name of the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of the SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The status of the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param clusterStatus
         *        The status of the SageMaker HyperPod cluster.
         * @see ClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterStatus
         */
        Builder clusterStatus(String clusterStatus);

        /**
         * <p>
         * The status of the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param clusterStatus
         *        The status of the SageMaker HyperPod cluster.
         * @see ClusterStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterStatus
         */
        Builder clusterStatus(ClusterStatus clusterStatus);

        /**
         * <p>
         * The time when the SageMaker Cluster is created.
         * </p>
         * 
         * @param creationTime
         *        The time when the SageMaker Cluster is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The failure message of the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param failureMessage
         *        The failure message of the SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * The instance groups of the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param instanceGroups
         *        The instance groups of the SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroups(Collection<ClusterInstanceGroupDetails> instanceGroups);

        /**
         * <p>
         * The instance groups of the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param instanceGroups
         *        The instance groups of the SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroups(ClusterInstanceGroupDetails... instanceGroups);

        /**
         * <p>
         * The instance groups of the SageMaker HyperPod cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupDetails.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceGroups(List<ClusterInstanceGroupDetails>)}.
         * 
         * @param instanceGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceGroups(java.util.Collection<ClusterInstanceGroupDetails>)
         */
        Builder instanceGroups(Consumer<ClusterInstanceGroupDetails.Builder>... instanceGroups);

        /**
         * <p>
         * The specialized instance groups for training models like Amazon Nova to be created in the SageMaker HyperPod
         * cluster.
         * </p>
         * 
         * @param restrictedInstanceGroups
         *        The specialized instance groups for training models like Amazon Nova to be created in the SageMaker
         *        HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictedInstanceGroups(Collection<ClusterRestrictedInstanceGroupDetails> restrictedInstanceGroups);

        /**
         * <p>
         * The specialized instance groups for training models like Amazon Nova to be created in the SageMaker HyperPod
         * cluster.
         * </p>
         * 
         * @param restrictedInstanceGroups
         *        The specialized instance groups for training models like Amazon Nova to be created in the SageMaker
         *        HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictedInstanceGroups(ClusterRestrictedInstanceGroupDetails... restrictedInstanceGroups);

        /**
         * <p>
         * The specialized instance groups for training models like Amazon Nova to be created in the SageMaker HyperPod
         * cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterRestrictedInstanceGroupDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterRestrictedInstanceGroupDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterRestrictedInstanceGroupDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #restrictedInstanceGroups(List<ClusterRestrictedInstanceGroupDetails>)}.
         * 
         * @param restrictedInstanceGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ClusterRestrictedInstanceGroupDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restrictedInstanceGroups(java.util.Collection<ClusterRestrictedInstanceGroupDetails>)
         */
        Builder restrictedInstanceGroups(Consumer<ClusterRestrictedInstanceGroupDetails.Builder>... restrictedInstanceGroups);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * @param vpcConfig
         *        The new value for the VpcConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The type of orchestrator used for the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param orchestrator
         *        The type of orchestrator used for the SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orchestrator(ClusterOrchestrator orchestrator);

        /**
         * <p>
         * The type of orchestrator used for the SageMaker HyperPod cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterOrchestrator.Builder} avoiding the
         * need to create one manually via {@link ClusterOrchestrator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterOrchestrator.Builder#build()} is called immediately and
         * its result is passed to {@link #orchestrator(ClusterOrchestrator)}.
         * 
         * @param orchestrator
         *        a consumer that will call methods on {@link ClusterOrchestrator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orchestrator(ClusterOrchestrator)
         */
        default Builder orchestrator(Consumer<ClusterOrchestrator.Builder> orchestrator) {
            return orchestrator(ClusterOrchestrator.builder().applyMutation(orchestrator).build());
        }

        /**
         * <p>
         * The current configuration for managed tier checkpointing on the HyperPod cluster. For example, this shows
         * whether the feature is enabled and the percentage of cluster memory allocated for checkpoint storage.
         * </p>
         * 
         * @param tieredStorageConfig
         *        The current configuration for managed tier checkpointing on the HyperPod cluster. For example, this
         *        shows whether the feature is enabled and the percentage of cluster memory allocated for checkpoint
         *        storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tieredStorageConfig(ClusterTieredStorageConfig tieredStorageConfig);

        /**
         * <p>
         * The current configuration for managed tier checkpointing on the HyperPod cluster. For example, this shows
         * whether the feature is enabled and the percentage of cluster memory allocated for checkpoint storage.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterTieredStorageConfig.Builder}
         * avoiding the need to create one manually via {@link ClusterTieredStorageConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterTieredStorageConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #tieredStorageConfig(ClusterTieredStorageConfig)}.
         * 
         * @param tieredStorageConfig
         *        a consumer that will call methods on {@link ClusterTieredStorageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tieredStorageConfig(ClusterTieredStorageConfig)
         */
        default Builder tieredStorageConfig(Consumer<ClusterTieredStorageConfig.Builder> tieredStorageConfig) {
            return tieredStorageConfig(ClusterTieredStorageConfig.builder().applyMutation(tieredStorageConfig).build());
        }

        /**
         * <p>
         * The node recovery mode configured for the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param nodeRecovery
         *        The node recovery mode configured for the SageMaker HyperPod cluster.
         * @see ClusterNodeRecovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterNodeRecovery
         */
        Builder nodeRecovery(String nodeRecovery);

        /**
         * <p>
         * The node recovery mode configured for the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param nodeRecovery
         *        The node recovery mode configured for the SageMaker HyperPod cluster.
         * @see ClusterNodeRecovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterNodeRecovery
         */
        Builder nodeRecovery(ClusterNodeRecovery nodeRecovery);

        /**
         * <p>
         * The mode used for provisioning nodes in the cluster.
         * </p>
         * 
         * @param nodeProvisioningMode
         *        The mode used for provisioning nodes in the cluster.
         * @see ClusterNodeProvisioningMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterNodeProvisioningMode
         */
        Builder nodeProvisioningMode(String nodeProvisioningMode);

        /**
         * <p>
         * The mode used for provisioning nodes in the cluster.
         * </p>
         * 
         * @param nodeProvisioningMode
         *        The mode used for provisioning nodes in the cluster.
         * @see ClusterNodeProvisioningMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterNodeProvisioningMode
         */
        Builder nodeProvisioningMode(ClusterNodeProvisioningMode nodeProvisioningMode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that HyperPod uses for cluster autoscaling operations.
         * </p>
         * 
         * @param clusterRole
         *        The Amazon Resource Name (ARN) of the IAM role that HyperPod uses for cluster autoscaling operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterRole(String clusterRole);

        /**
         * <p>
         * The current autoscaling configuration and status for the autoscaler.
         * </p>
         * 
         * @param autoScaling
         *        The current autoscaling configuration and status for the autoscaler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScaling(ClusterAutoScalingConfigOutput autoScaling);

        /**
         * <p>
         * The current autoscaling configuration and status for the autoscaler.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterAutoScalingConfigOutput.Builder}
         * avoiding the need to create one manually via {@link ClusterAutoScalingConfigOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterAutoScalingConfigOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #autoScaling(ClusterAutoScalingConfigOutput)}.
         * 
         * @param autoScaling
         *        a consumer that will call methods on {@link ClusterAutoScalingConfigOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScaling(ClusterAutoScalingConfigOutput)
         */
        default Builder autoScaling(Consumer<ClusterAutoScalingConfigOutput.Builder> autoScaling) {
            return autoScaling(ClusterAutoScalingConfigOutput.builder().applyMutation(autoScaling).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String clusterArn;

        private String clusterName;

        private String clusterStatus;

        private Instant creationTime;

        private String failureMessage;

        private List<ClusterInstanceGroupDetails> instanceGroups = DefaultSdkAutoConstructList.getInstance();

        private List<ClusterRestrictedInstanceGroupDetails> restrictedInstanceGroups = DefaultSdkAutoConstructList.getInstance();

        private VpcConfig vpcConfig;

        private ClusterOrchestrator orchestrator;

        private ClusterTieredStorageConfig tieredStorageConfig;

        private String nodeRecovery;

        private String nodeProvisioningMode;

        private String clusterRole;

        private ClusterAutoScalingConfigOutput autoScaling;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterResponse model) {
            super(model);
            clusterArn(model.clusterArn);
            clusterName(model.clusterName);
            clusterStatus(model.clusterStatus);
            creationTime(model.creationTime);
            failureMessage(model.failureMessage);
            instanceGroups(model.instanceGroups);
            restrictedInstanceGroups(model.restrictedInstanceGroups);
            vpcConfig(model.vpcConfig);
            orchestrator(model.orchestrator);
            tieredStorageConfig(model.tieredStorageConfig);
            nodeRecovery(model.nodeRecovery);
            nodeProvisioningMode(model.nodeProvisioningMode);
            clusterRole(model.clusterRole);
            autoScaling(model.autoScaling);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getClusterStatus() {
            return clusterStatus;
        }

        public final void setClusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
        }

        @Override
        public final Builder clusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
            return this;
        }

        @Override
        public final Builder clusterStatus(ClusterStatus clusterStatus) {
            this.clusterStatus(clusterStatus == null ? null : clusterStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final List<ClusterInstanceGroupDetails.Builder> getInstanceGroups() {
            List<ClusterInstanceGroupDetails.Builder> result = ClusterInstanceGroupDetailsListCopier
                    .copyToBuilder(this.instanceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceGroups(Collection<ClusterInstanceGroupDetails.BuilderImpl> instanceGroups) {
            this.instanceGroups = ClusterInstanceGroupDetailsListCopier.copyFromBuilder(instanceGroups);
        }

        @Override
        public final Builder instanceGroups(Collection<ClusterInstanceGroupDetails> instanceGroups) {
            this.instanceGroups = ClusterInstanceGroupDetailsListCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(ClusterInstanceGroupDetails... instanceGroups) {
            instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(Consumer<ClusterInstanceGroupDetails.Builder>... instanceGroups) {
            instanceGroups(Stream.of(instanceGroups).map(c -> ClusterInstanceGroupDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ClusterRestrictedInstanceGroupDetails.Builder> getRestrictedInstanceGroups() {
            List<ClusterRestrictedInstanceGroupDetails.Builder> result = ClusterRestrictedInstanceGroupDetailsListCopier
                    .copyToBuilder(this.restrictedInstanceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRestrictedInstanceGroups(
                Collection<ClusterRestrictedInstanceGroupDetails.BuilderImpl> restrictedInstanceGroups) {
            this.restrictedInstanceGroups = ClusterRestrictedInstanceGroupDetailsListCopier
                    .copyFromBuilder(restrictedInstanceGroups);
        }

        @Override
        public final Builder restrictedInstanceGroups(Collection<ClusterRestrictedInstanceGroupDetails> restrictedInstanceGroups) {
            this.restrictedInstanceGroups = ClusterRestrictedInstanceGroupDetailsListCopier.copy(restrictedInstanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restrictedInstanceGroups(ClusterRestrictedInstanceGroupDetails... restrictedInstanceGroups) {
            restrictedInstanceGroups(Arrays.asList(restrictedInstanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restrictedInstanceGroups(
                Consumer<ClusterRestrictedInstanceGroupDetails.Builder>... restrictedInstanceGroups) {
            restrictedInstanceGroups(Stream.of(restrictedInstanceGroups)
                    .map(c -> ClusterRestrictedInstanceGroupDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final ClusterOrchestrator.Builder getOrchestrator() {
            return orchestrator != null ? orchestrator.toBuilder() : null;
        }

        public final void setOrchestrator(ClusterOrchestrator.BuilderImpl orchestrator) {
            this.orchestrator = orchestrator != null ? orchestrator.build() : null;
        }

        @Override
        public final Builder orchestrator(ClusterOrchestrator orchestrator) {
            this.orchestrator = orchestrator;
            return this;
        }

        public final ClusterTieredStorageConfig.Builder getTieredStorageConfig() {
            return tieredStorageConfig != null ? tieredStorageConfig.toBuilder() : null;
        }

        public final void setTieredStorageConfig(ClusterTieredStorageConfig.BuilderImpl tieredStorageConfig) {
            this.tieredStorageConfig = tieredStorageConfig != null ? tieredStorageConfig.build() : null;
        }

        @Override
        public final Builder tieredStorageConfig(ClusterTieredStorageConfig tieredStorageConfig) {
            this.tieredStorageConfig = tieredStorageConfig;
            return this;
        }

        public final String getNodeRecovery() {
            return nodeRecovery;
        }

        public final void setNodeRecovery(String nodeRecovery) {
            this.nodeRecovery = nodeRecovery;
        }

        @Override
        public final Builder nodeRecovery(String nodeRecovery) {
            this.nodeRecovery = nodeRecovery;
            return this;
        }

        @Override
        public final Builder nodeRecovery(ClusterNodeRecovery nodeRecovery) {
            this.nodeRecovery(nodeRecovery == null ? null : nodeRecovery.toString());
            return this;
        }

        public final String getNodeProvisioningMode() {
            return nodeProvisioningMode;
        }

        public final void setNodeProvisioningMode(String nodeProvisioningMode) {
            this.nodeProvisioningMode = nodeProvisioningMode;
        }

        @Override
        public final Builder nodeProvisioningMode(String nodeProvisioningMode) {
            this.nodeProvisioningMode = nodeProvisioningMode;
            return this;
        }

        @Override
        public final Builder nodeProvisioningMode(ClusterNodeProvisioningMode nodeProvisioningMode) {
            this.nodeProvisioningMode(nodeProvisioningMode == null ? null : nodeProvisioningMode.toString());
            return this;
        }

        public final String getClusterRole() {
            return clusterRole;
        }

        public final void setClusterRole(String clusterRole) {
            this.clusterRole = clusterRole;
        }

        @Override
        public final Builder clusterRole(String clusterRole) {
            this.clusterRole = clusterRole;
            return this;
        }

        public final ClusterAutoScalingConfigOutput.Builder getAutoScaling() {
            return autoScaling != null ? autoScaling.toBuilder() : null;
        }

        public final void setAutoScaling(ClusterAutoScalingConfigOutput.BuilderImpl autoScaling) {
            this.autoScaling = autoScaling != null ? autoScaling.build() : null;
        }

        @Override
        public final Builder autoScaling(ClusterAutoScalingConfigOutput autoScaling) {
            this.autoScaling = autoScaling;
            return this;
        }

        @Override
        public DescribeClusterResponse build() {
            return new DescribeClusterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
