/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNotebookInstanceResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeNotebookInstanceResponse.Builder, DescribeNotebookInstanceResponse> {
    private static final SdkField<String> NOTEBOOK_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotebookInstanceArn").getter(getter(DescribeNotebookInstanceResponse::notebookInstanceArn))
            .setter(setter(Builder::notebookInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceArn").build())
            .build();

    private static final SdkField<String> NOTEBOOK_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotebookInstanceName").getter(getter(DescribeNotebookInstanceResponse::notebookInstanceName))
            .setter(setter(Builder::notebookInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceName").build())
            .build();

    private static final SdkField<String> NOTEBOOK_INSTANCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotebookInstanceStatus")
            .getter(getter(DescribeNotebookInstanceResponse::notebookInstanceStatusAsString))
            .setter(setter(Builder::notebookInstanceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstanceStatus").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeNotebookInstanceResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(DescribeNotebookInstanceResponse::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(DescribeNotebookInstanceResponse::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddressType").getter(getter(DescribeNotebookInstanceResponse::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(DescribeNotebookInstanceResponse::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroups")
            .getter(getter(DescribeNotebookInstanceResponse::securityGroups))
            .setter(setter(Builder::securityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeNotebookInstanceResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(DescribeNotebookInstanceResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId").getter(getter(DescribeNotebookInstanceResponse::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeNotebookInstanceResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeNotebookInstanceResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NotebookInstanceLifecycleConfigName")
            .getter(getter(DescribeNotebookInstanceResponse::notebookInstanceLifecycleConfigName))
            .setter(setter(Builder::notebookInstanceLifecycleConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("NotebookInstanceLifecycleConfigName").build()).build();

    private static final SdkField<String> DIRECT_INTERNET_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectInternetAccess").getter(getter(DescribeNotebookInstanceResponse::directInternetAccessAsString))
            .setter(setter(Builder::directInternetAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectInternetAccess").build())
            .build();

    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VolumeSizeInGB").getter(getter(DescribeNotebookInstanceResponse::volumeSizeInGB))
            .setter(setter(Builder::volumeSizeInGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInGB").build()).build();

    private static final SdkField<List<String>> ACCELERATOR_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AcceleratorTypes")
            .getter(getter(DescribeNotebookInstanceResponse::acceleratorTypesAsStrings))
            .setter(setter(Builder::acceleratorTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_CODE_REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultCodeRepository").getter(getter(DescribeNotebookInstanceResponse::defaultCodeRepository))
            .setter(setter(Builder::defaultCodeRepository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCodeRepository").build())
            .build();

    private static final SdkField<List<String>> ADDITIONAL_CODE_REPOSITORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalCodeRepositories")
            .getter(getter(DescribeNotebookInstanceResponse::additionalCodeRepositories))
            .setter(setter(Builder::additionalCodeRepositories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalCodeRepositories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROOT_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RootAccess").getter(getter(DescribeNotebookInstanceResponse::rootAccessAsString))
            .setter(setter(Builder::rootAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootAccess").build()).build();

    private static final SdkField<String> PLATFORM_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformIdentifier").getter(getter(DescribeNotebookInstanceResponse::platformIdentifier))
            .setter(setter(Builder::platformIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformIdentifier").build())
            .build();

    private static final SdkField<InstanceMetadataServiceConfiguration> INSTANCE_METADATA_SERVICE_CONFIGURATION_FIELD = SdkField
            .<InstanceMetadataServiceConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceMetadataServiceConfiguration")
            .getter(getter(DescribeNotebookInstanceResponse::instanceMetadataServiceConfiguration))
            .setter(setter(Builder::instanceMetadataServiceConfiguration))
            .constructor(InstanceMetadataServiceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("InstanceMetadataServiceConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_INSTANCE_ARN_FIELD,
            NOTEBOOK_INSTANCE_NAME_FIELD, NOTEBOOK_INSTANCE_STATUS_FIELD, FAILURE_REASON_FIELD, URL_FIELD, INSTANCE_TYPE_FIELD,
            IP_ADDRESS_TYPE_FIELD, SUBNET_ID_FIELD, SECURITY_GROUPS_FIELD, ROLE_ARN_FIELD, KMS_KEY_ID_FIELD,
            NETWORK_INTERFACE_ID_FIELD, LAST_MODIFIED_TIME_FIELD, CREATION_TIME_FIELD,
            NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD, DIRECT_INTERNET_ACCESS_FIELD, VOLUME_SIZE_IN_GB_FIELD,
            ACCELERATOR_TYPES_FIELD, DEFAULT_CODE_REPOSITORY_FIELD, ADDITIONAL_CODE_REPOSITORIES_FIELD, ROOT_ACCESS_FIELD,
            PLATFORM_IDENTIFIER_FIELD, INSTANCE_METADATA_SERVICE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String notebookInstanceArn;

    private final String notebookInstanceName;

    private final String notebookInstanceStatus;

    private final String failureReason;

    private final String url;

    private final String instanceType;

    private final String ipAddressType;

    private final String subnetId;

    private final List<String> securityGroups;

    private final String roleArn;

    private final String kmsKeyId;

    private final String networkInterfaceId;

    private final Instant lastModifiedTime;

    private final Instant creationTime;

    private final String notebookInstanceLifecycleConfigName;

    private final String directInternetAccess;

    private final Integer volumeSizeInGB;

    private final List<String> acceleratorTypes;

    private final String defaultCodeRepository;

    private final List<String> additionalCodeRepositories;

    private final String rootAccess;

    private final String platformIdentifier;

    private final InstanceMetadataServiceConfiguration instanceMetadataServiceConfiguration;

    private DescribeNotebookInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.notebookInstanceArn = builder.notebookInstanceArn;
        this.notebookInstanceName = builder.notebookInstanceName;
        this.notebookInstanceStatus = builder.notebookInstanceStatus;
        this.failureReason = builder.failureReason;
        this.url = builder.url;
        this.instanceType = builder.instanceType;
        this.ipAddressType = builder.ipAddressType;
        this.subnetId = builder.subnetId;
        this.securityGroups = builder.securityGroups;
        this.roleArn = builder.roleArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.creationTime = builder.creationTime;
        this.notebookInstanceLifecycleConfigName = builder.notebookInstanceLifecycleConfigName;
        this.directInternetAccess = builder.directInternetAccess;
        this.volumeSizeInGB = builder.volumeSizeInGB;
        this.acceleratorTypes = builder.acceleratorTypes;
        this.defaultCodeRepository = builder.defaultCodeRepository;
        this.additionalCodeRepositories = builder.additionalCodeRepositories;
        this.rootAccess = builder.rootAccess;
        this.platformIdentifier = builder.platformIdentifier;
        this.instanceMetadataServiceConfiguration = builder.instanceMetadataServiceConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the notebook instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the notebook instance.
     */
    public final String notebookInstanceArn() {
        return notebookInstanceArn;
    }

    /**
     * <p>
     * The name of the SageMaker AI notebook instance.
     * </p>
     * 
     * @return The name of the SageMaker AI notebook instance.
     */
    public final String notebookInstanceName() {
        return notebookInstanceName;
    }

    /**
     * <p>
     * The status of the notebook instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #notebookInstanceStatus} will return {@link NotebookInstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #notebookInstanceStatusAsString}.
     * </p>
     * 
     * @return The status of the notebook instance.
     * @see NotebookInstanceStatus
     */
    public final NotebookInstanceStatus notebookInstanceStatus() {
        return NotebookInstanceStatus.fromValue(notebookInstanceStatus);
    }

    /**
     * <p>
     * The status of the notebook instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #notebookInstanceStatus} will return {@link NotebookInstanceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #notebookInstanceStatusAsString}.
     * </p>
     * 
     * @return The status of the notebook instance.
     * @see NotebookInstanceStatus
     */
    public final String notebookInstanceStatusAsString() {
        return notebookInstanceStatus;
    }

    /**
     * <p>
     * If status is <code>Failed</code>, the reason it failed.
     * </p>
     * 
     * @return If status is <code>Failed</code>, the reason it failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The URL that you use to connect to the Jupyter notebook that is running in your notebook instance.
     * </p>
     * 
     * @return The URL that you use to connect to the Jupyter notebook that is running in your notebook instance.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The type of ML compute instance running on the notebook instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type of ML compute instance running on the notebook instance.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The type of ML compute instance running on the notebook instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type of ML compute instance running on the notebook instance.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The IP address type configured for the notebook instance. Returns <code>ipv4</code> for IPv4-only connectivity or
     * <code>dualstack</code> for both IPv4 and IPv6 connectivity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IPAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type configured for the notebook instance. Returns <code>ipv4</code> for IPv4-only
     *         connectivity or <code>dualstack</code> for both IPv4 and IPv6 connectivity.
     * @see IPAddressType
     */
    public final IPAddressType ipAddressType() {
        return IPAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The IP address type configured for the notebook instance. Returns <code>ipv4</code> for IPv4-only connectivity or
     * <code>dualstack</code> for both IPv4 and IPv6 connectivity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IPAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type configured for the notebook instance. Returns <code>ipv4</code> for IPv4-only
     *         connectivity or <code>dualstack</code> for both IPv4 and IPv6 connectivity.
     * @see IPAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * <p>
     * The ID of the VPC subnet.
     * </p>
     * 
     * @return The ID of the VPC subnet.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroups() {
        return securityGroups != null && !(securityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the VPC security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroups} method.
     * </p>
     * 
     * @return The IDs of the VPC security groups.
     */
    public final List<String> securityGroups() {
        return securityGroups;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role associated with the instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role associated with the instance.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key ID SageMaker AI uses to encrypt data when storing it on the ML storage volume
     * attached to the instance.
     * </p>
     * 
     * @return The Amazon Web Services KMS key ID SageMaker AI uses to encrypt data when storing it on the ML storage
     *         volume attached to the instance.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The network interface IDs that SageMaker AI created at the time of creating the instance.
     * </p>
     * 
     * @return The network interface IDs that SageMaker AI created at the time of creating the instance.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * A timestamp. Use this parameter to retrieve the time when the notebook instance was last modified.
     * </p>
     * 
     * @return A timestamp. Use this parameter to retrieve the time when the notebook instance was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * A timestamp. Use this parameter to return the time when the notebook instance was created
     * </p>
     * 
     * @return A timestamp. Use this parameter to return the time when the notebook instance was created
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Returns the name of a notebook instance lifecycle configuration.
     * </p>
     * <p>
     * For information about notebook instance lifestyle configurations, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
     * Customize a Notebook Instance</a>
     * </p>
     * 
     * @return Returns the name of a notebook instance lifecycle configuration.</p>
     *         <p>
     *         For information about notebook instance lifestyle configurations, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1:
     *         (Optional) Customize a Notebook Instance</a>
     */
    public final String notebookInstanceLifecycleConfigName() {
        return notebookInstanceLifecycleConfigName;
    }

    /**
     * <p>
     * Describes whether SageMaker AI provides internet access to the notebook instance. If this value is set to
     * <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to SageMaker AI training
     * and endpoint services.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
     * >Notebook Instances Are Internet-Enabled by Default</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #directInternetAccess} will return {@link DirectInternetAccess#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #directInternetAccessAsString}.
     * </p>
     * 
     * @return Describes whether SageMaker AI provides internet access to the notebook instance. If this value is set to
     *         <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to SageMaker AI
     *         training and endpoint services.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
     *         >Notebook Instances Are Internet-Enabled by Default</a>.
     * @see DirectInternetAccess
     */
    public final DirectInternetAccess directInternetAccess() {
        return DirectInternetAccess.fromValue(directInternetAccess);
    }

    /**
     * <p>
     * Describes whether SageMaker AI provides internet access to the notebook instance. If this value is set to
     * <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to SageMaker AI training
     * and endpoint services.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
     * >Notebook Instances Are Internet-Enabled by Default</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #directInternetAccess} will return {@link DirectInternetAccess#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #directInternetAccessAsString}.
     * </p>
     * 
     * @return Describes whether SageMaker AI provides internet access to the notebook instance. If this value is set to
     *         <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to SageMaker AI
     *         training and endpoint services.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
     *         >Notebook Instances Are Internet-Enabled by Default</a>.
     * @see DirectInternetAccess
     */
    public final String directInternetAccessAsString() {
        return directInternetAccess;
    }

    /**
     * <p>
     * The size, in GB, of the ML storage volume attached to the notebook instance.
     * </p>
     * 
     * @return The size, in GB, of the ML storage volume attached to the notebook instance.
     */
    public final Integer volumeSizeInGB() {
        return volumeSizeInGB;
    }

    /**
     * <p>
     * This parameter is no longer supported. Elastic Inference (EI) is no longer available.
     * </p>
     * <p>
     * This parameter was used to specify a list of the EI instance types associated with this notebook instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAcceleratorTypes} method.
     * </p>
     * 
     * @return This parameter is no longer supported. Elastic Inference (EI) is no longer available.</p>
     *         <p>
     *         This parameter was used to specify a list of the EI instance types associated with this notebook
     *         instance.
     */
    public final List<NotebookInstanceAcceleratorType> acceleratorTypes() {
        return NotebookInstanceAcceleratorTypesCopier.copyStringToEnum(acceleratorTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AcceleratorTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAcceleratorTypes() {
        return acceleratorTypes != null && !(acceleratorTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This parameter is no longer supported. Elastic Inference (EI) is no longer available.
     * </p>
     * <p>
     * This parameter was used to specify a list of the EI instance types associated with this notebook instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAcceleratorTypes} method.
     * </p>
     * 
     * @return This parameter is no longer supported. Elastic Inference (EI) is no longer available.</p>
     *         <p>
     *         This parameter was used to specify a list of the EI instance types associated with this notebook
     *         instance.
     */
    public final List<String> acceleratorTypesAsStrings() {
        return acceleratorTypes;
    }

    /**
     * <p>
     * The Git repository associated with the notebook instance as its default code repository. This can be either the
     * name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or
     * in any other Git repository. When you open a notebook instance, it opens in the directory that contains this
     * repository. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with
     * SageMaker AI Notebook Instances</a>.
     * </p>
     * 
     * @return The Git repository associated with the notebook instance as its default code repository. This can be
     *         either the name of a Git repository stored as a resource in your account, or the URL of a Git repository
     *         in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
     *         CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the
     *         directory that contains this repository. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
     *         with SageMaker AI Notebook Instances</a>.
     */
    public final String defaultCodeRepository() {
        return defaultCodeRepository;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalCodeRepositories property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalCodeRepositories() {
        return additionalCodeRepositories != null && !(additionalCodeRepositories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of up to three Git repositories associated with the notebook instance. These can be either the names of
     * Git repositories stored as resources in your account, or the URL of Git repositories in <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services CodeCommit</a> or
     * in any other Git repository. These repositories are cloned at the same level as the default repository of your
     * notebook instance. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with
     * SageMaker AI Notebook Instances</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalCodeRepositories} method.
     * </p>
     * 
     * @return An array of up to three Git repositories associated with the notebook instance. These can be either the
     *         names of Git repositories stored as resources in your account, or the URL of Git repositories in <a
     *         href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
     *         CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the
     *         default repository of your notebook instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
     *         with SageMaker AI Notebook Instances</a>.
     */
    public final List<String> additionalCodeRepositories() {
        return additionalCodeRepositories;
    }

    /**
     * <p>
     * Whether root access is enabled or disabled for users of the notebook instance.
     * </p>
     * <note>
     * <p>
     * Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle
     * configurations associated with a notebook instance always run with root access even if you disable root access
     * for users.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootAccess} will
     * return {@link RootAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootAccessAsString}.
     * </p>
     * 
     * @return Whether root access is enabled or disabled for users of the notebook instance.</p> <note>
     *         <p>
     *         Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
     *         lifecycle configurations associated with a notebook instance always run with root access even if you
     *         disable root access for users.
     *         </p>
     * @see RootAccess
     */
    public final RootAccess rootAccess() {
        return RootAccess.fromValue(rootAccess);
    }

    /**
     * <p>
     * Whether root access is enabled or disabled for users of the notebook instance.
     * </p>
     * <note>
     * <p>
     * Lifecycle configurations need root access to be able to set up a notebook instance. Because of this, lifecycle
     * configurations associated with a notebook instance always run with root access even if you disable root access
     * for users.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootAccess} will
     * return {@link RootAccess#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rootAccessAsString}.
     * </p>
     * 
     * @return Whether root access is enabled or disabled for users of the notebook instance.</p> <note>
     *         <p>
     *         Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
     *         lifecycle configurations associated with a notebook instance always run with root access even if you
     *         disable root access for users.
     *         </p>
     * @see RootAccess
     */
    public final String rootAccessAsString() {
        return rootAccess;
    }

    /**
     * <p>
     * The platform identifier of the notebook instance runtime environment.
     * </p>
     * 
     * @return The platform identifier of the notebook instance runtime environment.
     */
    public final String platformIdentifier() {
        return platformIdentifier;
    }

    /**
     * <p>
     * Information on the IMDS configuration of the notebook instance
     * </p>
     * 
     * @return Information on the IMDS configuration of the notebook instance
     */
    public final InstanceMetadataServiceConfiguration instanceMetadataServiceConfiguration() {
        return instanceMetadataServiceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroups() ? securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(notebookInstanceLifecycleConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(directInternetAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(hasAcceleratorTypes() ? acceleratorTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultCodeRepository());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalCodeRepositories() ? additionalCodeRepositories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(rootAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platformIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(instanceMetadataServiceConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotebookInstanceResponse)) {
            return false;
        }
        DescribeNotebookInstanceResponse other = (DescribeNotebookInstanceResponse) obj;
        return Objects.equals(notebookInstanceArn(), other.notebookInstanceArn())
                && Objects.equals(notebookInstanceName(), other.notebookInstanceName())
                && Objects.equals(notebookInstanceStatusAsString(), other.notebookInstanceStatusAsString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(url(), other.url())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString())
                && Objects.equals(subnetId(), other.subnetId()) && hasSecurityGroups() == other.hasSecurityGroups()
                && Objects.equals(securityGroups(), other.securityGroups()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(notebookInstanceLifecycleConfigName(), other.notebookInstanceLifecycleConfigName())
                && Objects.equals(directInternetAccessAsString(), other.directInternetAccessAsString())
                && Objects.equals(volumeSizeInGB(), other.volumeSizeInGB())
                && hasAcceleratorTypes() == other.hasAcceleratorTypes()
                && Objects.equals(acceleratorTypesAsStrings(), other.acceleratorTypesAsStrings())
                && Objects.equals(defaultCodeRepository(), other.defaultCodeRepository())
                && hasAdditionalCodeRepositories() == other.hasAdditionalCodeRepositories()
                && Objects.equals(additionalCodeRepositories(), other.additionalCodeRepositories())
                && Objects.equals(rootAccessAsString(), other.rootAccessAsString())
                && Objects.equals(platformIdentifier(), other.platformIdentifier())
                && Objects.equals(instanceMetadataServiceConfiguration(), other.instanceMetadataServiceConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeNotebookInstanceResponse").add("NotebookInstanceArn", notebookInstanceArn())
                .add("NotebookInstanceName", notebookInstanceName())
                .add("NotebookInstanceStatus", notebookInstanceStatusAsString()).add("FailureReason", failureReason())
                .add("Url", url()).add("InstanceType", instanceTypeAsString()).add("IpAddressType", ipAddressTypeAsString())
                .add("SubnetId", subnetId()).add("SecurityGroups", hasSecurityGroups() ? securityGroups() : null)
                .add("RoleArn", roleArn()).add("KmsKeyId", kmsKeyId()).add("NetworkInterfaceId", networkInterfaceId())
                .add("LastModifiedTime", lastModifiedTime()).add("CreationTime", creationTime())
                .add("NotebookInstanceLifecycleConfigName", notebookInstanceLifecycleConfigName())
                .add("DirectInternetAccess", directInternetAccessAsString()).add("VolumeSizeInGB", volumeSizeInGB())
                .add("AcceleratorTypes", hasAcceleratorTypes() ? acceleratorTypesAsStrings() : null)
                .add("DefaultCodeRepository", defaultCodeRepository())
                .add("AdditionalCodeRepositories", hasAdditionalCodeRepositories() ? additionalCodeRepositories() : null)
                .add("RootAccess", rootAccessAsString()).add("PlatformIdentifier", platformIdentifier())
                .add("InstanceMetadataServiceConfiguration", instanceMetadataServiceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotebookInstanceArn":
            return Optional.ofNullable(clazz.cast(notebookInstanceArn()));
        case "NotebookInstanceName":
            return Optional.ofNullable(clazz.cast(notebookInstanceName()));
        case "NotebookInstanceStatus":
            return Optional.ofNullable(clazz.cast(notebookInstanceStatusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "IpAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "NotebookInstanceLifecycleConfigName":
            return Optional.ofNullable(clazz.cast(notebookInstanceLifecycleConfigName()));
        case "DirectInternetAccess":
            return Optional.ofNullable(clazz.cast(directInternetAccessAsString()));
        case "VolumeSizeInGB":
            return Optional.ofNullable(clazz.cast(volumeSizeInGB()));
        case "AcceleratorTypes":
            return Optional.ofNullable(clazz.cast(acceleratorTypesAsStrings()));
        case "DefaultCodeRepository":
            return Optional.ofNullable(clazz.cast(defaultCodeRepository()));
        case "AdditionalCodeRepositories":
            return Optional.ofNullable(clazz.cast(additionalCodeRepositories()));
        case "RootAccess":
            return Optional.ofNullable(clazz.cast(rootAccessAsString()));
        case "PlatformIdentifier":
            return Optional.ofNullable(clazz.cast(platformIdentifier()));
        case "InstanceMetadataServiceConfiguration":
            return Optional.ofNullable(clazz.cast(instanceMetadataServiceConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NotebookInstanceArn", NOTEBOOK_INSTANCE_ARN_FIELD);
        map.put("NotebookInstanceName", NOTEBOOK_INSTANCE_NAME_FIELD);
        map.put("NotebookInstanceStatus", NOTEBOOK_INSTANCE_STATUS_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("Url", URL_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("SecurityGroups", SECURITY_GROUPS_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("NotebookInstanceLifecycleConfigName", NOTEBOOK_INSTANCE_LIFECYCLE_CONFIG_NAME_FIELD);
        map.put("DirectInternetAccess", DIRECT_INTERNET_ACCESS_FIELD);
        map.put("VolumeSizeInGB", VOLUME_SIZE_IN_GB_FIELD);
        map.put("AcceleratorTypes", ACCELERATOR_TYPES_FIELD);
        map.put("DefaultCodeRepository", DEFAULT_CODE_REPOSITORY_FIELD);
        map.put("AdditionalCodeRepositories", ADDITIONAL_CODE_REPOSITORIES_FIELD);
        map.put("RootAccess", ROOT_ACCESS_FIELD);
        map.put("PlatformIdentifier", PLATFORM_IDENTIFIER_FIELD);
        map.put("InstanceMetadataServiceConfiguration", INSTANCE_METADATA_SERVICE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeNotebookInstanceResponse, T> g) {
        return obj -> g.apply((DescribeNotebookInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeNotebookInstanceResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the notebook instance.
         * </p>
         * 
         * @param notebookInstanceArn
         *        The Amazon Resource Name (ARN) of the notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceArn(String notebookInstanceArn);

        /**
         * <p>
         * The name of the SageMaker AI notebook instance.
         * </p>
         * 
         * @param notebookInstanceName
         *        The name of the SageMaker AI notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceName(String notebookInstanceName);

        /**
         * <p>
         * The status of the notebook instance.
         * </p>
         * 
         * @param notebookInstanceStatus
         *        The status of the notebook instance.
         * @see NotebookInstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotebookInstanceStatus
         */
        Builder notebookInstanceStatus(String notebookInstanceStatus);

        /**
         * <p>
         * The status of the notebook instance.
         * </p>
         * 
         * @param notebookInstanceStatus
         *        The status of the notebook instance.
         * @see NotebookInstanceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NotebookInstanceStatus
         */
        Builder notebookInstanceStatus(NotebookInstanceStatus notebookInstanceStatus);

        /**
         * <p>
         * If status is <code>Failed</code>, the reason it failed.
         * </p>
         * 
         * @param failureReason
         *        If status is <code>Failed</code>, the reason it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The URL that you use to connect to the Jupyter notebook that is running in your notebook instance.
         * </p>
         * 
         * @param url
         *        The URL that you use to connect to the Jupyter notebook that is running in your notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The type of ML compute instance running on the notebook instance.
         * </p>
         * 
         * @param instanceType
         *        The type of ML compute instance running on the notebook instance.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The type of ML compute instance running on the notebook instance.
         * </p>
         * 
         * @param instanceType
         *        The type of ML compute instance running on the notebook instance.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The IP address type configured for the notebook instance. Returns <code>ipv4</code> for IPv4-only
         * connectivity or <code>dualstack</code> for both IPv4 and IPv6 connectivity.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type configured for the notebook instance. Returns <code>ipv4</code> for IPv4-only
         *        connectivity or <code>dualstack</code> for both IPv4 and IPv6 connectivity.
         * @see IPAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IPAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The IP address type configured for the notebook instance. Returns <code>ipv4</code> for IPv4-only
         * connectivity or <code>dualstack</code> for both IPv4 and IPv6 connectivity.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type configured for the notebook instance. Returns <code>ipv4</code> for IPv4-only
         *        connectivity or <code>dualstack</code> for both IPv4 and IPv6 connectivity.
         * @see IPAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IPAddressType
         */
        Builder ipAddressType(IPAddressType ipAddressType);

        /**
         * <p>
         * The ID of the VPC subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the VPC subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The IDs of the VPC security groups.
         * </p>
         * 
         * @param securityGroups
         *        The IDs of the VPC security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * The IDs of the VPC security groups.
         * </p>
         * 
         * @param securityGroups
         *        The IDs of the VPC security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role associated with the instance.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon Web Services KMS key ID SageMaker AI uses to encrypt data when storing it on the ML storage volume
         * attached to the instance.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services KMS key ID SageMaker AI uses to encrypt data when storing it on the ML storage
         *        volume attached to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The network interface IDs that SageMaker AI created at the time of creating the instance.
         * </p>
         * 
         * @param networkInterfaceId
         *        The network interface IDs that SageMaker AI created at the time of creating the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * A timestamp. Use this parameter to retrieve the time when the notebook instance was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        A timestamp. Use this parameter to retrieve the time when the notebook instance was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * A timestamp. Use this parameter to return the time when the notebook instance was created
         * </p>
         * 
         * @param creationTime
         *        A timestamp. Use this parameter to return the time when the notebook instance was created
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Returns the name of a notebook instance lifecycle configuration.
         * </p>
         * <p>
         * For information about notebook instance lifestyle configurations, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1: (Optional)
         * Customize a Notebook Instance</a>
         * </p>
         * 
         * @param notebookInstanceLifecycleConfigName
         *        Returns the name of a notebook instance lifecycle configuration.</p>
         *        <p>
         *        For information about notebook instance lifestyle configurations, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html">Step 2.1:
         *        (Optional) Customize a Notebook Instance</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName);

        /**
         * <p>
         * Describes whether SageMaker AI provides internet access to the notebook instance. If this value is set to
         * <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to SageMaker AI
         * training and endpoint services.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
         * >Notebook Instances Are Internet-Enabled by Default</a>.
         * </p>
         * 
         * @param directInternetAccess
         *        Describes whether SageMaker AI provides internet access to the notebook instance. If this value is set
         *        to <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to
         *        SageMaker AI training and endpoint services.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
         *        >Notebook Instances Are Internet-Enabled by Default</a>.
         * @see DirectInternetAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectInternetAccess
         */
        Builder directInternetAccess(String directInternetAccess);

        /**
         * <p>
         * Describes whether SageMaker AI provides internet access to the notebook instance. If this value is set to
         * <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to SageMaker AI
         * training and endpoint services.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
         * >Notebook Instances Are Internet-Enabled by Default</a>.
         * </p>
         * 
         * @param directInternetAccess
         *        Describes whether SageMaker AI provides internet access to the notebook instance. If this value is set
         *        to <i>Disabled</i>, the notebook instance does not have internet access, and cannot connect to
         *        SageMaker AI training and endpoint services.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access"
         *        >Notebook Instances Are Internet-Enabled by Default</a>.
         * @see DirectInternetAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectInternetAccess
         */
        Builder directInternetAccess(DirectInternetAccess directInternetAccess);

        /**
         * <p>
         * The size, in GB, of the ML storage volume attached to the notebook instance.
         * </p>
         * 
         * @param volumeSizeInGB
         *        The size, in GB, of the ML storage volume attached to the notebook instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSizeInGB(Integer volumeSizeInGB);

        /**
         * <p>
         * This parameter is no longer supported. Elastic Inference (EI) is no longer available.
         * </p>
         * <p>
         * This parameter was used to specify a list of the EI instance types associated with this notebook instance.
         * </p>
         * 
         * @param acceleratorTypes
         *        This parameter is no longer supported. Elastic Inference (EI) is no longer available.</p>
         *        <p>
         *        This parameter was used to specify a list of the EI instance types associated with this notebook
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypesWithStrings(Collection<String> acceleratorTypes);

        /**
         * <p>
         * This parameter is no longer supported. Elastic Inference (EI) is no longer available.
         * </p>
         * <p>
         * This parameter was used to specify a list of the EI instance types associated with this notebook instance.
         * </p>
         * 
         * @param acceleratorTypes
         *        This parameter is no longer supported. Elastic Inference (EI) is no longer available.</p>
         *        <p>
         *        This parameter was used to specify a list of the EI instance types associated with this notebook
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypesWithStrings(String... acceleratorTypes);

        /**
         * <p>
         * This parameter is no longer supported. Elastic Inference (EI) is no longer available.
         * </p>
         * <p>
         * This parameter was used to specify a list of the EI instance types associated with this notebook instance.
         * </p>
         * 
         * @param acceleratorTypes
         *        This parameter is no longer supported. Elastic Inference (EI) is no longer available.</p>
         *        <p>
         *        This parameter was used to specify a list of the EI instance types associated with this notebook
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypes(Collection<NotebookInstanceAcceleratorType> acceleratorTypes);

        /**
         * <p>
         * This parameter is no longer supported. Elastic Inference (EI) is no longer available.
         * </p>
         * <p>
         * This parameter was used to specify a list of the EI instance types associated with this notebook instance.
         * </p>
         * 
         * @param acceleratorTypes
         *        This parameter is no longer supported. Elastic Inference (EI) is no longer available.</p>
         *        <p>
         *        This parameter was used to specify a list of the EI instance types associated with this notebook
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypes(NotebookInstanceAcceleratorType... acceleratorTypes);

        /**
         * <p>
         * The Git repository associated with the notebook instance as its default code repository. This can be either
         * the name of a Git repository stored as a resource in your account, or the URL of a Git repository in <a
         * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
         * CodeCommit</a> or in any other Git repository. When you open a notebook instance, it opens in the directory
         * that contains this repository. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with
         * SageMaker AI Notebook Instances</a>.
         * </p>
         * 
         * @param defaultCodeRepository
         *        The Git repository associated with the notebook instance as its default code repository. This can be
         *        either the name of a Git repository stored as a resource in your account, or the URL of a Git
         *        repository in <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon
         *        Web Services CodeCommit</a> or in any other Git repository. When you open a notebook instance, it
         *        opens in the directory that contains this repository. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
         *        with SageMaker AI Notebook Instances</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCodeRepository(String defaultCodeRepository);

        /**
         * <p>
         * An array of up to three Git repositories associated with the notebook instance. These can be either the names
         * of Git repositories stored as resources in your account, or the URL of Git repositories in <a
         * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
         * CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default
         * repository of your notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with
         * SageMaker AI Notebook Instances</a>.
         * </p>
         * 
         * @param additionalCodeRepositories
         *        An array of up to three Git repositories associated with the notebook instance. These can be either
         *        the names of Git repositories stored as resources in your account, or the URL of Git repositories in
         *        <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
         *        CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the
         *        default repository of your notebook instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
         *        with SageMaker AI Notebook Instances</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalCodeRepositories(Collection<String> additionalCodeRepositories);

        /**
         * <p>
         * An array of up to three Git repositories associated with the notebook instance. These can be either the names
         * of Git repositories stored as resources in your account, or the URL of Git repositories in <a
         * href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
         * CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the default
         * repository of your notebook instance. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories with
         * SageMaker AI Notebook Instances</a>.
         * </p>
         * 
         * @param additionalCodeRepositories
         *        An array of up to three Git repositories associated with the notebook instance. These can be either
         *        the names of Git repositories stored as resources in your account, or the URL of Git repositories in
         *        <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html">Amazon Web Services
         *        CodeCommit</a> or in any other Git repository. These repositories are cloned at the same level as the
         *        default repository of your notebook instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html">Associating Git Repositories
         *        with SageMaker AI Notebook Instances</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalCodeRepositories(String... additionalCodeRepositories);

        /**
         * <p>
         * Whether root access is enabled or disabled for users of the notebook instance.
         * </p>
         * <note>
         * <p>
         * Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
         * lifecycle configurations associated with a notebook instance always run with root access even if you disable
         * root access for users.
         * </p>
         * </note>
         * 
         * @param rootAccess
         *        Whether root access is enabled or disabled for users of the notebook instance.</p> <note>
         *        <p>
         *        Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
         *        lifecycle configurations associated with a notebook instance always run with root access even if you
         *        disable root access for users.
         *        </p>
         * @see RootAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootAccess
         */
        Builder rootAccess(String rootAccess);

        /**
         * <p>
         * Whether root access is enabled or disabled for users of the notebook instance.
         * </p>
         * <note>
         * <p>
         * Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
         * lifecycle configurations associated with a notebook instance always run with root access even if you disable
         * root access for users.
         * </p>
         * </note>
         * 
         * @param rootAccess
         *        Whether root access is enabled or disabled for users of the notebook instance.</p> <note>
         *        <p>
         *        Lifecycle configurations need root access to be able to set up a notebook instance. Because of this,
         *        lifecycle configurations associated with a notebook instance always run with root access even if you
         *        disable root access for users.
         *        </p>
         * @see RootAccess
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootAccess
         */
        Builder rootAccess(RootAccess rootAccess);

        /**
         * <p>
         * The platform identifier of the notebook instance runtime environment.
         * </p>
         * 
         * @param platformIdentifier
         *        The platform identifier of the notebook instance runtime environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformIdentifier(String platformIdentifier);

        /**
         * <p>
         * Information on the IMDS configuration of the notebook instance
         * </p>
         * 
         * @param instanceMetadataServiceConfiguration
         *        Information on the IMDS configuration of the notebook instance
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMetadataServiceConfiguration(InstanceMetadataServiceConfiguration instanceMetadataServiceConfiguration);

        /**
         * <p>
         * Information on the IMDS configuration of the notebook instance
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InstanceMetadataServiceConfiguration.Builder} avoiding the need to create one manually via
         * {@link InstanceMetadataServiceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceMetadataServiceConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #instanceMetadataServiceConfiguration(InstanceMetadataServiceConfiguration)}.
         * 
         * @param instanceMetadataServiceConfiguration
         *        a consumer that will call methods on {@link InstanceMetadataServiceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceMetadataServiceConfiguration(InstanceMetadataServiceConfiguration)
         */
        default Builder instanceMetadataServiceConfiguration(
                Consumer<InstanceMetadataServiceConfiguration.Builder> instanceMetadataServiceConfiguration) {
            return instanceMetadataServiceConfiguration(InstanceMetadataServiceConfiguration.builder()
                    .applyMutation(instanceMetadataServiceConfiguration).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String notebookInstanceArn;

        private String notebookInstanceName;

        private String notebookInstanceStatus;

        private String failureReason;

        private String url;

        private String instanceType;

        private String ipAddressType;

        private String subnetId;

        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private String kmsKeyId;

        private String networkInterfaceId;

        private Instant lastModifiedTime;

        private Instant creationTime;

        private String notebookInstanceLifecycleConfigName;

        private String directInternetAccess;

        private Integer volumeSizeInGB;

        private List<String> acceleratorTypes = DefaultSdkAutoConstructList.getInstance();

        private String defaultCodeRepository;

        private List<String> additionalCodeRepositories = DefaultSdkAutoConstructList.getInstance();

        private String rootAccess;

        private String platformIdentifier;

        private InstanceMetadataServiceConfiguration instanceMetadataServiceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotebookInstanceResponse model) {
            super(model);
            notebookInstanceArn(model.notebookInstanceArn);
            notebookInstanceName(model.notebookInstanceName);
            notebookInstanceStatus(model.notebookInstanceStatus);
            failureReason(model.failureReason);
            url(model.url);
            instanceType(model.instanceType);
            ipAddressType(model.ipAddressType);
            subnetId(model.subnetId);
            securityGroups(model.securityGroups);
            roleArn(model.roleArn);
            kmsKeyId(model.kmsKeyId);
            networkInterfaceId(model.networkInterfaceId);
            lastModifiedTime(model.lastModifiedTime);
            creationTime(model.creationTime);
            notebookInstanceLifecycleConfigName(model.notebookInstanceLifecycleConfigName);
            directInternetAccess(model.directInternetAccess);
            volumeSizeInGB(model.volumeSizeInGB);
            acceleratorTypesWithStrings(model.acceleratorTypes);
            defaultCodeRepository(model.defaultCodeRepository);
            additionalCodeRepositories(model.additionalCodeRepositories);
            rootAccess(model.rootAccess);
            platformIdentifier(model.platformIdentifier);
            instanceMetadataServiceConfiguration(model.instanceMetadataServiceConfiguration);
        }

        public final String getNotebookInstanceArn() {
            return notebookInstanceArn;
        }

        public final void setNotebookInstanceArn(String notebookInstanceArn) {
            this.notebookInstanceArn = notebookInstanceArn;
        }

        @Override
        public final Builder notebookInstanceArn(String notebookInstanceArn) {
            this.notebookInstanceArn = notebookInstanceArn;
            return this;
        }

        public final String getNotebookInstanceName() {
            return notebookInstanceName;
        }

        public final void setNotebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
        }

        @Override
        public final Builder notebookInstanceName(String notebookInstanceName) {
            this.notebookInstanceName = notebookInstanceName;
            return this;
        }

        public final String getNotebookInstanceStatus() {
            return notebookInstanceStatus;
        }

        public final void setNotebookInstanceStatus(String notebookInstanceStatus) {
            this.notebookInstanceStatus = notebookInstanceStatus;
        }

        @Override
        public final Builder notebookInstanceStatus(String notebookInstanceStatus) {
            this.notebookInstanceStatus = notebookInstanceStatus;
            return this;
        }

        @Override
        public final Builder notebookInstanceStatus(NotebookInstanceStatus notebookInstanceStatus) {
            this.notebookInstanceStatus(notebookInstanceStatus == null ? null : notebookInstanceStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IPAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupIdsCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupIdsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getNotebookInstanceLifecycleConfigName() {
            return notebookInstanceLifecycleConfigName;
        }

        public final void setNotebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
        }

        @Override
        public final Builder notebookInstanceLifecycleConfigName(String notebookInstanceLifecycleConfigName) {
            this.notebookInstanceLifecycleConfigName = notebookInstanceLifecycleConfigName;
            return this;
        }

        public final String getDirectInternetAccess() {
            return directInternetAccess;
        }

        public final void setDirectInternetAccess(String directInternetAccess) {
            this.directInternetAccess = directInternetAccess;
        }

        @Override
        public final Builder directInternetAccess(String directInternetAccess) {
            this.directInternetAccess = directInternetAccess;
            return this;
        }

        @Override
        public final Builder directInternetAccess(DirectInternetAccess directInternetAccess) {
            this.directInternetAccess(directInternetAccess == null ? null : directInternetAccess.toString());
            return this;
        }

        public final Integer getVolumeSizeInGB() {
            return volumeSizeInGB;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        @Override
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        public final Collection<String> getAcceleratorTypes() {
            if (acceleratorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return acceleratorTypes;
        }

        public final void setAcceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copy(acceleratorTypes);
        }

        @Override
        public final Builder acceleratorTypesWithStrings(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copy(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypesWithStrings(String... acceleratorTypes) {
            acceleratorTypesWithStrings(Arrays.asList(acceleratorTypes));
            return this;
        }

        @Override
        public final Builder acceleratorTypes(Collection<NotebookInstanceAcceleratorType> acceleratorTypes) {
            this.acceleratorTypes = NotebookInstanceAcceleratorTypesCopier.copyEnumToString(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypes(NotebookInstanceAcceleratorType... acceleratorTypes) {
            acceleratorTypes(Arrays.asList(acceleratorTypes));
            return this;
        }

        public final String getDefaultCodeRepository() {
            return defaultCodeRepository;
        }

        public final void setDefaultCodeRepository(String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
        }

        @Override
        public final Builder defaultCodeRepository(String defaultCodeRepository) {
            this.defaultCodeRepository = defaultCodeRepository;
            return this;
        }

        public final Collection<String> getAdditionalCodeRepositories() {
            if (additionalCodeRepositories instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalCodeRepositories;
        }

        public final void setAdditionalCodeRepositories(Collection<String> additionalCodeRepositories) {
            this.additionalCodeRepositories = AdditionalCodeRepositoryNamesOrUrlsCopier.copy(additionalCodeRepositories);
        }

        @Override
        public final Builder additionalCodeRepositories(Collection<String> additionalCodeRepositories) {
            this.additionalCodeRepositories = AdditionalCodeRepositoryNamesOrUrlsCopier.copy(additionalCodeRepositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalCodeRepositories(String... additionalCodeRepositories) {
            additionalCodeRepositories(Arrays.asList(additionalCodeRepositories));
            return this;
        }

        public final String getRootAccess() {
            return rootAccess;
        }

        public final void setRootAccess(String rootAccess) {
            this.rootAccess = rootAccess;
        }

        @Override
        public final Builder rootAccess(String rootAccess) {
            this.rootAccess = rootAccess;
            return this;
        }

        @Override
        public final Builder rootAccess(RootAccess rootAccess) {
            this.rootAccess(rootAccess == null ? null : rootAccess.toString());
            return this;
        }

        public final String getPlatformIdentifier() {
            return platformIdentifier;
        }

        public final void setPlatformIdentifier(String platformIdentifier) {
            this.platformIdentifier = platformIdentifier;
        }

        @Override
        public final Builder platformIdentifier(String platformIdentifier) {
            this.platformIdentifier = platformIdentifier;
            return this;
        }

        public final InstanceMetadataServiceConfiguration.Builder getInstanceMetadataServiceConfiguration() {
            return instanceMetadataServiceConfiguration != null ? instanceMetadataServiceConfiguration.toBuilder() : null;
        }

        public final void setInstanceMetadataServiceConfiguration(
                InstanceMetadataServiceConfiguration.BuilderImpl instanceMetadataServiceConfiguration) {
            this.instanceMetadataServiceConfiguration = instanceMetadataServiceConfiguration != null ? instanceMetadataServiceConfiguration
                    .build() : null;
        }

        @Override
        public final Builder instanceMetadataServiceConfiguration(
                InstanceMetadataServiceConfiguration instanceMetadataServiceConfiguration) {
            this.instanceMetadataServiceConfiguration = instanceMetadataServiceConfiguration;
            return this;
        }

        @Override
        public DescribeNotebookInstanceResponse build() {
            return new DescribeNotebookInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
