/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedCapacityResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeReservedCapacityResponse.Builder, DescribeReservedCapacityResponse> {
    private static final SdkField<String> RESERVED_CAPACITY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservedCapacityArn").getter(getter(DescribeReservedCapacityResponse::reservedCapacityArn))
            .setter(setter(Builder::reservedCapacityArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCapacityArn").build())
            .build();

    private static final SdkField<String> RESERVED_CAPACITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservedCapacityType").getter(getter(DescribeReservedCapacityResponse::reservedCapacityTypeAsString))
            .setter(setter(Builder::reservedCapacityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedCapacityType").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeReservedCapacityResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(DescribeReservedCapacityResponse::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<Long> DURATION_HOURS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationHours").getter(getter(DescribeReservedCapacityResponse::durationHours))
            .setter(setter(Builder::durationHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationHours").build()).build();

    private static final SdkField<Long> DURATION_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationMinutes").getter(getter(DescribeReservedCapacityResponse::durationMinutes))
            .setter(setter(Builder::durationMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMinutes").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(DescribeReservedCapacityResponse::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(DescribeReservedCapacityResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(DescribeReservedCapacityResponse::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<Integer> TOTAL_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalInstanceCount").getter(getter(DescribeReservedCapacityResponse::totalInstanceCount))
            .setter(setter(Builder::totalInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInstanceCount").build())
            .build();

    private static final SdkField<Integer> AVAILABLE_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AvailableInstanceCount").getter(getter(DescribeReservedCapacityResponse::availableInstanceCount))
            .setter(setter(Builder::availableInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableInstanceCount").build())
            .build();

    private static final SdkField<Integer> IN_USE_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InUseInstanceCount").getter(getter(DescribeReservedCapacityResponse::inUseInstanceCount))
            .setter(setter(Builder::inUseInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InUseInstanceCount").build())
            .build();

    private static final SdkField<UltraServerSummary> ULTRA_SERVER_SUMMARY_FIELD = SdkField
            .<UltraServerSummary> builder(MarshallingType.SDK_POJO).memberName("UltraServerSummary")
            .getter(getter(DescribeReservedCapacityResponse::ultraServerSummary)).setter(setter(Builder::ultraServerSummary))
            .constructor(UltraServerSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UltraServerSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_CAPACITY_ARN_FIELD,
            RESERVED_CAPACITY_TYPE_FIELD, STATUS_FIELD, AVAILABILITY_ZONE_FIELD, DURATION_HOURS_FIELD, DURATION_MINUTES_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, INSTANCE_TYPE_FIELD, TOTAL_INSTANCE_COUNT_FIELD, AVAILABLE_INSTANCE_COUNT_FIELD,
            IN_USE_INSTANCE_COUNT_FIELD, ULTRA_SERVER_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String reservedCapacityArn;

    private final String reservedCapacityType;

    private final String status;

    private final String availabilityZone;

    private final Long durationHours;

    private final Long durationMinutes;

    private final Instant startTime;

    private final Instant endTime;

    private final String instanceType;

    private final Integer totalInstanceCount;

    private final Integer availableInstanceCount;

    private final Integer inUseInstanceCount;

    private final UltraServerSummary ultraServerSummary;

    private DescribeReservedCapacityResponse(BuilderImpl builder) {
        super(builder);
        this.reservedCapacityArn = builder.reservedCapacityArn;
        this.reservedCapacityType = builder.reservedCapacityType;
        this.status = builder.status;
        this.availabilityZone = builder.availabilityZone;
        this.durationHours = builder.durationHours;
        this.durationMinutes = builder.durationMinutes;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.instanceType = builder.instanceType;
        this.totalInstanceCount = builder.totalInstanceCount;
        this.availableInstanceCount = builder.availableInstanceCount;
        this.inUseInstanceCount = builder.inUseInstanceCount;
        this.ultraServerSummary = builder.ultraServerSummary;
    }

    /**
     * <p>
     * ARN of the reserved capacity.
     * </p>
     * 
     * @return ARN of the reserved capacity.
     */
    public final String reservedCapacityArn() {
        return reservedCapacityArn;
    }

    /**
     * <p>
     * The type of reserved capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #reservedCapacityType} will return {@link ReservedCapacityType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #reservedCapacityTypeAsString}.
     * </p>
     * 
     * @return The type of reserved capacity.
     * @see ReservedCapacityType
     */
    public final ReservedCapacityType reservedCapacityType() {
        return ReservedCapacityType.fromValue(reservedCapacityType);
    }

    /**
     * <p>
     * The type of reserved capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #reservedCapacityType} will return {@link ReservedCapacityType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #reservedCapacityTypeAsString}.
     * </p>
     * 
     * @return The type of reserved capacity.
     * @see ReservedCapacityType
     */
    public final String reservedCapacityTypeAsString() {
        return reservedCapacityType;
    }

    /**
     * <p>
     * The current status of the reserved capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReservedCapacityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the reserved capacity.
     * @see ReservedCapacityStatus
     */
    public final ReservedCapacityStatus status() {
        return ReservedCapacityStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the reserved capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReservedCapacityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the reserved capacity.
     * @see ReservedCapacityStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Availability Zone where the reserved capacity is provisioned.
     * </p>
     * 
     * @return The Availability Zone where the reserved capacity is provisioned.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The total duration of the reserved capacity in hours.
     * </p>
     * 
     * @return The total duration of the reserved capacity in hours.
     */
    public final Long durationHours() {
        return durationHours;
    }

    /**
     * <p>
     * The number of minutes for the duration of the reserved capacity. For example, if a reserved capacity starts at
     * 08:55 and ends at 11:30, the minutes field would be 35.
     * </p>
     * 
     * @return The number of minutes for the duration of the reserved capacity. For example, if a reserved capacity
     *         starts at 08:55 and ends at 11:30, the minutes field would be 35.
     */
    public final Long durationMinutes() {
        return durationMinutes;
    }

    /**
     * <p>
     * The timestamp when the reserved capacity becomes active.
     * </p>
     * 
     * @return The timestamp when the reserved capacity becomes active.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The timestamp when the reserved capacity expires.
     * </p>
     * 
     * @return The timestamp when the reserved capacity expires.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The Amazon EC2 instance type used in the reserved capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ReservedCapacityInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The Amazon EC2 instance type used in the reserved capacity.
     * @see ReservedCapacityInstanceType
     */
    public final ReservedCapacityInstanceType instanceType() {
        return ReservedCapacityInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The Amazon EC2 instance type used in the reserved capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ReservedCapacityInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The Amazon EC2 instance type used in the reserved capacity.
     * @see ReservedCapacityInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The total number of instances allocated to this reserved capacity.
     * </p>
     * 
     * @return The total number of instances allocated to this reserved capacity.
     */
    public final Integer totalInstanceCount() {
        return totalInstanceCount;
    }

    /**
     * <p>
     * The number of instances currently available for use in this reserved capacity.
     * </p>
     * 
     * @return The number of instances currently available for use in this reserved capacity.
     */
    public final Integer availableInstanceCount() {
        return availableInstanceCount;
    }

    /**
     * <p>
     * The number of instances currently in use from this reserved capacity.
     * </p>
     * 
     * @return The number of instances currently in use from this reserved capacity.
     */
    public final Integer inUseInstanceCount() {
        return inUseInstanceCount;
    }

    /**
     * <p>
     * A summary of the UltraServer associated with this reserved capacity.
     * </p>
     * 
     * @return A summary of the UltraServer associated with this reserved capacity.
     */
    public final UltraServerSummary ultraServerSummary() {
        return ultraServerSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservedCapacityArn());
        hashCode = 31 * hashCode + Objects.hashCode(reservedCapacityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(durationHours());
        hashCode = 31 * hashCode + Objects.hashCode(durationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(totalInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(availableInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(inUseInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(ultraServerSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedCapacityResponse)) {
            return false;
        }
        DescribeReservedCapacityResponse other = (DescribeReservedCapacityResponse) obj;
        return Objects.equals(reservedCapacityArn(), other.reservedCapacityArn())
                && Objects.equals(reservedCapacityTypeAsString(), other.reservedCapacityTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(durationHours(), other.durationHours())
                && Objects.equals(durationMinutes(), other.durationMinutes()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(totalInstanceCount(), other.totalInstanceCount())
                && Objects.equals(availableInstanceCount(), other.availableInstanceCount())
                && Objects.equals(inUseInstanceCount(), other.inUseInstanceCount())
                && Objects.equals(ultraServerSummary(), other.ultraServerSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReservedCapacityResponse").add("ReservedCapacityArn", reservedCapacityArn())
                .add("ReservedCapacityType", reservedCapacityTypeAsString()).add("Status", statusAsString())
                .add("AvailabilityZone", availabilityZone()).add("DurationHours", durationHours())
                .add("DurationMinutes", durationMinutes()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("InstanceType", instanceTypeAsString()).add("TotalInstanceCount", totalInstanceCount())
                .add("AvailableInstanceCount", availableInstanceCount()).add("InUseInstanceCount", inUseInstanceCount())
                .add("UltraServerSummary", ultraServerSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedCapacityArn":
            return Optional.ofNullable(clazz.cast(reservedCapacityArn()));
        case "ReservedCapacityType":
            return Optional.ofNullable(clazz.cast(reservedCapacityTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "DurationHours":
            return Optional.ofNullable(clazz.cast(durationHours()));
        case "DurationMinutes":
            return Optional.ofNullable(clazz.cast(durationMinutes()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "TotalInstanceCount":
            return Optional.ofNullable(clazz.cast(totalInstanceCount()));
        case "AvailableInstanceCount":
            return Optional.ofNullable(clazz.cast(availableInstanceCount()));
        case "InUseInstanceCount":
            return Optional.ofNullable(clazz.cast(inUseInstanceCount()));
        case "UltraServerSummary":
            return Optional.ofNullable(clazz.cast(ultraServerSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReservedCapacityArn", RESERVED_CAPACITY_ARN_FIELD);
        map.put("ReservedCapacityType", RESERVED_CAPACITY_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("DurationHours", DURATION_HOURS_FIELD);
        map.put("DurationMinutes", DURATION_MINUTES_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("TotalInstanceCount", TOTAL_INSTANCE_COUNT_FIELD);
        map.put("AvailableInstanceCount", AVAILABLE_INSTANCE_COUNT_FIELD);
        map.put("InUseInstanceCount", IN_USE_INSTANCE_COUNT_FIELD);
        map.put("UltraServerSummary", ULTRA_SERVER_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedCapacityResponse, T> g) {
        return obj -> g.apply((DescribeReservedCapacityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReservedCapacityResponse> {
        /**
         * <p>
         * ARN of the reserved capacity.
         * </p>
         * 
         * @param reservedCapacityArn
         *        ARN of the reserved capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedCapacityArn(String reservedCapacityArn);

        /**
         * <p>
         * The type of reserved capacity.
         * </p>
         * 
         * @param reservedCapacityType
         *        The type of reserved capacity.
         * @see ReservedCapacityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedCapacityType
         */
        Builder reservedCapacityType(String reservedCapacityType);

        /**
         * <p>
         * The type of reserved capacity.
         * </p>
         * 
         * @param reservedCapacityType
         *        The type of reserved capacity.
         * @see ReservedCapacityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedCapacityType
         */
        Builder reservedCapacityType(ReservedCapacityType reservedCapacityType);

        /**
         * <p>
         * The current status of the reserved capacity.
         * </p>
         * 
         * @param status
         *        The current status of the reserved capacity.
         * @see ReservedCapacityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedCapacityStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the reserved capacity.
         * </p>
         * 
         * @param status
         *        The current status of the reserved capacity.
         * @see ReservedCapacityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedCapacityStatus
         */
        Builder status(ReservedCapacityStatus status);

        /**
         * <p>
         * The Availability Zone where the reserved capacity is provisioned.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone where the reserved capacity is provisioned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The total duration of the reserved capacity in hours.
         * </p>
         * 
         * @param durationHours
         *        The total duration of the reserved capacity in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationHours(Long durationHours);

        /**
         * <p>
         * The number of minutes for the duration of the reserved capacity. For example, if a reserved capacity starts
         * at 08:55 and ends at 11:30, the minutes field would be 35.
         * </p>
         * 
         * @param durationMinutes
         *        The number of minutes for the duration of the reserved capacity. For example, if a reserved capacity
         *        starts at 08:55 and ends at 11:30, the minutes field would be 35.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationMinutes(Long durationMinutes);

        /**
         * <p>
         * The timestamp when the reserved capacity becomes active.
         * </p>
         * 
         * @param startTime
         *        The timestamp when the reserved capacity becomes active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The timestamp when the reserved capacity expires.
         * </p>
         * 
         * @param endTime
         *        The timestamp when the reserved capacity expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The Amazon EC2 instance type used in the reserved capacity.
         * </p>
         * 
         * @param instanceType
         *        The Amazon EC2 instance type used in the reserved capacity.
         * @see ReservedCapacityInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedCapacityInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The Amazon EC2 instance type used in the reserved capacity.
         * </p>
         * 
         * @param instanceType
         *        The Amazon EC2 instance type used in the reserved capacity.
         * @see ReservedCapacityInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReservedCapacityInstanceType
         */
        Builder instanceType(ReservedCapacityInstanceType instanceType);

        /**
         * <p>
         * The total number of instances allocated to this reserved capacity.
         * </p>
         * 
         * @param totalInstanceCount
         *        The total number of instances allocated to this reserved capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalInstanceCount(Integer totalInstanceCount);

        /**
         * <p>
         * The number of instances currently available for use in this reserved capacity.
         * </p>
         * 
         * @param availableInstanceCount
         *        The number of instances currently available for use in this reserved capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableInstanceCount(Integer availableInstanceCount);

        /**
         * <p>
         * The number of instances currently in use from this reserved capacity.
         * </p>
         * 
         * @param inUseInstanceCount
         *        The number of instances currently in use from this reserved capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inUseInstanceCount(Integer inUseInstanceCount);

        /**
         * <p>
         * A summary of the UltraServer associated with this reserved capacity.
         * </p>
         * 
         * @param ultraServerSummary
         *        A summary of the UltraServer associated with this reserved capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ultraServerSummary(UltraServerSummary ultraServerSummary);

        /**
         * <p>
         * A summary of the UltraServer associated with this reserved capacity.
         * </p>
         * This is a convenience method that creates an instance of the {@link UltraServerSummary.Builder} avoiding the
         * need to create one manually via {@link UltraServerSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UltraServerSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #ultraServerSummary(UltraServerSummary)}.
         * 
         * @param ultraServerSummary
         *        a consumer that will call methods on {@link UltraServerSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ultraServerSummary(UltraServerSummary)
         */
        default Builder ultraServerSummary(Consumer<UltraServerSummary.Builder> ultraServerSummary) {
            return ultraServerSummary(UltraServerSummary.builder().applyMutation(ultraServerSummary).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String reservedCapacityArn;

        private String reservedCapacityType;

        private String status;

        private String availabilityZone;

        private Long durationHours;

        private Long durationMinutes;

        private Instant startTime;

        private Instant endTime;

        private String instanceType;

        private Integer totalInstanceCount;

        private Integer availableInstanceCount;

        private Integer inUseInstanceCount;

        private UltraServerSummary ultraServerSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedCapacityResponse model) {
            super(model);
            reservedCapacityArn(model.reservedCapacityArn);
            reservedCapacityType(model.reservedCapacityType);
            status(model.status);
            availabilityZone(model.availabilityZone);
            durationHours(model.durationHours);
            durationMinutes(model.durationMinutes);
            startTime(model.startTime);
            endTime(model.endTime);
            instanceType(model.instanceType);
            totalInstanceCount(model.totalInstanceCount);
            availableInstanceCount(model.availableInstanceCount);
            inUseInstanceCount(model.inUseInstanceCount);
            ultraServerSummary(model.ultraServerSummary);
        }

        public final String getReservedCapacityArn() {
            return reservedCapacityArn;
        }

        public final void setReservedCapacityArn(String reservedCapacityArn) {
            this.reservedCapacityArn = reservedCapacityArn;
        }

        @Override
        public final Builder reservedCapacityArn(String reservedCapacityArn) {
            this.reservedCapacityArn = reservedCapacityArn;
            return this;
        }

        public final String getReservedCapacityType() {
            return reservedCapacityType;
        }

        public final void setReservedCapacityType(String reservedCapacityType) {
            this.reservedCapacityType = reservedCapacityType;
        }

        @Override
        public final Builder reservedCapacityType(String reservedCapacityType) {
            this.reservedCapacityType = reservedCapacityType;
            return this;
        }

        @Override
        public final Builder reservedCapacityType(ReservedCapacityType reservedCapacityType) {
            this.reservedCapacityType(reservedCapacityType == null ? null : reservedCapacityType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReservedCapacityStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Long getDurationHours() {
            return durationHours;
        }

        public final void setDurationHours(Long durationHours) {
            this.durationHours = durationHours;
        }

        @Override
        public final Builder durationHours(Long durationHours) {
            this.durationHours = durationHours;
            return this;
        }

        public final Long getDurationMinutes() {
            return durationMinutes;
        }

        public final void setDurationMinutes(Long durationMinutes) {
            this.durationMinutes = durationMinutes;
        }

        @Override
        public final Builder durationMinutes(Long durationMinutes) {
            this.durationMinutes = durationMinutes;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ReservedCapacityInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getTotalInstanceCount() {
            return totalInstanceCount;
        }

        public final void setTotalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
        }

        @Override
        public final Builder totalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
            return this;
        }

        public final Integer getAvailableInstanceCount() {
            return availableInstanceCount;
        }

        public final void setAvailableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
        }

        @Override
        public final Builder availableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
            return this;
        }

        public final Integer getInUseInstanceCount() {
            return inUseInstanceCount;
        }

        public final void setInUseInstanceCount(Integer inUseInstanceCount) {
            this.inUseInstanceCount = inUseInstanceCount;
        }

        @Override
        public final Builder inUseInstanceCount(Integer inUseInstanceCount) {
            this.inUseInstanceCount = inUseInstanceCount;
            return this;
        }

        public final UltraServerSummary.Builder getUltraServerSummary() {
            return ultraServerSummary != null ? ultraServerSummary.toBuilder() : null;
        }

        public final void setUltraServerSummary(UltraServerSummary.BuilderImpl ultraServerSummary) {
            this.ultraServerSummary = ultraServerSummary != null ? ultraServerSummary.build() : null;
        }

        @Override
        public final Builder ultraServerSummary(UltraServerSummary ultraServerSummary) {
            this.ultraServerSummary = ultraServerSummary;
            return this;
        }

        @Override
        public DescribeReservedCapacityResponse build() {
            return new DescribeReservedCapacityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
