/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetachClusterNodeVolumeRequest extends SageMakerRequest implements
        ToCopyableBuilder<DetachClusterNodeVolumeRequest.Builder, DetachClusterNodeVolumeRequest> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(DetachClusterNodeVolumeRequest::clusterArn))
            .setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NodeId")
            .getter(getter(DetachClusterNodeVolumeRequest::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeId").getter(getter(DetachClusterNodeVolumeRequest::volumeId)).setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD,
            NODE_ID_FIELD, VOLUME_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterArn;

    private final String nodeId;

    private final String volumeId;

    private DetachClusterNodeVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.clusterArn = builder.clusterArn;
        this.nodeId = builder.nodeId;
        this.volumeId = builder.volumeId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of your SageMaker HyperPod cluster containing the target node. Your cluster must
     * use EKS as the orchestration and be in the <code>InService</code> state.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of your SageMaker HyperPod cluster containing the target node. Your
     *         cluster must use EKS as the orchestration and be in the <code>InService</code> state.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The unique identifier of the cluster node from which you want to detach the volume.
     * </p>
     * 
     * @return The unique identifier of the cluster node from which you want to detach the volume.
     */
    public final String nodeId() {
        return nodeId;
    }

    /**
     * <p>
     * The unique identifier of your EBS volume that you want to detach. Your volume must be currently attached to the
     * specified node.
     * </p>
     * 
     * @return The unique identifier of your EBS volume that you want to detach. Your volume must be currently attached
     *         to the specified node.
     */
    public final String volumeId() {
        return volumeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachClusterNodeVolumeRequest)) {
            return false;
        }
        DetachClusterNodeVolumeRequest other = (DetachClusterNodeVolumeRequest) obj;
        return Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(nodeId(), other.nodeId())
                && Objects.equals(volumeId(), other.volumeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetachClusterNodeVolumeRequest").add("ClusterArn", clusterArn()).add("NodeId", nodeId())
                .add("VolumeId", volumeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "NodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterArn", CLUSTER_ARN_FIELD);
        map.put("NodeId", NODE_ID_FIELD);
        map.put("VolumeId", VOLUME_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetachClusterNodeVolumeRequest, T> g) {
        return obj -> g.apply((DetachClusterNodeVolumeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, DetachClusterNodeVolumeRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of your SageMaker HyperPod cluster containing the target node. Your cluster
         * must use EKS as the orchestration and be in the <code>InService</code> state.
         * </p>
         * 
         * @param clusterArn
         *        The Amazon Resource Name (ARN) of your SageMaker HyperPod cluster containing the target node. Your
         *        cluster must use EKS as the orchestration and be in the <code>InService</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The unique identifier of the cluster node from which you want to detach the volume.
         * </p>
         * 
         * @param nodeId
         *        The unique identifier of the cluster node from which you want to detach the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);

        /**
         * <p>
         * The unique identifier of your EBS volume that you want to detach. Your volume must be currently attached to
         * the specified node.
         * </p>
         * 
         * @param volumeId
         *        The unique identifier of your EBS volume that you want to detach. Your volume must be currently
         *        attached to the specified node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String clusterArn;

        private String nodeId;

        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachClusterNodeVolumeRequest model) {
            super(model);
            clusterArn(model.clusterArn);
            nodeId(model.nodeId);
            volumeId(model.volumeId);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getNodeId() {
            return nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetachClusterNodeVolumeRequest build() {
            return new DetachClusterNodeVolumeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
