/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of <code>Domain</code> configuration settings to update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainSettingsForUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainSettingsForUpdate.Builder, DomainSettingsForUpdate> {
    private static final SdkField<RStudioServerProDomainSettingsForUpdate> R_STUDIO_SERVER_PRO_DOMAIN_SETTINGS_FOR_UPDATE_FIELD = SdkField
            .<RStudioServerProDomainSettingsForUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("RStudioServerProDomainSettingsForUpdate")
            .getter(getter(DomainSettingsForUpdate::rStudioServerProDomainSettingsForUpdate))
            .setter(setter(Builder::rStudioServerProDomainSettingsForUpdate))
            .constructor(RStudioServerProDomainSettingsForUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("RStudioServerProDomainSettingsForUpdate").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_IDENTITY_CONFIG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleIdentityConfig")
            .getter(getter(DomainSettingsForUpdate::executionRoleIdentityConfigAsString))
            .setter(setter(Builder::executionRoleIdentityConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleIdentityConfig")
                    .build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(DomainSettingsForUpdate::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TrustedIdentityPropagationSettings> TRUSTED_IDENTITY_PROPAGATION_SETTINGS_FIELD = SdkField
            .<TrustedIdentityPropagationSettings> builder(MarshallingType.SDK_POJO)
            .memberName("TrustedIdentityPropagationSettings")
            .getter(getter(DomainSettingsForUpdate::trustedIdentityPropagationSettings))
            .setter(setter(Builder::trustedIdentityPropagationSettings))
            .constructor(TrustedIdentityPropagationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustedIdentityPropagationSettings")
                    .build()).build();

    private static final SdkField<DockerSettings> DOCKER_SETTINGS_FIELD = SdkField
            .<DockerSettings> builder(MarshallingType.SDK_POJO).memberName("DockerSettings")
            .getter(getter(DomainSettingsForUpdate::dockerSettings)).setter(setter(Builder::dockerSettings))
            .constructor(DockerSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DockerSettings").build()).build();

    private static final SdkField<AmazonQSettings> AMAZON_Q_SETTINGS_FIELD = SdkField
            .<AmazonQSettings> builder(MarshallingType.SDK_POJO).memberName("AmazonQSettings")
            .getter(getter(DomainSettingsForUpdate::amazonQSettings)).setter(setter(Builder::amazonQSettings))
            .constructor(AmazonQSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonQSettings").build()).build();

    private static final SdkField<UnifiedStudioSettings> UNIFIED_STUDIO_SETTINGS_FIELD = SdkField
            .<UnifiedStudioSettings> builder(MarshallingType.SDK_POJO).memberName("UnifiedStudioSettings")
            .getter(getter(DomainSettingsForUpdate::unifiedStudioSettings)).setter(setter(Builder::unifiedStudioSettings))
            .constructor(UnifiedStudioSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnifiedStudioSettings").build())
            .build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddressType").getter(getter(DomainSettingsForUpdate::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            R_STUDIO_SERVER_PRO_DOMAIN_SETTINGS_FOR_UPDATE_FIELD, EXECUTION_ROLE_IDENTITY_CONFIG_FIELD, SECURITY_GROUP_IDS_FIELD,
            TRUSTED_IDENTITY_PROPAGATION_SETTINGS_FIELD, DOCKER_SETTINGS_FIELD, AMAZON_Q_SETTINGS_FIELD,
            UNIFIED_STUDIO_SETTINGS_FIELD, IP_ADDRESS_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RStudioServerProDomainSettingsForUpdate rStudioServerProDomainSettingsForUpdate;

    private final String executionRoleIdentityConfig;

    private final List<String> securityGroupIds;

    private final TrustedIdentityPropagationSettings trustedIdentityPropagationSettings;

    private final DockerSettings dockerSettings;

    private final AmazonQSettings amazonQSettings;

    private final UnifiedStudioSettings unifiedStudioSettings;

    private final String ipAddressType;

    private DomainSettingsForUpdate(BuilderImpl builder) {
        this.rStudioServerProDomainSettingsForUpdate = builder.rStudioServerProDomainSettingsForUpdate;
        this.executionRoleIdentityConfig = builder.executionRoleIdentityConfig;
        this.securityGroupIds = builder.securityGroupIds;
        this.trustedIdentityPropagationSettings = builder.trustedIdentityPropagationSettings;
        this.dockerSettings = builder.dockerSettings;
        this.amazonQSettings = builder.amazonQSettings;
        this.unifiedStudioSettings = builder.unifiedStudioSettings;
        this.ipAddressType = builder.ipAddressType;
    }

    /**
     * <p>
     * A collection of <code>RStudioServerPro</code> Domain-level app settings to update. A single
     * <code>RStudioServerPro</code> application is created for a domain.
     * </p>
     * 
     * @return A collection of <code>RStudioServerPro</code> Domain-level app settings to update. A single
     *         <code>RStudioServerPro</code> application is created for a domain.
     */
    public final RStudioServerProDomainSettingsForUpdate rStudioServerProDomainSettingsForUpdate() {
        return rStudioServerProDomainSettingsForUpdate;
    }

    /**
     * <p>
     * The configuration for attaching a SageMaker AI user profile name to the execution role as a <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html"
     * >sts:SourceIdentity key</a>. This configuration can only be modified if there are no apps in the
     * <code>InService</code> or <code>Pending</code> state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #executionRoleIdentityConfig} will return {@link ExecutionRoleIdentityConfig#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #executionRoleIdentityConfigAsString}.
     * </p>
     * 
     * @return The configuration for attaching a SageMaker AI user profile name to the execution role as a <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html"
     *         >sts:SourceIdentity key</a>. This configuration can only be modified if there are no apps in the
     *         <code>InService</code> or <code>Pending</code> state.
     * @see ExecutionRoleIdentityConfig
     */
    public final ExecutionRoleIdentityConfig executionRoleIdentityConfig() {
        return ExecutionRoleIdentityConfig.fromValue(executionRoleIdentityConfig);
    }

    /**
     * <p>
     * The configuration for attaching a SageMaker AI user profile name to the execution role as a <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html"
     * >sts:SourceIdentity key</a>. This configuration can only be modified if there are no apps in the
     * <code>InService</code> or <code>Pending</code> state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #executionRoleIdentityConfig} will return {@link ExecutionRoleIdentityConfig#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #executionRoleIdentityConfigAsString}.
     * </p>
     * 
     * @return The configuration for attaching a SageMaker AI user profile name to the execution role as a <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html"
     *         >sts:SourceIdentity key</a>. This configuration can only be modified if there are no apps in the
     *         <code>InService</code> or <code>Pending</code> state.
     * @see ExecutionRoleIdentityConfig
     */
    public final String executionRoleIdentityConfigAsString() {
        return executionRoleIdentityConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for communication
     * between Domain-level apps and user apps.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for
     *         communication between Domain-level apps and user apps.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The Trusted Identity Propagation (TIP) settings for the SageMaker domain. These settings determine how user
     * identities from IAM Identity Center are propagated through the domain to TIP enabled Amazon Web Services
     * services.
     * </p>
     * 
     * @return The Trusted Identity Propagation (TIP) settings for the SageMaker domain. These settings determine how
     *         user identities from IAM Identity Center are propagated through the domain to TIP enabled Amazon Web
     *         Services services.
     */
    public final TrustedIdentityPropagationSettings trustedIdentityPropagationSettings() {
        return trustedIdentityPropagationSettings;
    }

    /**
     * <p>
     * A collection of settings that configure the domain's Docker interaction.
     * </p>
     * 
     * @return A collection of settings that configure the domain's Docker interaction.
     */
    public final DockerSettings dockerSettings() {
        return dockerSettings;
    }

    /**
     * <p>
     * A collection of settings that configure the Amazon Q experience within the domain.
     * </p>
     * 
     * @return A collection of settings that configure the Amazon Q experience within the domain.
     */
    public final AmazonQSettings amazonQSettings() {
        return amazonQSettings;
    }

    /**
     * <p>
     * The settings that apply to an SageMaker AI domain when you use it in Amazon SageMaker Unified Studio.
     * </p>
     * 
     * @return The settings that apply to an SageMaker AI domain when you use it in Amazon SageMaker Unified Studio.
     */
    public final UnifiedStudioSettings unifiedStudioSettings() {
        return unifiedStudioSettings;
    }

    /**
     * <p>
     * The IP address type for the domain. Specify <code>ipv4</code> for IPv4-only connectivity or
     * <code>dualstack</code> for both IPv4 and IPv6 connectivity. When you specify <code>dualstack</code>, the subnet
     * must support IPv6 CIDR blocks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IPAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the domain. Specify <code>ipv4</code> for IPv4-only connectivity or
     *         <code>dualstack</code> for both IPv4 and IPv6 connectivity. When you specify <code>dualstack</code>, the
     *         subnet must support IPv6 CIDR blocks.
     * @see IPAddressType
     */
    public final IPAddressType ipAddressType() {
        return IPAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The IP address type for the domain. Specify <code>ipv4</code> for IPv4-only connectivity or
     * <code>dualstack</code> for both IPv4 and IPv6 connectivity. When you specify <code>dualstack</code>, the subnet
     * must support IPv6 CIDR blocks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IPAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the domain. Specify <code>ipv4</code> for IPv4-only connectivity or
     *         <code>dualstack</code> for both IPv4 and IPv6 connectivity. When you specify <code>dualstack</code>, the
     *         subnet must support IPv6 CIDR blocks.
     * @see IPAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rStudioServerProDomainSettingsForUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleIdentityConfigAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(trustedIdentityPropagationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(dockerSettings());
        hashCode = 31 * hashCode + Objects.hashCode(amazonQSettings());
        hashCode = 31 * hashCode + Objects.hashCode(unifiedStudioSettings());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSettingsForUpdate)) {
            return false;
        }
        DomainSettingsForUpdate other = (DomainSettingsForUpdate) obj;
        return Objects.equals(rStudioServerProDomainSettingsForUpdate(), other.rStudioServerProDomainSettingsForUpdate())
                && Objects.equals(executionRoleIdentityConfigAsString(), other.executionRoleIdentityConfigAsString())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(trustedIdentityPropagationSettings(), other.trustedIdentityPropagationSettings())
                && Objects.equals(dockerSettings(), other.dockerSettings())
                && Objects.equals(amazonQSettings(), other.amazonQSettings())
                && Objects.equals(unifiedStudioSettings(), other.unifiedStudioSettings())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainSettingsForUpdate")
                .add("RStudioServerProDomainSettingsForUpdate", rStudioServerProDomainSettingsForUpdate())
                .add("ExecutionRoleIdentityConfig", executionRoleIdentityConfigAsString())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("TrustedIdentityPropagationSettings", trustedIdentityPropagationSettings())
                .add("DockerSettings", dockerSettings()).add("AmazonQSettings", amazonQSettings())
                .add("UnifiedStudioSettings", unifiedStudioSettings()).add("IpAddressType", ipAddressTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RStudioServerProDomainSettingsForUpdate":
            return Optional.ofNullable(clazz.cast(rStudioServerProDomainSettingsForUpdate()));
        case "ExecutionRoleIdentityConfig":
            return Optional.ofNullable(clazz.cast(executionRoleIdentityConfigAsString()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "TrustedIdentityPropagationSettings":
            return Optional.ofNullable(clazz.cast(trustedIdentityPropagationSettings()));
        case "DockerSettings":
            return Optional.ofNullable(clazz.cast(dockerSettings()));
        case "AmazonQSettings":
            return Optional.ofNullable(clazz.cast(amazonQSettings()));
        case "UnifiedStudioSettings":
            return Optional.ofNullable(clazz.cast(unifiedStudioSettings()));
        case "IpAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RStudioServerProDomainSettingsForUpdate", R_STUDIO_SERVER_PRO_DOMAIN_SETTINGS_FOR_UPDATE_FIELD);
        map.put("ExecutionRoleIdentityConfig", EXECUTION_ROLE_IDENTITY_CONFIG_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("TrustedIdentityPropagationSettings", TRUSTED_IDENTITY_PROPAGATION_SETTINGS_FIELD);
        map.put("DockerSettings", DOCKER_SETTINGS_FIELD);
        map.put("AmazonQSettings", AMAZON_Q_SETTINGS_FIELD);
        map.put("UnifiedStudioSettings", UNIFIED_STUDIO_SETTINGS_FIELD);
        map.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DomainSettingsForUpdate, T> g) {
        return obj -> g.apply((DomainSettingsForUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainSettingsForUpdate> {
        /**
         * <p>
         * A collection of <code>RStudioServerPro</code> Domain-level app settings to update. A single
         * <code>RStudioServerPro</code> application is created for a domain.
         * </p>
         * 
         * @param rStudioServerProDomainSettingsForUpdate
         *        A collection of <code>RStudioServerPro</code> Domain-level app settings to update. A single
         *        <code>RStudioServerPro</code> application is created for a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rStudioServerProDomainSettingsForUpdate(
                RStudioServerProDomainSettingsForUpdate rStudioServerProDomainSettingsForUpdate);

        /**
         * <p>
         * A collection of <code>RStudioServerPro</code> Domain-level app settings to update. A single
         * <code>RStudioServerPro</code> application is created for a domain.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RStudioServerProDomainSettingsForUpdate.Builder} avoiding the need to create one manually via
         * {@link RStudioServerProDomainSettingsForUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RStudioServerProDomainSettingsForUpdate.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #rStudioServerProDomainSettingsForUpdate(RStudioServerProDomainSettingsForUpdate)}.
         * 
         * @param rStudioServerProDomainSettingsForUpdate
         *        a consumer that will call methods on {@link RStudioServerProDomainSettingsForUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rStudioServerProDomainSettingsForUpdate(RStudioServerProDomainSettingsForUpdate)
         */
        default Builder rStudioServerProDomainSettingsForUpdate(
                Consumer<RStudioServerProDomainSettingsForUpdate.Builder> rStudioServerProDomainSettingsForUpdate) {
            return rStudioServerProDomainSettingsForUpdate(RStudioServerProDomainSettingsForUpdate.builder()
                    .applyMutation(rStudioServerProDomainSettingsForUpdate).build());
        }

        /**
         * <p>
         * The configuration for attaching a SageMaker AI user profile name to the execution role as a <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html"
         * >sts:SourceIdentity key</a>. This configuration can only be modified if there are no apps in the
         * <code>InService</code> or <code>Pending</code> state.
         * </p>
         * 
         * @param executionRoleIdentityConfig
         *        The configuration for attaching a SageMaker AI user profile name to the execution role as a <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html"
         *        >sts:SourceIdentity key</a>. This configuration can only be modified if there are no apps in the
         *        <code>InService</code> or <code>Pending</code> state.
         * @see ExecutionRoleIdentityConfig
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionRoleIdentityConfig
         */
        Builder executionRoleIdentityConfig(String executionRoleIdentityConfig);

        /**
         * <p>
         * The configuration for attaching a SageMaker AI user profile name to the execution role as a <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html"
         * >sts:SourceIdentity key</a>. This configuration can only be modified if there are no apps in the
         * <code>InService</code> or <code>Pending</code> state.
         * </p>
         * 
         * @param executionRoleIdentityConfig
         *        The configuration for attaching a SageMaker AI user profile name to the execution role as a <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html"
         *        >sts:SourceIdentity key</a>. This configuration can only be modified if there are no apps in the
         *        <code>InService</code> or <code>Pending</code> state.
         * @see ExecutionRoleIdentityConfig
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionRoleIdentityConfig
         */
        Builder executionRoleIdentityConfig(ExecutionRoleIdentityConfig executionRoleIdentityConfig);

        /**
         * <p>
         * The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for communication
         * between Domain-level apps and user apps.
         * </p>
         * 
         * @param securityGroupIds
         *        The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for
         *        communication between Domain-level apps and user apps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for communication
         * between Domain-level apps and user apps.
         * </p>
         * 
         * @param securityGroupIds
         *        The security groups for the Amazon Virtual Private Cloud that the <code>Domain</code> uses for
         *        communication between Domain-level apps and user apps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The Trusted Identity Propagation (TIP) settings for the SageMaker domain. These settings determine how user
         * identities from IAM Identity Center are propagated through the domain to TIP enabled Amazon Web Services
         * services.
         * </p>
         * 
         * @param trustedIdentityPropagationSettings
         *        The Trusted Identity Propagation (TIP) settings for the SageMaker domain. These settings determine how
         *        user identities from IAM Identity Center are propagated through the domain to TIP enabled Amazon Web
         *        Services services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustedIdentityPropagationSettings(TrustedIdentityPropagationSettings trustedIdentityPropagationSettings);

        /**
         * <p>
         * The Trusted Identity Propagation (TIP) settings for the SageMaker domain. These settings determine how user
         * identities from IAM Identity Center are propagated through the domain to TIP enabled Amazon Web Services
         * services.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TrustedIdentityPropagationSettings.Builder} avoiding the need to create one manually via
         * {@link TrustedIdentityPropagationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrustedIdentityPropagationSettings.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #trustedIdentityPropagationSettings(TrustedIdentityPropagationSettings)}.
         * 
         * @param trustedIdentityPropagationSettings
         *        a consumer that will call methods on {@link TrustedIdentityPropagationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trustedIdentityPropagationSettings(TrustedIdentityPropagationSettings)
         */
        default Builder trustedIdentityPropagationSettings(
                Consumer<TrustedIdentityPropagationSettings.Builder> trustedIdentityPropagationSettings) {
            return trustedIdentityPropagationSettings(TrustedIdentityPropagationSettings.builder()
                    .applyMutation(trustedIdentityPropagationSettings).build());
        }

        /**
         * <p>
         * A collection of settings that configure the domain's Docker interaction.
         * </p>
         * 
         * @param dockerSettings
         *        A collection of settings that configure the domain's Docker interaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dockerSettings(DockerSettings dockerSettings);

        /**
         * <p>
         * A collection of settings that configure the domain's Docker interaction.
         * </p>
         * This is a convenience method that creates an instance of the {@link DockerSettings.Builder} avoiding the need
         * to create one manually via {@link DockerSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DockerSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #dockerSettings(DockerSettings)}.
         * 
         * @param dockerSettings
         *        a consumer that will call methods on {@link DockerSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dockerSettings(DockerSettings)
         */
        default Builder dockerSettings(Consumer<DockerSettings.Builder> dockerSettings) {
            return dockerSettings(DockerSettings.builder().applyMutation(dockerSettings).build());
        }

        /**
         * <p>
         * A collection of settings that configure the Amazon Q experience within the domain.
         * </p>
         * 
         * @param amazonQSettings
         *        A collection of settings that configure the Amazon Q experience within the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonQSettings(AmazonQSettings amazonQSettings);

        /**
         * <p>
         * A collection of settings that configure the Amazon Q experience within the domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link AmazonQSettings.Builder} avoiding the
         * need to create one manually via {@link AmazonQSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmazonQSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #amazonQSettings(AmazonQSettings)}.
         * 
         * @param amazonQSettings
         *        a consumer that will call methods on {@link AmazonQSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amazonQSettings(AmazonQSettings)
         */
        default Builder amazonQSettings(Consumer<AmazonQSettings.Builder> amazonQSettings) {
            return amazonQSettings(AmazonQSettings.builder().applyMutation(amazonQSettings).build());
        }

        /**
         * <p>
         * The settings that apply to an SageMaker AI domain when you use it in Amazon SageMaker Unified Studio.
         * </p>
         * 
         * @param unifiedStudioSettings
         *        The settings that apply to an SageMaker AI domain when you use it in Amazon SageMaker Unified Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unifiedStudioSettings(UnifiedStudioSettings unifiedStudioSettings);

        /**
         * <p>
         * The settings that apply to an SageMaker AI domain when you use it in Amazon SageMaker Unified Studio.
         * </p>
         * This is a convenience method that creates an instance of the {@link UnifiedStudioSettings.Builder} avoiding
         * the need to create one manually via {@link UnifiedStudioSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnifiedStudioSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #unifiedStudioSettings(UnifiedStudioSettings)}.
         * 
         * @param unifiedStudioSettings
         *        a consumer that will call methods on {@link UnifiedStudioSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unifiedStudioSettings(UnifiedStudioSettings)
         */
        default Builder unifiedStudioSettings(Consumer<UnifiedStudioSettings.Builder> unifiedStudioSettings) {
            return unifiedStudioSettings(UnifiedStudioSettings.builder().applyMutation(unifiedStudioSettings).build());
        }

        /**
         * <p>
         * The IP address type for the domain. Specify <code>ipv4</code> for IPv4-only connectivity or
         * <code>dualstack</code> for both IPv4 and IPv6 connectivity. When you specify <code>dualstack</code>, the
         * subnet must support IPv6 CIDR blocks.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for the domain. Specify <code>ipv4</code> for IPv4-only connectivity or
         *        <code>dualstack</code> for both IPv4 and IPv6 connectivity. When you specify <code>dualstack</code>,
         *        the subnet must support IPv6 CIDR blocks.
         * @see IPAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IPAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The IP address type for the domain. Specify <code>ipv4</code> for IPv4-only connectivity or
         * <code>dualstack</code> for both IPv4 and IPv6 connectivity. When you specify <code>dualstack</code>, the
         * subnet must support IPv6 CIDR blocks.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for the domain. Specify <code>ipv4</code> for IPv4-only connectivity or
         *        <code>dualstack</code> for both IPv4 and IPv6 connectivity. When you specify <code>dualstack</code>,
         *        the subnet must support IPv6 CIDR blocks.
         * @see IPAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IPAddressType
         */
        Builder ipAddressType(IPAddressType ipAddressType);
    }

    static final class BuilderImpl implements Builder {
        private RStudioServerProDomainSettingsForUpdate rStudioServerProDomainSettingsForUpdate;

        private String executionRoleIdentityConfig;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private TrustedIdentityPropagationSettings trustedIdentityPropagationSettings;

        private DockerSettings dockerSettings;

        private AmazonQSettings amazonQSettings;

        private UnifiedStudioSettings unifiedStudioSettings;

        private String ipAddressType;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainSettingsForUpdate model) {
            rStudioServerProDomainSettingsForUpdate(model.rStudioServerProDomainSettingsForUpdate);
            executionRoleIdentityConfig(model.executionRoleIdentityConfig);
            securityGroupIds(model.securityGroupIds);
            trustedIdentityPropagationSettings(model.trustedIdentityPropagationSettings);
            dockerSettings(model.dockerSettings);
            amazonQSettings(model.amazonQSettings);
            unifiedStudioSettings(model.unifiedStudioSettings);
            ipAddressType(model.ipAddressType);
        }

        public final RStudioServerProDomainSettingsForUpdate.Builder getRStudioServerProDomainSettingsForUpdate() {
            return rStudioServerProDomainSettingsForUpdate != null ? rStudioServerProDomainSettingsForUpdate.toBuilder() : null;
        }

        public final void setRStudioServerProDomainSettingsForUpdate(
                RStudioServerProDomainSettingsForUpdate.BuilderImpl rStudioServerProDomainSettingsForUpdate) {
            this.rStudioServerProDomainSettingsForUpdate = rStudioServerProDomainSettingsForUpdate != null ? rStudioServerProDomainSettingsForUpdate
                    .build() : null;
        }

        @Override
        public final Builder rStudioServerProDomainSettingsForUpdate(
                RStudioServerProDomainSettingsForUpdate rStudioServerProDomainSettingsForUpdate) {
            this.rStudioServerProDomainSettingsForUpdate = rStudioServerProDomainSettingsForUpdate;
            return this;
        }

        public final String getExecutionRoleIdentityConfig() {
            return executionRoleIdentityConfig;
        }

        public final void setExecutionRoleIdentityConfig(String executionRoleIdentityConfig) {
            this.executionRoleIdentityConfig = executionRoleIdentityConfig;
        }

        @Override
        public final Builder executionRoleIdentityConfig(String executionRoleIdentityConfig) {
            this.executionRoleIdentityConfig = executionRoleIdentityConfig;
            return this;
        }

        @Override
        public final Builder executionRoleIdentityConfig(ExecutionRoleIdentityConfig executionRoleIdentityConfig) {
            this.executionRoleIdentityConfig(executionRoleIdentityConfig == null ? null : executionRoleIdentityConfig.toString());
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = DomainSecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = DomainSecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final TrustedIdentityPropagationSettings.Builder getTrustedIdentityPropagationSettings() {
            return trustedIdentityPropagationSettings != null ? trustedIdentityPropagationSettings.toBuilder() : null;
        }

        public final void setTrustedIdentityPropagationSettings(
                TrustedIdentityPropagationSettings.BuilderImpl trustedIdentityPropagationSettings) {
            this.trustedIdentityPropagationSettings = trustedIdentityPropagationSettings != null ? trustedIdentityPropagationSettings
                    .build() : null;
        }

        @Override
        public final Builder trustedIdentityPropagationSettings(
                TrustedIdentityPropagationSettings trustedIdentityPropagationSettings) {
            this.trustedIdentityPropagationSettings = trustedIdentityPropagationSettings;
            return this;
        }

        public final DockerSettings.Builder getDockerSettings() {
            return dockerSettings != null ? dockerSettings.toBuilder() : null;
        }

        public final void setDockerSettings(DockerSettings.BuilderImpl dockerSettings) {
            this.dockerSettings = dockerSettings != null ? dockerSettings.build() : null;
        }

        @Override
        public final Builder dockerSettings(DockerSettings dockerSettings) {
            this.dockerSettings = dockerSettings;
            return this;
        }

        public final AmazonQSettings.Builder getAmazonQSettings() {
            return amazonQSettings != null ? amazonQSettings.toBuilder() : null;
        }

        public final void setAmazonQSettings(AmazonQSettings.BuilderImpl amazonQSettings) {
            this.amazonQSettings = amazonQSettings != null ? amazonQSettings.build() : null;
        }

        @Override
        public final Builder amazonQSettings(AmazonQSettings amazonQSettings) {
            this.amazonQSettings = amazonQSettings;
            return this;
        }

        public final UnifiedStudioSettings.Builder getUnifiedStudioSettings() {
            return unifiedStudioSettings != null ? unifiedStudioSettings.toBuilder() : null;
        }

        public final void setUnifiedStudioSettings(UnifiedStudioSettings.BuilderImpl unifiedStudioSettings) {
            this.unifiedStudioSettings = unifiedStudioSettings != null ? unifiedStudioSettings.build() : null;
        }

        @Override
        public final Builder unifiedStudioSettings(UnifiedStudioSettings unifiedStudioSettings) {
            this.unifiedStudioSettings = unifiedStudioSettings;
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IPAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        @Override
        public DomainSettingsForUpdate build() {
            return new DomainSettingsForUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
