/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The EC2 capacity reservations that are shared to an ML capacity reservation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Ec2CapacityReservation implements SdkPojo, Serializable,
        ToCopyableBuilder<Ec2CapacityReservation.Builder, Ec2CapacityReservation> {
    private static final SdkField<String> EC2_CAPACITY_RESERVATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ec2CapacityReservationId").getter(getter(Ec2CapacityReservation::ec2CapacityReservationId))
            .setter(setter(Builder::ec2CapacityReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2CapacityReservationId").build())
            .build();

    private static final SdkField<Integer> TOTAL_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalInstanceCount").getter(getter(Ec2CapacityReservation::totalInstanceCount))
            .setter(setter(Builder::totalInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInstanceCount").build())
            .build();

    private static final SdkField<Integer> AVAILABLE_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AvailableInstanceCount").getter(getter(Ec2CapacityReservation::availableInstanceCount))
            .setter(setter(Builder::availableInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableInstanceCount").build())
            .build();

    private static final SdkField<Integer> USED_BY_CURRENT_ENDPOINT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UsedByCurrentEndpoint").getter(getter(Ec2CapacityReservation::usedByCurrentEndpoint))
            .setter(setter(Builder::usedByCurrentEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsedByCurrentEndpoint").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EC2_CAPACITY_RESERVATION_ID_FIELD, TOTAL_INSTANCE_COUNT_FIELD, AVAILABLE_INSTANCE_COUNT_FIELD,
            USED_BY_CURRENT_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ec2CapacityReservationId;

    private final Integer totalInstanceCount;

    private final Integer availableInstanceCount;

    private final Integer usedByCurrentEndpoint;

    private Ec2CapacityReservation(BuilderImpl builder) {
        this.ec2CapacityReservationId = builder.ec2CapacityReservationId;
        this.totalInstanceCount = builder.totalInstanceCount;
        this.availableInstanceCount = builder.availableInstanceCount;
        this.usedByCurrentEndpoint = builder.usedByCurrentEndpoint;
    }

    /**
     * <p>
     * The unique identifier for an EC2 capacity reservation that's part of the ML capacity reservation.
     * </p>
     * 
     * @return The unique identifier for an EC2 capacity reservation that's part of the ML capacity reservation.
     */
    public final String ec2CapacityReservationId() {
        return ec2CapacityReservationId;
    }

    /**
     * <p>
     * The number of instances that you allocated to the EC2 capacity reservation.
     * </p>
     * 
     * @return The number of instances that you allocated to the EC2 capacity reservation.
     */
    public final Integer totalInstanceCount() {
        return totalInstanceCount;
    }

    /**
     * <p>
     * The number of instances that are currently available in the EC2 capacity reservation.
     * </p>
     * 
     * @return The number of instances that are currently available in the EC2 capacity reservation.
     */
    public final Integer availableInstanceCount() {
        return availableInstanceCount;
    }

    /**
     * <p>
     * The number of instances from the EC2 capacity reservation that are being used by the endpoint.
     * </p>
     * 
     * @return The number of instances from the EC2 capacity reservation that are being used by the endpoint.
     */
    public final Integer usedByCurrentEndpoint() {
        return usedByCurrentEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ec2CapacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(totalInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(availableInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(usedByCurrentEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2CapacityReservation)) {
            return false;
        }
        Ec2CapacityReservation other = (Ec2CapacityReservation) obj;
        return Objects.equals(ec2CapacityReservationId(), other.ec2CapacityReservationId())
                && Objects.equals(totalInstanceCount(), other.totalInstanceCount())
                && Objects.equals(availableInstanceCount(), other.availableInstanceCount())
                && Objects.equals(usedByCurrentEndpoint(), other.usedByCurrentEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Ec2CapacityReservation").add("Ec2CapacityReservationId", ec2CapacityReservationId())
                .add("TotalInstanceCount", totalInstanceCount()).add("AvailableInstanceCount", availableInstanceCount())
                .add("UsedByCurrentEndpoint", usedByCurrentEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ec2CapacityReservationId":
            return Optional.ofNullable(clazz.cast(ec2CapacityReservationId()));
        case "TotalInstanceCount":
            return Optional.ofNullable(clazz.cast(totalInstanceCount()));
        case "AvailableInstanceCount":
            return Optional.ofNullable(clazz.cast(availableInstanceCount()));
        case "UsedByCurrentEndpoint":
            return Optional.ofNullable(clazz.cast(usedByCurrentEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Ec2CapacityReservationId", EC2_CAPACITY_RESERVATION_ID_FIELD);
        map.put("TotalInstanceCount", TOTAL_INSTANCE_COUNT_FIELD);
        map.put("AvailableInstanceCount", AVAILABLE_INSTANCE_COUNT_FIELD);
        map.put("UsedByCurrentEndpoint", USED_BY_CURRENT_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ec2CapacityReservation, T> g) {
        return obj -> g.apply((Ec2CapacityReservation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Ec2CapacityReservation> {
        /**
         * <p>
         * The unique identifier for an EC2 capacity reservation that's part of the ML capacity reservation.
         * </p>
         * 
         * @param ec2CapacityReservationId
         *        The unique identifier for an EC2 capacity reservation that's part of the ML capacity reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2CapacityReservationId(String ec2CapacityReservationId);

        /**
         * <p>
         * The number of instances that you allocated to the EC2 capacity reservation.
         * </p>
         * 
         * @param totalInstanceCount
         *        The number of instances that you allocated to the EC2 capacity reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalInstanceCount(Integer totalInstanceCount);

        /**
         * <p>
         * The number of instances that are currently available in the EC2 capacity reservation.
         * </p>
         * 
         * @param availableInstanceCount
         *        The number of instances that are currently available in the EC2 capacity reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableInstanceCount(Integer availableInstanceCount);

        /**
         * <p>
         * The number of instances from the EC2 capacity reservation that are being used by the endpoint.
         * </p>
         * 
         * @param usedByCurrentEndpoint
         *        The number of instances from the EC2 capacity reservation that are being used by the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usedByCurrentEndpoint(Integer usedByCurrentEndpoint);
    }

    static final class BuilderImpl implements Builder {
        private String ec2CapacityReservationId;

        private Integer totalInstanceCount;

        private Integer availableInstanceCount;

        private Integer usedByCurrentEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2CapacityReservation model) {
            ec2CapacityReservationId(model.ec2CapacityReservationId);
            totalInstanceCount(model.totalInstanceCount);
            availableInstanceCount(model.availableInstanceCount);
            usedByCurrentEndpoint(model.usedByCurrentEndpoint);
        }

        public final String getEc2CapacityReservationId() {
            return ec2CapacityReservationId;
        }

        public final void setEc2CapacityReservationId(String ec2CapacityReservationId) {
            this.ec2CapacityReservationId = ec2CapacityReservationId;
        }

        @Override
        public final Builder ec2CapacityReservationId(String ec2CapacityReservationId) {
            this.ec2CapacityReservationId = ec2CapacityReservationId;
            return this;
        }

        public final Integer getTotalInstanceCount() {
            return totalInstanceCount;
        }

        public final void setTotalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
        }

        @Override
        public final Builder totalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
            return this;
        }

        public final Integer getAvailableInstanceCount() {
            return availableInstanceCount;
        }

        public final void setAvailableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
        }

        @Override
        public final Builder availableInstanceCount(Integer availableInstanceCount) {
            this.availableInstanceCount = availableInstanceCount;
            return this;
        }

        public final Integer getUsedByCurrentEndpoint() {
            return usedByCurrentEndpoint;
        }

        public final void setUsedByCurrentEndpoint(Integer usedByCurrentEndpoint) {
            this.usedByCurrentEndpoint = usedByCurrentEndpoint;
        }

        @Override
        public final Builder usedByCurrentEndpoint(Integer usedByCurrentEndpoint) {
            this.usedByCurrentEndpoint = usedByCurrentEndpoint;
            return this;
        }

        @Override
        public Ec2CapacityReservation build() {
            return new Ec2CapacityReservation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
