/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class Ec2CapacityReservationsListCopier {
    static List<Ec2CapacityReservation> copy(Collection<? extends Ec2CapacityReservation> ec2CapacityReservationsListParam) {
        List<Ec2CapacityReservation> list;
        if (ec2CapacityReservationsListParam == null || ec2CapacityReservationsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Ec2CapacityReservation> modifiableList = new ArrayList<>(ec2CapacityReservationsListParam.size());
            ec2CapacityReservationsListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Ec2CapacityReservation> copyFromBuilder(
            Collection<? extends Ec2CapacityReservation.Builder> ec2CapacityReservationsListParam) {
        List<Ec2CapacityReservation> list;
        if (ec2CapacityReservationsListParam == null || ec2CapacityReservationsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Ec2CapacityReservation> modifiableList = new ArrayList<>(ec2CapacityReservationsListParam.size());
            ec2CapacityReservationsListParam.forEach(entry -> {
                Ec2CapacityReservation member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Ec2CapacityReservation.Builder> copyToBuilder(
            Collection<? extends Ec2CapacityReservation> ec2CapacityReservationsListParam) {
        List<Ec2CapacityReservation.Builder> list;
        if (ec2CapacityReservationsListParam == null || ec2CapacityReservationsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Ec2CapacityReservation.Builder> modifiableList = new ArrayList<>(ec2CapacityReservationsListParam.size());
            ec2CapacityReservationsListParam.forEach(entry -> {
                Ec2CapacityReservation.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
