/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details for the restricted instance groups (RIG) environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentConfigDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentConfigDetails.Builder, EnvironmentConfigDetails> {
    private static final SdkField<FSxLustreConfig> F_SX_LUSTRE_CONFIG_FIELD = SdkField
            .<FSxLustreConfig> builder(MarshallingType.SDK_POJO).memberName("FSxLustreConfig")
            .getter(getter(EnvironmentConfigDetails::fSxLustreConfig)).setter(setter(Builder::fSxLustreConfig))
            .constructor(FSxLustreConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FSxLustreConfig").build()).build();

    private static final SdkField<String> S3_OUTPUT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3OutputPath").getter(getter(EnvironmentConfigDetails::s3OutputPath))
            .setter(setter(Builder::s3OutputPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(F_SX_LUSTRE_CONFIG_FIELD,
            S3_OUTPUT_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FSxLustreConfig fSxLustreConfig;

    private final String s3OutputPath;

    private EnvironmentConfigDetails(BuilderImpl builder) {
        this.fSxLustreConfig = builder.fSxLustreConfig;
        this.s3OutputPath = builder.s3OutputPath;
    }

    /**
     * <p>
     * Configuration settings for an Amazon FSx for Lustre file system to be used with the cluster.
     * </p>
     * 
     * @return Configuration settings for an Amazon FSx for Lustre file system to be used with the cluster.
     */
    public final FSxLustreConfig fSxLustreConfig() {
        return fSxLustreConfig;
    }

    /**
     * <p>
     * The Amazon S3 path where output data from the restricted instance group (RIG) environment will be stored.
     * </p>
     * 
     * @return The Amazon S3 path where output data from the restricted instance group (RIG) environment will be stored.
     */
    public final String s3OutputPath() {
        return s3OutputPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fSxLustreConfig());
        hashCode = 31 * hashCode + Objects.hashCode(s3OutputPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentConfigDetails)) {
            return false;
        }
        EnvironmentConfigDetails other = (EnvironmentConfigDetails) obj;
        return Objects.equals(fSxLustreConfig(), other.fSxLustreConfig()) && Objects.equals(s3OutputPath(), other.s3OutputPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentConfigDetails").add("FSxLustreConfig", fSxLustreConfig())
                .add("S3OutputPath", s3OutputPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FSxLustreConfig":
            return Optional.ofNullable(clazz.cast(fSxLustreConfig()));
        case "S3OutputPath":
            return Optional.ofNullable(clazz.cast(s3OutputPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FSxLustreConfig", F_SX_LUSTRE_CONFIG_FIELD);
        map.put("S3OutputPath", S3_OUTPUT_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentConfigDetails, T> g) {
        return obj -> g.apply((EnvironmentConfigDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentConfigDetails> {
        /**
         * <p>
         * Configuration settings for an Amazon FSx for Lustre file system to be used with the cluster.
         * </p>
         * 
         * @param fSxLustreConfig
         *        Configuration settings for an Amazon FSx for Lustre file system to be used with the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fSxLustreConfig(FSxLustreConfig fSxLustreConfig);

        /**
         * <p>
         * Configuration settings for an Amazon FSx for Lustre file system to be used with the cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link FSxLustreConfig.Builder} avoiding the
         * need to create one manually via {@link FSxLustreConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FSxLustreConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #fSxLustreConfig(FSxLustreConfig)}.
         * 
         * @param fSxLustreConfig
         *        a consumer that will call methods on {@link FSxLustreConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fSxLustreConfig(FSxLustreConfig)
         */
        default Builder fSxLustreConfig(Consumer<FSxLustreConfig.Builder> fSxLustreConfig) {
            return fSxLustreConfig(FSxLustreConfig.builder().applyMutation(fSxLustreConfig).build());
        }

        /**
         * <p>
         * The Amazon S3 path where output data from the restricted instance group (RIG) environment will be stored.
         * </p>
         * 
         * @param s3OutputPath
         *        The Amazon S3 path where output data from the restricted instance group (RIG) environment will be
         *        stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OutputPath(String s3OutputPath);
    }

    static final class BuilderImpl implements Builder {
        private FSxLustreConfig fSxLustreConfig;

        private String s3OutputPath;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentConfigDetails model) {
            fSxLustreConfig(model.fSxLustreConfig);
            s3OutputPath(model.s3OutputPath);
        }

        public final FSxLustreConfig.Builder getFSxLustreConfig() {
            return fSxLustreConfig != null ? fSxLustreConfig.toBuilder() : null;
        }

        public final void setFSxLustreConfig(FSxLustreConfig.BuilderImpl fSxLustreConfig) {
            this.fSxLustreConfig = fSxLustreConfig != null ? fSxLustreConfig.build() : null;
        }

        @Override
        public final Builder fSxLustreConfig(FSxLustreConfig fSxLustreConfig) {
            this.fSxLustreConfig = fSxLustreConfig;
            return this;
        }

        public final String getS3OutputPath() {
            return s3OutputPath;
        }

        public final void setS3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
        }

        @Override
        public final Builder s3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        @Override
        public EnvironmentConfigDetails build() {
            return new EnvironmentConfigDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
