/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata associated with a cluster event, which may include details about various resource types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventMetadata implements SdkPojo, Serializable, ToCopyableBuilder<EventMetadata.Builder, EventMetadata> {
    private static final SdkField<ClusterMetadata> CLUSTER_FIELD = SdkField.<ClusterMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("Cluster").getter(getter(EventMetadata::cluster)).setter(setter(Builder::cluster))
            .constructor(ClusterMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cluster").build()).build();

    private static final SdkField<InstanceGroupMetadata> INSTANCE_GROUP_FIELD = SdkField
            .<InstanceGroupMetadata> builder(MarshallingType.SDK_POJO).memberName("InstanceGroup")
            .getter(getter(EventMetadata::instanceGroup)).setter(setter(Builder::instanceGroup))
            .constructor(InstanceGroupMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroup").build()).build();

    private static final SdkField<InstanceGroupScalingMetadata> INSTANCE_GROUP_SCALING_FIELD = SdkField
            .<InstanceGroupScalingMetadata> builder(MarshallingType.SDK_POJO).memberName("InstanceGroupScaling")
            .getter(getter(EventMetadata::instanceGroupScaling)).setter(setter(Builder::instanceGroupScaling))
            .constructor(InstanceGroupScalingMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupScaling").build())
            .build();

    private static final SdkField<InstanceMetadata> INSTANCE_FIELD = SdkField
            .<InstanceMetadata> builder(MarshallingType.SDK_POJO).memberName("Instance").getter(getter(EventMetadata::instance))
            .setter(setter(Builder::instance)).constructor(InstanceMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD,
            INSTANCE_GROUP_FIELD, INSTANCE_GROUP_SCALING_FIELD, INSTANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ClusterMetadata cluster;

    private final InstanceGroupMetadata instanceGroup;

    private final InstanceGroupScalingMetadata instanceGroupScaling;

    private final InstanceMetadata instance;

    private final Type type;

    private EventMetadata(BuilderImpl builder) {
        this.cluster = builder.cluster;
        this.instanceGroup = builder.instanceGroup;
        this.instanceGroupScaling = builder.instanceGroupScaling;
        this.instance = builder.instance;
        this.type = builder.type;
    }

    /**
     * <p>
     * Metadata specific to cluster-level events.
     * </p>
     * 
     * @return Metadata specific to cluster-level events.
     */
    public final ClusterMetadata cluster() {
        return cluster;
    }

    /**
     * <p>
     * Metadata specific to instance group-level events.
     * </p>
     * 
     * @return Metadata specific to instance group-level events.
     */
    public final InstanceGroupMetadata instanceGroup() {
        return instanceGroup;
    }

    /**
     * <p>
     * Metadata related to instance group scaling events.
     * </p>
     * 
     * @return Metadata related to instance group scaling events.
     */
    public final InstanceGroupScalingMetadata instanceGroupScaling() {
        return instanceGroupScaling;
    }

    /**
     * <p>
     * Metadata specific to instance-level events.
     * </p>
     * 
     * @return Metadata specific to instance-level events.
     */
    public final InstanceMetadata instance() {
        return instance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(instanceGroup());
        hashCode = 31 * hashCode + Objects.hashCode(instanceGroupScaling());
        hashCode = 31 * hashCode + Objects.hashCode(instance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventMetadata)) {
            return false;
        }
        EventMetadata other = (EventMetadata) obj;
        return Objects.equals(cluster(), other.cluster()) && Objects.equals(instanceGroup(), other.instanceGroup())
                && Objects.equals(instanceGroupScaling(), other.instanceGroupScaling())
                && Objects.equals(instance(), other.instance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventMetadata").add("Cluster", cluster()).add("InstanceGroup", instanceGroup())
                .add("InstanceGroupScaling", instanceGroupScaling()).add("Instance", instance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "InstanceGroup":
            return Optional.ofNullable(clazz.cast(instanceGroup()));
        case "InstanceGroupScaling":
            return Optional.ofNullable(clazz.cast(instanceGroupScaling()));
        case "Instance":
            return Optional.ofNullable(clazz.cast(instance()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #cluster()} initialized to the given value.
     *
     * <p>
     * Metadata specific to cluster-level events.
     * </p>
     * 
     * @param cluster
     *        Metadata specific to cluster-level events.
     */
    public static EventMetadata fromCluster(ClusterMetadata cluster) {
        return builder().cluster(cluster).build();
    }

    /**
     * Create an instance of this class with {@link #cluster()} initialized to the given value.
     *
     * <p>
     * Metadata specific to cluster-level events.
     * </p>
     * 
     * @param cluster
     *        Metadata specific to cluster-level events.
     */
    public static EventMetadata fromCluster(Consumer<ClusterMetadata.Builder> cluster) {
        ClusterMetadata.Builder builder = ClusterMetadata.builder();
        cluster.accept(builder);
        return fromCluster(builder.build());
    }

    /**
     * Create an instance of this class with {@link #instanceGroup()} initialized to the given value.
     *
     * <p>
     * Metadata specific to instance group-level events.
     * </p>
     * 
     * @param instanceGroup
     *        Metadata specific to instance group-level events.
     */
    public static EventMetadata fromInstanceGroup(InstanceGroupMetadata instanceGroup) {
        return builder().instanceGroup(instanceGroup).build();
    }

    /**
     * Create an instance of this class with {@link #instanceGroup()} initialized to the given value.
     *
     * <p>
     * Metadata specific to instance group-level events.
     * </p>
     * 
     * @param instanceGroup
     *        Metadata specific to instance group-level events.
     */
    public static EventMetadata fromInstanceGroup(Consumer<InstanceGroupMetadata.Builder> instanceGroup) {
        InstanceGroupMetadata.Builder builder = InstanceGroupMetadata.builder();
        instanceGroup.accept(builder);
        return fromInstanceGroup(builder.build());
    }

    /**
     * Create an instance of this class with {@link #instanceGroupScaling()} initialized to the given value.
     *
     * <p>
     * Metadata related to instance group scaling events.
     * </p>
     * 
     * @param instanceGroupScaling
     *        Metadata related to instance group scaling events.
     */
    public static EventMetadata fromInstanceGroupScaling(InstanceGroupScalingMetadata instanceGroupScaling) {
        return builder().instanceGroupScaling(instanceGroupScaling).build();
    }

    /**
     * Create an instance of this class with {@link #instanceGroupScaling()} initialized to the given value.
     *
     * <p>
     * Metadata related to instance group scaling events.
     * </p>
     * 
     * @param instanceGroupScaling
     *        Metadata related to instance group scaling events.
     */
    public static EventMetadata fromInstanceGroupScaling(Consumer<InstanceGroupScalingMetadata.Builder> instanceGroupScaling) {
        InstanceGroupScalingMetadata.Builder builder = InstanceGroupScalingMetadata.builder();
        instanceGroupScaling.accept(builder);
        return fromInstanceGroupScaling(builder.build());
    }

    /**
     * Create an instance of this class with {@link #instance()} initialized to the given value.
     *
     * <p>
     * Metadata specific to instance-level events.
     * </p>
     * 
     * @param instance
     *        Metadata specific to instance-level events.
     */
    public static EventMetadata fromInstance(InstanceMetadata instance) {
        return builder().instance(instance).build();
    }

    /**
     * Create an instance of this class with {@link #instance()} initialized to the given value.
     *
     * <p>
     * Metadata specific to instance-level events.
     * </p>
     * 
     * @param instance
     *        Metadata specific to instance-level events.
     */
    public static EventMetadata fromInstance(Consumer<InstanceMetadata.Builder> instance) {
        InstanceMetadata.Builder builder = InstanceMetadata.builder();
        instance.accept(builder);
        return fromInstance(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Cluster", CLUSTER_FIELD);
        map.put("InstanceGroup", INSTANCE_GROUP_FIELD);
        map.put("InstanceGroupScaling", INSTANCE_GROUP_SCALING_FIELD);
        map.put("Instance", INSTANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventMetadata, T> g) {
        return obj -> g.apply((EventMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventMetadata> {
        /**
         * <p>
         * Metadata specific to cluster-level events.
         * </p>
         * 
         * @param cluster
         *        Metadata specific to cluster-level events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(ClusterMetadata cluster);

        /**
         * <p>
         * Metadata specific to cluster-level events.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterMetadata.Builder} avoiding the
         * need to create one manually via {@link ClusterMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #cluster(ClusterMetadata)}.
         * 
         * @param cluster
         *        a consumer that will call methods on {@link ClusterMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cluster(ClusterMetadata)
         */
        default Builder cluster(Consumer<ClusterMetadata.Builder> cluster) {
            return cluster(ClusterMetadata.builder().applyMutation(cluster).build());
        }

        /**
         * <p>
         * Metadata specific to instance group-level events.
         * </p>
         * 
         * @param instanceGroup
         *        Metadata specific to instance group-level events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroup(InstanceGroupMetadata instanceGroup);

        /**
         * <p>
         * Metadata specific to instance group-level events.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceGroupMetadata.Builder} avoiding
         * the need to create one manually via {@link InstanceGroupMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceGroupMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceGroup(InstanceGroupMetadata)}.
         * 
         * @param instanceGroup
         *        a consumer that will call methods on {@link InstanceGroupMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceGroup(InstanceGroupMetadata)
         */
        default Builder instanceGroup(Consumer<InstanceGroupMetadata.Builder> instanceGroup) {
            return instanceGroup(InstanceGroupMetadata.builder().applyMutation(instanceGroup).build());
        }

        /**
         * <p>
         * Metadata related to instance group scaling events.
         * </p>
         * 
         * @param instanceGroupScaling
         *        Metadata related to instance group scaling events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupScaling(InstanceGroupScalingMetadata instanceGroupScaling);

        /**
         * <p>
         * Metadata related to instance group scaling events.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceGroupScalingMetadata.Builder}
         * avoiding the need to create one manually via {@link InstanceGroupScalingMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceGroupScalingMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceGroupScaling(InstanceGroupScalingMetadata)}.
         * 
         * @param instanceGroupScaling
         *        a consumer that will call methods on {@link InstanceGroupScalingMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceGroupScaling(InstanceGroupScalingMetadata)
         */
        default Builder instanceGroupScaling(Consumer<InstanceGroupScalingMetadata.Builder> instanceGroupScaling) {
            return instanceGroupScaling(InstanceGroupScalingMetadata.builder().applyMutation(instanceGroupScaling).build());
        }

        /**
         * <p>
         * Metadata specific to instance-level events.
         * </p>
         * 
         * @param instance
         *        Metadata specific to instance-level events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instance(InstanceMetadata instance);

        /**
         * <p>
         * Metadata specific to instance-level events.
         * </p>
         * This is a convenience method that creates an instance of the {@link InstanceMetadata.Builder} avoiding the
         * need to create one manually via {@link InstanceMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InstanceMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #instance(InstanceMetadata)}.
         * 
         * @param instance
         *        a consumer that will call methods on {@link InstanceMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instance(InstanceMetadata)
         */
        default Builder instance(Consumer<InstanceMetadata.Builder> instance) {
            return instance(InstanceMetadata.builder().applyMutation(instance).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ClusterMetadata cluster;

        private InstanceGroupMetadata instanceGroup;

        private InstanceGroupScalingMetadata instanceGroupScaling;

        private InstanceMetadata instance;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EventMetadata model) {
            cluster(model.cluster);
            instanceGroup(model.instanceGroup);
            instanceGroupScaling(model.instanceGroupScaling);
            instance(model.instance);
        }

        public final ClusterMetadata.Builder getCluster() {
            return cluster != null ? cluster.toBuilder() : null;
        }

        public final void setCluster(ClusterMetadata.BuilderImpl cluster) {
            Object oldValue = this.cluster;
            this.cluster = cluster != null ? cluster.build() : null;
            handleUnionValueChange(Type.CLUSTER, oldValue, this.cluster);
        }

        @Override
        public final Builder cluster(ClusterMetadata cluster) {
            Object oldValue = this.cluster;
            this.cluster = cluster;
            handleUnionValueChange(Type.CLUSTER, oldValue, this.cluster);
            return this;
        }

        public final InstanceGroupMetadata.Builder getInstanceGroup() {
            return instanceGroup != null ? instanceGroup.toBuilder() : null;
        }

        public final void setInstanceGroup(InstanceGroupMetadata.BuilderImpl instanceGroup) {
            Object oldValue = this.instanceGroup;
            this.instanceGroup = instanceGroup != null ? instanceGroup.build() : null;
            handleUnionValueChange(Type.INSTANCE_GROUP, oldValue, this.instanceGroup);
        }

        @Override
        public final Builder instanceGroup(InstanceGroupMetadata instanceGroup) {
            Object oldValue = this.instanceGroup;
            this.instanceGroup = instanceGroup;
            handleUnionValueChange(Type.INSTANCE_GROUP, oldValue, this.instanceGroup);
            return this;
        }

        public final InstanceGroupScalingMetadata.Builder getInstanceGroupScaling() {
            return instanceGroupScaling != null ? instanceGroupScaling.toBuilder() : null;
        }

        public final void setInstanceGroupScaling(InstanceGroupScalingMetadata.BuilderImpl instanceGroupScaling) {
            Object oldValue = this.instanceGroupScaling;
            this.instanceGroupScaling = instanceGroupScaling != null ? instanceGroupScaling.build() : null;
            handleUnionValueChange(Type.INSTANCE_GROUP_SCALING, oldValue, this.instanceGroupScaling);
        }

        @Override
        public final Builder instanceGroupScaling(InstanceGroupScalingMetadata instanceGroupScaling) {
            Object oldValue = this.instanceGroupScaling;
            this.instanceGroupScaling = instanceGroupScaling;
            handleUnionValueChange(Type.INSTANCE_GROUP_SCALING, oldValue, this.instanceGroupScaling);
            return this;
        }

        public final InstanceMetadata.Builder getInstance() {
            return instance != null ? instance.toBuilder() : null;
        }

        public final void setInstance(InstanceMetadata.BuilderImpl instance) {
            Object oldValue = this.instance;
            this.instance = instance != null ? instance.build() : null;
            handleUnionValueChange(Type.INSTANCE, oldValue, this.instance);
        }

        @Override
        public final Builder instance(InstanceMetadata instance) {
            Object oldValue = this.instance;
            this.instance = instance;
            handleUnionValueChange(Type.INSTANCE, oldValue, this.instance);
            return this;
        }

        @Override
        public EventMetadata build() {
            return new EventMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EventMetadata#type()
     */
    public enum Type {
        CLUSTER,

        INSTANCE_GROUP,

        INSTANCE_GROUP_SCALING,

        INSTANCE,

        UNKNOWN_TO_SDK_VERSION
    }
}
