/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for an Amazon FSx for Lustre file system to be used with the cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FSxLustreConfig implements SdkPojo, Serializable, ToCopyableBuilder<FSxLustreConfig.Builder, FSxLustreConfig> {
    private static final SdkField<Integer> SIZE_IN_GIB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SizeInGiB").getter(getter(FSxLustreConfig::sizeInGiB)).setter(setter(Builder::sizeInGiB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInGiB").build()).build();

    private static final SdkField<Integer> PER_UNIT_STORAGE_THROUGHPUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("PerUnitStorageThroughput")
            .getter(getter(FSxLustreConfig::perUnitStorageThroughput)).setter(setter(Builder::perUnitStorageThroughput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerUnitStorageThroughput").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_IN_GIB_FIELD,
            PER_UNIT_STORAGE_THROUGHPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer sizeInGiB;

    private final Integer perUnitStorageThroughput;

    private FSxLustreConfig(BuilderImpl builder) {
        this.sizeInGiB = builder.sizeInGiB;
        this.perUnitStorageThroughput = builder.perUnitStorageThroughput;
    }

    /**
     * <p>
     * The storage capacity of the Amazon FSx for Lustre file system, specified in gibibytes (GiB).
     * </p>
     * 
     * @return The storage capacity of the Amazon FSx for Lustre file system, specified in gibibytes (GiB).
     */
    public final Integer sizeInGiB() {
        return sizeInGiB;
    }

    /**
     * <p>
     * The throughput capacity of the Amazon FSx for Lustre file system, measured in MB/s per TiB of storage.
     * </p>
     * 
     * @return The throughput capacity of the Amazon FSx for Lustre file system, measured in MB/s per TiB of storage.
     */
    public final Integer perUnitStorageThroughput() {
        return perUnitStorageThroughput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sizeInGiB());
        hashCode = 31 * hashCode + Objects.hashCode(perUnitStorageThroughput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FSxLustreConfig)) {
            return false;
        }
        FSxLustreConfig other = (FSxLustreConfig) obj;
        return Objects.equals(sizeInGiB(), other.sizeInGiB())
                && Objects.equals(perUnitStorageThroughput(), other.perUnitStorageThroughput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FSxLustreConfig").add("SizeInGiB", sizeInGiB())
                .add("PerUnitStorageThroughput", perUnitStorageThroughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SizeInGiB":
            return Optional.ofNullable(clazz.cast(sizeInGiB()));
        case "PerUnitStorageThroughput":
            return Optional.ofNullable(clazz.cast(perUnitStorageThroughput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SizeInGiB", SIZE_IN_GIB_FIELD);
        map.put("PerUnitStorageThroughput", PER_UNIT_STORAGE_THROUGHPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FSxLustreConfig, T> g) {
        return obj -> g.apply((FSxLustreConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FSxLustreConfig> {
        /**
         * <p>
         * The storage capacity of the Amazon FSx for Lustre file system, specified in gibibytes (GiB).
         * </p>
         * 
         * @param sizeInGiB
         *        The storage capacity of the Amazon FSx for Lustre file system, specified in gibibytes (GiB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInGiB(Integer sizeInGiB);

        /**
         * <p>
         * The throughput capacity of the Amazon FSx for Lustre file system, measured in MB/s per TiB of storage.
         * </p>
         * 
         * @param perUnitStorageThroughput
         *        The throughput capacity of the Amazon FSx for Lustre file system, measured in MB/s per TiB of storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder perUnitStorageThroughput(Integer perUnitStorageThroughput);
    }

    static final class BuilderImpl implements Builder {
        private Integer sizeInGiB;

        private Integer perUnitStorageThroughput;

        private BuilderImpl() {
        }

        private BuilderImpl(FSxLustreConfig model) {
            sizeInGiB(model.sizeInGiB);
            perUnitStorageThroughput(model.perUnitStorageThroughput);
        }

        public final Integer getSizeInGiB() {
            return sizeInGiB;
        }

        public final void setSizeInGiB(Integer sizeInGiB) {
            this.sizeInGiB = sizeInGiB;
        }

        @Override
        public final Builder sizeInGiB(Integer sizeInGiB) {
            this.sizeInGiB = sizeInGiB;
            return this;
        }

        public final Integer getPerUnitStorageThroughput() {
            return perUnitStorageThroughput;
        }

        public final void setPerUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
        }

        @Override
        public final Builder perUnitStorageThroughput(Integer perUnitStorageThroughput) {
            this.perUnitStorageThroughput = perUnitStorageThroughput;
            return this;
        }

        @Override
        public FSxLustreConfig build() {
            return new FSxLustreConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
