/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information required for human workers to complete a labeling task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HumanTaskConfig implements SdkPojo, Serializable, ToCopyableBuilder<HumanTaskConfig.Builder, HumanTaskConfig> {
    private static final SdkField<String> WORKTEAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkteamArn").getter(getter(HumanTaskConfig::workteamArn)).setter(setter(Builder::workteamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkteamArn").build()).build();

    private static final SdkField<UiConfig> UI_CONFIG_FIELD = SdkField.<UiConfig> builder(MarshallingType.SDK_POJO)
            .memberName("UiConfig").getter(getter(HumanTaskConfig::uiConfig)).setter(setter(Builder::uiConfig))
            .constructor(UiConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UiConfig").build()).build();

    private static final SdkField<String> PRE_HUMAN_TASK_LAMBDA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreHumanTaskLambdaArn").getter(getter(HumanTaskConfig::preHumanTaskLambdaArn))
            .setter(setter(Builder::preHumanTaskLambdaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreHumanTaskLambdaArn").build())
            .build();

    private static final SdkField<List<String>> TASK_KEYWORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TaskKeywords")
            .getter(getter(HumanTaskConfig::taskKeywords))
            .setter(setter(Builder::taskKeywords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskKeywords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TASK_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskTitle").getter(getter(HumanTaskConfig::taskTitle)).setter(setter(Builder::taskTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskTitle").build()).build();

    private static final SdkField<String> TASK_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskDescription").getter(getter(HumanTaskConfig::taskDescription))
            .setter(setter(Builder::taskDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskDescription").build()).build();

    private static final SdkField<Integer> NUMBER_OF_HUMAN_WORKERS_PER_DATA_OBJECT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfHumanWorkersPerDataObject")
            .getter(getter(HumanTaskConfig::numberOfHumanWorkersPerDataObject))
            .setter(setter(Builder::numberOfHumanWorkersPerDataObject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfHumanWorkersPerDataObject")
                    .build()).build();

    private static final SdkField<Integer> TASK_TIME_LIMIT_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TaskTimeLimitInSeconds").getter(getter(HumanTaskConfig::taskTimeLimitInSeconds))
            .setter(setter(Builder::taskTimeLimitInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskTimeLimitInSeconds").build())
            .build();

    private static final SdkField<Integer> TASK_AVAILABILITY_LIFETIME_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TaskAvailabilityLifetimeInSeconds")
            .getter(getter(HumanTaskConfig::taskAvailabilityLifetimeInSeconds))
            .setter(setter(Builder::taskAvailabilityLifetimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskAvailabilityLifetimeInSeconds")
                    .build()).build();

    private static final SdkField<Integer> MAX_CONCURRENT_TASK_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxConcurrentTaskCount").getter(getter(HumanTaskConfig::maxConcurrentTaskCount))
            .setter(setter(Builder::maxConcurrentTaskCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentTaskCount").build())
            .build();

    private static final SdkField<AnnotationConsolidationConfig> ANNOTATION_CONSOLIDATION_CONFIG_FIELD = SdkField
            .<AnnotationConsolidationConfig> builder(MarshallingType.SDK_POJO)
            .memberName("AnnotationConsolidationConfig")
            .getter(getter(HumanTaskConfig::annotationConsolidationConfig))
            .setter(setter(Builder::annotationConsolidationConfig))
            .constructor(AnnotationConsolidationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnnotationConsolidationConfig")
                    .build()).build();

    private static final SdkField<PublicWorkforceTaskPrice> PUBLIC_WORKFORCE_TASK_PRICE_FIELD = SdkField
            .<PublicWorkforceTaskPrice> builder(MarshallingType.SDK_POJO).memberName("PublicWorkforceTaskPrice")
            .getter(getter(HumanTaskConfig::publicWorkforceTaskPrice)).setter(setter(Builder::publicWorkforceTaskPrice))
            .constructor(PublicWorkforceTaskPrice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicWorkforceTaskPrice").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKTEAM_ARN_FIELD,
            UI_CONFIG_FIELD, PRE_HUMAN_TASK_LAMBDA_ARN_FIELD, TASK_KEYWORDS_FIELD, TASK_TITLE_FIELD, TASK_DESCRIPTION_FIELD,
            NUMBER_OF_HUMAN_WORKERS_PER_DATA_OBJECT_FIELD, TASK_TIME_LIMIT_IN_SECONDS_FIELD,
            TASK_AVAILABILITY_LIFETIME_IN_SECONDS_FIELD, MAX_CONCURRENT_TASK_COUNT_FIELD, ANNOTATION_CONSOLIDATION_CONFIG_FIELD,
            PUBLIC_WORKFORCE_TASK_PRICE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String workteamArn;

    private final UiConfig uiConfig;

    private final String preHumanTaskLambdaArn;

    private final List<String> taskKeywords;

    private final String taskTitle;

    private final String taskDescription;

    private final Integer numberOfHumanWorkersPerDataObject;

    private final Integer taskTimeLimitInSeconds;

    private final Integer taskAvailabilityLifetimeInSeconds;

    private final Integer maxConcurrentTaskCount;

    private final AnnotationConsolidationConfig annotationConsolidationConfig;

    private final PublicWorkforceTaskPrice publicWorkforceTaskPrice;

    private HumanTaskConfig(BuilderImpl builder) {
        this.workteamArn = builder.workteamArn;
        this.uiConfig = builder.uiConfig;
        this.preHumanTaskLambdaArn = builder.preHumanTaskLambdaArn;
        this.taskKeywords = builder.taskKeywords;
        this.taskTitle = builder.taskTitle;
        this.taskDescription = builder.taskDescription;
        this.numberOfHumanWorkersPerDataObject = builder.numberOfHumanWorkersPerDataObject;
        this.taskTimeLimitInSeconds = builder.taskTimeLimitInSeconds;
        this.taskAvailabilityLifetimeInSeconds = builder.taskAvailabilityLifetimeInSeconds;
        this.maxConcurrentTaskCount = builder.maxConcurrentTaskCount;
        this.annotationConsolidationConfig = builder.annotationConsolidationConfig;
        this.publicWorkforceTaskPrice = builder.publicWorkforceTaskPrice;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the work team assigned to complete the tasks.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the work team assigned to complete the tasks.
     */
    public final String workteamArn() {
        return workteamArn;
    }

    /**
     * <p>
     * Information about the user interface that workers use to complete the labeling task.
     * </p>
     * 
     * @return Information about the user interface that workers use to complete the labeling task.
     */
    public final UiConfig uiConfig() {
        return uiConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a Lambda function that is run before a data object is sent to a human worker.
     * Use this function to provide input to a custom labeling job.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>, use
     * one of the following Amazon SageMaker Ground Truth Lambda function ARNs for <code>PreHumanTaskLambdaArn</code>.
     * For custom labeling workflows, see <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-prelambda"
     * >Pre-annotation Lambda</a>.
     * </p>
     * <p>
     * <b>Bounding box</b> - Finds the most similar boxes from different workers based on the Jaccard index of the
     * boxes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-BoundingBox</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class
     * of an image based on annotations from individual workers.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClass</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Multi-label image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the
     * true classes of an image based on annotations from individual workers.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClassMultiLabel</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Semantic segmentation</b> - Treats each pixel in an image as a multi-class classification and treats pixel
     * annotations from workers as "votes" for the correct label.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-SemanticSegmentation</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true class
     * of text based on annotations from individual workers.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClass</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Multi-label text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the
     * true classes of text based on annotations from individual workers.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClassMultiLabel</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClassMultiLabel</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Named entity recognition</b> - Groups similar selections and calculates aggregate boundaries, resolving to
     * most-assigned label.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-NamedEntityRecognition</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Video Classification</b> - Use this task type when you need workers to classify videos using predefined labels
     * that you specify. Workers are shown videos and are asked to choose one label for each video.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoMultiClass</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoMultiClass</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Video Frame Object Detection</b> - Use this task type to have workers identify and locate objects in a
     * sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task
     * to ask workers to identify and localize various objects in a series of video frames, such as cars, bikes, and
     * pedestrians.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoObjectDetection</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Video Frame Object Tracking</b> - Use this task type to have workers track the movement of objects in a
     * sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this task
     * to ask workers to track the movement of objects, such as cars, bikes, and pedestrians.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoObjectTracking</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>3D Point Cloud Modalities</b>
     * </p>
     * <p>
     * Use the following pre-annotation lambdas for 3D point cloud labeling modality tasks. See <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-task-types.html">3D Point Cloud Task types
     * </a> to learn more.
     * </p>
     * <p>
     * <b>3D Point Cloud Object Detection</b> - Use this task type when you want workers to classify objects in a 3D
     * point cloud by drawing 3D cuboids around objects. For example, you can use this task type to ask workers to
     * identify different types of objects in a point cloud, such as cars, bikes, and pedestrians.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>3D Point Cloud Object Tracking</b> - Use this task type when you want workers to draw 3D cuboids around
     * objects that appear in a sequence of 3D point cloud frames. For example, you can use this task type to ask
     * workers to track the movement of vehicles across multiple point cloud frames.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>3D Point Cloud Semantic Segmentation</b> - Use this task type when you want workers to create a point-level
     * semantic segmentation masks by painting objects in a 3D point cloud using different colors where each color is
     * assigned to one of the classes you specify.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Use the following ARNs for Label Verification and Adjustment Jobs</b>
     * </p>
     * <p>
     * Use label verification and adjustment jobs to review and adjust labels. To learn more, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust Labels </a>.
     * </p>
     * <p>
     * <b>Bounding box verification</b> - Uses a variant of the Expectation Maximization approach to estimate the true
     * class of verification judgement for bounding box labels based on annotations from individual workers.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VerificationBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VerificationBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VerificationBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VerificationBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VerificationBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VerificationBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VerificationBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VerificationBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VerificationBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VerificationBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VerificationBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VerificationBoundingBox</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Bounding box adjustment</b> - Finds the most similar boxes from different workers based on the Jaccard index
     * of the adjusted annotations.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentBoundingBox</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentBoundingBox</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Semantic segmentation verification</b> - Uses a variant of the Expectation Maximization approach to estimate
     * the true class of verification judgment for semantic segmentation labels based on annotations from individual
     * workers.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VerificationSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VerificationSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VerificationSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VerificationSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VerificationSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VerificationSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VerificationSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VerificationSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VerificationSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VerificationSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VerificationSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VerificationSemanticSegmentation</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Semantic segmentation adjustment</b> - Treats each pixel in an image as a multi-class classification and
     * treats pixel adjusted annotations from workers as "votes" for the correct label.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentSemanticSegmentation</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Video Frame Object Detection Adjustment</b> - Use this task type when you want workers to adjust bounding
     * boxes that workers have added to video frames to classify and localize objects in a sequence of video frames.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentVideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentVideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentVideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentVideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentVideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentVideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentVideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentVideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentVideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentVideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentVideoObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentVideoObjectDetection</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Video Frame Object Tracking Adjustment</b> - Use this task type when you want workers to adjust bounding boxes
     * that workers have added to video frames to track object movement across a sequence of video frames.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentVideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentVideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentVideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentVideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentVideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentVideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentVideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentVideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentVideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentVideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentVideoObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentVideoObjectTracking</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>3D point cloud object detection adjustment</b> - Adjust 3D cuboids in a point cloud frame.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>3D point cloud object tracking adjustment</b> - Adjust 3D cuboids across a sequence of point cloud frames.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>3D point cloud semantic segmentation adjustment</b> - Adjust semantic segmentation masks in a 3D point cloud.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Generative AI/Custom</b> - Direct passthrough of input data without any transformation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-PassThrough</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-PassThrough</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-PassThrough</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-PassThrough</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-PassThrough</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-PassThrough</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-PassThrough</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-PassThrough</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-PassThrough</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-PassThrough</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-PassThrough</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-PassThrough</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) of a Lambda function that is run before a data object is sent to a human
     *         worker. Use this function to provide input to a custom labeling job.</p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task
     *         types</a>, use one of the following Amazon SageMaker Ground Truth Lambda function ARNs for
     *         <code>PreHumanTaskLambdaArn</code>. For custom labeling workflows, see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-prelambda"
     *         >Pre-annotation Lambda</a>.
     *         </p>
     *         <p>
     *         <b>Bounding box</b> - Finds the most similar boxes from different workers based on the Jaccard index of
     *         the boxes.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-BoundingBox</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the
     *         true class of an image based on annotations from individual workers.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClass</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Multi-label image classification</b> - Uses a variant of the Expectation Maximization approach to
     *         estimate the true classes of an image based on annotations from individual workers.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Semantic segmentation</b> - Treats each pixel in an image as a multi-class classification and treats
     *         pixel annotations from workers as "votes" for the correct label.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-SemanticSegmentation</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true
     *         class of text based on annotations from individual workers.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClass</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Multi-label text classification</b> - Uses a variant of the Expectation Maximization approach to
     *         estimate the true classes of text based on annotations from individual workers.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClassMultiLabel</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Named entity recognition</b> - Groups similar selections and calculates aggregate boundaries,
     *         resolving to most-assigned label.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-NamedEntityRecognition</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Video Classification</b> - Use this task type when you need workers to classify videos using
     *         predefined labels that you specify. Workers are shown videos and are asked to choose one label for each
     *         video.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoMultiClass</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoMultiClass</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Video Frame Object Detection</b> - Use this task type to have workers identify and locate objects in a
     *         sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use
     *         this task to ask workers to identify and localize various objects in a series of video frames, such as
     *         cars, bikes, and pedestrians.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoObjectDetection</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Video Frame Object Tracking</b> - Use this task type to have workers track the movement of objects in
     *         a sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use
     *         this task to ask workers to track the movement of objects, such as cars, bikes, and pedestrians.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoObjectTracking</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>3D Point Cloud Modalities</b>
     *         </p>
     *         <p>
     *         Use the following pre-annotation lambdas for 3D point cloud labeling modality tasks. See <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-task-types.html">3D Point Cloud
     *         Task types </a> to learn more.
     *         </p>
     *         <p>
     *         <b>3D Point Cloud Object Detection</b> - Use this task type when you want workers to classify objects in
     *         a 3D point cloud by drawing 3D cuboids around objects. For example, you can use this task type to ask
     *         workers to identify different types of objects in a point cloud, such as cars, bikes, and pedestrians.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>3D Point Cloud Object Tracking</b> - Use this task type when you want workers to draw 3D cuboids
     *         around objects that appear in a sequence of 3D point cloud frames. For example, you can use this task
     *         type to ask workers to track the movement of vehicles across multiple point cloud frames.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>3D Point Cloud Semantic Segmentation</b> - Use this task type when you want workers to create a
     *         point-level semantic segmentation masks by painting objects in a 3D point cloud using different colors
     *         where each color is assigned to one of the classes you specify.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Use the following ARNs for Label Verification and Adjustment Jobs</b>
     *         </p>
     *         <p>
     *         Use label verification and adjustment jobs to review and adjust labels. To learn more, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust
     *         Labels </a>.
     *         </p>
     *         <p>
     *         <b>Bounding box verification</b> - Uses a variant of the Expectation Maximization approach to estimate
     *         the true class of verification judgement for bounding box labels based on annotations from individual
     *         workers.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VerificationBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VerificationBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VerificationBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VerificationBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VerificationBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VerificationBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VerificationBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VerificationBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VerificationBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VerificationBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VerificationBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VerificationBoundingBox</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Bounding box adjustment</b> - Finds the most similar boxes from different workers based on the Jaccard
     *         index of the adjusted annotations.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentBoundingBox</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentBoundingBox</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Semantic segmentation verification</b> - Uses a variant of the Expectation Maximization approach to
     *         estimate the true class of verification judgment for semantic segmentation labels based on annotations
     *         from individual workers.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VerificationSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VerificationSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VerificationSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VerificationSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VerificationSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VerificationSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VerificationSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VerificationSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VerificationSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VerificationSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VerificationSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VerificationSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Semantic segmentation adjustment</b> - Treats each pixel in an image as a multi-class classification
     *         and treats pixel adjusted annotations from workers as "votes" for the correct label.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Video Frame Object Detection Adjustment</b> - Use this task type when you want workers to adjust
     *         bounding boxes that workers have added to video frames to classify and localize objects in a sequence of
     *         video frames.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentVideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentVideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentVideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentVideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentVideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentVideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentVideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentVideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentVideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentVideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentVideoObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentVideoObjectDetection</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Video Frame Object Tracking Adjustment</b> - Use this task type when you want workers to adjust
     *         bounding boxes that workers have added to video frames to track object movement across a sequence of
     *         video frames.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentVideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentVideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentVideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentVideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentVideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentVideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentVideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentVideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentVideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentVideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentVideoObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentVideoObjectTracking</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>3D point cloud object detection adjustment</b> - Adjust 3D cuboids in a point cloud frame.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectDetection</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>3D point cloud object tracking adjustment</b> - Adjust 3D cuboids across a sequence of point cloud
     *         frames.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectTracking</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>3D point cloud semantic segmentation adjustment</b> - Adjust semantic segmentation masks in a 3D point
     *         cloud.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Generative AI/Custom</b> - Direct passthrough of input data without any transformation.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-PassThrough</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-PassThrough</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-PassThrough</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-PassThrough</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-PassThrough</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-PassThrough</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-PassThrough</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-PassThrough</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-PassThrough</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-PassThrough</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-PassThrough</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-PassThrough</code>
     *         </p>
     *         </li>
     */
    public final String preHumanTaskLambdaArn() {
        return preHumanTaskLambdaArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskKeywords property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTaskKeywords() {
        return taskKeywords != null && !(taskKeywords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Keywords used to describe the task so that workers on Amazon Mechanical Turk can discover the task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskKeywords} method.
     * </p>
     * 
     * @return Keywords used to describe the task so that workers on Amazon Mechanical Turk can discover the task.
     */
    public final List<String> taskKeywords() {
        return taskKeywords;
    }

    /**
     * <p>
     * A title for the task for your human workers.
     * </p>
     * 
     * @return A title for the task for your human workers.
     */
    public final String taskTitle() {
        return taskTitle;
    }

    /**
     * <p>
     * A description of the task for your human workers.
     * </p>
     * 
     * @return A description of the task for your human workers.
     */
    public final String taskDescription() {
        return taskDescription;
    }

    /**
     * <p>
     * The number of human workers that will label an object.
     * </p>
     * 
     * @return The number of human workers that will label an object.
     */
    public final Integer numberOfHumanWorkersPerDataObject() {
        return numberOfHumanWorkersPerDataObject;
    }

    /**
     * <p>
     * The amount of time that a worker has to complete a task.
     * </p>
     * <p>
     * If you create a custom labeling job, the maximum value for this parameter is 8 hours (28,800 seconds).
     * </p>
     * <p>
     * If you create a labeling job using a <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task type</a> the maximum for
     * this parameter depends on the task type you use:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-label-images.html">image</a> and <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-label-text.html">text</a> labeling jobs, the maximum is
     * 8 hours (28,800 seconds).
     * </p>
     * </li>
     * <li>
     * <p>
     * For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud.html">3D point cloud</a> and <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-video.html">video frame</a> labeling jobs, the maximum
     * is 30 days (2952,000 seconds) for non-AL mode. For most users, the maximum is also 30 days.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The amount of time that a worker has to complete a task. </p>
     *         <p>
     *         If you create a custom labeling job, the maximum value for this parameter is 8 hours (28,800 seconds).
     *         </p>
     *         <p>
     *         If you create a labeling job using a <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task type</a> the
     *         maximum for this parameter depends on the task type you use:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-label-images.html">image</a> and <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-label-text.html">text</a> labeling jobs, the
     *         maximum is 8 hours (28,800 seconds).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud.html">3D point cloud</a> and
     *         <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-video.html">video frame</a> labeling jobs,
     *         the maximum is 30 days (2952,000 seconds) for non-AL mode. For most users, the maximum is also 30 days.
     *         </p>
     *         </li>
     */
    public final Integer taskTimeLimitInSeconds() {
        return taskTimeLimitInSeconds;
    }

    /**
     * <p>
     * The length of time that a task remains available for labeling by human workers. The default and maximum values
     * for this parameter depend on the type of workforce you use.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you choose the Amazon Mechanical Turk workforce, the maximum is 12 hours (43,200 seconds). The default is 6
     * hours (21,600 seconds).
     * </p>
     * </li>
     * <li>
     * <p>
     * If you choose a private or vendor workforce, the default value is 30 days (2592,000 seconds) for non-AL mode. For
     * most users, the maximum is also 30 days.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The length of time that a task remains available for labeling by human workers. The default and maximum
     *         values for this parameter depend on the type of workforce you use.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you choose the Amazon Mechanical Turk workforce, the maximum is 12 hours (43,200 seconds). The default
     *         is 6 hours (21,600 seconds).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you choose a private or vendor workforce, the default value is 30 days (2592,000 seconds) for non-AL
     *         mode. For most users, the maximum is also 30 days.
     *         </p>
     *         </li>
     */
    public final Integer taskAvailabilityLifetimeInSeconds() {
        return taskAvailabilityLifetimeInSeconds;
    }

    /**
     * <p>
     * Defines the maximum number of data objects that can be labeled by human workers at the same time. Also referred
     * to as batch size. Each object may have more than one worker at one time. The default value is 1000 objects. To
     * increase the maximum value to 5000 objects, contact Amazon Web Services Support.
     * </p>
     * 
     * @return Defines the maximum number of data objects that can be labeled by human workers at the same time. Also
     *         referred to as batch size. Each object may have more than one worker at one time. The default value is
     *         1000 objects. To increase the maximum value to 5000 objects, contact Amazon Web Services Support.
     */
    public final Integer maxConcurrentTaskCount() {
        return maxConcurrentTaskCount;
    }

    /**
     * <p>
     * Configures how labels are consolidated across human workers.
     * </p>
     * 
     * @return Configures how labels are consolidated across human workers.
     */
    public final AnnotationConsolidationConfig annotationConsolidationConfig() {
        return annotationConsolidationConfig;
    }

    /**
     * <p>
     * The price that you pay for each task performed by an Amazon Mechanical Turk worker.
     * </p>
     * 
     * @return The price that you pay for each task performed by an Amazon Mechanical Turk worker.
     */
    public final PublicWorkforceTaskPrice publicWorkforceTaskPrice() {
        return publicWorkforceTaskPrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workteamArn());
        hashCode = 31 * hashCode + Objects.hashCode(uiConfig());
        hashCode = 31 * hashCode + Objects.hashCode(preHumanTaskLambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskKeywords() ? taskKeywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(taskTitle());
        hashCode = 31 * hashCode + Objects.hashCode(taskDescription());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfHumanWorkersPerDataObject());
        hashCode = 31 * hashCode + Objects.hashCode(taskTimeLimitInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(taskAvailabilityLifetimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrentTaskCount());
        hashCode = 31 * hashCode + Objects.hashCode(annotationConsolidationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(publicWorkforceTaskPrice());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanTaskConfig)) {
            return false;
        }
        HumanTaskConfig other = (HumanTaskConfig) obj;
        return Objects.equals(workteamArn(), other.workteamArn()) && Objects.equals(uiConfig(), other.uiConfig())
                && Objects.equals(preHumanTaskLambdaArn(), other.preHumanTaskLambdaArn())
                && hasTaskKeywords() == other.hasTaskKeywords() && Objects.equals(taskKeywords(), other.taskKeywords())
                && Objects.equals(taskTitle(), other.taskTitle()) && Objects.equals(taskDescription(), other.taskDescription())
                && Objects.equals(numberOfHumanWorkersPerDataObject(), other.numberOfHumanWorkersPerDataObject())
                && Objects.equals(taskTimeLimitInSeconds(), other.taskTimeLimitInSeconds())
                && Objects.equals(taskAvailabilityLifetimeInSeconds(), other.taskAvailabilityLifetimeInSeconds())
                && Objects.equals(maxConcurrentTaskCount(), other.maxConcurrentTaskCount())
                && Objects.equals(annotationConsolidationConfig(), other.annotationConsolidationConfig())
                && Objects.equals(publicWorkforceTaskPrice(), other.publicWorkforceTaskPrice());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HumanTaskConfig").add("WorkteamArn", workteamArn()).add("UiConfig", uiConfig())
                .add("PreHumanTaskLambdaArn", preHumanTaskLambdaArn())
                .add("TaskKeywords", hasTaskKeywords() ? taskKeywords() : null).add("TaskTitle", taskTitle())
                .add("TaskDescription", taskDescription())
                .add("NumberOfHumanWorkersPerDataObject", numberOfHumanWorkersPerDataObject())
                .add("TaskTimeLimitInSeconds", taskTimeLimitInSeconds())
                .add("TaskAvailabilityLifetimeInSeconds", taskAvailabilityLifetimeInSeconds())
                .add("MaxConcurrentTaskCount", maxConcurrentTaskCount())
                .add("AnnotationConsolidationConfig", annotationConsolidationConfig())
                .add("PublicWorkforceTaskPrice", publicWorkforceTaskPrice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkteamArn":
            return Optional.ofNullable(clazz.cast(workteamArn()));
        case "UiConfig":
            return Optional.ofNullable(clazz.cast(uiConfig()));
        case "PreHumanTaskLambdaArn":
            return Optional.ofNullable(clazz.cast(preHumanTaskLambdaArn()));
        case "TaskKeywords":
            return Optional.ofNullable(clazz.cast(taskKeywords()));
        case "TaskTitle":
            return Optional.ofNullable(clazz.cast(taskTitle()));
        case "TaskDescription":
            return Optional.ofNullable(clazz.cast(taskDescription()));
        case "NumberOfHumanWorkersPerDataObject":
            return Optional.ofNullable(clazz.cast(numberOfHumanWorkersPerDataObject()));
        case "TaskTimeLimitInSeconds":
            return Optional.ofNullable(clazz.cast(taskTimeLimitInSeconds()));
        case "TaskAvailabilityLifetimeInSeconds":
            return Optional.ofNullable(clazz.cast(taskAvailabilityLifetimeInSeconds()));
        case "MaxConcurrentTaskCount":
            return Optional.ofNullable(clazz.cast(maxConcurrentTaskCount()));
        case "AnnotationConsolidationConfig":
            return Optional.ofNullable(clazz.cast(annotationConsolidationConfig()));
        case "PublicWorkforceTaskPrice":
            return Optional.ofNullable(clazz.cast(publicWorkforceTaskPrice()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkteamArn", WORKTEAM_ARN_FIELD);
        map.put("UiConfig", UI_CONFIG_FIELD);
        map.put("PreHumanTaskLambdaArn", PRE_HUMAN_TASK_LAMBDA_ARN_FIELD);
        map.put("TaskKeywords", TASK_KEYWORDS_FIELD);
        map.put("TaskTitle", TASK_TITLE_FIELD);
        map.put("TaskDescription", TASK_DESCRIPTION_FIELD);
        map.put("NumberOfHumanWorkersPerDataObject", NUMBER_OF_HUMAN_WORKERS_PER_DATA_OBJECT_FIELD);
        map.put("TaskTimeLimitInSeconds", TASK_TIME_LIMIT_IN_SECONDS_FIELD);
        map.put("TaskAvailabilityLifetimeInSeconds", TASK_AVAILABILITY_LIFETIME_IN_SECONDS_FIELD);
        map.put("MaxConcurrentTaskCount", MAX_CONCURRENT_TASK_COUNT_FIELD);
        map.put("AnnotationConsolidationConfig", ANNOTATION_CONSOLIDATION_CONFIG_FIELD);
        map.put("PublicWorkforceTaskPrice", PUBLIC_WORKFORCE_TASK_PRICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HumanTaskConfig, T> g) {
        return obj -> g.apply((HumanTaskConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HumanTaskConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the work team assigned to complete the tasks.
         * </p>
         * 
         * @param workteamArn
         *        The Amazon Resource Name (ARN) of the work team assigned to complete the tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workteamArn(String workteamArn);

        /**
         * <p>
         * Information about the user interface that workers use to complete the labeling task.
         * </p>
         * 
         * @param uiConfig
         *        Information about the user interface that workers use to complete the labeling task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uiConfig(UiConfig uiConfig);

        /**
         * <p>
         * Information about the user interface that workers use to complete the labeling task.
         * </p>
         * This is a convenience method that creates an instance of the {@link UiConfig.Builder} avoiding the need to
         * create one manually via {@link UiConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UiConfig.Builder#build()} is called immediately and its result is
         * passed to {@link #uiConfig(UiConfig)}.
         * 
         * @param uiConfig
         *        a consumer that will call methods on {@link UiConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uiConfig(UiConfig)
         */
        default Builder uiConfig(Consumer<UiConfig.Builder> uiConfig) {
            return uiConfig(UiConfig.builder().applyMutation(uiConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a Lambda function that is run before a data object is sent to a human
         * worker. Use this function to provide input to a custom labeling job.
         * </p>
         * <p>
         * For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task types</a>,
         * use one of the following Amazon SageMaker Ground Truth Lambda function ARNs for
         * <code>PreHumanTaskLambdaArn</code>. For custom labeling workflows, see <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-prelambda"
         * >Pre-annotation Lambda</a>.
         * </p>
         * <p>
         * <b>Bounding box</b> - Finds the most similar boxes from different workers based on the Jaccard index of the
         * boxes.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-BoundingBox</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true
         * class of an image based on annotations from individual workers.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClass</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Multi-label image classification</b> - Uses a variant of the Expectation Maximization approach to estimate
         * the true classes of an image based on annotations from individual workers.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClassMultiLabel</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Semantic segmentation</b> - Treats each pixel in an image as a multi-class classification and treats pixel
         * annotations from workers as "votes" for the correct label.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-SemanticSegmentation</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the true
         * class of text based on annotations from individual workers.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClass</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Multi-label text classification</b> - Uses a variant of the Expectation Maximization approach to estimate
         * the true classes of text based on annotations from individual workers.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClassMultiLabel</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClassMultiLabel</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Named entity recognition</b> - Groups similar selections and calculates aggregate boundaries, resolving to
         * most-assigned label.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-NamedEntityRecognition</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Video Classification</b> - Use this task type when you need workers to classify videos using predefined
         * labels that you specify. Workers are shown videos and are asked to choose one label for each video.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoMultiClass</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoMultiClass</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Video Frame Object Detection</b> - Use this task type to have workers identify and locate objects in a
         * sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this
         * task to ask workers to identify and localize various objects in a series of video frames, such as cars,
         * bikes, and pedestrians.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoObjectDetection</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Video Frame Object Tracking</b> - Use this task type to have workers track the movement of objects in a
         * sequence of video frames (images extracted from a video) using bounding boxes. For example, you can use this
         * task to ask workers to track the movement of objects, such as cars, bikes, and pedestrians.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoObjectTracking</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>3D Point Cloud Modalities</b>
         * </p>
         * <p>
         * Use the following pre-annotation lambdas for 3D point cloud labeling modality tasks. See <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-task-types.html">3D Point Cloud Task
         * types </a> to learn more.
         * </p>
         * <p>
         * <b>3D Point Cloud Object Detection</b> - Use this task type when you want workers to classify objects in a 3D
         * point cloud by drawing 3D cuboids around objects. For example, you can use this task type to ask workers to
         * identify different types of objects in a point cloud, such as cars, bikes, and pedestrians.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>3D Point Cloud Object Tracking</b> - Use this task type when you want workers to draw 3D cuboids around
         * objects that appear in a sequence of 3D point cloud frames. For example, you can use this task type to ask
         * workers to track the movement of vehicles across multiple point cloud frames.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>3D Point Cloud Semantic Segmentation</b> - Use this task type when you want workers to create a
         * point-level semantic segmentation masks by painting objects in a 3D point cloud using different colors where
         * each color is assigned to one of the classes you specify.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Use the following ARNs for Label Verification and Adjustment Jobs</b>
         * </p>
         * <p>
         * Use label verification and adjustment jobs to review and adjust labels. To learn more, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust Labels
         * </a>.
         * </p>
         * <p>
         * <b>Bounding box verification</b> - Uses a variant of the Expectation Maximization approach to estimate the
         * true class of verification judgement for bounding box labels based on annotations from individual workers.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VerificationBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VerificationBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VerificationBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VerificationBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VerificationBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VerificationBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VerificationBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VerificationBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VerificationBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VerificationBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VerificationBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VerificationBoundingBox</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Bounding box adjustment</b> - Finds the most similar boxes from different workers based on the Jaccard
         * index of the adjusted annotations.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentBoundingBox</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentBoundingBox</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Semantic segmentation verification</b> - Uses a variant of the Expectation Maximization approach to
         * estimate the true class of verification judgment for semantic segmentation labels based on annotations from
         * individual workers.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VerificationSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VerificationSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VerificationSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VerificationSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VerificationSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VerificationSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VerificationSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VerificationSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VerificationSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VerificationSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VerificationSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VerificationSemanticSegmentation</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Semantic segmentation adjustment</b> - Treats each pixel in an image as a multi-class classification and
         * treats pixel adjusted annotations from workers as "votes" for the correct label.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentSemanticSegmentation</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Video Frame Object Detection Adjustment</b> - Use this task type when you want workers to adjust bounding
         * boxes that workers have added to video frames to classify and localize objects in a sequence of video frames.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentVideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentVideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentVideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentVideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentVideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentVideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentVideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentVideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentVideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentVideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentVideoObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentVideoObjectDetection</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Video Frame Object Tracking Adjustment</b> - Use this task type when you want workers to adjust bounding
         * boxes that workers have added to video frames to track object movement across a sequence of video frames.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentVideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentVideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentVideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentVideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentVideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentVideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentVideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentVideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentVideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentVideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentVideoObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentVideoObjectTracking</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>3D point cloud object detection adjustment</b> - Adjust 3D cuboids in a point cloud frame.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>3D point cloud object tracking adjustment</b> - Adjust 3D cuboids across a sequence of point cloud frames.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>3D point cloud semantic segmentation adjustment</b> - Adjust semantic segmentation masks in a 3D point
         * cloud.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Generative AI/Custom</b> - Direct passthrough of input data without any transformation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-PassThrough</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-PassThrough</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-PassThrough</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-PassThrough</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-PassThrough</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-PassThrough</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-PassThrough</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-PassThrough</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-PassThrough</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-PassThrough</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-PassThrough</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-PassThrough</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param preHumanTaskLambdaArn
         *        The Amazon Resource Name (ARN) of a Lambda function that is run before a data object is sent to a
         *        human worker. Use this function to provide input to a custom labeling job.</p>
         *        <p>
         *        For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task
         *        types</a>, use one of the following Amazon SageMaker Ground Truth Lambda function ARNs for
         *        <code>PreHumanTaskLambdaArn</code>. For custom labeling workflows, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates-step3.html#sms-custom-templates-step3-prelambda"
         *        >Pre-annotation Lambda</a>.
         *        </p>
         *        <p>
         *        <b>Bounding box</b> - Finds the most similar boxes from different workers based on the Jaccard index
         *        of the boxes.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-BoundingBox</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Image classification</b> - Uses a variant of the Expectation Maximization approach to estimate the
         *        true class of an image based on annotations from individual workers.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClass</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Multi-label image classification</b> - Uses a variant of the Expectation Maximization approach to
         *        estimate the true classes of an image based on annotations from individual workers.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-ImageMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-ImageMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-ImageMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-ImageMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-ImageMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-ImageMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-ImageMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-ImageMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-ImageMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-ImageMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-ImageMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-ImageMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Semantic segmentation</b> - Treats each pixel in an image as a multi-class classification and
         *        treats pixel annotations from workers as "votes" for the correct label.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-SemanticSegmentation</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Text classification</b> - Uses a variant of the Expectation Maximization approach to estimate the
         *        true class of text based on annotations from individual workers.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClass</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Multi-label text classification</b> - Uses a variant of the Expectation Maximization approach to
         *        estimate the true classes of text based on annotations from individual workers.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-TextMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-TextMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-TextMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-TextMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-TextMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-TextMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-TextMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-TextMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-TextMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-TextMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-TextMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-TextMultiClassMultiLabel</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Named entity recognition</b> - Groups similar selections and calculates aggregate boundaries,
         *        resolving to most-assigned label.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-NamedEntityRecognition</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Video Classification</b> - Use this task type when you need workers to classify videos using
         *        predefined labels that you specify. Workers are shown videos and are asked to choose one label for
         *        each video.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoMultiClass</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoMultiClass</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Video Frame Object Detection</b> - Use this task type to have workers identify and locate objects
         *        in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you
         *        can use this task to ask workers to identify and localize various objects in a series of video frames,
         *        such as cars, bikes, and pedestrians.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoObjectDetection</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Video Frame Object Tracking</b> - Use this task type to have workers track the movement of objects
         *        in a sequence of video frames (images extracted from a video) using bounding boxes. For example, you
         *        can use this task to ask workers to track the movement of objects, such as cars, bikes, and
         *        pedestrians.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VideoObjectTracking</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>3D Point Cloud Modalities</b>
         *        </p>
         *        <p>
         *        Use the following pre-annotation lambdas for 3D point cloud labeling modality tasks. See <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-task-types.html">3D Point Cloud
         *        Task types </a> to learn more.
         *        </p>
         *        <p>
         *        <b>3D Point Cloud Object Detection</b> - Use this task type when you want workers to classify objects
         *        in a 3D point cloud by drawing 3D cuboids around objects. For example, you can use this task type to
         *        ask workers to identify different types of objects in a point cloud, such as cars, bikes, and
         *        pedestrians.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>3D Point Cloud Object Tracking</b> - Use this task type when you want workers to draw 3D cuboids
         *        around objects that appear in a sequence of 3D point cloud frames. For example, you can use this task
         *        type to ask workers to track the movement of vehicles across multiple point cloud frames.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>3D Point Cloud Semantic Segmentation</b> - Use this task type when you want workers to create a
         *        point-level semantic segmentation masks by painting objects in a 3D point cloud using different colors
         *        where each color is assigned to one of the classes you specify.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Use the following ARNs for Label Verification and Adjustment Jobs</b>
         *        </p>
         *        <p>
         *        Use label verification and adjustment jobs to review and adjust labels. To learn more, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-verification-data.html">Verify and Adjust
         *        Labels </a>.
         *        </p>
         *        <p>
         *        <b>Bounding box verification</b> - Uses a variant of the Expectation Maximization approach to estimate
         *        the true class of verification judgement for bounding box labels based on annotations from individual
         *        workers.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VerificationBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VerificationBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VerificationBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VerificationBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VerificationBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VerificationBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VerificationBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VerificationBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VerificationBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VerificationBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VerificationBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VerificationBoundingBox</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Bounding box adjustment</b> - Finds the most similar boxes from different workers based on the
         *        Jaccard index of the adjusted annotations.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentBoundingBox</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentBoundingBox</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Semantic segmentation verification</b> - Uses a variant of the Expectation Maximization approach to
         *        estimate the true class of verification judgment for semantic segmentation labels based on annotations
         *        from individual workers.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-VerificationSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-VerificationSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-VerificationSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-VerificationSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-VerificationSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-VerificationSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-VerificationSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-VerificationSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-VerificationSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-VerificationSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-VerificationSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-VerificationSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Semantic segmentation adjustment</b> - Treats each pixel in an image as a multi-class
         *        classification and treats pixel adjusted annotations from workers as "votes" for the correct label.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Video Frame Object Detection Adjustment</b> - Use this task type when you want workers to adjust
         *        bounding boxes that workers have added to video frames to classify and localize objects in a sequence
         *        of video frames.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentVideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentVideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentVideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentVideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentVideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentVideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentVideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentVideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentVideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentVideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentVideoObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentVideoObjectDetection</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Video Frame Object Tracking Adjustment</b> - Use this task type when you want workers to adjust
         *        bounding boxes that workers have added to video frames to track object movement across a sequence of
         *        video frames.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-AdjustmentVideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-AdjustmentVideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-AdjustmentVideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-AdjustmentVideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-AdjustmentVideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-AdjustmentVideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-AdjustmentVideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-AdjustmentVideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-AdjustmentVideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-AdjustmentVideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-AdjustmentVideoObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-AdjustmentVideoObjectTracking</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>3D point cloud object detection adjustment</b> - Adjust 3D cuboids in a point cloud frame.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectDetection</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>3D point cloud object tracking adjustment</b> - Adjust 3D cuboids across a sequence of point cloud
         *        frames.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudObjectTracking</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>3D point cloud semantic segmentation adjustment</b> - Adjust semantic segmentation masks in a 3D
         *        point cloud.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-Adjustment3DPointCloudSemanticSegmentation</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Generative AI/Custom</b> - Direct passthrough of input data without any transformation.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-1:432418664414:function:PRE-PassThrough</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-east-2:266458841044:function:PRE-PassThrough</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:us-west-2:081040173940:function:PRE-PassThrough</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ca-central-1:918755190332:function:PRE-PassThrough</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-1:568282634449:function:PRE-PassThrough</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-west-2:487402164563:function:PRE-PassThrough</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:eu-central-1:203001061592:function:PRE-PassThrough</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-1:477331159723:function:PRE-PassThrough</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-northeast-2:845288260483:function:PRE-PassThrough</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-south-1:565803892007:function:PRE-PassThrough</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-1:377565633583:function:PRE-PassThrough</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:lambda:ap-southeast-2:454466003867:function:PRE-PassThrough</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preHumanTaskLambdaArn(String preHumanTaskLambdaArn);

        /**
         * <p>
         * Keywords used to describe the task so that workers on Amazon Mechanical Turk can discover the task.
         * </p>
         * 
         * @param taskKeywords
         *        Keywords used to describe the task so that workers on Amazon Mechanical Turk can discover the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskKeywords(Collection<String> taskKeywords);

        /**
         * <p>
         * Keywords used to describe the task so that workers on Amazon Mechanical Turk can discover the task.
         * </p>
         * 
         * @param taskKeywords
         *        Keywords used to describe the task so that workers on Amazon Mechanical Turk can discover the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskKeywords(String... taskKeywords);

        /**
         * <p>
         * A title for the task for your human workers.
         * </p>
         * 
         * @param taskTitle
         *        A title for the task for your human workers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskTitle(String taskTitle);

        /**
         * <p>
         * A description of the task for your human workers.
         * </p>
         * 
         * @param taskDescription
         *        A description of the task for your human workers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDescription(String taskDescription);

        /**
         * <p>
         * The number of human workers that will label an object.
         * </p>
         * 
         * @param numberOfHumanWorkersPerDataObject
         *        The number of human workers that will label an object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfHumanWorkersPerDataObject(Integer numberOfHumanWorkersPerDataObject);

        /**
         * <p>
         * The amount of time that a worker has to complete a task.
         * </p>
         * <p>
         * If you create a custom labeling job, the maximum value for this parameter is 8 hours (28,800 seconds).
         * </p>
         * <p>
         * If you create a labeling job using a <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task type</a> the maximum
         * for this parameter depends on the task type you use:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-label-images.html">image</a> and <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-label-text.html">text</a> labeling jobs, the
         * maximum is 8 hours (28,800 seconds).
         * </p>
         * </li>
         * <li>
         * <p>
         * For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud.html">3D point cloud</a> and <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-video.html">video frame</a> labeling jobs, the
         * maximum is 30 days (2952,000 seconds) for non-AL mode. For most users, the maximum is also 30 days.
         * </p>
         * </li>
         * </ul>
         * 
         * @param taskTimeLimitInSeconds
         *        The amount of time that a worker has to complete a task. </p>
         *        <p>
         *        If you create a custom labeling job, the maximum value for this parameter is 8 hours (28,800 seconds).
         *        </p>
         *        <p>
         *        If you create a labeling job using a <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html">built-in task type</a> the
         *        maximum for this parameter depends on the task type you use:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-label-images.html">image</a> and <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-label-text.html">text</a> labeling jobs, the
         *        maximum is 8 hours (28,800 seconds).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud.html">3D point cloud</a>
         *        and <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sms-video.html">video frame</a> labeling
         *        jobs, the maximum is 30 days (2952,000 seconds) for non-AL mode. For most users, the maximum is also
         *        30 days.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskTimeLimitInSeconds(Integer taskTimeLimitInSeconds);

        /**
         * <p>
         * The length of time that a task remains available for labeling by human workers. The default and maximum
         * values for this parameter depend on the type of workforce you use.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you choose the Amazon Mechanical Turk workforce, the maximum is 12 hours (43,200 seconds). The default is
         * 6 hours (21,600 seconds).
         * </p>
         * </li>
         * <li>
         * <p>
         * If you choose a private or vendor workforce, the default value is 30 days (2592,000 seconds) for non-AL mode.
         * For most users, the maximum is also 30 days.
         * </p>
         * </li>
         * </ul>
         * 
         * @param taskAvailabilityLifetimeInSeconds
         *        The length of time that a task remains available for labeling by human workers. The default and
         *        maximum values for this parameter depend on the type of workforce you use.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you choose the Amazon Mechanical Turk workforce, the maximum is 12 hours (43,200 seconds). The
         *        default is 6 hours (21,600 seconds).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you choose a private or vendor workforce, the default value is 30 days (2592,000 seconds) for
         *        non-AL mode. For most users, the maximum is also 30 days.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskAvailabilityLifetimeInSeconds(Integer taskAvailabilityLifetimeInSeconds);

        /**
         * <p>
         * Defines the maximum number of data objects that can be labeled by human workers at the same time. Also
         * referred to as batch size. Each object may have more than one worker at one time. The default value is 1000
         * objects. To increase the maximum value to 5000 objects, contact Amazon Web Services Support.
         * </p>
         * 
         * @param maxConcurrentTaskCount
         *        Defines the maximum number of data objects that can be labeled by human workers at the same time. Also
         *        referred to as batch size. Each object may have more than one worker at one time. The default value is
         *        1000 objects. To increase the maximum value to 5000 objects, contact Amazon Web Services Support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrentTaskCount(Integer maxConcurrentTaskCount);

        /**
         * <p>
         * Configures how labels are consolidated across human workers.
         * </p>
         * 
         * @param annotationConsolidationConfig
         *        Configures how labels are consolidated across human workers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotationConsolidationConfig(AnnotationConsolidationConfig annotationConsolidationConfig);

        /**
         * <p>
         * Configures how labels are consolidated across human workers.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnnotationConsolidationConfig.Builder}
         * avoiding the need to create one manually via {@link AnnotationConsolidationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnnotationConsolidationConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #annotationConsolidationConfig(AnnotationConsolidationConfig)}.
         * 
         * @param annotationConsolidationConfig
         *        a consumer that will call methods on {@link AnnotationConsolidationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #annotationConsolidationConfig(AnnotationConsolidationConfig)
         */
        default Builder annotationConsolidationConfig(
                Consumer<AnnotationConsolidationConfig.Builder> annotationConsolidationConfig) {
            return annotationConsolidationConfig(AnnotationConsolidationConfig.builder()
                    .applyMutation(annotationConsolidationConfig).build());
        }

        /**
         * <p>
         * The price that you pay for each task performed by an Amazon Mechanical Turk worker.
         * </p>
         * 
         * @param publicWorkforceTaskPrice
         *        The price that you pay for each task performed by an Amazon Mechanical Turk worker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicWorkforceTaskPrice(PublicWorkforceTaskPrice publicWorkforceTaskPrice);

        /**
         * <p>
         * The price that you pay for each task performed by an Amazon Mechanical Turk worker.
         * </p>
         * This is a convenience method that creates an instance of the {@link PublicWorkforceTaskPrice.Builder}
         * avoiding the need to create one manually via {@link PublicWorkforceTaskPrice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PublicWorkforceTaskPrice.Builder#build()} is called immediately
         * and its result is passed to {@link #publicWorkforceTaskPrice(PublicWorkforceTaskPrice)}.
         * 
         * @param publicWorkforceTaskPrice
         *        a consumer that will call methods on {@link PublicWorkforceTaskPrice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicWorkforceTaskPrice(PublicWorkforceTaskPrice)
         */
        default Builder publicWorkforceTaskPrice(Consumer<PublicWorkforceTaskPrice.Builder> publicWorkforceTaskPrice) {
            return publicWorkforceTaskPrice(PublicWorkforceTaskPrice.builder().applyMutation(publicWorkforceTaskPrice).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String workteamArn;

        private UiConfig uiConfig;

        private String preHumanTaskLambdaArn;

        private List<String> taskKeywords = DefaultSdkAutoConstructList.getInstance();

        private String taskTitle;

        private String taskDescription;

        private Integer numberOfHumanWorkersPerDataObject;

        private Integer taskTimeLimitInSeconds;

        private Integer taskAvailabilityLifetimeInSeconds;

        private Integer maxConcurrentTaskCount;

        private AnnotationConsolidationConfig annotationConsolidationConfig;

        private PublicWorkforceTaskPrice publicWorkforceTaskPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanTaskConfig model) {
            workteamArn(model.workteamArn);
            uiConfig(model.uiConfig);
            preHumanTaskLambdaArn(model.preHumanTaskLambdaArn);
            taskKeywords(model.taskKeywords);
            taskTitle(model.taskTitle);
            taskDescription(model.taskDescription);
            numberOfHumanWorkersPerDataObject(model.numberOfHumanWorkersPerDataObject);
            taskTimeLimitInSeconds(model.taskTimeLimitInSeconds);
            taskAvailabilityLifetimeInSeconds(model.taskAvailabilityLifetimeInSeconds);
            maxConcurrentTaskCount(model.maxConcurrentTaskCount);
            annotationConsolidationConfig(model.annotationConsolidationConfig);
            publicWorkforceTaskPrice(model.publicWorkforceTaskPrice);
        }

        public final String getWorkteamArn() {
            return workteamArn;
        }

        public final void setWorkteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
        }

        @Override
        public final Builder workteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
            return this;
        }

        public final UiConfig.Builder getUiConfig() {
            return uiConfig != null ? uiConfig.toBuilder() : null;
        }

        public final void setUiConfig(UiConfig.BuilderImpl uiConfig) {
            this.uiConfig = uiConfig != null ? uiConfig.build() : null;
        }

        @Override
        public final Builder uiConfig(UiConfig uiConfig) {
            this.uiConfig = uiConfig;
            return this;
        }

        public final String getPreHumanTaskLambdaArn() {
            return preHumanTaskLambdaArn;
        }

        public final void setPreHumanTaskLambdaArn(String preHumanTaskLambdaArn) {
            this.preHumanTaskLambdaArn = preHumanTaskLambdaArn;
        }

        @Override
        public final Builder preHumanTaskLambdaArn(String preHumanTaskLambdaArn) {
            this.preHumanTaskLambdaArn = preHumanTaskLambdaArn;
            return this;
        }

        public final Collection<String> getTaskKeywords() {
            if (taskKeywords instanceof SdkAutoConstructList) {
                return null;
            }
            return taskKeywords;
        }

        public final void setTaskKeywords(Collection<String> taskKeywords) {
            this.taskKeywords = TaskKeywordsCopier.copy(taskKeywords);
        }

        @Override
        public final Builder taskKeywords(Collection<String> taskKeywords) {
            this.taskKeywords = TaskKeywordsCopier.copy(taskKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskKeywords(String... taskKeywords) {
            taskKeywords(Arrays.asList(taskKeywords));
            return this;
        }

        public final String getTaskTitle() {
            return taskTitle;
        }

        public final void setTaskTitle(String taskTitle) {
            this.taskTitle = taskTitle;
        }

        @Override
        public final Builder taskTitle(String taskTitle) {
            this.taskTitle = taskTitle;
            return this;
        }

        public final String getTaskDescription() {
            return taskDescription;
        }

        public final void setTaskDescription(String taskDescription) {
            this.taskDescription = taskDescription;
        }

        @Override
        public final Builder taskDescription(String taskDescription) {
            this.taskDescription = taskDescription;
            return this;
        }

        public final Integer getNumberOfHumanWorkersPerDataObject() {
            return numberOfHumanWorkersPerDataObject;
        }

        public final void setNumberOfHumanWorkersPerDataObject(Integer numberOfHumanWorkersPerDataObject) {
            this.numberOfHumanWorkersPerDataObject = numberOfHumanWorkersPerDataObject;
        }

        @Override
        public final Builder numberOfHumanWorkersPerDataObject(Integer numberOfHumanWorkersPerDataObject) {
            this.numberOfHumanWorkersPerDataObject = numberOfHumanWorkersPerDataObject;
            return this;
        }

        public final Integer getTaskTimeLimitInSeconds() {
            return taskTimeLimitInSeconds;
        }

        public final void setTaskTimeLimitInSeconds(Integer taskTimeLimitInSeconds) {
            this.taskTimeLimitInSeconds = taskTimeLimitInSeconds;
        }

        @Override
        public final Builder taskTimeLimitInSeconds(Integer taskTimeLimitInSeconds) {
            this.taskTimeLimitInSeconds = taskTimeLimitInSeconds;
            return this;
        }

        public final Integer getTaskAvailabilityLifetimeInSeconds() {
            return taskAvailabilityLifetimeInSeconds;
        }

        public final void setTaskAvailabilityLifetimeInSeconds(Integer taskAvailabilityLifetimeInSeconds) {
            this.taskAvailabilityLifetimeInSeconds = taskAvailabilityLifetimeInSeconds;
        }

        @Override
        public final Builder taskAvailabilityLifetimeInSeconds(Integer taskAvailabilityLifetimeInSeconds) {
            this.taskAvailabilityLifetimeInSeconds = taskAvailabilityLifetimeInSeconds;
            return this;
        }

        public final Integer getMaxConcurrentTaskCount() {
            return maxConcurrentTaskCount;
        }

        public final void setMaxConcurrentTaskCount(Integer maxConcurrentTaskCount) {
            this.maxConcurrentTaskCount = maxConcurrentTaskCount;
        }

        @Override
        public final Builder maxConcurrentTaskCount(Integer maxConcurrentTaskCount) {
            this.maxConcurrentTaskCount = maxConcurrentTaskCount;
            return this;
        }

        public final AnnotationConsolidationConfig.Builder getAnnotationConsolidationConfig() {
            return annotationConsolidationConfig != null ? annotationConsolidationConfig.toBuilder() : null;
        }

        public final void setAnnotationConsolidationConfig(AnnotationConsolidationConfig.BuilderImpl annotationConsolidationConfig) {
            this.annotationConsolidationConfig = annotationConsolidationConfig != null ? annotationConsolidationConfig.build()
                    : null;
        }

        @Override
        public final Builder annotationConsolidationConfig(AnnotationConsolidationConfig annotationConsolidationConfig) {
            this.annotationConsolidationConfig = annotationConsolidationConfig;
            return this;
        }

        public final PublicWorkforceTaskPrice.Builder getPublicWorkforceTaskPrice() {
            return publicWorkforceTaskPrice != null ? publicWorkforceTaskPrice.toBuilder() : null;
        }

        public final void setPublicWorkforceTaskPrice(PublicWorkforceTaskPrice.BuilderImpl publicWorkforceTaskPrice) {
            this.publicWorkforceTaskPrice = publicWorkforceTaskPrice != null ? publicWorkforceTaskPrice.build() : null;
        }

        @Override
        public final Builder publicWorkforceTaskPrice(PublicWorkforceTaskPrice publicWorkforceTaskPrice) {
            this.publicWorkforceTaskPrice = publicWorkforceTaskPrice;
            return this;
        }

        @Override
        public HumanTaskConfig build() {
            return new HumanTaskConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
