/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a training job launched by a hyperparameter tuning job. Choose <code>Bayesian</code> for
 * Bayesian optimization, and <code>Random</code> for random search optimization. For more advanced use cases, use
 * <code>Hyperband</code>, which evaluates objective metrics for training jobs after every epoch. For more information
 * about strategies, see <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/dg/automatic-model-tuning-how-it-works.html">How Hyperparameter
 * Tuning Works</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HyperParameterTuningJobStrategyConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<HyperParameterTuningJobStrategyConfig.Builder, HyperParameterTuningJobStrategyConfig> {
    private static final SdkField<HyperbandStrategyConfig> HYPERBAND_STRATEGY_CONFIG_FIELD = SdkField
            .<HyperbandStrategyConfig> builder(MarshallingType.SDK_POJO).memberName("HyperbandStrategyConfig")
            .getter(getter(HyperParameterTuningJobStrategyConfig::hyperbandStrategyConfig))
            .setter(setter(Builder::hyperbandStrategyConfig)).constructor(HyperbandStrategyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperbandStrategyConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(HYPERBAND_STRATEGY_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final HyperbandStrategyConfig hyperbandStrategyConfig;

    private HyperParameterTuningJobStrategyConfig(BuilderImpl builder) {
        this.hyperbandStrategyConfig = builder.hyperbandStrategyConfig;
    }

    /**
     * <p>
     * The configuration for the object that specifies the <code>Hyperband</code> strategy. This parameter is only
     * supported for the <code>Hyperband</code> selection for <code>Strategy</code> within the
     * <code>HyperParameterTuningJobConfig</code> API.
     * </p>
     * 
     * @return The configuration for the object that specifies the <code>Hyperband</code> strategy. This parameter is
     *         only supported for the <code>Hyperband</code> selection for <code>Strategy</code> within the
     *         <code>HyperParameterTuningJobConfig</code> API.
     */
    public final HyperbandStrategyConfig hyperbandStrategyConfig() {
        return hyperbandStrategyConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hyperbandStrategyConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTuningJobStrategyConfig)) {
            return false;
        }
        HyperParameterTuningJobStrategyConfig other = (HyperParameterTuningJobStrategyConfig) obj;
        return Objects.equals(hyperbandStrategyConfig(), other.hyperbandStrategyConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HyperParameterTuningJobStrategyConfig")
                .add("HyperbandStrategyConfig", hyperbandStrategyConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HyperbandStrategyConfig":
            return Optional.ofNullable(clazz.cast(hyperbandStrategyConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HyperbandStrategyConfig", HYPERBAND_STRATEGY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterTuningJobStrategyConfig, T> g) {
        return obj -> g.apply((HyperParameterTuningJobStrategyConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HyperParameterTuningJobStrategyConfig> {
        /**
         * <p>
         * The configuration for the object that specifies the <code>Hyperband</code> strategy. This parameter is only
         * supported for the <code>Hyperband</code> selection for <code>Strategy</code> within the
         * <code>HyperParameterTuningJobConfig</code> API.
         * </p>
         * 
         * @param hyperbandStrategyConfig
         *        The configuration for the object that specifies the <code>Hyperband</code> strategy. This parameter is
         *        only supported for the <code>Hyperband</code> selection for <code>Strategy</code> within the
         *        <code>HyperParameterTuningJobConfig</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperbandStrategyConfig(HyperbandStrategyConfig hyperbandStrategyConfig);

        /**
         * <p>
         * The configuration for the object that specifies the <code>Hyperband</code> strategy. This parameter is only
         * supported for the <code>Hyperband</code> selection for <code>Strategy</code> within the
         * <code>HyperParameterTuningJobConfig</code> API.
         * </p>
         * This is a convenience method that creates an instance of the {@link HyperbandStrategyConfig.Builder} avoiding
         * the need to create one manually via {@link HyperbandStrategyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HyperbandStrategyConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #hyperbandStrategyConfig(HyperbandStrategyConfig)}.
         * 
         * @param hyperbandStrategyConfig
         *        a consumer that will call methods on {@link HyperbandStrategyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hyperbandStrategyConfig(HyperbandStrategyConfig)
         */
        default Builder hyperbandStrategyConfig(Consumer<HyperbandStrategyConfig.Builder> hyperbandStrategyConfig) {
            return hyperbandStrategyConfig(HyperbandStrategyConfig.builder().applyMutation(hyperbandStrategyConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HyperbandStrategyConfig hyperbandStrategyConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterTuningJobStrategyConfig model) {
            hyperbandStrategyConfig(model.hyperbandStrategyConfig);
        }

        public final HyperbandStrategyConfig.Builder getHyperbandStrategyConfig() {
            return hyperbandStrategyConfig != null ? hyperbandStrategyConfig.toBuilder() : null;
        }

        public final void setHyperbandStrategyConfig(HyperbandStrategyConfig.BuilderImpl hyperbandStrategyConfig) {
            this.hyperbandStrategyConfig = hyperbandStrategyConfig != null ? hyperbandStrategyConfig.build() : null;
        }

        @Override
        public final Builder hyperbandStrategyConfig(HyperbandStrategyConfig hyperbandStrategyConfig) {
            this.hyperbandStrategyConfig = hyperbandStrategyConfig;
            return this;
        }

        @Override
        public HyperParameterTuningJobStrategyConfig build() {
            return new HyperParameterTuningJobStrategyConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
