/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the resources to deploy with this inference component, including the model, container, and compute
 * resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceComponentSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceComponentSpecification.Builder, InferenceComponentSpecification> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(InferenceComponentSpecification::modelName))
            .setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<InferenceComponentContainerSpecification> CONTAINER_FIELD = SdkField
            .<InferenceComponentContainerSpecification> builder(MarshallingType.SDK_POJO).memberName("Container")
            .getter(getter(InferenceComponentSpecification::container)).setter(setter(Builder::container))
            .constructor(InferenceComponentContainerSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Container").build()).build();

    private static final SdkField<InferenceComponentStartupParameters> STARTUP_PARAMETERS_FIELD = SdkField
            .<InferenceComponentStartupParameters> builder(MarshallingType.SDK_POJO).memberName("StartupParameters")
            .getter(getter(InferenceComponentSpecification::startupParameters)).setter(setter(Builder::startupParameters))
            .constructor(InferenceComponentStartupParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartupParameters").build()).build();

    private static final SdkField<InferenceComponentComputeResourceRequirements> COMPUTE_RESOURCE_REQUIREMENTS_FIELD = SdkField
            .<InferenceComponentComputeResourceRequirements> builder(MarshallingType.SDK_POJO)
            .memberName("ComputeResourceRequirements")
            .getter(getter(InferenceComponentSpecification::computeResourceRequirements))
            .setter(setter(Builder::computeResourceRequirements))
            .constructor(InferenceComponentComputeResourceRequirements::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeResourceRequirements")
                    .build()).build();

    private static final SdkField<String> BASE_INFERENCE_COMPONENT_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BaseInferenceComponentName")
            .getter(getter(InferenceComponentSpecification::baseInferenceComponentName))
            .setter(setter(Builder::baseInferenceComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseInferenceComponentName").build())
            .build();

    private static final SdkField<InferenceComponentDataCacheConfig> DATA_CACHE_CONFIG_FIELD = SdkField
            .<InferenceComponentDataCacheConfig> builder(MarshallingType.SDK_POJO).memberName("DataCacheConfig")
            .getter(getter(InferenceComponentSpecification::dataCacheConfig)).setter(setter(Builder::dataCacheConfig))
            .constructor(InferenceComponentDataCacheConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCacheConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            CONTAINER_FIELD, STARTUP_PARAMETERS_FIELD, COMPUTE_RESOURCE_REQUIREMENTS_FIELD, BASE_INFERENCE_COMPONENT_NAME_FIELD,
            DATA_CACHE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String modelName;

    private final InferenceComponentContainerSpecification container;

    private final InferenceComponentStartupParameters startupParameters;

    private final InferenceComponentComputeResourceRequirements computeResourceRequirements;

    private final String baseInferenceComponentName;

    private final InferenceComponentDataCacheConfig dataCacheConfig;

    private InferenceComponentSpecification(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.container = builder.container;
        this.startupParameters = builder.startupParameters;
        this.computeResourceRequirements = builder.computeResourceRequirements;
        this.baseInferenceComponentName = builder.baseInferenceComponentName;
        this.dataCacheConfig = builder.dataCacheConfig;
    }

    /**
     * <p>
     * The name of an existing SageMaker AI model object in your account that you want to deploy with the inference
     * component.
     * </p>
     * 
     * @return The name of an existing SageMaker AI model object in your account that you want to deploy with the
     *         inference component.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * Defines a container that provides the runtime environment for a model that you deploy with an inference
     * component.
     * </p>
     * 
     * @return Defines a container that provides the runtime environment for a model that you deploy with an inference
     *         component.
     */
    public final InferenceComponentContainerSpecification container() {
        return container;
    }

    /**
     * <p>
     * Settings that take effect while the model container starts up.
     * </p>
     * 
     * @return Settings that take effect while the model container starts up.
     */
    public final InferenceComponentStartupParameters startupParameters() {
        return startupParameters;
    }

    /**
     * <p>
     * The compute resources allocated to run the model, plus any adapter models, that you assign to the inference
     * component.
     * </p>
     * <p>
     * Omit this parameter if your request is meant to create an adapter inference component. An adapter inference
     * component is loaded by a base inference component, and it uses the compute resources of the base inference
     * component.
     * </p>
     * 
     * @return The compute resources allocated to run the model, plus any adapter models, that you assign to the
     *         inference component.</p>
     *         <p>
     *         Omit this parameter if your request is meant to create an adapter inference component. An adapter
     *         inference component is loaded by a base inference component, and it uses the compute resources of the
     *         base inference component.
     */
    public final InferenceComponentComputeResourceRequirements computeResourceRequirements() {
        return computeResourceRequirements;
    }

    /**
     * <p>
     * The name of an existing inference component that is to contain the inference component that you're creating with
     * your request.
     * </p>
     * <p>
     * Specify this parameter only if your request is meant to create an adapter inference component. An adapter
     * inference component contains the path to an adapter model. The purpose of the adapter model is to tailor the
     * inference output of a base foundation model, which is hosted by the base inference component. The adapter
     * inference component uses the compute resources that you assigned to the base inference component.
     * </p>
     * <p>
     * When you create an adapter inference component, use the <code>Container</code> parameter to specify the location
     * of the adapter artifacts. In the parameter value, use the <code>ArtifactUrl</code> parameter of the
     * <code>InferenceComponentContainerSpecification</code> data type.
     * </p>
     * <p>
     * Before you can create an adapter inference component, you must have an existing inference component that contains
     * the foundation model that you want to adapt.
     * </p>
     * 
     * @return The name of an existing inference component that is to contain the inference component that you're
     *         creating with your request.</p>
     *         <p>
     *         Specify this parameter only if your request is meant to create an adapter inference component. An adapter
     *         inference component contains the path to an adapter model. The purpose of the adapter model is to tailor
     *         the inference output of a base foundation model, which is hosted by the base inference component. The
     *         adapter inference component uses the compute resources that you assigned to the base inference component.
     *         </p>
     *         <p>
     *         When you create an adapter inference component, use the <code>Container</code> parameter to specify the
     *         location of the adapter artifacts. In the parameter value, use the <code>ArtifactUrl</code> parameter of
     *         the <code>InferenceComponentContainerSpecification</code> data type.
     *         </p>
     *         <p>
     *         Before you can create an adapter inference component, you must have an existing inference component that
     *         contains the foundation model that you want to adapt.
     */
    public final String baseInferenceComponentName() {
        return baseInferenceComponentName;
    }

    /**
     * <p>
     * Settings that affect how the inference component caches data.
     * </p>
     * 
     * @return Settings that affect how the inference component caches data.
     */
    public final InferenceComponentDataCacheConfig dataCacheConfig() {
        return dataCacheConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(container());
        hashCode = 31 * hashCode + Objects.hashCode(startupParameters());
        hashCode = 31 * hashCode + Objects.hashCode(computeResourceRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(baseInferenceComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(dataCacheConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceComponentSpecification)) {
            return false;
        }
        InferenceComponentSpecification other = (InferenceComponentSpecification) obj;
        return Objects.equals(modelName(), other.modelName()) && Objects.equals(container(), other.container())
                && Objects.equals(startupParameters(), other.startupParameters())
                && Objects.equals(computeResourceRequirements(), other.computeResourceRequirements())
                && Objects.equals(baseInferenceComponentName(), other.baseInferenceComponentName())
                && Objects.equals(dataCacheConfig(), other.dataCacheConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceComponentSpecification").add("ModelName", modelName()).add("Container", container())
                .add("StartupParameters", startupParameters()).add("ComputeResourceRequirements", computeResourceRequirements())
                .add("BaseInferenceComponentName", baseInferenceComponentName()).add("DataCacheConfig", dataCacheConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "Container":
            return Optional.ofNullable(clazz.cast(container()));
        case "StartupParameters":
            return Optional.ofNullable(clazz.cast(startupParameters()));
        case "ComputeResourceRequirements":
            return Optional.ofNullable(clazz.cast(computeResourceRequirements()));
        case "BaseInferenceComponentName":
            return Optional.ofNullable(clazz.cast(baseInferenceComponentName()));
        case "DataCacheConfig":
            return Optional.ofNullable(clazz.cast(dataCacheConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("Container", CONTAINER_FIELD);
        map.put("StartupParameters", STARTUP_PARAMETERS_FIELD);
        map.put("ComputeResourceRequirements", COMPUTE_RESOURCE_REQUIREMENTS_FIELD);
        map.put("BaseInferenceComponentName", BASE_INFERENCE_COMPONENT_NAME_FIELD);
        map.put("DataCacheConfig", DATA_CACHE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceComponentSpecification, T> g) {
        return obj -> g.apply((InferenceComponentSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceComponentSpecification> {
        /**
         * <p>
         * The name of an existing SageMaker AI model object in your account that you want to deploy with the inference
         * component.
         * </p>
         * 
         * @param modelName
         *        The name of an existing SageMaker AI model object in your account that you want to deploy with the
         *        inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * Defines a container that provides the runtime environment for a model that you deploy with an inference
         * component.
         * </p>
         * 
         * @param container
         *        Defines a container that provides the runtime environment for a model that you deploy with an
         *        inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder container(InferenceComponentContainerSpecification container);

        /**
         * <p>
         * Defines a container that provides the runtime environment for a model that you deploy with an inference
         * component.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InferenceComponentContainerSpecification.Builder} avoiding the need to create one manually via
         * {@link InferenceComponentContainerSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceComponentContainerSpecification.Builder#build()} is
         * called immediately and its result is passed to {@link #container(InferenceComponentContainerSpecification)}.
         * 
         * @param container
         *        a consumer that will call methods on {@link InferenceComponentContainerSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #container(InferenceComponentContainerSpecification)
         */
        default Builder container(Consumer<InferenceComponentContainerSpecification.Builder> container) {
            return container(InferenceComponentContainerSpecification.builder().applyMutation(container).build());
        }

        /**
         * <p>
         * Settings that take effect while the model container starts up.
         * </p>
         * 
         * @param startupParameters
         *        Settings that take effect while the model container starts up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startupParameters(InferenceComponentStartupParameters startupParameters);

        /**
         * <p>
         * Settings that take effect while the model container starts up.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InferenceComponentStartupParameters.Builder} avoiding the need to create one manually via
         * {@link InferenceComponentStartupParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceComponentStartupParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #startupParameters(InferenceComponentStartupParameters)}.
         * 
         * @param startupParameters
         *        a consumer that will call methods on {@link InferenceComponentStartupParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startupParameters(InferenceComponentStartupParameters)
         */
        default Builder startupParameters(Consumer<InferenceComponentStartupParameters.Builder> startupParameters) {
            return startupParameters(InferenceComponentStartupParameters.builder().applyMutation(startupParameters).build());
        }

        /**
         * <p>
         * The compute resources allocated to run the model, plus any adapter models, that you assign to the inference
         * component.
         * </p>
         * <p>
         * Omit this parameter if your request is meant to create an adapter inference component. An adapter inference
         * component is loaded by a base inference component, and it uses the compute resources of the base inference
         * component.
         * </p>
         * 
         * @param computeResourceRequirements
         *        The compute resources allocated to run the model, plus any adapter models, that you assign to the
         *        inference component.</p>
         *        <p>
         *        Omit this parameter if your request is meant to create an adapter inference component. An adapter
         *        inference component is loaded by a base inference component, and it uses the compute resources of the
         *        base inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeResourceRequirements(InferenceComponentComputeResourceRequirements computeResourceRequirements);

        /**
         * <p>
         * The compute resources allocated to run the model, plus any adapter models, that you assign to the inference
         * component.
         * </p>
         * <p>
         * Omit this parameter if your request is meant to create an adapter inference component. An adapter inference
         * component is loaded by a base inference component, and it uses the compute resources of the base inference
         * component.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InferenceComponentComputeResourceRequirements.Builder} avoiding the need to create one manually via
         * {@link InferenceComponentComputeResourceRequirements#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceComponentComputeResourceRequirements.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #computeResourceRequirements(InferenceComponentComputeResourceRequirements)}.
         * 
         * @param computeResourceRequirements
         *        a consumer that will call methods on {@link InferenceComponentComputeResourceRequirements.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeResourceRequirements(InferenceComponentComputeResourceRequirements)
         */
        default Builder computeResourceRequirements(
                Consumer<InferenceComponentComputeResourceRequirements.Builder> computeResourceRequirements) {
            return computeResourceRequirements(InferenceComponentComputeResourceRequirements.builder()
                    .applyMutation(computeResourceRequirements).build());
        }

        /**
         * <p>
         * The name of an existing inference component that is to contain the inference component that you're creating
         * with your request.
         * </p>
         * <p>
         * Specify this parameter only if your request is meant to create an adapter inference component. An adapter
         * inference component contains the path to an adapter model. The purpose of the adapter model is to tailor the
         * inference output of a base foundation model, which is hosted by the base inference component. The adapter
         * inference component uses the compute resources that you assigned to the base inference component.
         * </p>
         * <p>
         * When you create an adapter inference component, use the <code>Container</code> parameter to specify the
         * location of the adapter artifacts. In the parameter value, use the <code>ArtifactUrl</code> parameter of the
         * <code>InferenceComponentContainerSpecification</code> data type.
         * </p>
         * <p>
         * Before you can create an adapter inference component, you must have an existing inference component that
         * contains the foundation model that you want to adapt.
         * </p>
         * 
         * @param baseInferenceComponentName
         *        The name of an existing inference component that is to contain the inference component that you're
         *        creating with your request.</p>
         *        <p>
         *        Specify this parameter only if your request is meant to create an adapter inference component. An
         *        adapter inference component contains the path to an adapter model. The purpose of the adapter model is
         *        to tailor the inference output of a base foundation model, which is hosted by the base inference
         *        component. The adapter inference component uses the compute resources that you assigned to the base
         *        inference component.
         *        </p>
         *        <p>
         *        When you create an adapter inference component, use the <code>Container</code> parameter to specify
         *        the location of the adapter artifacts. In the parameter value, use the <code>ArtifactUrl</code>
         *        parameter of the <code>InferenceComponentContainerSpecification</code> data type.
         *        </p>
         *        <p>
         *        Before you can create an adapter inference component, you must have an existing inference component
         *        that contains the foundation model that you want to adapt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseInferenceComponentName(String baseInferenceComponentName);

        /**
         * <p>
         * Settings that affect how the inference component caches data.
         * </p>
         * 
         * @param dataCacheConfig
         *        Settings that affect how the inference component caches data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataCacheConfig(InferenceComponentDataCacheConfig dataCacheConfig);

        /**
         * <p>
         * Settings that affect how the inference component caches data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InferenceComponentDataCacheConfig.Builder} avoiding the need to create one manually via
         * {@link InferenceComponentDataCacheConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceComponentDataCacheConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #dataCacheConfig(InferenceComponentDataCacheConfig)}.
         * 
         * @param dataCacheConfig
         *        a consumer that will call methods on {@link InferenceComponentDataCacheConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataCacheConfig(InferenceComponentDataCacheConfig)
         */
        default Builder dataCacheConfig(Consumer<InferenceComponentDataCacheConfig.Builder> dataCacheConfig) {
            return dataCacheConfig(InferenceComponentDataCacheConfig.builder().applyMutation(dataCacheConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String modelName;

        private InferenceComponentContainerSpecification container;

        private InferenceComponentStartupParameters startupParameters;

        private InferenceComponentComputeResourceRequirements computeResourceRequirements;

        private String baseInferenceComponentName;

        private InferenceComponentDataCacheConfig dataCacheConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceComponentSpecification model) {
            modelName(model.modelName);
            container(model.container);
            startupParameters(model.startupParameters);
            computeResourceRequirements(model.computeResourceRequirements);
            baseInferenceComponentName(model.baseInferenceComponentName);
            dataCacheConfig(model.dataCacheConfig);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final InferenceComponentContainerSpecification.Builder getContainer() {
            return container != null ? container.toBuilder() : null;
        }

        public final void setContainer(InferenceComponentContainerSpecification.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        @Override
        public final Builder container(InferenceComponentContainerSpecification container) {
            this.container = container;
            return this;
        }

        public final InferenceComponentStartupParameters.Builder getStartupParameters() {
            return startupParameters != null ? startupParameters.toBuilder() : null;
        }

        public final void setStartupParameters(InferenceComponentStartupParameters.BuilderImpl startupParameters) {
            this.startupParameters = startupParameters != null ? startupParameters.build() : null;
        }

        @Override
        public final Builder startupParameters(InferenceComponentStartupParameters startupParameters) {
            this.startupParameters = startupParameters;
            return this;
        }

        public final InferenceComponentComputeResourceRequirements.Builder getComputeResourceRequirements() {
            return computeResourceRequirements != null ? computeResourceRequirements.toBuilder() : null;
        }

        public final void setComputeResourceRequirements(
                InferenceComponentComputeResourceRequirements.BuilderImpl computeResourceRequirements) {
            this.computeResourceRequirements = computeResourceRequirements != null ? computeResourceRequirements.build() : null;
        }

        @Override
        public final Builder computeResourceRequirements(InferenceComponentComputeResourceRequirements computeResourceRequirements) {
            this.computeResourceRequirements = computeResourceRequirements;
            return this;
        }

        public final String getBaseInferenceComponentName() {
            return baseInferenceComponentName;
        }

        public final void setBaseInferenceComponentName(String baseInferenceComponentName) {
            this.baseInferenceComponentName = baseInferenceComponentName;
        }

        @Override
        public final Builder baseInferenceComponentName(String baseInferenceComponentName) {
            this.baseInferenceComponentName = baseInferenceComponentName;
            return this;
        }

        public final InferenceComponentDataCacheConfig.Builder getDataCacheConfig() {
            return dataCacheConfig != null ? dataCacheConfig.toBuilder() : null;
        }

        public final void setDataCacheConfig(InferenceComponentDataCacheConfig.BuilderImpl dataCacheConfig) {
            this.dataCacheConfig = dataCacheConfig != null ? dataCacheConfig.build() : null;
        }

        @Override
        public final Builder dataCacheConfig(InferenceComponentDataCacheConfig dataCacheConfig) {
            this.dataCacheConfig = dataCacheConfig;
            return this;
        }

        @Override
        public InferenceComponentSpecification build() {
            return new InferenceComponentSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
