/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata information about an instance in a HyperPod cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceMetadata.Builder, InstanceMetadata> {
    private static final SdkField<String> CUSTOMER_ENI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomerEni").getter(getter(InstanceMetadata::customerEni)).setter(setter(Builder::customerEni))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerEni").build()).build();

    private static final SdkField<AdditionalEnis> ADDITIONAL_ENIS_FIELD = SdkField
            .<AdditionalEnis> builder(MarshallingType.SDK_POJO).memberName("AdditionalEnis")
            .getter(getter(InstanceMetadata::additionalEnis)).setter(setter(Builder::additionalEnis))
            .constructor(AdditionalEnis::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalEnis").build()).build();

    private static final SdkField<CapacityReservation> CAPACITY_RESERVATION_FIELD = SdkField
            .<CapacityReservation> builder(MarshallingType.SDK_POJO).memberName("CapacityReservation")
            .getter(getter(InstanceMetadata::capacityReservation)).setter(setter(Builder::capacityReservation))
            .constructor(CapacityReservation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservation").build())
            .build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMessage").getter(getter(InstanceMetadata::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()).build();

    private static final SdkField<String> LCS_EXECUTION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LcsExecutionState").getter(getter(InstanceMetadata::lcsExecutionState))
            .setter(setter(Builder::lcsExecutionState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LcsExecutionState").build()).build();

    private static final SdkField<String> NODE_LOGICAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeLogicalId").getter(getter(InstanceMetadata::nodeLogicalId)).setter(setter(Builder::nodeLogicalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeLogicalId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_ENI_FIELD,
            ADDITIONAL_ENIS_FIELD, CAPACITY_RESERVATION_FIELD, FAILURE_MESSAGE_FIELD, LCS_EXECUTION_STATE_FIELD,
            NODE_LOGICAL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String customerEni;

    private final AdditionalEnis additionalEnis;

    private final CapacityReservation capacityReservation;

    private final String failureMessage;

    private final String lcsExecutionState;

    private final String nodeLogicalId;

    private InstanceMetadata(BuilderImpl builder) {
        this.customerEni = builder.customerEni;
        this.additionalEnis = builder.additionalEnis;
        this.capacityReservation = builder.capacityReservation;
        this.failureMessage = builder.failureMessage;
        this.lcsExecutionState = builder.lcsExecutionState;
        this.nodeLogicalId = builder.nodeLogicalId;
    }

    /**
     * <p>
     * The ID of the customer-managed Elastic Network Interface (ENI) associated with the instance.
     * </p>
     * 
     * @return The ID of the customer-managed Elastic Network Interface (ENI) associated with the instance.
     */
    public final String customerEni() {
        return customerEni;
    }

    /**
     * <p>
     * Information about additional Elastic Network Interfaces (ENIs) associated with the instance.
     * </p>
     * 
     * @return Information about additional Elastic Network Interfaces (ENIs) associated with the instance.
     */
    public final AdditionalEnis additionalEnis() {
        return additionalEnis;
    }

    /**
     * <p>
     * Information about the Capacity Reservation used by the instance.
     * </p>
     * 
     * @return Information about the Capacity Reservation used by the instance.
     */
    public final CapacityReservation capacityReservation() {
        return capacityReservation;
    }

    /**
     * <p>
     * An error message describing why the instance creation or update failed, if applicable.
     * </p>
     * 
     * @return An error message describing why the instance creation or update failed, if applicable.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * <p>
     * The execution state of the Lifecycle Script (LCS) for the instance.
     * </p>
     * 
     * @return The execution state of the Lifecycle Script (LCS) for the instance.
     */
    public final String lcsExecutionState() {
        return lcsExecutionState;
    }

    /**
     * <p>
     * The unique logical identifier of the node within the cluster. The ID used here is the same object as in the
     * <code>BatchAddClusterNodes</code> API.
     * </p>
     * 
     * @return The unique logical identifier of the node within the cluster. The ID used here is the same object as in
     *         the <code>BatchAddClusterNodes</code> API.
     */
    public final String nodeLogicalId() {
        return nodeLogicalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customerEni());
        hashCode = 31 * hashCode + Objects.hashCode(additionalEnis());
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservation());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lcsExecutionState());
        hashCode = 31 * hashCode + Objects.hashCode(nodeLogicalId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceMetadata)) {
            return false;
        }
        InstanceMetadata other = (InstanceMetadata) obj;
        return Objects.equals(customerEni(), other.customerEni()) && Objects.equals(additionalEnis(), other.additionalEnis())
                && Objects.equals(capacityReservation(), other.capacityReservation())
                && Objects.equals(failureMessage(), other.failureMessage())
                && Objects.equals(lcsExecutionState(), other.lcsExecutionState())
                && Objects.equals(nodeLogicalId(), other.nodeLogicalId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceMetadata").add("CustomerEni", customerEni()).add("AdditionalEnis", additionalEnis())
                .add("CapacityReservation", capacityReservation()).add("FailureMessage", failureMessage())
                .add("LcsExecutionState", lcsExecutionState()).add("NodeLogicalId", nodeLogicalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomerEni":
            return Optional.ofNullable(clazz.cast(customerEni()));
        case "AdditionalEnis":
            return Optional.ofNullable(clazz.cast(additionalEnis()));
        case "CapacityReservation":
            return Optional.ofNullable(clazz.cast(capacityReservation()));
        case "FailureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "LcsExecutionState":
            return Optional.ofNullable(clazz.cast(lcsExecutionState()));
        case "NodeLogicalId":
            return Optional.ofNullable(clazz.cast(nodeLogicalId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CustomerEni", CUSTOMER_ENI_FIELD);
        map.put("AdditionalEnis", ADDITIONAL_ENIS_FIELD);
        map.put("CapacityReservation", CAPACITY_RESERVATION_FIELD);
        map.put("FailureMessage", FAILURE_MESSAGE_FIELD);
        map.put("LcsExecutionState", LCS_EXECUTION_STATE_FIELD);
        map.put("NodeLogicalId", NODE_LOGICAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceMetadata, T> g) {
        return obj -> g.apply((InstanceMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceMetadata> {
        /**
         * <p>
         * The ID of the customer-managed Elastic Network Interface (ENI) associated with the instance.
         * </p>
         * 
         * @param customerEni
         *        The ID of the customer-managed Elastic Network Interface (ENI) associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerEni(String customerEni);

        /**
         * <p>
         * Information about additional Elastic Network Interfaces (ENIs) associated with the instance.
         * </p>
         * 
         * @param additionalEnis
         *        Information about additional Elastic Network Interfaces (ENIs) associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalEnis(AdditionalEnis additionalEnis);

        /**
         * <p>
         * Information about additional Elastic Network Interfaces (ENIs) associated with the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdditionalEnis.Builder} avoiding the need
         * to create one manually via {@link AdditionalEnis#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdditionalEnis.Builder#build()} is called immediately and its
         * result is passed to {@link #additionalEnis(AdditionalEnis)}.
         * 
         * @param additionalEnis
         *        a consumer that will call methods on {@link AdditionalEnis.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalEnis(AdditionalEnis)
         */
        default Builder additionalEnis(Consumer<AdditionalEnis.Builder> additionalEnis) {
            return additionalEnis(AdditionalEnis.builder().applyMutation(additionalEnis).build());
        }

        /**
         * <p>
         * Information about the Capacity Reservation used by the instance.
         * </p>
         * 
         * @param capacityReservation
         *        Information about the Capacity Reservation used by the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservation(CapacityReservation capacityReservation);

        /**
         * <p>
         * Information about the Capacity Reservation used by the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityReservation.Builder} avoiding the
         * need to create one manually via {@link CapacityReservation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityReservation.Builder#build()} is called immediately and
         * its result is passed to {@link #capacityReservation(CapacityReservation)}.
         * 
         * @param capacityReservation
         *        a consumer that will call methods on {@link CapacityReservation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservation(CapacityReservation)
         */
        default Builder capacityReservation(Consumer<CapacityReservation.Builder> capacityReservation) {
            return capacityReservation(CapacityReservation.builder().applyMutation(capacityReservation).build());
        }

        /**
         * <p>
         * An error message describing why the instance creation or update failed, if applicable.
         * </p>
         * 
         * @param failureMessage
         *        An error message describing why the instance creation or update failed, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * The execution state of the Lifecycle Script (LCS) for the instance.
         * </p>
         * 
         * @param lcsExecutionState
         *        The execution state of the Lifecycle Script (LCS) for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lcsExecutionState(String lcsExecutionState);

        /**
         * <p>
         * The unique logical identifier of the node within the cluster. The ID used here is the same object as in the
         * <code>BatchAddClusterNodes</code> API.
         * </p>
         * 
         * @param nodeLogicalId
         *        The unique logical identifier of the node within the cluster. The ID used here is the same object as
         *        in the <code>BatchAddClusterNodes</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeLogicalId(String nodeLogicalId);
    }

    static final class BuilderImpl implements Builder {
        private String customerEni;

        private AdditionalEnis additionalEnis;

        private CapacityReservation capacityReservation;

        private String failureMessage;

        private String lcsExecutionState;

        private String nodeLogicalId;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceMetadata model) {
            customerEni(model.customerEni);
            additionalEnis(model.additionalEnis);
            capacityReservation(model.capacityReservation);
            failureMessage(model.failureMessage);
            lcsExecutionState(model.lcsExecutionState);
            nodeLogicalId(model.nodeLogicalId);
        }

        public final String getCustomerEni() {
            return customerEni;
        }

        public final void setCustomerEni(String customerEni) {
            this.customerEni = customerEni;
        }

        @Override
        public final Builder customerEni(String customerEni) {
            this.customerEni = customerEni;
            return this;
        }

        public final AdditionalEnis.Builder getAdditionalEnis() {
            return additionalEnis != null ? additionalEnis.toBuilder() : null;
        }

        public final void setAdditionalEnis(AdditionalEnis.BuilderImpl additionalEnis) {
            this.additionalEnis = additionalEnis != null ? additionalEnis.build() : null;
        }

        @Override
        public final Builder additionalEnis(AdditionalEnis additionalEnis) {
            this.additionalEnis = additionalEnis;
            return this;
        }

        public final CapacityReservation.Builder getCapacityReservation() {
            return capacityReservation != null ? capacityReservation.toBuilder() : null;
        }

        public final void setCapacityReservation(CapacityReservation.BuilderImpl capacityReservation) {
            this.capacityReservation = capacityReservation != null ? capacityReservation.build() : null;
        }

        @Override
        public final Builder capacityReservation(CapacityReservation capacityReservation) {
            this.capacityReservation = capacityReservation;
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getLcsExecutionState() {
            return lcsExecutionState;
        }

        public final void setLcsExecutionState(String lcsExecutionState) {
            this.lcsExecutionState = lcsExecutionState;
        }

        @Override
        public final Builder lcsExecutionState(String lcsExecutionState) {
            this.lcsExecutionState = lcsExecutionState;
            return this;
        }

        public final String getNodeLogicalId() {
            return nodeLogicalId;
        }

        public final void setNodeLogicalId(String nodeLogicalId) {
            this.nodeLogicalId = nodeLogicalId;
        }

        @Override
        public final Builder nodeLogicalId(String nodeLogicalId) {
            this.nodeLogicalId = nodeLogicalId;
            return this;
        }

        @Override
        public InstanceMetadata build() {
            return new InstanceMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
