/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for how instances are placed and allocated within UltraServers. This is only applicable for UltraServer
 * capacity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstancePlacementConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<InstancePlacementConfig.Builder, InstancePlacementConfig> {
    private static final SdkField<Boolean> ENABLE_MULTIPLE_JOBS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableMultipleJobs").getter(getter(InstancePlacementConfig::enableMultipleJobs))
            .setter(setter(Builder::enableMultipleJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableMultipleJobs").build())
            .build();

    private static final SdkField<List<PlacementSpecification>> PLACEMENT_SPECIFICATIONS_FIELD = SdkField
            .<List<PlacementSpecification>> builder(MarshallingType.LIST)
            .memberName("PlacementSpecifications")
            .getter(getter(InstancePlacementConfig::placementSpecifications))
            .setter(setter(Builder::placementSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementSpecifications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlacementSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlacementSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_MULTIPLE_JOBS_FIELD,
            PLACEMENT_SPECIFICATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enableMultipleJobs;

    private final List<PlacementSpecification> placementSpecifications;

    private InstancePlacementConfig(BuilderImpl builder) {
        this.enableMultipleJobs = builder.enableMultipleJobs;
        this.placementSpecifications = builder.placementSpecifications;
    }

    /**
     * <p>
     * If set to true, allows multiple jobs to share the same UltraServer instances. If set to false, ensures this job's
     * instances are placed on an UltraServer exclusively, with no other jobs sharing the same UltraServer. Default is
     * false.
     * </p>
     * 
     * @return If set to true, allows multiple jobs to share the same UltraServer instances. If set to false, ensures
     *         this job's instances are placed on an UltraServer exclusively, with no other jobs sharing the same
     *         UltraServer. Default is false.
     */
    public final Boolean enableMultipleJobs() {
        return enableMultipleJobs;
    }

    /**
     * For responses, this returns true if the service returned a value for the PlacementSpecifications property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPlacementSpecifications() {
        return placementSpecifications != null && !(placementSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of specifications for how instances should be placed on specific UltraServers. Maximum of 10 items is
     * supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlacementSpecifications} method.
     * </p>
     * 
     * @return A list of specifications for how instances should be placed on specific UltraServers. Maximum of 10 items
     *         is supported.
     */
    public final List<PlacementSpecification> placementSpecifications() {
        return placementSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableMultipleJobs());
        hashCode = 31 * hashCode + Objects.hashCode(hasPlacementSpecifications() ? placementSpecifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancePlacementConfig)) {
            return false;
        }
        InstancePlacementConfig other = (InstancePlacementConfig) obj;
        return Objects.equals(enableMultipleJobs(), other.enableMultipleJobs())
                && hasPlacementSpecifications() == other.hasPlacementSpecifications()
                && Objects.equals(placementSpecifications(), other.placementSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstancePlacementConfig").add("EnableMultipleJobs", enableMultipleJobs())
                .add("PlacementSpecifications", hasPlacementSpecifications() ? placementSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableMultipleJobs":
            return Optional.ofNullable(clazz.cast(enableMultipleJobs()));
        case "PlacementSpecifications":
            return Optional.ofNullable(clazz.cast(placementSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnableMultipleJobs", ENABLE_MULTIPLE_JOBS_FIELD);
        map.put("PlacementSpecifications", PLACEMENT_SPECIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstancePlacementConfig, T> g) {
        return obj -> g.apply((InstancePlacementConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstancePlacementConfig> {
        /**
         * <p>
         * If set to true, allows multiple jobs to share the same UltraServer instances. If set to false, ensures this
         * job's instances are placed on an UltraServer exclusively, with no other jobs sharing the same UltraServer.
         * Default is false.
         * </p>
         * 
         * @param enableMultipleJobs
         *        If set to true, allows multiple jobs to share the same UltraServer instances. If set to false, ensures
         *        this job's instances are placed on an UltraServer exclusively, with no other jobs sharing the same
         *        UltraServer. Default is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableMultipleJobs(Boolean enableMultipleJobs);

        /**
         * <p>
         * A list of specifications for how instances should be placed on specific UltraServers. Maximum of 10 items is
         * supported.
         * </p>
         * 
         * @param placementSpecifications
         *        A list of specifications for how instances should be placed on specific UltraServers. Maximum of 10
         *        items is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementSpecifications(Collection<PlacementSpecification> placementSpecifications);

        /**
         * <p>
         * A list of specifications for how instances should be placed on specific UltraServers. Maximum of 10 items is
         * supported.
         * </p>
         * 
         * @param placementSpecifications
         *        A list of specifications for how instances should be placed on specific UltraServers. Maximum of 10
         *        items is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementSpecifications(PlacementSpecification... placementSpecifications);

        /**
         * <p>
         * A list of specifications for how instances should be placed on specific UltraServers. Maximum of 10 items is
         * supported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.PlacementSpecification.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.PlacementSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.PlacementSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #placementSpecifications(List<PlacementSpecification>)}.
         * 
         * @param placementSpecifications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.PlacementSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementSpecifications(java.util.Collection<PlacementSpecification>)
         */
        Builder placementSpecifications(Consumer<PlacementSpecification.Builder>... placementSpecifications);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableMultipleJobs;

        private List<PlacementSpecification> placementSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstancePlacementConfig model) {
            enableMultipleJobs(model.enableMultipleJobs);
            placementSpecifications(model.placementSpecifications);
        }

        public final Boolean getEnableMultipleJobs() {
            return enableMultipleJobs;
        }

        public final void setEnableMultipleJobs(Boolean enableMultipleJobs) {
            this.enableMultipleJobs = enableMultipleJobs;
        }

        @Override
        public final Builder enableMultipleJobs(Boolean enableMultipleJobs) {
            this.enableMultipleJobs = enableMultipleJobs;
            return this;
        }

        public final List<PlacementSpecification.Builder> getPlacementSpecifications() {
            List<PlacementSpecification.Builder> result = PlacementSpecificationsCopier
                    .copyToBuilder(this.placementSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementSpecifications(Collection<PlacementSpecification.BuilderImpl> placementSpecifications) {
            this.placementSpecifications = PlacementSpecificationsCopier.copyFromBuilder(placementSpecifications);
        }

        @Override
        public final Builder placementSpecifications(Collection<PlacementSpecification> placementSpecifications) {
            this.placementSpecifications = PlacementSpecificationsCopier.copy(placementSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementSpecifications(PlacementSpecification... placementSpecifications) {
            placementSpecifications(Arrays.asList(placementSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementSpecifications(Consumer<PlacementSpecification.Builder>... placementSpecifications) {
            placementSpecifications(Stream.of(placementSpecifications)
                    .map(c -> PlacementSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public InstancePlacementConfig build() {
            return new InstancePlacementConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
