/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClusterEventsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListClusterEventsRequest.Builder, ListClusterEventsRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(ListClusterEventsRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceGroupName").getter(getter(ListClusterEventsRequest::instanceGroupName))
            .setter(setter(Builder::instanceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()).build();

    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NodeId")
            .getter(getter(ListClusterEventsRequest::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()).build();

    private static final SdkField<Instant> EVENT_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EventTimeAfter").getter(getter(ListClusterEventsRequest::eventTimeAfter))
            .setter(setter(Builder::eventTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTimeAfter").build()).build();

    private static final SdkField<Instant> EVENT_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EventTimeBefore").getter(getter(ListClusterEventsRequest::eventTimeBefore))
            .setter(setter(Builder::eventTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTimeBefore").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListClusterEventsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListClusterEventsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ListClusterEventsRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListClusterEventsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListClusterEventsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            INSTANCE_GROUP_NAME_FIELD, NODE_ID_FIELD, EVENT_TIME_AFTER_FIELD, EVENT_TIME_BEFORE_FIELD, SORT_BY_FIELD,
            SORT_ORDER_FIELD, RESOURCE_TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterName;

    private final String instanceGroupName;

    private final String nodeId;

    private final Instant eventTimeAfter;

    private final Instant eventTimeBefore;

    private final String sortBy;

    private final String sortOrder;

    private final String resourceType;

    private final Integer maxResults;

    private final String nextToken;

    private ListClusterEventsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.instanceGroupName = builder.instanceGroupName;
        this.nodeId = builder.nodeId;
        this.eventTimeAfter = builder.eventTimeAfter;
        this.eventTimeBefore = builder.eventTimeBefore;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.resourceType = builder.resourceType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the HyperPod cluster for which to list events.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the HyperPod cluster for which to list events.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The name of the instance group to filter events. If specified, only events related to this instance group are
     * returned.
     * </p>
     * 
     * @return The name of the instance group to filter events. If specified, only events related to this instance group
     *         are returned.
     */
    public final String instanceGroupName() {
        return instanceGroupName;
    }

    /**
     * <p>
     * The EC2 instance ID to filter events. If specified, only events related to this instance are returned.
     * </p>
     * 
     * @return The EC2 instance ID to filter events. If specified, only events related to this instance are returned.
     */
    public final String nodeId() {
        return nodeId;
    }

    /**
     * <p>
     * The start of the time range for filtering events. Only events that occurred after this time are included in the
     * results.
     * </p>
     * 
     * @return The start of the time range for filtering events. Only events that occurred after this time are included
     *         in the results.
     */
    public final Instant eventTimeAfter() {
        return eventTimeAfter;
    }

    /**
     * <p>
     * The end of the time range for filtering events. Only events that occurred before this time are included in the
     * results.
     * </p>
     * 
     * @return The end of the time range for filtering events. Only events that occurred before this time are included
     *         in the results.
     */
    public final Instant eventTimeBefore() {
        return eventTimeBefore;
    }

    /**
     * <p>
     * The field to use for sorting the event list. Currently, the only supported value is <code>EventTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link EventSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The field to use for sorting the event list. Currently, the only supported value is
     *         <code>EventTime</code>.
     * @see EventSortBy
     */
    public final EventSortBy sortBy() {
        return EventSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The field to use for sorting the event list. Currently, the only supported value is <code>EventTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link EventSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The field to use for sorting the event list. Currently, the only supported value is
     *         <code>EventTime</code>.
     * @see EventSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The order in which to sort the results. Valid values are <code>Ascending</code> or <code>Descending</code> (the
     * default is <code>Descending</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order in which to sort the results. Valid values are <code>Ascending</code> or
     *         <code>Descending</code> (the default is <code>Descending</code>).
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order in which to sort the results. Valid values are <code>Ascending</code> or <code>Descending</code> (the
     * default is <code>Descending</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order in which to sort the results. Valid values are <code>Ascending</code> or
     *         <code>Descending</code> (the default is <code>Descending</code>).
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * The type of resource for which to filter events. Valid values are <code>Cluster</code>,
     * <code>InstanceGroup</code>, or <code>Instance</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ClusterEventResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource for which to filter events. Valid values are <code>Cluster</code>,
     *         <code>InstanceGroup</code>, or <code>Instance</code>.
     * @see ClusterEventResourceType
     */
    public final ClusterEventResourceType resourceType() {
        return ClusterEventResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource for which to filter events. Valid values are <code>Cluster</code>,
     * <code>InstanceGroup</code>, or <code>Instance</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ClusterEventResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource for which to filter events. Valid values are <code>Cluster</code>,
     *         <code>InstanceGroup</code>, or <code>Instance</code>.
     * @see ClusterEventResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The maximum number of events to return in the response. Valid range is 1 to 100.
     * </p>
     * 
     * @return The maximum number of events to return in the response. Valid range is 1 to 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token to retrieve the next set of results. This token is obtained from the output of a previous
     * <code>ListClusterEvents</code> call.
     * </p>
     * 
     * @return A token to retrieve the next set of results. This token is obtained from the output of a previous
     *         <code>ListClusterEvents</code> call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(eventTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(eventTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClusterEventsRequest)) {
            return false;
        }
        ListClusterEventsRequest other = (ListClusterEventsRequest) obj;
        return Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(instanceGroupName(), other.instanceGroupName()) && Objects.equals(nodeId(), other.nodeId())
                && Objects.equals(eventTimeAfter(), other.eventTimeAfter())
                && Objects.equals(eventTimeBefore(), other.eventTimeBefore())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListClusterEventsRequest").add("ClusterName", clusterName())
                .add("InstanceGroupName", instanceGroupName()).add("NodeId", nodeId()).add("EventTimeAfter", eventTimeAfter())
                .add("EventTimeBefore", eventTimeBefore()).add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString())
                .add("ResourceType", resourceTypeAsString()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "InstanceGroupName":
            return Optional.ofNullable(clazz.cast(instanceGroupName()));
        case "NodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        case "EventTimeAfter":
            return Optional.ofNullable(clazz.cast(eventTimeAfter()));
        case "EventTimeBefore":
            return Optional.ofNullable(clazz.cast(eventTimeBefore()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterName", CLUSTER_NAME_FIELD);
        map.put("InstanceGroupName", INSTANCE_GROUP_NAME_FIELD);
        map.put("NodeId", NODE_ID_FIELD);
        map.put("EventTimeAfter", EVENT_TIME_AFTER_FIELD);
        map.put("EventTimeBefore", EVENT_TIME_BEFORE_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListClusterEventsRequest, T> g) {
        return obj -> g.apply((ListClusterEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListClusterEventsRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the HyperPod cluster for which to list events.
         * </p>
         * 
         * @param clusterName
         *        The name or Amazon Resource Name (ARN) of the HyperPod cluster for which to list events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The name of the instance group to filter events. If specified, only events related to this instance group are
         * returned.
         * </p>
         * 
         * @param instanceGroupName
         *        The name of the instance group to filter events. If specified, only events related to this instance
         *        group are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupName(String instanceGroupName);

        /**
         * <p>
         * The EC2 instance ID to filter events. If specified, only events related to this instance are returned.
         * </p>
         * 
         * @param nodeId
         *        The EC2 instance ID to filter events. If specified, only events related to this instance are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);

        /**
         * <p>
         * The start of the time range for filtering events. Only events that occurred after this time are included in
         * the results.
         * </p>
         * 
         * @param eventTimeAfter
         *        The start of the time range for filtering events. Only events that occurred after this time are
         *        included in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTimeAfter(Instant eventTimeAfter);

        /**
         * <p>
         * The end of the time range for filtering events. Only events that occurred before this time are included in
         * the results.
         * </p>
         * 
         * @param eventTimeBefore
         *        The end of the time range for filtering events. Only events that occurred before this time are
         *        included in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTimeBefore(Instant eventTimeBefore);

        /**
         * <p>
         * The field to use for sorting the event list. Currently, the only supported value is <code>EventTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The field to use for sorting the event list. Currently, the only supported value is
         *        <code>EventTime</code>.
         * @see EventSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The field to use for sorting the event list. Currently, the only supported value is <code>EventTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The field to use for sorting the event list. Currently, the only supported value is
         *        <code>EventTime</code>.
         * @see EventSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventSortBy
         */
        Builder sortBy(EventSortBy sortBy);

        /**
         * <p>
         * The order in which to sort the results. Valid values are <code>Ascending</code> or <code>Descending</code>
         * (the default is <code>Descending</code>).
         * </p>
         * 
         * @param sortOrder
         *        The order in which to sort the results. Valid values are <code>Ascending</code> or
         *        <code>Descending</code> (the default is <code>Descending</code>).
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order in which to sort the results. Valid values are <code>Ascending</code> or <code>Descending</code>
         * (the default is <code>Descending</code>).
         * </p>
         * 
         * @param sortOrder
         *        The order in which to sort the results. Valid values are <code>Ascending</code> or
         *        <code>Descending</code> (the default is <code>Descending</code>).
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * The type of resource for which to filter events. Valid values are <code>Cluster</code>,
         * <code>InstanceGroup</code>, or <code>Instance</code>.
         * </p>
         * 
         * @param resourceType
         *        The type of resource for which to filter events. Valid values are <code>Cluster</code>,
         *        <code>InstanceGroup</code>, or <code>Instance</code>.
         * @see ClusterEventResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterEventResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource for which to filter events. Valid values are <code>Cluster</code>,
         * <code>InstanceGroup</code>, or <code>Instance</code>.
         * </p>
         * 
         * @param resourceType
         *        The type of resource for which to filter events. Valid values are <code>Cluster</code>,
         *        <code>InstanceGroup</code>, or <code>Instance</code>.
         * @see ClusterEventResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterEventResourceType
         */
        Builder resourceType(ClusterEventResourceType resourceType);

        /**
         * <p>
         * The maximum number of events to return in the response. Valid range is 1 to 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of events to return in the response. Valid range is 1 to 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token to retrieve the next set of results. This token is obtained from the output of a previous
         * <code>ListClusterEvents</code> call.
         * </p>
         * 
         * @param nextToken
         *        A token to retrieve the next set of results. This token is obtained from the output of a previous
         *        <code>ListClusterEvents</code> call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String instanceGroupName;

        private String nodeId;

        private Instant eventTimeAfter;

        private Instant eventTimeBefore;

        private String sortBy;

        private String sortOrder;

        private String resourceType;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClusterEventsRequest model) {
            super(model);
            clusterName(model.clusterName);
            instanceGroupName(model.instanceGroupName);
            nodeId(model.nodeId);
            eventTimeAfter(model.eventTimeAfter);
            eventTimeBefore(model.eventTimeBefore);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            resourceType(model.resourceType);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getInstanceGroupName() {
            return instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        public final String getNodeId() {
            return nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final Instant getEventTimeAfter() {
            return eventTimeAfter;
        }

        public final void setEventTimeAfter(Instant eventTimeAfter) {
            this.eventTimeAfter = eventTimeAfter;
        }

        @Override
        public final Builder eventTimeAfter(Instant eventTimeAfter) {
            this.eventTimeAfter = eventTimeAfter;
            return this;
        }

        public final Instant getEventTimeBefore() {
            return eventTimeBefore;
        }

        public final void setEventTimeBefore(Instant eventTimeBefore) {
            this.eventTimeBefore = eventTimeBefore;
        }

        @Override
        public final Builder eventTimeBefore(Instant eventTimeBefore) {
            this.eventTimeBefore = eventTimeBefore;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(EventSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ClusterEventResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListClusterEventsRequest build() {
            return new ListClusterEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
