/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPipelineVersionsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListPipelineVersionsResponse.Builder, ListPipelineVersionsResponse> {
    private static final SdkField<List<PipelineVersionSummary>> PIPELINE_VERSION_SUMMARIES_FIELD = SdkField
            .<List<PipelineVersionSummary>> builder(MarshallingType.LIST)
            .memberName("PipelineVersionSummaries")
            .getter(getter(ListPipelineVersionsResponse::pipelineVersionSummaries))
            .setter(setter(Builder::pipelineVersionSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineVersionSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PipelineVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PipelineVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPipelineVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PIPELINE_VERSION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<PipelineVersionSummary> pipelineVersionSummaries;

    private final String nextToken;

    private ListPipelineVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineVersionSummaries = builder.pipelineVersionSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PipelineVersionSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPipelineVersionSummaries() {
        return pipelineVersionSummaries != null && !(pipelineVersionSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a sorted list of pipeline version summary objects matching the specified filters. Each version summary
     * includes the pipeline version ID, the creation date, and the last pipeline execution created from that version.
     * This list can be empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPipelineVersionSummaries} method.
     * </p>
     * 
     * @return Contains a sorted list of pipeline version summary objects matching the specified filters. Each version
     *         summary includes the pipeline version ID, the creation date, and the last pipeline execution created from
     *         that version. This list can be empty.
     */
    public final List<PipelineVersionSummary> pipelineVersionSummaries() {
        return pipelineVersionSummaries;
    }

    /**
     * <p>
     * If the result of the previous <code>ListPipelineVersions</code> request was truncated, the response includes a
     * <code>NextToken</code>. To retrieve the next set of pipeline versions, use this token in your next request.
     * </p>
     * 
     * @return If the result of the previous <code>ListPipelineVersions</code> request was truncated, the response
     *         includes a <code>NextToken</code>. To retrieve the next set of pipeline versions, use this token in your
     *         next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPipelineVersionSummaries() ? pipelineVersionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelineVersionsResponse)) {
            return false;
        }
        ListPipelineVersionsResponse other = (ListPipelineVersionsResponse) obj;
        return hasPipelineVersionSummaries() == other.hasPipelineVersionSummaries()
                && Objects.equals(pipelineVersionSummaries(), other.pipelineVersionSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPipelineVersionsResponse")
                .add("PipelineVersionSummaries", hasPipelineVersionSummaries() ? pipelineVersionSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PipelineVersionSummaries":
            return Optional.ofNullable(clazz.cast(pipelineVersionSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PipelineVersionSummaries", PIPELINE_VERSION_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPipelineVersionsResponse, T> g) {
        return obj -> g.apply((ListPipelineVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPipelineVersionsResponse> {
        /**
         * <p>
         * Contains a sorted list of pipeline version summary objects matching the specified filters. Each version
         * summary includes the pipeline version ID, the creation date, and the last pipeline execution created from
         * that version. This list can be empty.
         * </p>
         * 
         * @param pipelineVersionSummaries
         *        Contains a sorted list of pipeline version summary objects matching the specified filters. Each
         *        version summary includes the pipeline version ID, the creation date, and the last pipeline execution
         *        created from that version. This list can be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineVersionSummaries(Collection<PipelineVersionSummary> pipelineVersionSummaries);

        /**
         * <p>
         * Contains a sorted list of pipeline version summary objects matching the specified filters. Each version
         * summary includes the pipeline version ID, the creation date, and the last pipeline execution created from
         * that version. This list can be empty.
         * </p>
         * 
         * @param pipelineVersionSummaries
         *        Contains a sorted list of pipeline version summary objects matching the specified filters. Each
         *        version summary includes the pipeline version ID, the creation date, and the last pipeline execution
         *        created from that version. This list can be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineVersionSummaries(PipelineVersionSummary... pipelineVersionSummaries);

        /**
         * <p>
         * Contains a sorted list of pipeline version summary objects matching the specified filters. Each version
         * summary includes the pipeline version ID, the creation date, and the last pipeline execution created from
         * that version. This list can be empty.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.PipelineVersionSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.PipelineVersionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.PipelineVersionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #pipelineVersionSummaries(List<PipelineVersionSummary>)}.
         * 
         * @param pipelineVersionSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.PipelineVersionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineVersionSummaries(java.util.Collection<PipelineVersionSummary>)
         */
        Builder pipelineVersionSummaries(Consumer<PipelineVersionSummary.Builder>... pipelineVersionSummaries);

        /**
         * <p>
         * If the result of the previous <code>ListPipelineVersions</code> request was truncated, the response includes
         * a <code>NextToken</code>. To retrieve the next set of pipeline versions, use this token in your next request.
         * </p>
         * 
         * @param nextToken
         *        If the result of the previous <code>ListPipelineVersions</code> request was truncated, the response
         *        includes a <code>NextToken</code>. To retrieve the next set of pipeline versions, use this token in
         *        your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<PipelineVersionSummary> pipelineVersionSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelineVersionsResponse model) {
            super(model);
            pipelineVersionSummaries(model.pipelineVersionSummaries);
            nextToken(model.nextToken);
        }

        public final List<PipelineVersionSummary.Builder> getPipelineVersionSummaries() {
            List<PipelineVersionSummary.Builder> result = PipelineVersionSummaryListCopier
                    .copyToBuilder(this.pipelineVersionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPipelineVersionSummaries(Collection<PipelineVersionSummary.BuilderImpl> pipelineVersionSummaries) {
            this.pipelineVersionSummaries = PipelineVersionSummaryListCopier.copyFromBuilder(pipelineVersionSummaries);
        }

        @Override
        public final Builder pipelineVersionSummaries(Collection<PipelineVersionSummary> pipelineVersionSummaries) {
            this.pipelineVersionSummaries = PipelineVersionSummaryListCopier.copy(pipelineVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineVersionSummaries(PipelineVersionSummary... pipelineVersionSummaries) {
            pipelineVersionSummaries(Arrays.asList(pipelineVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineVersionSummaries(Consumer<PipelineVersionSummary.Builder>... pipelineVersionSummaries) {
            pipelineVersionSummaries(Stream.of(pipelineVersionSummaries)
                    .map(c -> PipelineVersionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPipelineVersionsResponse build() {
            return new ListPipelineVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
